/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ShutdownHookManager;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.mothra.packer.PackerDeque;
import org.cert.netsa.mothra.packer.PackerDeque$;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.PackingLogic;
import org.cert.netsa.mothra.packer.Partitioner;
import org.cert.netsa.mothra.packer.PartitionerConfigurator;
import org.cert.netsa.mothra.packer.PartitionerPackLogic;
import org.cert.netsa.mothra.packer.RunTimeCodeLoader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.InvariantPackerMain;
import org.cert.netsa.mothra.tools.InvariantPackerMain$delayedInit$body;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class InvariantPackerMain$
implements App,
StrictLogging {
    public static InvariantPackerMain$ MODULE$;
    private String org$cert$netsa$mothra$tools$InvariantPackerMain$$APP;
    private String appProp;
    private int SHUTDOWN_PRIORITY;
    private String DEFAULT_COMPRESSION;
    private Option<CompressionCodec> compressCodec;
    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix;
    private int DEFAULT_MAX_THREADS;
    private int maxThreads;
    private long MINIMUM_MAXIMUM_SIZE;
    private Option<Object> maximumSize;
    private int DEFAULT_OUTPUT_FILE_IDLE_SECONDS;
    private int OUTPUT_FILE_IDLE_SECONDS_MINIMUM;
    private int outputIdleSeconds;
    private int DEFAULT_MAXIMUM_AGE_SECONDS;
    private int maxInputAge;
    private int DEFAULT_MINIMUM_INPUT_COUNT;
    private int minInputCount;
    private long DEFAULT_MINIMUM_INPUT_SIZE;
    private long minInputSize;
    private int DEFAULT_FILE_CACHE_SIZE;
    private int MINIMUM_FILE_CACHE_SIZE;
    private int fileCacheSize;
    private int DEFAULT_POLL_INTERVAL;
    private int pollingInterval;
    private int DEFAULT_OBSERVATION_DOMAIN_ID;
    private int observationDomain;
    private boolean oneshot;
    private /* synthetic */ Tuple2 x$14;
    private String[] switches;
    private String[] positionalArgs;
    private Path incomingDir;
    private Path destinationDir;
    private Path packLogicPath;
    public Object org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex;
    public Map<String, InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles;
    public PackerDeque<InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU;
    public volatile int org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount;
    public volatile int org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount;
    public long org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize;
    private int taskCountInterval;
    private InfoModel infoModel;
    private Configuration hadoopConf;
    public CompressionCodecFactory org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory;
    private /* synthetic */ Tuple2 x$15;
    public int org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion;
    public Seq<Partitioner> org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners;
    private String ignored;
    public ThreadPoolExecutor org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool;
    public InvariantPackerMain.MyDirWatcher org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher;
    private boolean running;
    private final Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new InvariantPackerMain$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.InvariantPackerMain mothra-tools.jar [--version] [--one-shot] <sourceDir> <destinationDir> <partitionerFile>\n\nsourceDir:         Directory to read from, as Hadoop URI\ndestinationDir:    Directory to write to, as Hadoop URI\npartitionerFile:   A Scala source file containing Partitioner Packing Logic\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringBuilder(3306).append("\n").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" processes files created by super_mediator running in invariant mode and\nwrites them into HDFS.  It reads IPRIX records from files from `sourceDir` and\nwrites the records to files in `destinationDir`.\n\nThe `partitionerFile` is a Scala source file that may contain either\nPartitionerConfigurator or PartitionerPackLogic.  ").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" reads, parses,\ncompiles, and loads the Scala code contained in the file, then extracts the\nsequence of Partitions defined in that file.  The partitioners are used by\n").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" when writing flow records to the `destinationDir`.\n\nIf \"--version\" is included on the command line, the application prints its\nversion number and exists.\n\nIf \"--one-shot\" is included on the command line, the `sourceDir` is only\nscanned one time.  Once all files in sourceDir have been packed, the\napplication exits.  When \"--one-shot\" is not provided, the application runs\nuntil it is signaled to end.\n\nThe Java property values that are used by this application are:\n\n").append(this.appProp()).append("compression -- The compression to use for files written to\nHDFS.  Values typically supported by Hadoop include `bzip2`, `gzip`,\n`lz4`, `lzo`, `lzop`, `snappy`, and `default`.  The empty string indicates\nno compression.  The default is `").append(this.DEFAULT_COMPRESSION()).append("`.\n\n").append(this.appProp()).append("maxThreads -- The maximum number of threads that attempt to write to\noutput files simultaneously.  The default is ").append(this.DEFAULT_MAX_THREADS()).append(".\n\n").append(this.appProp()).append("pollingInterval -- How often the `sourceDir` is checked (polled) for\nIPFIX files to process.  The default is ").append(this.DEFAULT_POLL_INTERVAL()).append(" seconds.\n\n").append(this.appProp()).append("maximumSize -- The (approximate) maximum size file to create, in\noctets.  The default is no maximum.  When a file's size exceeds this value,\nthe file is closed and a new file is started.  Typically a file's size will\nnot exceed this value by more than the maximum size of an IPFIX message, 64k.\nThis value may not be less than ").append(this.MINIMUM_MAXIMUM_SIZE()).append(".\n\n").append(this.appProp()).append("outputIdleSeconds -- The maximum number of seconds to allow an idle\noutput file to remain open so additional incoming records may appended to it.\nIt defaults to the value ").append(this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS()).append(".  This value may\nnot be less than ").append(this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM()).append(".\n\n").append(this.appProp()).append("fileCacheSize -- The maximum size of the open file cache.  This is\nthe maximum number of open files maintained by the file cache for writing to\noutput files.  Once the cache reaches this number of open files, the\napplication closes the least-recently-used file when it needs to open another.\nThis value does not include the file handles required when reading incoming\nfiles.  The default is ").append(this.DEFAULT_FILE_CACHE_SIZE()).append("; the minimum permitted is\n").append(this.MINIMUM_FILE_CACHE_SIZE()).append(".\n\n").append(this.appProp()).append("observationDomainId -- The observationDomainId to use in output\nfiles.  The default is ").append(this.DEFAULT_OBSERVATION_DOMAIN_ID()).append(".\n\nWhen an output file has not been opened yet, it is not opened until the oldest\ninput file reaches a particular age, the number of input files reaches a\ncount, or the sum of the sizes of the input files reaches a value.  (Reaching\nany threshold allows the output file to be opened.)  The next three properties\ndescribe these values:\n\n").append(this.appProp()).append("maxInputAgeSeconds -- The age for an input file that causes its\ndestination output file to be opened.  Here, \"age\" refers to how long ago the\nfile was noticed, not the age of the file itself.  The default is\n").append(this.DEFAULT_MAXIMUM_AGE_SECONDS()).append(" seconds.\n\n").append(this.appProp()).append("minInputCount -- The number of queued input files that causes their\ndestination output file to be opened.  The default is\n").append(this.DEFAULT_MINIMUM_INPUT_COUNT()).append(".\n\n").append(this.appProp()).append("minInputSize -- The sum of the sizes of queued input files that\ncauses their destination output file to be opened, in octets.  The default is\n").append(this.DEFAULT_MINIMUM_INPUT_SIZE()).append(".\n").toString());
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
        System.exit(0);
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$timediff(long t1, long t0) {
        double arg$macro$1 = (double)(t1 - t0) / 1000.0;
        return new StringOps("%.03f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
    }

    public void org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        int active = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.getActiveCount();
        long total = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.getTaskCount();
        long completed = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.getCompletedTaskCount();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(53).append("Task Counts: Active: ").append(active).append(",").append(" Queued: ").append(total - completed - (long)active).append(",").append(" Completed: ").append(completed).append(",").append(" Total: ").append(total).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output Files: Open: {}, Total: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount), BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$APP() {
        return this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP;
    }

    private String appProp() {
        return this.appProp;
    }

    private int SHUTDOWN_PRIORITY() {
        return this.SHUTDOWN_PRIORITY;
    }

    public String DEFAULT_COMPRESSION() {
        return this.DEFAULT_COMPRESSION;
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public int DEFAULT_MAX_THREADS() {
        return this.DEFAULT_MAX_THREADS;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public long MINIMUM_MAXIMUM_SIZE() {
        return this.MINIMUM_MAXIMUM_SIZE;
    }

    public Option<Object> maximumSize() {
        return this.maximumSize;
    }

    public int DEFAULT_OUTPUT_FILE_IDLE_SECONDS() {
        return this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS;
    }

    public int OUTPUT_FILE_IDLE_SECONDS_MINIMUM() {
        return this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM;
    }

    public int outputIdleSeconds() {
        return this.outputIdleSeconds;
    }

    public int DEFAULT_MAXIMUM_AGE_SECONDS() {
        return this.DEFAULT_MAXIMUM_AGE_SECONDS;
    }

    public int maxInputAge() {
        return this.maxInputAge;
    }

    public int DEFAULT_MINIMUM_INPUT_COUNT() {
        return this.DEFAULT_MINIMUM_INPUT_COUNT;
    }

    public int minInputCount() {
        return this.minInputCount;
    }

    public long DEFAULT_MINIMUM_INPUT_SIZE() {
        return this.DEFAULT_MINIMUM_INPUT_SIZE;
    }

    public long minInputSize() {
        return this.minInputSize;
    }

    public int DEFAULT_FILE_CACHE_SIZE() {
        return this.DEFAULT_FILE_CACHE_SIZE;
    }

    public int MINIMUM_FILE_CACHE_SIZE() {
        return this.MINIMUM_FILE_CACHE_SIZE;
    }

    public int fileCacheSize() {
        return this.fileCacheSize;
    }

    public int DEFAULT_POLL_INTERVAL() {
        return this.DEFAULT_POLL_INTERVAL;
    }

    public int pollingInterval() {
        return this.pollingInterval;
    }

    public int DEFAULT_OBSERVATION_DOMAIN_ID() {
        return this.DEFAULT_OBSERVATION_DOMAIN_ID;
    }

    public int observationDomain() {
        return this.observationDomain;
    }

    public boolean oneshot() {
        return this.oneshot;
    }

    public void oneshot_$eq(boolean x$1) {
        this.oneshot = x$1;
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public Path incomingDir() {
        return this.incomingDir;
    }

    public Path destinationDir() {
        return this.destinationDir;
    }

    public Path packLogicPath() {
        return this.packLogicPath;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String ignored() {
        return this.ignored;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public static final /* synthetic */ int $anonfun$maxThreads$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ long $anonfun$maximumSize$1(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ int $anonfun$outputIdleSeconds$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
    }

    public static final /* synthetic */ int $anonfun$maxInputAge$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
    }

    public static final /* synthetic */ int $anonfun$minInputCount$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ long $anonfun$minInputSize$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ int $anonfun$fileCacheSize$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ int $anonfun$pollingInterval$1(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
    }

    public static final /* synthetic */ int $anonfun$observationDomain$1(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$x$14$1(String x$13) {
        String string = x$13.substring(0, 2);
        String string2 = "--";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$new$2(long x$16) {
        return Long.toString(x$16);
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$InvariantPackerMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        String string;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        BoxedUnit boxedUnit14;
        BoxedUnit boxedUnit15;
        BoxedUnit boxedUnit16;
        BoxedUnit boxedUnit17;
        Tuple2 tuple2;
        Object result;
        Object x;
        RunTimeCodeLoader x2;
        BoxedUnit boxedUnit18;
        BoxedUnit boxedUnit19;
        None$ none$;
        String compressName;
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP = "InvariantPacker";
        this.appProp = "mothra.invariantpacker.";
        this.SHUTDOWN_PRIORITY = 50;
        this.DEFAULT_COMPRESSION = "";
        String string2 = compressName = (String)package$.MODULE$.props().get(new StringBuilder(11).append(this.appProp()).append("compression").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_COMPRESSION());
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            none$ = None$.MODULE$;
        } else {
            Option option;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                void var1_1;
                CompressionCodec codec = InvariantPackerMain$.MODULE$.org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory.getCodecByName(compressName);
                codec.createCompressor();
                return var1_1;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                option = Option$.MODULE$.apply((Object)ok);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit20;
                BoxedUnit boxedUnit21;
                BoxedUnit boxedUnit22;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(36).append("Unable to initialize compressor").append(" '").append(compressName).append("': ").append(e.toString()).toString());
                    boxedUnit22 = BoxedUnit.UNIT;
                } else {
                    boxedUnit22 = BoxedUnit.UNIT;
                }
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(36).append("Unable to initialize compressor").append(" '").append(compressName).append("': ").append(sw.toString()).toString());
                    boxedUnit21 = BoxedUnit.UNIT;
                } else {
                    boxedUnit21 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit20 = BoxedUnit.UNIT;
                } else {
                    boxedUnit20 = BoxedUnit.UNIT;
                }
                option = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = option;
        }
        this.compressCodec = none$;
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix = (String)this.compressCodec().map((Function1 & Serializable & scala.Serializable)c -> c.getDefaultExtension()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.DEFAULT_MAX_THREADS = 6;
        this.maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(10).append(this.appProp()).append("maxThreads").toString()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$maxThreads$1(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_MAX_THREADS()));
        Predef$.MODULE$.require(this.maxThreads() >= 1);
        this.MINIMUM_MAXIMUM_SIZE = 524288L;
        this.maximumSize = package$.MODULE$.props().get(new StringBuilder(11).append(this.appProp()).append("maximumSize").toString()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)InvariantPackerMain$.$anonfun$maximumSize$1(x$5)));
        Predef$.MODULE$.require(this.maximumSize().isEmpty() || BoxesRunTime.unboxToLong((Object)this.maximumSize().get()) >= this.MINIMUM_MAXIMUM_SIZE());
        this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS = 900;
        this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM = 60;
        this.outputIdleSeconds = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(17).append(this.appProp()).append("outputIdleSeconds").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$outputIdleSeconds$1(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_OUTPUT_FILE_IDLE_SECONDS()));
        Predef$.MODULE$.require(this.outputIdleSeconds() >= this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM());
        this.DEFAULT_MAXIMUM_AGE_SECONDS = 900;
        this.maxInputAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(18).append(this.appProp()).append("maxInputAgeSeconds").toString()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$maxInputAge$1(x$7))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_MAXIMUM_AGE_SECONDS())) * 1000;
        this.DEFAULT_MINIMUM_INPUT_COUNT = 3;
        this.minInputCount = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(13).append(this.appProp()).append("minInputCount").toString()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$minInputCount$1(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_MINIMUM_INPUT_COUNT()));
        Predef$.MODULE$.require(this.minInputCount() > 0);
        this.DEFAULT_MINIMUM_INPUT_SIZE = 0x100000L;
        this.minInputSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get(new StringBuilder(12).append(this.appProp()).append("minInputSize").toString()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)InvariantPackerMain$.$anonfun$minInputSize$1(x$9))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_MINIMUM_INPUT_SIZE()));
        Predef$.MODULE$.require(this.minInputSize() > 0L);
        this.DEFAULT_FILE_CACHE_SIZE = 2000;
        this.MINIMUM_FILE_CACHE_SIZE = 128;
        this.fileCacheSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(13).append(this.appProp()).append("fileCacheSize").toString()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$fileCacheSize$1(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_FILE_CACHE_SIZE()));
        Predef$.MODULE$.require(this.fileCacheSize() >= this.MINIMUM_FILE_CACHE_SIZE());
        Predef$.MODULE$.require(this.fileCacheSize() >= this.maxThreads());
        this.DEFAULT_POLL_INTERVAL = 15;
        this.pollingInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(15).append(this.appProp()).append("pollingInterval").toString()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$pollingInterval$1(x$11))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_POLL_INTERVAL()));
        Predef$.MODULE$.require(this.pollingInterval() > 0);
        this.DEFAULT_OBSERVATION_DOMAIN_ID = 0;
        this.observationDomain = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(19).append(this.appProp()).append("observationDomainId").toString()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)InvariantPackerMain$.$anonfun$observationDomain$1(x$12))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_OBSERVATION_DOMAIN_ID()));
        this.oneshot = false;
        System.err.println(new StringBuilder(8).append("ARgs is ").append(this.args()).toString());
        Tuple2 tuple22 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).partition((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)InvariantPackerMain$.$anonfun$x$14$1(x$13)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String[] switches = (String[])tuple22._1();
        String[] positionalArgs = (String[])tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)switches, (Object)positionalArgs);
        this.x$14 = tuple23;
        this.switches = (String[])this.x$14._1();
        this.positionalArgs = (String[])this.x$14._2();
        System.err.println(new StringBuilder(12).append("Switches is ").append(this.switches()).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.switches())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                boolean bl = "-V".equals(A1) ? true : "--version".equals(A1);
                if (bl) {
                    InvariantPackerMain$.MODULE$.version();
                    object = BoxedUnit.UNIT;
                } else {
                    boolean bl2 = "-h".equals(A1) ? true : "--help".equals(A1);
                    if (bl2) {
                        InvariantPackerMain$.MODULE$.usage(true);
                        object = BoxedUnit.UNIT;
                    } else {
                        boolean bl3 = "--one-shot".equals(A1) ? true : "--oneshot".equals(A1);
                        if (bl3) {
                            InvariantPackerMain$.MODULE$.oneshot_$eq(true);
                            object = BoxedUnit.UNIT;
                        } else if (A1 != null) {
                            A1 A12 = A1;
                            Predef$.MODULE$.println((Object)new StringBuilder(19).append("Unknown argument '").append(A12).append("'").toString());
                            InvariantPackerMain$.MODULE$.usage(InvariantPackerMain$.MODULE$.usage$default$1());
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                boolean bl;
                boolean bl2;
                String string = x1;
                boolean bl3 = "-V".equals(string) ? true : "--version".equals(string);
                boolean bl4 = bl3 ? true : ((bl2 = "-h".equals(string) ? true : "--help".equals(string)) ? true : ((bl = "--one-shot".equals(string) ? true : "--oneshot".equals(string)) ? true : string != null));
                return bl4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        if (this.positionalArgs().length != 3) {
            BoxedUnit boxedUnit23;
            String errmsg = this.positionalArgs().length == 1 ? "Called with 1 argument" : new StringBuilder(22).append("Called with ").append(this.positionalArgs().length).append(" arguments").toString();
            errmsg = new StringBuilder(65).append(errmsg).append("; exactly 3 required (incomingDir destinationDir partitionerFile)").toString();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(errmsg);
                boxedUnit23 = BoxedUnit.UNIT;
            } else {
                boxedUnit23 = BoxedUnit.UNIT;
            }
            Predef$.MODULE$.println((Object)errmsg);
            this.usage(this.usage$default$1());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(74).append("\n=============================").append(" ").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" is starting =============================\n").toString());
            boxedUnit19 = BoxedUnit.UNIT;
        } else {
            boxedUnit19 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is {} {}", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP(), Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
            boxedUnit18 = BoxedUnit.UNIT;
        } else {
            boxedUnit18 = BoxedUnit.UNIT;
        }
        this.incomingDir = new Path(this.positionalArgs()[0]);
        this.destinationDir = new Path(this.positionalArgs()[1]);
        this.packLogicPath = new Path(this.positionalArgs()[2]);
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex = new Object();
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles = Predef$.MODULE$.Map().empty();
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU = PackerDeque$.MODULE$.empty();
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount = 0;
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount = 0;
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize = BoxesRunTime.unboxToLong((Object)this.maximumSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE)) - 65535L;
        this.taskCountInterval = 3;
        this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        this.hadoopConf = new Configuration();
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory = new CompressionCodecFactory(this.hadoopConf());
        FSDataInputStream stream = this.packLogicPath().getFileSystem(this.hadoopConf()).open(this.packLogicPath());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new RunTimeCodeLoader((InputStream)stream));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new Exception(new StringBuilder(48).append("Failed to compile run-time packing logic in '").append(this.packLogicPath()).append("': ").append(e).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        RunTimeCodeLoader runTimeCodeLoader = x2 = (RunTimeCodeLoader)success.value();
        RunTimeCodeLoader loader = runTimeCodeLoader;
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> loader.load());
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                throw new Exception(new StringBuilder(46).append("Failed to load run-time packing logic from '").append(this.packLogicPath()).append(": ").append(e).toString());
            }
            throw new MatchError((Object)try_2);
        }
        Success success2 = (Success)try_2;
        Object object = x = success2.value();
        Object object2 = result = object;
        if (object2 instanceof PartitionerPackLogic) {
            PartitionerPackLogic partitionerPackLogic = (PartitionerPackLogic)object2;
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionerPackLogic.version()), partitionerPackLogic.partitioners());
        } else if (object2 instanceof PartitionerConfigurator) {
            PartitionerConfigurator partitionerConfigurator = (PartitionerConfigurator)object2;
            PartitionerPackLogic ppl = new PartitionerPackLogic(partitionerConfigurator.partitioners());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ppl.version()), ppl.partitioners());
        } else {
            if (object2 instanceof PackingLogic) {
                throw new Exception("partitionerFile must contain partitions, not other PackingLogic");
            }
            throw new Exception("Unexpected type returned from compiled code: result.getClass");
        }
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        int packVersion = tuple24._1$mcI$sp();
        Seq partitioners = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)packVersion), (Object)partitioners);
        this.x$15 = tuple25;
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion = this.x$15._1$mcI$sp();
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners = (Seq)this.x$15._2();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} Settings::", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()});
            boxedUnit17 = BoxedUnit.UNIT;
        } else {
            boxedUnit17 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Incoming directory: {}", new Object[]{this.incomingDir()});
            boxedUnit16 = BoxedUnit.UNIT;
        } else {
            boxedUnit16 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Destination directory: {}", new Object[]{this.destinationDir()});
            boxedUnit15 = BoxedUnit.UNIT;
        } else {
            boxedUnit15 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Partitioner logic file: {}", new Object[]{this.packLogicPath()});
            boxedUnit14 = BoxedUnit.UNIT;
        } else {
            boxedUnit14 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output compression: {}", new Object[]{this.compressCodec().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")});
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum simultaneous writing tasks: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxThreads())});
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.oneshot()) {
            BoxedUnit boxedUnit24;
            BoxedUnit boxedUnit25;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Will shut down after a single scan of the incoming directory");
                boxedUnit25 = BoxedUnit.UNIT;
            } else {
                boxedUnit25 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Ignoring the following settings:");
                boxedUnit24 = BoxedUnit.UNIT;
            } else {
                boxedUnit24 = BoxedUnit.UNIT;
            }
            string = "- ";
        } else {
            string = this.ignored = "";
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Polling interval of the incoming directory: {}", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.pollingInterval())});
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Open an output file when it has an input file noticed this long ago: {} seconds", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)(this.maxInputAge() / 1000))});
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Open an output file when it has this number of input files: {}", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.minInputCount())});
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Open an output file when the sum of the sizes of the input files exceeds this value: {} octets", new Object[]{this.ignored(), BoxesRunTime.boxToLong((long)this.minInputSize())});
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Maximum time an output file may remain idle before being closed: {} seconds", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.outputIdleSeconds())});
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(42).append("Approximate maximum size of output files: ").append(this.maximumSize().map((Function1 & Serializable & scala.Serializable)x$16 -> InvariantPackerMain$.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)x$16))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unlimited")).toString());
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of open output files: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.fileCacheSize())});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Observation domain for output files: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.observationDomain())});
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray())).mkString(",")});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} threads are starting::", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ShutdownHookManager.get().addShutdownHook((Runnable)new InvariantPackerMain.Cleanup(), this.SHUTDOWN_PRIORITY());
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new PackerThreadFactory("ActiveWriter-"));
        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher = new InvariantPackerMain.MyDirWatcher(this.incomingDir());
        boolean bl = this.running = !this.oneshot();
        if (this.oneshot()) {
            BoxedUnit boxedUnit26;
            BoxedUnit boxedUnit27;
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher.runOnce();
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher.shutdown();
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles.values().foreach((Function1 & Serializable & scala.Serializable)rp -> {
                InvariantPackerMain$.MODULE$.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.execute(rp);
                return BoxedUnit.UNIT;
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Running with one-shot enabled; waiting for threads to end...");
                boxedUnit27 = BoxedUnit.UNIT;
            } else {
                boxedUnit27 = BoxedUnit.UNIT;
            }
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.shutdown();
            do {
                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts();
            } while (!this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.awaitTermination(1L, TimeUnit.SECONDS));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("All tasks have completed");
                boxedUnit26 = BoxedUnit.UNIT;
            } else {
                boxedUnit26 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("{} is done", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit28;
            BoxedUnit boxedUnit29;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Starting the incoming directory poller");
                boxedUnit29 = BoxedUnit.UNIT;
            } else {
                boxedUnit29 = BoxedUnit.UNIT;
            }
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher.runPeriodically(this.pollingInterval());
            PackerThreadFactory checkFactory = new PackerThreadFactory("OutputFileCheck-");
            ScheduledThreadPoolExecutor checkTaskPool = new ScheduledThreadPoolExecutor(1, checkFactory);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Starting the output file checker");
                boxedUnit28 = BoxedUnit.UNIT;
            } else {
                boxedUnit28 = BoxedUnit.UNIT;
            }
            checkTaskPool.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            checkTaskPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            checkTaskPool.setRemoveOnCancelPolicy(true);
            checkTaskPool.scheduleWithFixedDelay(new InvariantPackerMain.CheckRepositoryPaths(), this.pollingInterval() / 2, this.pollingInterval(), TimeUnit.SECONDS);
            do {
                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts();
            } while (this.running() && !this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.awaitTermination(this.taskCountInterval, TimeUnit.SECONDS));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private InvariantPackerMain$() {
        MODULE$ = this;
        App.$init$((App)this);
        StrictLogging.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new InvariantPackerMain$delayedInit$body(this));
    }
}

