/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.io.ipfix.Record;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.Reader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.packer.Writer;
import org.cert.netsa.mothra.tools.FileJoinerMain;
import org.cert.netsa.mothra.tools.FileJoinerMain$delayedInit$body;
import resource.Resource$;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class FileJoinerMain$
implements App,
StrictLogging {
    public static FileJoinerMain$ MODULE$;
    private String DEFAULT_COMPRESSION;
    private int DEFAULT_MAX_THREADS;
    private String DEFAULT_SPAWN_THREAD;
    private /* synthetic */ Tuple2 x$2;
    private String[] switches;
    private String[] positionalArgs;
    private InfoModel infoModel;
    private Configuration hadoopConf;
    private CompressionCodecFactory codecFactory;
    private Option<CompressionCodec> compressCodec;
    private int maxThreads;
    private int minCountToJoin;
    private Option<Object> maximumSize;
    private String spawnThread;
    private Map<String, Object> spawnThreadMap;
    private boolean threadPerDirectory;
    private List<Path> org$cert$netsa$mothra$tools$FileJoinerMain$$dirList;
    private FileSystem fileSystem;
    private LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$FileJoinerMain$$signalQueue;
    private ThreadPoolExecutor org$cert$netsa$mothra$tools$FileJoinerMain$$pool;
    private int logTaskCountInterval;
    private ScheduledExecutorService logTaskCountThread;
    private Regex repoFileRegex;
    private final Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new FileJoinerMain$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.FileJoinerMain mothra-tools.jar <s1> [<s2> <s3> ...]\n\ns1..sn:         Directories to process, as Hadoop URIs\n");
        if (full) {
            Predef$.MODULE$.print((Object)new java.lang.StringBuilder(2622).append("\nFileJoiner reduces the number of data files in a Mothra repository.  It\nmay also be used to modify the files' compression.\n\nFileJoiner runs as a batch process, not as a daemon.\n\nFileJoiner makes a single recursive scan of the source directories <s1>,\n<s2>, ... for files whose names match the pattern \"YYYYMMDD.HH.\" or\n\"YYYYMMDD.HH-PTddH.\" (It looks for files matching the regular expression\n`^\\d{8}\\.\\d{2}(?:-PT\\d\\d?H)?\\.`) Files whose names match that pattern are\nprocessed by FileJoiner to create a single new file in the same directory\nthat has the same prefix as the originals, and then the original file(s)\nare removed.\n\nBy default, files that share the same prefix are only processed when there\nare two or more files.  To force re-writing when there is a single file,\nset the Java property `mothra.filejoiner.minCountToJoin` to a value less\nthan 2.  The property may also be used to create a new file only when an\n\"excessive\" number of files share the same prefix.\n\nThere is always a single thread that recursively scans the directories.\nThe number of threads that joins the files may be set by specifying the\n`mothra.filejoiner.maxThreads` Java property.  If not specified, the\ndefault is ").append(this.DEFAULT_MAX_THREADS()).append(".\n\nFileJoiner may be run so that either it spawns a thread for every\ndirectory that contains files to be joined or it spawns a thread for each\nset of files in a directory that have the same prefix.  The behavior is\ncontrolled whether the `mothra.filejoiner.spawnThread` Java property is\nset to `by-prefix` or `by-directory`.  The default is `").append(this.DEFAULT_SPAWN_THREAD()).append("`.\n(For backwards compatibility, `by-hour` is an alias for `by-prefix`.)\n\nBy default, FileJoiner does not compress the files it writes.\n(NOTE: It should support writing the output using the same compression as\nthe input.)  To specify the compression codec that it should use, specify\nthe `mothra.filejoiner.compression` Java property.  Values typically\nsupported by Hadoop include `bzip2`, `gzip`, `lz4`, `lzo`, `lzop`,\n`snappy`, and `default`.  The empty string indicates no compression.\n\nFileJoiner joins files sharing the same prefix into a single file by\ndefault.  The `mothra.filejoiner.maximumSize` Java property may be used to\nlimit the maximum file size.  The size is for the compressed file if\ncompression is active.  The value is approximate since it is only checked\nafter the data appears on disk which occurs in large blocks because of\nbuffering by the Java stream code and the compression algorithm.  (By\nsetting that property and `mothra.filejoiner.minCountToJoin` to 1, you can\nforce large files to be split into smaller ones, making the FileJoiner a\nfile-splitter.)\n").toString());
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(11).append("FileJoiner ").append(Version$.MODULE$.get(Version$.MODULE$.get$default$1())).toString());
        System.exit(0);
    }

    public String DEFAULT_COMPRESSION() {
        return this.DEFAULT_COMPRESSION;
    }

    public int DEFAULT_MAX_THREADS() {
        return this.DEFAULT_MAX_THREADS;
    }

    public String DEFAULT_SPAWN_THREAD() {
        return this.DEFAULT_SPAWN_THREAD;
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public void org$cert$netsa$mothra$tools$FileJoinerMain$$joinFilesBasename(Path dir, String basename, Set<Path> files) {
        BoxedUnit boxedUnit;
        ObjectRef writer = ObjectRef.create(null);
        ObjectRef newPaths = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef removeList = ObjectRef.create((Object)List$.MODULE$.empty());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Joining {} '{}*' files in {}/", new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, dir});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long t0 = System.currentTimeMillis();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            writer$1.elem = new Writer(dir, basename, MODULE$.compressCodec(), MODULE$.maximumSize(), MODULE$.infoModel(), MODULE$.hadoopConf());
            Option<FsPermission> originalPerm = ((Writer)writer$1.elem).originalPermission();
            if (MODULE$.maximumSize().isEmpty()) {
                files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                    FileJoinerMain$.$anonfun$joinFilesBasename$2(writer, removeList, f);
                    return BoxedUnit.UNIT;
                });
            } else {
                files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                    FileJoinerMain$.$anonfun$joinFilesBasename$6(writer, newPaths, basename, dir, removeList, f);
                    return BoxedUnit.UNIT;
                });
            }
            ((Writer)writer$1.elem).close();
            Path path = ((Writer)writer$1.elem).exportFile();
            newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
            writer$1.elem = null;
            originalPerm.foreach((Function1 & Serializable & scala.Serializable)perm -> {
                FileJoinerMain$.$anonfun$joinFilesBasename$10(newPaths, perm);
                return BoxedUnit.UNIT;
            });
            ((List)removeList$1.elem).foreach((Function1 & Serializable & scala.Serializable)f -> {
                FileJoinerMain$.$anonfun$joinFilesBasename$12(f);
                return BoxedUnit.UNIT;
            });
        });
        if (try_ instanceof Success) {
            if (this.logger().underlying().isDebugEnabled()) {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)files.size());
                String arg$macro$2 = basename;
                Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)((List)newPaths.elem).size());
                Path arg$macro$4 = dir;
                double arg$macro$5 = (double)(System.currentTimeMillis() - t0) / 1000.0;
                this.logger().underlying().debug(new StringOps("Finished joining %s '%s*' files into %s files in %s/ in %.3f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4, BoxesRunTime.boxToDouble((double)arg$macro$5)})));
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to join {} '{}*' files in {}/: {}", new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, dir, e.toString()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Option$.MODULE$.apply((Object)((Writer)writer.elem)).foreach((Function1 & Serializable & scala.Serializable)w -> {
                FileJoinerMain$.$anonfun$joinFilesBasename$14(newPaths, w);
                return BoxedUnit.UNIT;
            });
            ((List)newPaths.elem).foreach((Function1 & Serializable & scala.Serializable)f -> {
                FileJoinerMain$.$anonfun$joinFilesBasename$15(dir, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)try_);
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private CompressionCodecFactory codecFactory() {
        return this.codecFactory;
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public int minCountToJoin() {
        return this.minCountToJoin;
    }

    public Option<Object> maximumSize() {
        return this.maximumSize;
    }

    public String spawnThread() {
        return this.spawnThread;
    }

    public Map<String, Object> spawnThreadMap() {
        return this.spawnThreadMap;
    }

    private boolean threadPerDirectory() {
        return this.threadPerDirectory;
    }

    public List<Path> org$cert$netsa$mothra$tools$FileJoinerMain$$dirList() {
        return this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList;
    }

    private void org$cert$netsa$mothra$tools$FileJoinerMain$$dirList_$eq(List<Path> x$1) {
        this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList = x$1;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$FileJoinerMain$$signalQueue() {
        return this.org$cert$netsa$mothra$tools$FileJoinerMain$$signalQueue;
    }

    public ThreadPoolExecutor org$cert$netsa$mothra$tools$FileJoinerMain$$pool() {
        return this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool;
    }

    public int logTaskCountInterval() {
        return this.logTaskCountInterval;
    }

    private ScheduledExecutorService logTaskCountThread() {
        return this.logTaskCountThread;
    }

    private Regex repoFileRegex() {
        return this.repoFileRegex;
    }

    public static final /* synthetic */ boolean $anonfun$x$2$1(String x$1) {
        String string = x$1.substring(0, 1);
        String string2 = "-";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$5(ObjectRef writer$1, Record record) {
        ((Writer)writer$1.elem).add(record);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$4(ObjectRef writer$1, ObjectRef removeList$1, Path f$1, Reader reader) {
        reader.foreach((Function1 & Serializable & scala.Serializable)record -> {
            FileJoinerMain$.$anonfun$joinFilesBasename$5(writer$1, record);
            return BoxedUnit.UNIT;
        });
        Path path = f$1;
        removeList$1.elem = (List)((List)removeList$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$2(ObjectRef writer$1, ObjectRef removeList$1, Path f) {
        resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new Reader(f, MODULE$.codecFactory(), MODULE$.infoModel(), MODULE$.hadoopConf()), Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            FileJoinerMain$.$anonfun$joinFilesBasename$4(writer$1, removeList$1, f, reader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$9(ObjectRef writer$1, ObjectRef newPaths$1, String basename$1, Path dir$1, Record record) {
        if (((Writer)writer$1.elem).reachedMaxSize()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("Closing file '{}'", new Object[]{((Writer)writer$1.elem).getName()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((Writer)writer$1.elem).close();
            Path path = ((Writer)writer$1.elem).exportFile();
            newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
            writer$1.elem = null;
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("Creating additional writer for '{}*' files in {}", new Object[]{basename$1, dir$1});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            writer$1.elem = new Writer(dir$1, basename$1, MODULE$.compressCodec(), MODULE$.maximumSize(), MODULE$.infoModel(), MODULE$.hadoopConf());
        }
        ((Writer)writer$1.elem).add(record);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$8(ObjectRef writer$1, ObjectRef newPaths$1, String basename$1, Path dir$1, ObjectRef removeList$1, Path f$2, Reader reader) {
        reader.foreach((Function1 & Serializable & scala.Serializable)record -> {
            FileJoinerMain$.$anonfun$joinFilesBasename$9(writer$1, newPaths$1, basename$1, dir$1, record);
            return BoxedUnit.UNIT;
        });
        Path path = f$2;
        removeList$1.elem = (List)((List)removeList$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$6(ObjectRef writer$1, ObjectRef newPaths$1, String basename$1, Path dir$1, ObjectRef removeList$1, Path f) {
        resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new Reader(f, MODULE$.codecFactory(), MODULE$.infoModel(), MODULE$.hadoopConf()), Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            FileJoinerMain$.$anonfun$joinFilesBasename$8(writer$1, newPaths$1, basename$1, dir$1, removeList$1, f, reader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$11(FsPermission perm$1, Path f) {
        MODULE$.fileSystem().setPermission(f, perm$1);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$10(ObjectRef newPaths$1, FsPermission perm) {
        ((List)newPaths$1.elem).foreach((Function1 & Serializable & scala.Serializable)f -> {
            FileJoinerMain$.$anonfun$joinFilesBasename$11(perm, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$12(Path f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.fileSystem().delete(f, false));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Failed to remove old file '{}': {}", new Object[]{f, e.toString()});
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$14(ObjectRef newPaths$1, Writer w) {
        Path path = w.exportFile();
        newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$15(Path dir$1, Path f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.fileSystem().delete(f, false));
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new java.lang.StringBuilder(33).append("Failed to remove new file '").append(f.getName()).append("' in ").append(dir$1).append("/").toString(), ex);
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ int $anonfun$maxThreads$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ int $anonfun$minCountToJoin$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ long $anonfun$maximumSize$1(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Path x$13) {
        FileSystem fileSystem = x$13.getFileSystem(MODULE$.hadoopConf());
        FileSystem fileSystem2 = MODULE$.fileSystem();
        return fileSystem == null ? fileSystem2 != null : !fileSystem.equals(fileSystem2);
    }

    private final /* synthetic */ RemoteIterator liftedTree1$1(Path dir$2) {
        RemoteIterator remoteIterator;
        try {
            remoteIterator = this.fileSystem().listLocatedStatus(dir$2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Unable to get status of '{}/': {}", new Object[]{dir$2, e.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                remoteIterator = new RemoteIterator<LocatedFileStatus>(){

                    public boolean hasNext() {
                        return false;
                    }

                    public LocatedFileStatus next() {
                        throw new NoSuchElementException();
                    }
                };
            }
            throw throwable;
        }
        return remoteIterator;
    }

    public static final /* synthetic */ boolean $anonfun$new$7(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 != null) {
            Set set = (Set)tuple2._2();
            return set.size() >= MODULE$.minCountToJoin();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$9(Path dir$2, Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 != null) {
            String basename = (String)tuple2._1();
            Set set = (Set)tuple2._2();
            MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().execute(new FileJoinerMain.BasenameFilesJob(dir$2, basename, (Set<Path>)set));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$FileJoinerMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        None$ none$;
        String compressName;
        BoxedUnit boxedUnit14;
        BoxedUnit boxedUnit15;
        this.DEFAULT_COMPRESSION = "";
        this.DEFAULT_MAX_THREADS = 6;
        this.DEFAULT_SPAWN_THREAD = "by-directory";
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileJoinerMain$.$anonfun$x$2$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] switches = (String[])tuple2._1();
        String[] positionalArgs = (String[])tuple2._2();
        this.x$2 = new Tuple2((Object)switches, (Object)positionalArgs);
        this.switches = (String[])this.x$2._1();
        this.positionalArgs = (String[])this.x$2._2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.switches())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if ("-V".equals(A1) ? true : "--version".equals(A1)) {
                    FileJoinerMain$.MODULE$.version();
                    return (B1)BoxedUnit.UNIT;
                }
                if ("-h".equals(A1) ? true : "--help".equals(A1)) {
                    FileJoinerMain$.MODULE$.usage(true);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    Predef$.MODULE$.println((Object)new java.lang.StringBuilder(19).append("Unknown argument '").append(A12).append("'").toString());
                    FileJoinerMain$.MODULE$.usage(FileJoinerMain$.MODULE$.usage$default$1());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                if ("-V".equals(string) ? true : "--version".equals(string)) {
                    return true;
                }
                if ("-h".equals(string) ? true : "--help".equals(string)) {
                    return true;
                }
                return string != null;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n============================= FileJoiner is starting =============================\n");
            boxedUnit15 = BoxedUnit.UNIT;
        } else {
            boxedUnit15 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is FileJoiner {}", new Object[]{Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
            boxedUnit14 = BoxedUnit.UNIT;
        } else {
            boxedUnit14 = BoxedUnit.UNIT;
        }
        if (this.positionalArgs().length == 0) {
            BoxedUnit boxedUnit16;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Called with no args; at least 1 required");
                boxedUnit16 = BoxedUnit.UNIT;
            } else {
                boxedUnit16 = BoxedUnit.UNIT;
            }
            this.usage(this.usage$default$1());
        }
        this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        this.hadoopConf = new Configuration();
        this.codecFactory = new CompressionCodecFactory(this.hadoopConf());
        String string = compressName = (String)package$.MODULE$.props().get("mothra.filejoiner.compression").getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_COMPRESSION());
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
        } else {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                CompressionCodec codec = MODULE$.codecFactory().getCodecByName(compressName);
                codec.createCompressor();
                return codec;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                none$ = Option$.MODULE$.apply((Object)ok);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit17;
                BoxedUnit boxedUnit18;
                BoxedUnit boxedUnit19;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unable to initialize compressor '{}': {}", new Object[]{compressName, e});
                    boxedUnit19 = BoxedUnit.UNIT;
                } else {
                    boxedUnit19 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(34).append("Unable to initialize compressor '").append(compressName).append("'").toString(), e);
                    boxedUnit18 = BoxedUnit.UNIT;
                } else {
                    boxedUnit18 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit17 = BoxedUnit.UNIT;
                } else {
                    boxedUnit17 = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
        }
        this.compressCodec = none$;
        this.maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.filejoiner.maxThreads").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)FileJoinerMain$.$anonfun$maxThreads$1(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_MAX_THREADS()));
        Predef$.MODULE$.require(this.maxThreads() >= 1);
        this.minCountToJoin = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.filejoiner.minCountToJoin").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)FileJoinerMain$.$anonfun$minCountToJoin$1(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2));
        this.maximumSize = package$.MODULE$.props().get("mothra.filejoiner.maximumSize").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)FileJoinerMain$.$anonfun$maximumSize$1(x$11)));
        this.spawnThread = (String)package$.MODULE$.props().get("mothra.filejoiner.spawnThread").getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_SPAWN_THREAD());
        this.spawnThreadMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-directory"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-prefix"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-hour"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        this.threadPerDirectory = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)MODULE$.spawnThreadMap().apply((Object)MODULE$.spawnThread()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            StringBuilder sb = new StringBuilder();
            MODULE$.spawnThreadMap().keys().addString(sb, "mothra.filejoiner.spawnThread must be one of: '", "', '", "'");
            throw new Exception(sb.mkString());
        }));
        this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.positionalArgs())).toList().map((Function1 & Serializable & scala.Serializable)x$12 -> new Path(x$12), List$.MODULE$.canBuildFrom());
        this.fileSystem = ((Path)this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().head()).getFileSystem(this.hadoopConf());
        if (this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().drop(1).exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FileJoinerMain$.$anonfun$new$1(x$13)))) {
            BoxedUnit boxedUnit20;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("source directories use different file systems");
                boxedUnit20 = BoxedUnit.UNIT;
            } else {
                boxedUnit20 = BoxedUnit.UNIT;
            }
            throw new Exception("source directories use different file systems");
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("FileJoiner settings::");
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of top-level directories to scan: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().size())});
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of file joining threads: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxThreads())});
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Minimum number of files to join: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.minCountToJoin())});
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Policy for starting threads: {}", new Object[]{this.spawnThread()});
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Approximate maximum output file size: {}", new Object[]{this.maximumSize().getOrElse((Function0 & Serializable & scala.Serializable)() -> "unlimited")});
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output file compression: {}", new Object[]{this.compressCodec().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")});
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray())).mkString(",")});
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        this.org$cert$netsa$mothra$tools$FileJoinerMain$$signalQueue = new LinkedBlockingQueue();
        this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("FileJoinerThread-"));
        this.logTaskCountInterval = 5;
        this.logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-"));
        this.logTaskCountThread().scheduleAtFixedRate(new Thread(){

            public void run() {
                BoxedUnit boxedUnit;
                int active = FileJoinerMain$.MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().getActiveCount();
                long completed = FileJoinerMain$.MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().getCompletedTaskCount();
                long total = FileJoinerMain$.MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().getTaskCount();
                if (FileJoinerMain$.MODULE$.logger().underlying().isInfoEnabled()) {
                    FileJoinerMain$.MODULE$.logger().underlying().info("Directories to scan: {}, Total tasks: {}, Completed tasks: {}, Active tasks: {}, Queued tasks: {}", new Object[]{BoxesRunTime.boxToInteger((int)FileJoinerMain$.MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().size()), BoxesRunTime.boxToLong((long)total), BoxesRunTime.boxToLong((long)completed), BoxesRunTime.boxToInteger((int)active), BoxesRunTime.boxToLong((long)(total - (long)active - completed))});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
        this.repoFileRegex = new Regex("\\A(\\d{8}\\.\\d{2}(?:-PT\\d\\d?H)?\\.).*\\Z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting recursive scan of {} director{}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().size()), 1 == this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().size() ? "y" : "ies"});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        while (this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().nonEmpty()) {
            boolean bl;
            BoxedUnit boxedUnit21;
            Path dir = (Path)this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().head();
            this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList_$eq((List<Path>)((List)this.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().tail()));
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Scanning directory '{}/'", new Object[]{dir});
                boxedUnit21 = BoxedUnit.UNIT;
            } else {
                boxedUnit21 = BoxedUnit.UNIT;
            }
            scala.collection.mutable.Map fileMap = Map$.MODULE$.empty();
            RemoteIterator iter = this.liftedTree1$1(dir);
            do {
                Try try_;
                if ((try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    block2: {
                        LocatedFileStatus entry;
                        block1: {
                            if (!iter.hasNext()) {
                                return false;
                            }
                            entry = (LocatedFileStatus)iter.next();
                            if (!entry.isDirectory()) break block1;
                            Path path = entry.getPath();
                            MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList_$eq((List<Path>)((List)MODULE$.org$cert$netsa$mothra$tools$FileJoinerMain$$dirList().$plus$colon((Object)path, List$.MODULE$.canBuildFrom())));
                            break block2;
                        }
                        if (!entry.isFile()) break block2;
                        MODULE$.repoFileRegex().findFirstMatchIn((CharSequence)entry.getPath().getName()).foreach((Function1 & Serializable & scala.Serializable)m -> (Set)((SetLike)fileMap.getOrElseUpdate((Object)m.group(1), (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty())).$plus$eq((Object)entry.getPath()));
                    }
                    return true;
                })) instanceof Success) {
                    boolean ok;
                    Success success = (Success)try_;
                    bl = ok = BoxesRunTime.unboxToBoolean((Object)success.value());
                    continue;
                }
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit22;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Unable to read directory entry: {}", new Object[]{e.toString()});
                        boxedUnit22 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit22 = BoxedUnit.UNIT;
                    }
                    bl = true;
                    continue;
                }
                throw new MatchError((Object)try_);
            } while (bl);
            if (this.threadPerDirectory()) {
                if (fileMap.size() < this.minCountToJoin()) continue;
                this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().execute(new FileJoinerMain.DirectoryJob(dir, (scala.collection.mutable.Map<String, Set<Path>>)fileMap));
                continue;
            }
            fileMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)FileJoinerMain$.$anonfun$new$7(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)FileJoinerMain$.$anonfun$new$8(x$15))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                FileJoinerMain$.$anonfun$new$9(dir, x$16);
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Completed recursive directory scan");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Waiting for {} of {} tasks to complete...", new Object[]{BoxesRunTime.boxToLong((long)(this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().getTaskCount() - this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().getCompletedTaskCount())), BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().getTaskCount())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().shutdown();
        this.org$cert$netsa$mothra$tools$FileJoinerMain$$signalQueue().clear();
        while (!this.org$cert$netsa$mothra$tools$FileJoinerMain$$pool().isTerminated()) {
            this.org$cert$netsa$mothra$tools$FileJoinerMain$$signalQueue().poll(5L, TimeUnit.SECONDS);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All tasks have completed");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.logTaskCountThread().shutdown();
        this.logTaskCountThread().awaitTermination(1L, TimeUnit.SECONDS);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("FileJoiner is done");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private FileJoinerMain$() {
        MODULE$ = this;
        App.$init$((App)this);
        StrictLogging.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new FileJoinerMain$delayedInit$body(this));
    }
}

