/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.cert.netsa.io.ipfix.InfoElement;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.io.ipfix.Record;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.Reader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.FileSanitizerMain;
import org.cert.netsa.mothra.tools.FileSanitizerMain$SanitizingWriter$;
import org.cert.netsa.mothra.tools.FileSanitizerMain$delayedInit$body;
import resource.Resource$;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class FileSanitizerMain$
implements App,
StrictLogging {
    public static FileSanitizerMain$ MODULE$;
    private String DEFAULT_COMPRESSION;
    private int DEFAULT_MAX_THREADS;
    private String DEFAULT_SPAWN_THREAD;
    private /* synthetic */ Tuple2 x$2;
    private String[] switches;
    private String[] positionalArgs;
    private Configuration hadoopConf;
    private InfoModel infoModel;
    private Set<InfoElement> toRemove;
    private List<Path> org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList;
    private CompressionCodecFactory codecFactory;
    private Option<CompressionCodec> compressCodec;
    private int maxThreads;
    private Option<Object> maximumSize;
    private String spawnThread;
    private Map<String, Object> spawnThreadMap;
    private boolean threadPerDirectory;
    private FileSystem fileSystem;
    private LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue;
    private ThreadPoolExecutor org$cert$netsa$mothra$tools$FileSanitizerMain$$pool;
    private int logTaskCountInterval;
    private ScheduledExecutorService logTaskCountThread;
    private Regex repoFileRegex;
    private final Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new FileSanitizerMain$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.FileSanitizerMain mothra-tools.jar <f1>[,<f2>[,<f3>...]] <s1> [<s2> <s3> ...]\n\nf1..fn:         Names of InfoElements to be removed from the files\ns1..sn:         Directories to process, as Hadoop URIs\n");
        if (full) {
            Predef$.MODULE$.print((Object)new java.lang.StringBuilder(2527).append("\nFileSanitizer removes Information Element fields from the hourly files in a\nMothra repository.  In addition, when multiple files share the same name\nexcept for the UUID, FileSanitizer combines those files together.\n\nThe IE fields to be removed must be specified in a single argument, as a\ncomma-separated list of names, such as\n'sourceTransportPort,destinationTransportPort'.\n\nEach remaining argument is a single directory to process.\n\nFileSanitizer runs as a batch process, not as a daemon.\n\nFileSanitizer makes a single recursive scan of the source directories\n<s1>, <s2>, ... for files whose names match the pattern \"YYYYMMDD.HH.\" or\n\"YYYYMMDD.HH-PTddH.\" (It looks for files matching the regular expression\n`^\\d{8}\\.\\d{2}(?:PTddH)?\\.`) Files whose names match that pattern are\nprocessed by FileSanitizer to remove the named Information Elements.  All\nfiles where the regular expression matched the same string are joined into a\nsingle file, similar to the FileJoiner.  Finally, the original files are\nremoved.\n\nThere is always a single thread that recursively scans the directories.\nThe number of threads that sanitizes and joins the files may be set by\nspecifying the `mothra.filesanitizer.maxThreads` Java property.  If not\nspecified, the default is ").append(this.DEFAULT_MAX_THREADS()).append(".\n\nFileSanitizer may be run so that either it spawns a thread for every\ndirectory that contains files to process or it spawns a thread for each\nset of files in a directory that have the same prefix.  The behavior is\ncontrolled whether the `mothra.filesanitizer.spawnThread` Java property is\nset to `by-prefix` or `by-directory`.  The default is `").append(this.DEFAULT_SPAWN_THREAD()).append("`.\n(For backwards compatibility, `by-hour` is an alias for `by-prefix`.)\n\nBy default, FileSanitizer does not compress the files it writes.\n(NOTE: It should support writing the output using the same compression as\nthe input.)  To specify the compression codec that it should use, specify\nthe `mothra.filesanitizer.compression` Java property.  Values typically\nsupported by Hadoop include `bzip2`, `gzip`, `lz4`, `lzo`, `lzop`,\n`snappy`, and `default`.  The empty string indicates no compression.\n\nFileSanitizer joins files sharing the same prefix into a single file\nby default.  The `mothra.filesanitizer.maximumSize` Java property may be\nused to limit the maximum file size.  The size is for the compressed file\nif compression is active.  The value is approximate since it is only\nchecked after the data appears on disk which occurs in large blocks\nbecause of buffering by the Java stream code and the compression algorithm.\n").toString());
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(14).append("FileSanitizer ").append(Version$.MODULE$.get(Version$.MODULE$.get$default$1())).toString());
        System.exit(0);
    }

    public String DEFAULT_COMPRESSION() {
        return this.DEFAULT_COMPRESSION;
    }

    public int DEFAULT_MAX_THREADS() {
        return this.DEFAULT_MAX_THREADS;
    }

    public String DEFAULT_SPAWN_THREAD() {
        return this.DEFAULT_SPAWN_THREAD;
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Set<InfoElement> toRemove() {
        return this.toRemove;
    }

    public List<Path> org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList() {
        return this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList;
    }

    private void org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList_$eq(List<Path> x$1) {
        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList = x$1;
    }

    public void org$cert$netsa$mothra$tools$FileSanitizerMain$$sanitizeFilesBasename(Path dir, String basename, Set<Path> files) {
        BoxedUnit boxedUnit;
        ObjectRef writer = ObjectRef.create(null);
        ObjectRef newPaths = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef removeList = ObjectRef.create((Object)List$.MODULE$.empty());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Sanitizing {} '{}*' files in {}/", new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, dir});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long t0 = System.currentTimeMillis();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            writer$1.elem = FileSanitizerMain$SanitizingWriter$.MODULE$.apply(dir, basename);
            Option<FsPermission> originalPerm = ((FileSanitizerMain.SanitizingWriter)writer$1.elem).originalPermission();
            if (MODULE$.maximumSize().isEmpty()) {
                files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                    FileSanitizerMain$.$anonfun$sanitizeFilesBasename$2(writer, removeList, f);
                    return BoxedUnit.UNIT;
                });
            } else {
                files.foreach((Function1 & Serializable & scala.Serializable)f -> {
                    FileSanitizerMain$.$anonfun$sanitizeFilesBasename$6(writer, newPaths, basename, dir, removeList, f);
                    return BoxedUnit.UNIT;
                });
            }
            ((FileSanitizerMain.SanitizingWriter)writer$1.elem).close();
            Path path = ((FileSanitizerMain.SanitizingWriter)writer$1.elem).exportFile();
            newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
            writer$1.elem = null;
            originalPerm.foreach((Function1 & Serializable & scala.Serializable)perm -> {
                FileSanitizerMain$.$anonfun$sanitizeFilesBasename$10(newPaths, perm);
                return BoxedUnit.UNIT;
            });
            ((List)removeList$1.elem).foreach((Function1 & Serializable & scala.Serializable)f -> {
                FileSanitizerMain$.$anonfun$sanitizeFilesBasename$12(f);
                return BoxedUnit.UNIT;
            });
        });
        if (try_ instanceof Success) {
            if (this.logger().underlying().isDebugEnabled()) {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)files.size());
                String arg$macro$2 = basename;
                Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)((List)newPaths.elem).size());
                Path arg$macro$4 = dir;
                double arg$macro$5 = (double)(System.currentTimeMillis() - t0) / 1000.0;
                this.logger().underlying().debug(new StringOps("Finished sanitizing %s '%s*' files into %s files in %s/ in %.3f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4, BoxesRunTime.boxToDouble((double)arg$macro$5)})));
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to sanitize {} '{}*' files in {}/: {}", new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, dir, e});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Option$.MODULE$.apply((Object)((FileSanitizerMain.SanitizingWriter)writer.elem)).foreach((Function1 & Serializable & scala.Serializable)w -> {
                FileSanitizerMain$.$anonfun$sanitizeFilesBasename$14(newPaths, w);
                return BoxedUnit.UNIT;
            });
            ((List)newPaths.elem).foreach((Function1 & Serializable & scala.Serializable)f -> {
                FileSanitizerMain$.$anonfun$sanitizeFilesBasename$15(dir, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)try_);
    }

    private CompressionCodecFactory codecFactory() {
        return this.codecFactory;
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public Option<Object> maximumSize() {
        return this.maximumSize;
    }

    public String spawnThread() {
        return this.spawnThread;
    }

    public Map<String, Object> spawnThreadMap() {
        return this.spawnThreadMap;
    }

    private boolean threadPerDirectory() {
        return this.threadPerDirectory;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue() {
        return this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue;
    }

    public ThreadPoolExecutor org$cert$netsa$mothra$tools$FileSanitizerMain$$pool() {
        return this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool;
    }

    public int logTaskCountInterval() {
        return this.logTaskCountInterval;
    }

    private ScheduledExecutorService logTaskCountThread() {
        return this.logTaskCountThread;
    }

    private Regex repoFileRegex() {
        return this.repoFileRegex;
    }

    public static final /* synthetic */ boolean $anonfun$x$2$1(String x$1) {
        String string = x$1.substring(0, 1);
        String string2 = "-";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$toRemove$1(String ieName) {
        String string = ieName;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$5(ObjectRef writer$1, Record record) {
        ((FileSanitizerMain.SanitizingWriter)writer$1.elem).add(record);
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$4(ObjectRef writer$1, ObjectRef removeList$1, Path f$1, Reader reader) {
        reader.foreach((Function1 & Serializable & scala.Serializable)record -> {
            FileSanitizerMain$.$anonfun$sanitizeFilesBasename$5(writer$1, record);
            return BoxedUnit.UNIT;
        });
        Path path = f$1;
        removeList$1.elem = (List)((List)removeList$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$2(ObjectRef writer$1, ObjectRef removeList$1, Path f) {
        resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new Reader(f, MODULE$.codecFactory(), MODULE$.infoModel(), MODULE$.hadoopConf()), Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            FileSanitizerMain$.$anonfun$sanitizeFilesBasename$4(writer$1, removeList$1, f, reader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$9(ObjectRef writer$1, ObjectRef newPaths$1, String basename$1, Path dir$1, Record record) {
        if (((FileSanitizerMain.SanitizingWriter)writer$1.elem).reachedMaxSize()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("Closing file '{}'", new Object[]{((FileSanitizerMain.SanitizingWriter)writer$1.elem).getName()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((FileSanitizerMain.SanitizingWriter)writer$1.elem).close();
            Path path = ((FileSanitizerMain.SanitizingWriter)writer$1.elem).exportFile();
            newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
            writer$1.elem = null;
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("Creating additional writer for '{}*' files in {}", new Object[]{basename$1, dir$1});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            writer$1.elem = FileSanitizerMain$SanitizingWriter$.MODULE$.apply(dir$1, basename$1);
        }
        ((FileSanitizerMain.SanitizingWriter)writer$1.elem).add(record);
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$8(ObjectRef writer$1, ObjectRef newPaths$1, String basename$1, Path dir$1, ObjectRef removeList$1, Path f$2, Reader reader) {
        reader.foreach((Function1 & Serializable & scala.Serializable)record -> {
            FileSanitizerMain$.$anonfun$sanitizeFilesBasename$9(writer$1, newPaths$1, basename$1, dir$1, record);
            return BoxedUnit.UNIT;
        });
        Path path = f$2;
        removeList$1.elem = (List)((List)removeList$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$6(ObjectRef writer$1, ObjectRef newPaths$1, String basename$1, Path dir$1, ObjectRef removeList$1, Path f) {
        resource.package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new Reader(f, MODULE$.codecFactory(), MODULE$.infoModel(), MODULE$.hadoopConf()), Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            FileSanitizerMain$.$anonfun$sanitizeFilesBasename$8(writer$1, newPaths$1, basename$1, dir$1, removeList$1, f, reader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$11(FsPermission perm$1, Path f) {
        MODULE$.fileSystem().setPermission(f, perm$1);
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$10(ObjectRef newPaths$1, FsPermission perm) {
        ((List)newPaths$1.elem).foreach((Function1 & Serializable & scala.Serializable)f -> {
            FileSanitizerMain$.$anonfun$sanitizeFilesBasename$11(perm, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$12(Path f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.fileSystem().delete(f, false));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Failed to remove old file '{}': {}", new Object[]{f, e.toString()});
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$14(ObjectRef newPaths$1, FileSanitizerMain.SanitizingWriter w) {
        Path path = w.exportFile();
        newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$sanitizeFilesBasename$15(Path dir$1, Path f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.fileSystem().delete(f, false));
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new java.lang.StringBuilder(33).append("Failed to remove new file '").append(f.getName()).append("' in ").append(dir$1).append("/").toString(), ex);
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ int $anonfun$maxThreads$1(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
    }

    public static final /* synthetic */ long $anonfun$maximumSize$1(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Path x$14) {
        FileSystem fileSystem = x$14.getFileSystem(MODULE$.hadoopConf());
        FileSystem fileSystem2 = MODULE$.fileSystem();
        return fileSystem == null ? fileSystem2 != null : !fileSystem.equals(fileSystem2);
    }

    private final /* synthetic */ RemoteIterator liftedTree1$1(Path dir$2) {
        RemoteIterator remoteIterator;
        try {
            remoteIterator = this.fileSystem().listLocatedStatus(dir$2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Unable to get status of '{}/': {}", new Object[]{dir$2, e.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                remoteIterator = new RemoteIterator<LocatedFileStatus>(){

                    public boolean hasNext() {
                        return false;
                    }

                    public LocatedFileStatus next() {
                        throw new NoSuchElementException();
                    }
                };
            }
            throw throwable;
        }
        return remoteIterator;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$new$9(Path dir$2, Tuple2 x$17) {
        Tuple2 tuple2 = x$17;
        if (tuple2 != null) {
            String basename = (String)tuple2._1();
            Set set = (Set)tuple2._2();
            MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().execute(new FileSanitizerMain.BasenameFilesJob(dir$2, basename, (Set<Path>)set));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$FileSanitizerMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        None$ none$;
        String compressName;
        BoxedUnit boxedUnit14;
        BoxedUnit boxedUnit15;
        this.DEFAULT_COMPRESSION = "";
        this.DEFAULT_MAX_THREADS = 6;
        this.DEFAULT_SPAWN_THREAD = "by-directory";
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.args())).partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSanitizerMain$.$anonfun$x$2$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] switches = (String[])tuple2._1();
        String[] positionalArgs = (String[])tuple2._2();
        this.x$2 = new Tuple2((Object)switches, (Object)positionalArgs);
        this.switches = (String[])this.x$2._1();
        this.positionalArgs = (String[])this.x$2._2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.switches())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if ("-V".equals(A1) ? true : "--version".equals(A1)) {
                    FileSanitizerMain$.MODULE$.version();
                    return (B1)BoxedUnit.UNIT;
                }
                if ("-h".equals(A1) ? true : "--help".equals(A1)) {
                    FileSanitizerMain$.MODULE$.usage(true);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    Predef$.MODULE$.println((Object)new java.lang.StringBuilder(19).append("Unknown argument '").append(A12).append("'").toString());
                    FileSanitizerMain$.MODULE$.usage(FileSanitizerMain$.MODULE$.usage$default$1());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                if ("-V".equals(string) ? true : "--version".equals(string)) {
                    return true;
                }
                if ("-h".equals(string) ? true : "--help".equals(string)) {
                    return true;
                }
                return string != null;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        if (this.positionalArgs().length < 2) {
            BoxedUnit boxedUnit16;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Must specify at least two arguments: IE[,IE...] DIR [DIR...]");
                boxedUnit16 = BoxedUnit.UNIT;
            } else {
                boxedUnit16 = BoxedUnit.UNIT;
            }
            this.usage(this.usage$default$1());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n============================= FileSanitizer is starting =============================\n");
            boxedUnit15 = BoxedUnit.UNIT;
        } else {
            boxedUnit15 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is FileSanitizer {}", new Object[]{Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
            boxedUnit14 = BoxedUnit.UNIT;
        } else {
            boxedUnit14 = BoxedUnit.UNIT;
        }
        this.hadoopConf = new Configuration();
        this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        this.toRemove = Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.positionalArgs()[0].split(","))).withFilter((Function1 & Serializable & scala.Serializable)ieName -> BoxesRunTime.boxToBoolean((boolean)FileSanitizerMain$.$anonfun$toRemove$1(ieName))).flatMap((Function1 & Serializable & scala.Serializable)ieName -> Option$.MODULE$.option2Iterable(MODULE$.infoModel().get(ieName).orElse((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error("Unknown IE name '{}'", new Object[]{ieName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new RuntimeException(new java.lang.StringBuilder(18).append("Unknown IE name '").append((String)ieName).append("'").toString());
        }).map((Function1 & Serializable & scala.Serializable)ie -> ie)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InfoElement.class))))));
        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.positionalArgs())).tail())).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> new Path(x$3), List$.MODULE$.canBuildFrom());
        this.codecFactory = new CompressionCodecFactory(this.hadoopConf());
        String string = compressName = (String)package$.MODULE$.props().get("mothra.filesanitizer.compression").getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_COMPRESSION());
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
        } else {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                CompressionCodec codec = MODULE$.codecFactory().getCodecByName(compressName);
                codec.createCompressor();
                return codec;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                none$ = Option$.MODULE$.apply((Object)ok);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit17;
                BoxedUnit boxedUnit18;
                BoxedUnit boxedUnit19;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unable to initialize compressor '{}' {}", new Object[]{compressName, e});
                    boxedUnit19 = BoxedUnit.UNIT;
                } else {
                    boxedUnit19 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(34).append("Unable to initialize compressor '").append(compressName).append("'").toString(), e);
                    boxedUnit18 = BoxedUnit.UNIT;
                } else {
                    boxedUnit18 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit17 = BoxedUnit.UNIT;
                } else {
                    boxedUnit17 = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
        }
        this.compressCodec = none$;
        this.maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.filesanitizer.maxThreads").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)FileSanitizerMain$.$anonfun$maxThreads$1(x$12))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_MAX_THREADS()));
        Predef$.MODULE$.require(this.maxThreads() >= 1);
        this.maximumSize = package$.MODULE$.props().get("mothra.filesanitizer.maximumSize").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)FileSanitizerMain$.$anonfun$maximumSize$1(x$13)));
        this.spawnThread = (String)package$.MODULE$.props().get("mothra.filesanitizer.spawnThread").getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_SPAWN_THREAD());
        this.spawnThreadMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-directory"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-prefix"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-hour"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        this.threadPerDirectory = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)MODULE$.spawnThreadMap().apply((Object)MODULE$.spawnThread()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            StringBuilder sb = new StringBuilder();
            MODULE$.spawnThreadMap().keys().addString(sb, "mothra.filesanitizer.spawnThread must be one of: '", "', '", "'");
            throw new Exception(sb.mkString());
        }));
        this.fileSystem = ((Path)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().head()).getFileSystem(this.hadoopConf());
        if (this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().drop(1).exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)FileSanitizerMain$.$anonfun$new$1(x$14)))) {
            BoxedUnit boxedUnit20;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("source directories use different file systems");
                boxedUnit20 = BoxedUnit.UNIT;
            } else {
                boxedUnit20 = BoxedUnit.UNIT;
            }
            throw new Exception("source directories use different file systems");
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("FileSanitizer settings::");
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of top-level directories to scan: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().size())});
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of file joining threads: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxThreads())});
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Policy for starting threads: {}", new Object[]{this.spawnThread()});
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Approximate maximum output file size: {}", new Object[]{this.maximumSize().getOrElse((Function0 & Serializable & scala.Serializable)() -> "unlimited")});
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output file compression: {}", new Object[]{this.compressCodec().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")});
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray())).mkString(", ")});
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Elements to remove: {}", new Object[]{((TraversableOnce)this.toRemove().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Set$.MODULE$.canBuildFrom())).mkString(", ")});
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue = new LinkedBlockingQueue();
        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("FileSanitizerThread-"));
        this.logTaskCountInterval = 5;
        this.logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-"));
        this.logTaskCountThread().scheduleAtFixedRate(new Thread(){

            public void run() {
                BoxedUnit boxedUnit;
                int active = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().getActiveCount();
                long completed = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().getCompletedTaskCount();
                long total = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().getTaskCount();
                if (FileSanitizerMain$.MODULE$.logger().underlying().isInfoEnabled()) {
                    FileSanitizerMain$.MODULE$.logger().underlying().info("Directories to scan: {}, Total tasks: {}, Completed tasks: {}, Active tasks: {}, Queued tasks: {}", new Object[]{BoxesRunTime.boxToInteger((int)FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().size()), BoxesRunTime.boxToLong((long)total), BoxesRunTime.boxToLong((long)completed), BoxesRunTime.boxToInteger((int)active), BoxesRunTime.boxToLong((long)(total - (long)active - completed))});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
        this.repoFileRegex = new Regex("\\A(\\d{8}\\.\\d{2}(?:-PT\\d\\d?H)?\\.).*\\Z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting recursive scan of {} director{}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().size()), 1 == this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().size() ? "y" : "ies"});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        while (this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().nonEmpty()) {
            boolean bl;
            BoxedUnit boxedUnit21;
            Path dir = (Path)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().head();
            this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList_$eq((List<Path>)((List)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().tail()));
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Scanning directory '{}/'", new Object[]{dir});
                boxedUnit21 = BoxedUnit.UNIT;
            } else {
                boxedUnit21 = BoxedUnit.UNIT;
            }
            scala.collection.mutable.Map fileMap = Map$.MODULE$.empty();
            RemoteIterator iter = this.liftedTree1$1(dir);
            do {
                Try try_;
                if ((try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    block2: {
                        LocatedFileStatus entry;
                        block1: {
                            if (!iter.hasNext()) {
                                return false;
                            }
                            entry = (LocatedFileStatus)iter.next();
                            if (!entry.isDirectory()) break block1;
                            Path path = entry.getPath();
                            MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList_$eq((List<Path>)((List)MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList().$plus$colon((Object)path, List$.MODULE$.canBuildFrom())));
                            break block2;
                        }
                        if (!entry.isFile()) break block2;
                        MODULE$.repoFileRegex().findFirstMatchIn((CharSequence)entry.getPath().getName()).foreach((Function1 & Serializable & scala.Serializable)m -> (Set)((SetLike)fileMap.getOrElseUpdate((Object)m.group(1), (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty())).$plus$eq((Object)entry.getPath()));
                    }
                    return true;
                })) instanceof Success) {
                    boolean ok;
                    Success success = (Success)try_;
                    bl = ok = BoxesRunTime.unboxToBoolean((Object)success.value());
                    continue;
                }
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit22;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Unable to read directory entry: {}", new Object[]{e.toString()});
                        boxedUnit22 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit22 = BoxedUnit.UNIT;
                    }
                    bl = true;
                    continue;
                }
                throw new MatchError((Object)try_);
            } while (bl);
            if (this.threadPerDirectory()) {
                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().execute(new FileSanitizerMain.DirectoryJob(dir, (scala.collection.mutable.Map<String, Set<Path>>)fileMap));
                continue;
            }
            fileMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)FileSanitizerMain$.$anonfun$new$8(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                FileSanitizerMain$.$anonfun$new$9(dir, x$17);
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Completed recursive directory scan");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Waiting for {} of {} tasks to complete...", new Object[]{BoxesRunTime.boxToLong((long)(this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().getTaskCount() - this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().getCompletedTaskCount())), BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().getTaskCount())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().shutdown();
        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue().clear();
        while (!this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool().isTerminated()) {
            this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue().poll(5L, TimeUnit.SECONDS);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All tasks have completed");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.logTaskCountThread().shutdown();
        this.logTaskCountThread().awaitTermination(1L, TimeUnit.SECONDS);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("FileSanitizer is done");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private FileSanitizerMain$() {
        MODULE$ = this;
        App.$init$((App)this);
        StrictLogging.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new FileSanitizerMain$delayedInit$body(this));
    }
}

