/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.packer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.cert.netsa.mothra.packer.CorePacker;
import org.cert.netsa.mothra.packer.PackFileJob$;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005eh!B\u0012%\u0001\u001ar\u0003\u0002C0\u0001\u0005+\u0007I\u0011\u00011\t\u0011-\u0004!\u0011#Q\u0001\n\u0005D\u0001\"\n\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\tc\u0002\u0011\t\u0012)A\u0005[\"A!\u000f\u0001B\u0001B\u0003-1\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0000\u0001\u0001\u0006I!!\u0001\t\u0011\u0005\u001d\u0001\u0001)Q\u0005\u0003\u0003A\u0001\"!\u0003\u0001A\u0003&\u00111\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u001c!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003GB\u0011\"!\u001f\u0001#\u0003%\t!a\u001f\t\u0013\u0005}\u0004!!A\u0005B\u0005\u0005\u0005\"CAE\u0001\u0005\u0005I\u0011AA\u001a\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003_\u0003\u0011\u0011!C!\u0003cC\u0011\"!.\u0001\u0003\u0003%\t%a.\t\u0013\u0005e\u0006!!A\u0005B\u0005m\u0006\"CA_\u0001\u0005\u0005I\u0011IA`\u000f)\t\u0019\rJA\u0001\u0012\u00031\u0013Q\u0019\u0004\nG\u0011\n\t\u0011#\u0001'\u0003\u000fDa\u0001_\u000f\u0005\u0002\u0005]\u0007\"CA];\u0005\u0005IQIA^\u0011%\tI.HA\u0001\n\u0003\u000bY\u000eC\u0005\u0002fv\t\t\u0011\"!\u0002h\"I\u0011Q_\u000f\u0002\u0002\u0013%\u0011q\u001f\u0002\f!\u0006\u001c7NR5mK*{'M\u0003\u0002&M\u00051\u0001/Y2lKJT!a\n\u0015\u0002\r5|G\u000f\u001b:b\u0015\tI#&A\u0003oKR\u001c\u0018M\u0003\u0002,Y\u0005!1-\u001a:u\u0015\u0005i\u0013aA8sON1\u0001aL\u001cF\u001fJ\u0003\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\t1\fgn\u001a\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014G\u0001\u0004PE*,7\r\u001e\t\u0004quzT\"A\u001d\u000b\u0005iZ\u0014AC2p]\u000e,(O]3oi*\u0011AhM\u0001\u0005kRLG.\u0003\u0002?s\tA1)\u00197mC\ndW\r\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015IA\u0004C_>dW-\u00198\u0011\u0005\u0019kU\"A$\u000b\u0005!K\u0015\u0001D:dC2\fGn\\4hS:<'B\u0001&L\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001'\u0002\u0007\r|W.\u0003\u0002O\u000f\ni1\u000b\u001e:jGRdunZ4j]\u001e\u0004\"\u0001\u0011)\n\u0005E\u000b%a\u0002)s_\u0012,8\r\u001e\t\u0003'rs!\u0001\u0016.\u000f\u0005UKV\"\u0001,\u000b\u0005]C\u0016A\u0002\u001fs_>$hh\u0001\u0001\n\u0003\tK!aW!\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u00037\u0006\u000b!b]8ve\u000e,\u0007+\u0019;i+\u0005\t\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003\t17O\u0003\u0002gO\u00061\u0001.\u00193p_BT!\u0001\u001b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tQ7M\u0001\u0003QCRD\u0017aC:pkJ\u001cW\rU1uQ\u0002*\u0012!\u001c\t\u0003]>l\u0011\u0001J\u0005\u0003a\u0012\u0012!bQ8sKB\u000b7m[3s\u0003\u001d\u0001\u0018mY6fe\u0002\nAaY8oMB\u0011AO^\u0007\u0002k*\u0011!/Z\u0005\u0003oV\u0014QbQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0002{{z$\"a\u001f?\u0011\u00059\u0004\u0001\"\u0002:\u0007\u0001\b\u0019\b\"B0\u0007\u0001\u0004\t\u0007\"B\u0013\u0007\u0001\u0004i\u0017a\u0002;De\u0016\fG/\u001a\t\u0004\u0001\u0006\r\u0011bAA\u0003\u0003\n!Aj\u001c8h\u0003\u0019!8\u000b^1si\u0006)1m\\;oiB\u0019\u0001)!\u0004\n\u0007\u0005=\u0011IA\u0002J]RD3!CA\n!\r\u0001\u0015QC\u0005\u0004\u0003/\t%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000b\r|G-Z2\u0011\u000b\u0001\u000bi\"!\t\n\u0007\u0005}\u0011I\u0001\u0004PaRLwN\u001c\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003!\u0019w.\u001c9sKN\u001c(bAA\u0016K\u0006\u0011\u0011n\\\u0005\u0005\u0003_\t)C\u0001\tD_6\u0004(/Z:tS>t7i\u001c3fG\u0006A!/\u001e8D_VtG/\u0006\u0002\u0002\f\u00059qL]3tk2$\b\u0003\u0002\u001d\u0002:}J1!a\u000f:\u0005\u00191U\u000f^;sK\"\u001aA\"a\u0005\u0002\u0011M,(-\\5u)>$2a_A\"\u0011\u001d\t)%\u0004a\u0001\u0003\u000f\nA\u0001]8pYB\u0019\u0001(!\u0013\n\u0007\u0005-\u0013H\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018A\u0002:fgVdG/\u0006\u0002\u00028\u0005!1-\u00197m)\u0005y\u0014\u0001B2paf$b!!\u0017\u0002^\u0005}CcA>\u0002\\!)!\u000f\u0005a\u0002g\"9q\f\u0005I\u0001\u0002\u0004\t\u0007bB\u0013\u0011!\u0003\u0005\r!\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)GK\u0002b\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\n\u0015AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiHK\u0002n\u0003O\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAB!\r\u0001\u0014QQ\u0005\u0004\u0003\u000f\u000b$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0015Q\u0013\t\u0004\u0001\u0006E\u0015bAAJ\u0003\n\u0019\u0011I\\=\t\u0013\u0005]U#!AA\u0002\u0005-\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u001eB1\u0011qTAS\u0003\u001fk!!!)\u000b\u0007\u0005\r\u0016)\u0001\u0006d_2dWm\u0019;j_:LA!a*\u0002\"\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry\u0014Q\u0016\u0005\n\u0003/;\u0012\u0011!a\u0001\u0003\u001f\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111QAZ\u0011%\t9\nGA\u0001\u0002\u0004\tY!\u0001\u0005iCND7i\u001c3f)\t\tY!\u0001\u0005u_N#(/\u001b8h)\t\t\u0019)\u0001\u0004fcV\fGn\u001d\u000b\u0004\u007f\u0005\u0005\u0007\"CAL7\u0005\u0005\t\u0019AAH\u0003-\u0001\u0016mY6GS2,'j\u001c2\u0011\u00059l2#B\u000f\u0002J\u0006=\u0007c\u0001!\u0002L&\u0019\u0011QZ!\u0003\r\u0005s\u0017PU3g!\u0011\t\t.!6\u000e\u0005\u0005M'bAA\u0016g%\u0019Q,a5\u0015\u0005\u0005\u0015\u0017!B1qa2LHCBAo\u0003C\f\u0019\u000fF\u0002|\u0003?DQA\u001d\u0011A\u0004MDQa\u0018\u0011A\u0002\u0005DQ!\n\u0011A\u00025\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0006E\b#\u0002!\u0002\u001e\u0005-\b#\u0002!\u0002n\u0006l\u0017bAAx\u0003\n1A+\u001e9mKJB\u0001\"a=\"\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#A\u0018")
public class PackFileJob
implements Callable<Object>,
StrictLogging,
Product,
Serializable {
    private final Path sourcePath;
    private final CorePacker packer;
    private final Configuration conf;
    private final long tCreate;
    private long tStart;
    private volatile int count;
    private final Option<CompressionCodec> codec;
    private volatile Future<Object> _result;
    private Logger logger;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<Path, CorePacker>> unapply(PackFileJob x$0) {
        return PackFileJob$.MODULE$.unapply(x$0);
    }

    public static PackFileJob apply(Path sourcePath, CorePacker packer, Configuration conf) {
        return PackFileJob$.MODULE$.apply(sourcePath, packer, conf);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Logger logger() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_tools/src/packer/PackFileJob.scala: 25");
        }
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public Path sourcePath() {
        return this.sourcePath;
    }

    public CorePacker packer() {
        return this.packer;
    }

    public synchronized int runCount() {
        return this.count;
    }

    public PackFileJob submitTo(ThreadPoolExecutor pool) {
        this._result = pool.submit(this);
        return this;
    }

    public Future<Object> result() {
        return this._result;
    }

    @Override
    public boolean call() {
        BoxedUnit boxedUnit;
        boolean bl;
        BoxedUnit boxedUnit2;
        this.tStart = System.currentTimeMillis();
        ++this.count;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting to pack '{}', try #{}", new Object[]{this.sourcePath(), BoxesRunTime.boxToInteger((int)this.count)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        LongRef fileSize = LongRef.create((long)0L);
        Option decompr = this.codec.map((Function1 & Serializable)c -> CodecPool.getDecompressor((CompressionCodec)c));
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            FileSystem sourceFs = this.sourcePath().getFileSystem($this.conf);
            fileSize$1.elem = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> sourceFs.getFileStatus(this.sourcePath()).getLen()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            package$.MODULE$.managed((Function0 & Serializable)() -> {
                ReadableByteChannel readableByteChannel;
                FSDataInputStream stream = sourceFs.open(this.sourcePath());
                Option<CompressionCodec> option = $this.codec;
                if (None$.MODULE$.equals(option)) {
                    readableByteChannel = Channels.newChannel((InputStream)stream);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CompressionCodec c = (CompressionCodec)some.value();
                    readableByteChannel = Channels.newChannel((InputStream)c.createInputStream((InputStream)stream, (Decompressor)decompr.get()));
                } else {
                    throw new MatchError(option);
                }
                return readableByteChannel;
            }, Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ReadableByteChannel.class)).foreach((Function1 & Serializable)channel -> {
                PackFileJob.$anonfun$call$6(this, channel);
                return BoxedUnit.UNIT;
            });
            return sourceFs.delete(this.sourcePath(), false);
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to pack '{}': {}", new Object[]{this.sourcePath(), e.toString()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(0).append(new StringBuilder(31).append("Failed to pack '").append(this.sourcePath()).append("' on attempt #").append(this.count).append(":").toString()).append(new StringBuilder(1).append(" ").append(sw.toString()).toString()).toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            bl = true;
        }
        boolean succeeded = bl;
        decompr.foreach((Function1 & Serializable)d -> {
            PackFileJob.$anonfun$call$7(d);
            return BoxedUnit.UNIT;
        });
        if (succeeded) {
            String humanSize;
            String string;
            long tEnd = System.currentTimeMillis();
            if (fileSize.elem <= 0L) {
                string = "unknown";
            } else {
                String[] units = (String[])((Object[])new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"});
                double s = fileSize.elem;
                int u = 0;
                while (s > 1024.0) {
                    s /= 1024.0;
                    ++u;
                }
                double arg$macro$1 = s;
                String arg$macro$2 = units[u];
                string = humanSize = StringOps$.MODULE$.format$extension("%.3f%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), arg$macro$2}));
            }
            if (this.logger().underlying().isInfoEnabled()) {
                double arg$macro$3 = (double)(this.tStart - this.tCreate) / 1000.0;
                double arg$macro$4 = (double)(tEnd - this.tStart) / 1000.0;
                this.logger().underlying().info(new StringBuilder(0).append(new StringBuilder(17).append("Packed '").append(this.sourcePath()).append("'; size ").append(humanSize).append(";").toString()).append(StringOps$.MODULE$.format$extension(" waited %.3f seconds;", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}))).append(StringOps$.MODULE$.format$extension(" worked %.3f seconds", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4)}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return succeeded;
    }

    public PackFileJob copy(Path sourcePath, CorePacker packer, Configuration conf) {
        return new PackFileJob(sourcePath, packer, conf);
    }

    public Path copy$default$1() {
        return this.sourcePath();
    }

    public CorePacker copy$default$2() {
        return this.packer();
    }

    public String productPrefix() {
        return "PackFileJob";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sourcePath();
                break;
            }
            case 1: {
                object = this.packer();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PackFileJob;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "sourcePath";
                break;
            }
            case 1: {
                string = "packer";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PackFileJob)) return false;
        boolean bl = true;
        if (!bl) return false;
        PackFileJob packFileJob = (PackFileJob)x$1;
        Path path = this.sourcePath();
        Path path2 = packFileJob.sourcePath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        CorePacker corePacker = this.packer();
        CorePacker corePacker2 = packFileJob.packer();
        if (corePacker == null) {
            if (corePacker2 != null) {
                return false;
            }
        } else if (!((Object)corePacker).equals(corePacker2)) return false;
        if (!packFileJob.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$call$6(PackFileJob $this, ReadableByteChannel channel) {
        $this.packer().packStream(channel);
    }

    public static final /* synthetic */ void $anonfun$call$7(Decompressor d) {
        CodecPool.returnDecompressor((Decompressor)d);
    }

    public PackFileJob(Path sourcePath, CorePacker packer, Configuration conf) {
        this.sourcePath = sourcePath;
        this.packer = packer;
        this.conf = conf;
        StrictLogging.$init$((StrictLogging)this);
        Product.$init$((Product)this);
        this.tCreate = System.currentTimeMillis();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.tStart = 0L;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.count = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.codec = (Option)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            CompressionCodecFactory factory = new CompressionCodecFactory($this.conf);
            return Option$.MODULE$.apply((Object)factory.getCodec(this.sourcePath()));
        }).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        Statics.releaseFence();
    }
}

