// Copyright 2025 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.mothra.packer

/** A simple class whose `partitioners()` method needs to be called to get a sequence of
  * [[Partitioner]]s. Those results are used to configure a [[PartitionerPackLogic]].
  *
  * The sequence of Partitioners returned by this class split first by protocol and then by source
  * port.
  *
  * See the comments in the [[VlanPartitionerPackLogic]] source file for instructions on how this
  * file needs to be edited to support loading these partitioners at run-time.
  *
  * @see [[ProtoSportPackLogic]] for an older version of this concept.
  */
class ProtoSportPartitionerPackLogic extends PartitionerConfigurator {

  /** How to partition the records. */
  def partitioners: Seq[Partitioner] = {
    val protoPartitioner = Partitioner.UInt8("protocolIdentifier")
    protoPartitioner.addPartitionEquals(1)
    protoPartitioner.addPartitionEquals(6)
    protoPartitioner.addPartitionEquals(17)
    protoPartitioner.addPartitionEquals(50)
    protoPartitioner.addPartitionEquals(58)
    protoPartitioner.coverRanges()

    val sPortPartitioner = Partitioner.UInt16("sourceTransportPort")
    sPortPartitioner.addPartitionEquals(22)
    sPortPartitioner.addPartitionEquals(25)
    sPortPartitioner.addPartitionEquals(53)
    sPortPartitioner.addPartitionEquals(80)
    sPortPartitioner.addPartitionEquals(443)
    sPortPartitioner.addPartitionRange(443, false, 1023, true)
    sPortPartitioner.addPartitionEquals(8000)
    sPortPartitioner.coverRanges()

    Seq(protoPartitioner, sPortPartitioner)
  }
}

// @LICENSE_FOOTER@
//
// Mothra 1.7
//
// Copyright 2025 Carnegie Mellon University.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING INSTITUTE MATERIAL IS
// FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND,
// EITHER EXPRESSED OR IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS
// FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF THE MATERIAL.
// CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM
// PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or contac
// permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public release and unlimited
// distribution.  Please see Copyright notice for non-US Government use and distribution.
//
// This Software includes and/or makes use of Third-Party Software each subject to its own license.
//
// DM24-1649
