// Copyright 2025 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.mothra.tools

import org.apache.hadoop.fs.{Path => HadoopPath}

class CollectorOptions extends ToolOptions("mothra-collector") {

  note("""Required options:

  NOTE: Each of --incoming-dir and --outgoing-dir may be given multiple
        times. There must be an equal number of each, and each pair specifies
        a particular source to be collected into a particular destination.
  """)

  var incomingDirs: Seq[HadoopPath] = Seq()
  opt[HadoopPath]("incoming-dir")
    .valueName("DIR")
    .required()
    .unbounded()
    .foreach(incomingDirs :+= _)
    .text("HDFS directory from which to read files")
    .validate(checkHadoopDirExists("Option --incoming-dir"))

  var outgoingDirs: Seq[HadoopPath] = Seq()
  opt[HadoopPath]("outgoing-dir")
    .valueName("DIR")
    .required()
    .unbounded()
    .foreach(outgoingDirs :+= _)
    .text("HDFS directory into which to write files")
    .validate(checkHadoopDirExists("Option --outgoing-dir"))

  note("\nOptions:\n")

  help("help").text("Print this message and exit.")

  version("version").text(s"Print the version number of $toolName and exit.")

  checkConfig { _ =>
    if (incomingDirs.length != outgoingDirs.length)
      failure(s"There must be an equal number of incoming and outgoing directories")
    else success
  }

}

// @LICENSE_FOOTER@
//
// Mothra 1.7
//
// Copyright 2025 Carnegie Mellon University.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING INSTITUTE MATERIAL IS
// FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND,
// EITHER EXPRESSED OR IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS
// FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF THE MATERIAL.
// CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM
// PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or contac
// permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public release and unlimited
// distribution.  Please see Copyright notice for non-US Government use and distribution.
//
// This Software includes and/or makes use of Third-Party Software each subject to its own license.
//
// DM24-1649
