/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.packer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.cert.netsa.mothra.packer.CorePacker;
import org.cert.netsa.mothra.packer.PackFileJob$;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t=b!B\u0016-\u0001:2\u0004\u0002C4\u0001\u0005+\u0007I\u0011\u00015\t\u0011M\u0004!\u0011#Q\u0001\n%D\u0001\"\f\u0001\u0003\u0016\u0004%\t\u0001\u001e\u0005\ts\u0002\u0011\t\u0012)A\u0005k\"A!\u0010\u0001B\u0001B\u0003-1\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005E\u0001\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011!\tY\u0003\u0001Q!\n\u0005M\u0001\"CA\u0017\u0001\u0001\u0007I\u0011BA\u0018\u0011%\t9\u0004\u0001a\u0001\n\u0013\tI\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0015BA\u0019\u0011%\t9\u0005\u0001b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA&\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003_A1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002h!Y\u0011q\u000e\u0001A\u0002\u0003\u0007I\u0011BA9\u0011-\t)\b\u0001a\u0001\u0002\u0003\u0006K!!\u001b\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011q\u0011\u0001\u0005\u0002\u0005\u001d\u0004bBAE\u0001\u0011\u0005\u00111\u0012\u0005\n\u0003\u001b\u0003\u0011\u0011!C\u0001\u0003\u001fC\u0011\"!'\u0001#\u0003%\t!a'\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\t\t\rAA\u0001\n\u0003\ty\u0003C\u0005\u0002D\u0002\t\t\u0011\"\u0001\u0002F\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0003?\u0004\u0011\u0011!C\u0001\u0003CD\u0011\"!:\u0001\u0003\u0003%\t%a:\t\u0013\u0005-\b!!A\u0005B\u00055\b\"CAx\u0001\u0005\u0005I\u0011IAy\u0011%\t\u0019\u0010AA\u0001\n\u0003\n)p\u0002\u0006\u0002z2\n\t\u0011#\u0001/\u0003w4\u0011b\u000b\u0017\u0002\u0002#\u0005a&!@\t\u000f\u0005\u0005Q\u0005\"\u0001\u0003\u000e!I\u0011q^\u0013\u0002\u0002\u0013\u0015\u0013\u0011\u001f\u0005\n\u0005\u001f)\u0013\u0011!CA\u0005#A\u0011Ba\u0007&\u0003\u0003%\tI!\b\t\u0013\t-R%!A\u0005\n\t5\"a\u0003)bG.4\u0015\u000e\\3K_\nT!!\f\u0018\u0002\rA\f7m[3s\u0015\ty\u0003'\u0001\u0004n_RD'/\u0019\u0006\u0003cI\nQA\\3ug\u0006T!a\r\u001b\u0002\t\r,'\u000f\u001e\u0006\u0002k\u0005\u0019qN]4\u0014\r\u00019t(T,[!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003mC:<'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012aa\u00142kK\u000e$\bc\u0001!F\u000f6\t\u0011I\u0003\u0002C\u0007\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0011[\u0014\u0001B;uS2L!AR!\u0003\u0011\r\u000bG\u000e\\1cY\u0016\u0004\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013qAQ8pY\u0016\fg\u000e\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006a1oY1mC2|wmZ5oO*\u0011!kU\u0001\tif\u0004Xm]1gK*\tA+A\u0002d_6L!AV(\u0003\u001bM#(/[2u\u0019><w-\u001b8h!\tA\u0005,\u0003\u0002Z\u0013\n9\u0001K]8ek\u000e$\bCA.e\u001d\ta&M\u0004\u0002^C6\taL\u0003\u0002`A\u00061AH]8piz\u001a\u0001!C\u0001K\u0013\t\u0019\u0017*A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00154'\u0001D*fe&\fG.\u001b>bE2,'BA2J\u0003)\u0019x.\u001e:dKB\u000bG\u000f[\u000b\u0002SB\u0011!.]\u0007\u0002W*\u0011A.\\\u0001\u0003MNT!A\\8\u0002\r!\fGm\\8q\u0015\t\u0001H'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003e.\u0014A\u0001U1uQ\u0006Y1o\\;sG\u0016\u0004\u0016\r\u001e5!+\u0005)\bC\u0001<x\u001b\u0005a\u0013B\u0001=-\u0005)\u0019uN]3QC\u000e\\WM]\u0001\ba\u0006\u001c7.\u001a:!\u0003\u0011\u0019wN\u001c4\u0011\u0005qtX\"A?\u000b\u0005il\u0017BA@~\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"b!!\u0002\u0002\f\u00055A\u0003BA\u0004\u0003\u0013\u0001\"A\u001e\u0001\t\u000bi4\u00019A>\t\u000b\u001d4\u0001\u0019A5\t\u000b52\u0001\u0019A;\u0002\u000fQ\u001c%/Z1uKV\u0011\u00111\u0003\t\u0004\u0011\u0006U\u0011bAA\f\u0013\n!Aj\u001c8h\u0003!!8I]3bi\u0016\u0004\u0013A\u0002;Ti\u0006\u0014H/\u0001\u0006u'R\f'\u000f^0%KF$B!!\t\u0002(A\u0019\u0001*a\t\n\u0007\u0005\u0015\u0012J\u0001\u0003V]&$\b\"CA\u0015\u0015\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\biN#\u0018M\u001d;!\u0003\u0015\u0019w.\u001e8u+\t\t\t\u0004E\u0002I\u0003gI1!!\u000eJ\u0005\rIe\u000e^\u0001\nG>,h\u000e^0%KF$B!!\t\u0002<!I\u0011\u0011F\u0007\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0007G>,h\u000e\u001e\u0011)\u00079\t\t\u0005E\u0002I\u0003\u0007J1!!\u0012J\u0005!1x\u000e\\1uS2,\u0017!B2pI\u0016\u001cWCAA&!\u0015A\u0015QJA)\u0013\r\ty%\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005A1m\\7qe\u0016\u001c8OC\u0002\u0002\\5\f!![8\n\t\u0005}\u0013Q\u000b\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000e\faaY8eK\u000e\u0004\u0013\u0001\u0003:v]\u000e{WO\u001c;\u0002\u000f}\u0013Xm];miV\u0011\u0011\u0011\u000e\t\u0005\u0001\u0006-t)C\u0002\u0002n\u0005\u0013aAR;ukJ,\u0017aC0sKN,H\u000e^0%KF$B!!\t\u0002t!I\u0011\u0011F\n\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\t?J,7/\u001e7uA!\u001aA#!\u0011\u0002\u0011M,(-\\5u)>$B!a\u0002\u0002~!9\u0011qP\u000bA\u0002\u0005\u0005\u0015\u0001\u00029p_2\u00042\u0001QAB\u0013\r\t))\u0011\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/\u0001\u0004sKN,H\u000e^\u0001\u0005G\u0006dG\u000eF\u0001H\u0003\u0011\u0019w\u000e]=\u0015\r\u0005E\u0015QSAL)\u0011\t9!a%\t\u000biD\u00029A>\t\u000f\u001dD\u0002\u0013!a\u0001S\"9Q\u0006\u0007I\u0001\u0002\u0004)\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003;S3![APW\t\t\t\u000b\u0005\u0003\u0002$\u00065VBAAS\u0015\u0011\t9+!+\u0002\u0013Ut7\r[3dW\u0016$'bAAV\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0016Q\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003kS3!^AP\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0018\t\u0004q\u0005u\u0016bAA`s\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002H\u00065\u0007c\u0001%\u0002J&\u0019\u00111Z%\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002*u\t\t\u00111\u0001\u00022\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002TB1\u0011Q[An\u0003\u000fl!!a6\u000b\u0007\u0005e\u0017*\u0001\u0006d_2dWm\u0019;j_:LA!!8\u0002X\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r9\u00151\u001d\u0005\n\u0003Sy\u0012\u0011!a\u0001\u0003\u000f\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111XAu\u0011%\tI\u0003IA\u0001\u0002\u0004\t\t$\u0001\u0005iCND7i\u001c3f)\t\t\t$\u0001\u0005u_N#(/\u001b8h)\t\tY,\u0001\u0004fcV\fGn\u001d\u000b\u0004\u000f\u0006]\b\"CA\u0015G\u0005\u0005\t\u0019AAd\u0003-\u0001\u0016mY6GS2,'j\u001c2\u0011\u0005Y,3#B\u0013\u0002\u0000\n\u0015\u0001c\u0001%\u0003\u0002%\u0019!1A%\u0003\r\u0005s\u0017PU3g!\u0011\u00119Aa\u0003\u000e\u0005\t%!bAA.w%\u0019QM!\u0003\u0015\u0005\u0005m\u0018!B1qa2LHC\u0002B\n\u0005/\u0011I\u0002\u0006\u0003\u0002\b\tU\u0001\"\u0002>)\u0001\bY\b\"B4)\u0001\u0004I\u0007\"B\u0017)\u0001\u0004)\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0005?\u00119\u0003E\u0003I\u0003\u001b\u0012\t\u0003E\u0003I\u0005GIW/C\u0002\u0003&%\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u0015S\u0005\u0005\t\u0019AA\u0004\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002o\u0001")
public class PackFileJob
implements Callable<Object>,
StrictLogging,
Product,
Serializable {
    private final Path sourcePath;
    private final CorePacker packer;
    private final Configuration conf;
    private final long tCreate;
    private long tStart;
    private volatile int count;
    private final Option<CompressionCodec> codec;
    private volatile Future<Object> _result;
    private Logger logger;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<Path, CorePacker>> unapply(PackFileJob x$0) {
        return PackFileJob$.MODULE$.unapply(x$0);
    }

    public static PackFileJob apply(Path sourcePath, CorePacker packer, Configuration conf) {
        return PackFileJob$.MODULE$.apply(sourcePath, packer, conf);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Logger logger() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: PackFileJob.scala: 24");
        }
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public Path sourcePath() {
        return this.sourcePath;
    }

    public CorePacker packer() {
        return this.packer;
    }

    private long tCreate() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: PackFileJob.scala: 28");
        }
        return this.tCreate;
    }

    private long tStart() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: PackFileJob.scala: 29");
        }
        return this.tStart;
    }

    private void tStart_$eq(long x$1) {
        this.tStart = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private int count() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: PackFileJob.scala: 33");
        }
        return this.count;
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private Option<CompressionCodec> codec() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: PackFileJob.scala: 35");
        }
        return this.codec;
    }

    public synchronized int runCount() {
        return this.count();
    }

    private Future<Object> _result() {
        return this._result;
    }

    private void _result_$eq(Future<Object> x$1) {
        this._result = x$1;
    }

    public PackFileJob submitTo(ThreadPoolExecutor pool) {
        this._result_$eq(pool.submit(this));
        return this;
    }

    public Future<Object> result() {
        return this._result();
    }

    @Override
    public boolean call() {
        BoxedUnit boxedUnit;
        boolean bl;
        BoxedUnit boxedUnit2;
        this.tStart_$eq(System.currentTimeMillis());
        this.count_$eq(this.count() + 1);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting to pack '{}', try #{}", new Object[]{this.sourcePath(), BoxesRunTime.boxToInteger((int)this.count())});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        LongRef fileSize = LongRef.create((long)0L);
        Option decompr = this.codec().map((Function1 & Serializable)c -> CodecPool.getDecompressor((CompressionCodec)c));
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            FileSystem sourceFs = this.sourcePath().getFileSystem($this.conf);
            fileSize$1.elem = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> sourceFs.getFileStatus(this.sourcePath()).getLen()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            package$.MODULE$.managed((Function0 & Serializable)() -> {
                FSDataInputStream stream = sourceFs.open(this.sourcePath());
                Option<CompressionCodec> option = this.codec();
                if (None$.MODULE$.equals(option)) {
                    return Channels.newChannel((InputStream)stream);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CompressionCodec c = (CompressionCodec)some.value();
                    return Channels.newChannel((InputStream)c.createInputStream((InputStream)stream, (Decompressor)decompr.get()));
                }
                throw new MatchError(option);
            }, Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ReadableByteChannel.class)).foreach((Function1 & Serializable)channel -> {
                PackFileJob.$anonfun$call$6(this, channel);
                return BoxedUnit.UNIT;
            });
            return sourceFs.delete(this.sourcePath(), false);
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to pack '{}': {}", new Object[]{this.sourcePath(), e});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(17).append("Failed to pack '").append(this.sourcePath()).append("'").toString(), e);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            bl = true;
        }
        boolean succeeded = bl;
        decompr.foreach((Function1 & Serializable)d -> {
            PackFileJob.$anonfun$call$7(d);
            return BoxedUnit.UNIT;
        });
        if (succeeded) {
            String humanSize;
            String string;
            long tEnd = System.currentTimeMillis();
            if (fileSize.elem <= 0L) {
                string = "unknown";
            } else {
                String[] units = (String[])((Object[])new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"});
                double s = fileSize.elem;
                int u = 0;
                while (s > 1024.0) {
                    s /= 1024.0;
                    ++u;
                }
                string = humanSize = StringOps$.MODULE$.format$extension("%.3f%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)s), units[u]}));
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(StringOps$.MODULE$.format$extension("Packed '%s'; size %s; waited %.3f seconds; worked %.3f seconds", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.sourcePath(), humanSize, BoxesRunTime.boxToDouble((double)((double)(this.tStart() - this.tCreate()) / 1000.0)), BoxesRunTime.boxToDouble((double)((double)(tEnd - this.tStart()) / 1000.0))})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return succeeded;
    }

    public PackFileJob copy(Path sourcePath, CorePacker packer, Configuration conf) {
        return new PackFileJob(sourcePath, packer, conf);
    }

    public Path copy$default$1() {
        return this.sourcePath();
    }

    public CorePacker copy$default$2() {
        return this.packer();
    }

    public String productPrefix() {
        return "PackFileJob";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourcePath();
            }
            case 1: {
                return this.packer();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PackFileJob;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sourcePath";
            }
            case 1: {
                return "packer";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PackFileJob)) return false;
        boolean bl = true;
        if (!bl) return false;
        PackFileJob packFileJob = (PackFileJob)x$1;
        Path path = this.sourcePath();
        Path path2 = packFileJob.sourcePath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        CorePacker corePacker = this.packer();
        CorePacker corePacker2 = packFileJob.packer();
        if (corePacker == null) {
            if (corePacker2 != null) {
                return false;
            }
        } else if (!((Object)corePacker).equals(corePacker2)) return false;
        if (!packFileJob.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$call$6(PackFileJob $this, ReadableByteChannel channel) {
        $this.packer().packStream(channel);
    }

    public static final /* synthetic */ void $anonfun$call$7(Decompressor d) {
        CodecPool.returnDecompressor((Decompressor)d);
    }

    public PackFileJob(Path sourcePath, CorePacker packer, Configuration conf) {
        this.sourcePath = sourcePath;
        this.packer = packer;
        this.conf = conf;
        StrictLogging.$init$((StrictLogging)this);
        Product.$init$((Product)this);
        this.tCreate = System.currentTimeMillis();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.tStart = 0L;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.count = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.codec = (Option)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            CompressionCodecFactory factory = new CompressionCodecFactory($this.conf);
            return Option$.MODULE$.apply((Object)factory.getCodec(this.sourcePath()));
        }).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        Statics.releaseFence();
    }
}

