/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ShutdownHookManager;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.mothra.packer.PackerDeque;
import org.cert.netsa.mothra.packer.PackerDeque$;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.PackingLogic;
import org.cert.netsa.mothra.packer.Partitioner;
import org.cert.netsa.mothra.packer.PartitionerConfigurator;
import org.cert.netsa.mothra.packer.PartitionerPackLogic;
import org.cert.netsa.mothra.packer.RunTimeCodeLoader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.InvariantPackerMain;
import org.cert.netsa.mothra.tools.InvariantPackerMain$delayedInit$body;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class InvariantPackerMain$
implements App,
StrictLogging {
    public static final InvariantPackerMain$ MODULE$ = new InvariantPackerMain$();
    private static String org$cert$netsa$mothra$tools$InvariantPackerMain$$APP;
    private static String appProp;
    private static int SHUTDOWN_PRIORITY;
    private static String DEFAULT_COMPRESSION;
    private static Option<CompressionCodec> compressCodec;
    private static String org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix;
    private static int DEFAULT_MAX_THREADS;
    private static int maxThreads;
    private static long MINIMUM_MAXIMUM_SIZE;
    private static Option<Object> maximumSize;
    private static int DEFAULT_OUTPUT_FILE_IDLE_SECONDS;
    private static int OUTPUT_FILE_IDLE_SECONDS_MINIMUM;
    private static int outputIdleSeconds;
    private static int DEFAULT_MAXIMUM_AGE_SECONDS;
    private static int maxInputAge;
    private static int DEFAULT_MINIMUM_INPUT_COUNT;
    private static int minInputCount;
    private static long DEFAULT_MINIMUM_INPUT_SIZE;
    private static long minInputSize;
    private static int DEFAULT_FILE_CACHE_SIZE;
    private static int MINIMUM_FILE_CACHE_SIZE;
    private static int fileCacheSize;
    private static int DEFAULT_POLL_INTERVAL;
    private static int pollingInterval;
    private static int DEFAULT_OBSERVATION_DOMAIN_ID;
    private static int observationDomain;
    private static boolean oneshot;
    private static /* synthetic */ Tuple2 x$25;
    private static String[] switches;
    private static String[] positionalArgs;
    private static Path incomingDir;
    private static Path destinationDir;
    private static Path packLogicPath;
    private static Object org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex;
    private static Map<String, InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles;
    private static PackerDeque<InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU;
    private static volatile int org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount;
    private static volatile int org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount;
    private static long org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize;
    private static int taskCountInterval;
    private static InfoModel infoModel;
    private static Configuration hadoopConf;
    private static CompressionCodecFactory org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory;
    private static /* synthetic */ Tuple2 x$26;
    private static int org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion;
    private static Seq<Partitioner> org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners;
    private static String ignored;
    private static ThreadPoolExecutor org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool;
    private static InvariantPackerMain.MyDirWatcher org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher;
    private static boolean running;
    private static Logger logger;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        StrictLogging.$init$((StrictLogging)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new InvariantPackerMain$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.InvariantPackerMain mothra-tools.jar [--version] [--one-shot] <sourceDir> <destinationDir> <partitionerFile>\n\nsourceDir:         Directory to read from, as Hadoop URI\ndestinationDir:    Directory to write to, as Hadoop URI\npartitionerFile:   A Scala source file containing Partitioner Packing Logic\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringBuilder(3306).append("\n").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" processes files created by super_mediator running in invariant mode and\nwrites them into HDFS.  It reads IPRIX records from files from `sourceDir` and\nwrites the records to files in `destinationDir`.\n\nThe `partitionerFile` is a Scala source file that may contain either\nPartitionerConfigurator or PartitionerPackLogic.  ").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" reads, parses,\ncompiles, and loads the Scala code contained in the file, then extracts the\nsequence of Partitions defined in that file.  The partitioners are used by\n").append(this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()).append(" when writing flow records to the `destinationDir`.\n\nIf \"--version\" is included on the command line, the application prints its\nversion number and exists.\n\nIf \"--one-shot\" is included on the command line, the `sourceDir` is only\nscanned one time.  Once all files in sourceDir have been packed, the\napplication exits.  When \"--one-shot\" is not provided, the application runs\nuntil it is signaled to end.\n\nThe Java property values that are used by this application are:\n\n").append(this.appProp()).append("compression -- The compression to use for files written to\nHDFS.  Values typically supported by Hadoop include `bzip2`, `gzip`,\n`lz4`, `lzo`, `lzop`, `snappy`, and `default`.  The empty string indicates\nno compression.  The default is `").append(this.DEFAULT_COMPRESSION()).append("`.\n\n").append(this.appProp()).append("maxThreads -- The maximum number of threads that attempt to write to\noutput files simultaneously.  The default is ").append(this.DEFAULT_MAX_THREADS()).append(".\n\n").append(this.appProp()).append("pollingInterval -- How often the `sourceDir` is checked (polled) for\nIPFIX files to process.  The default is ").append(this.DEFAULT_POLL_INTERVAL()).append(" seconds.\n\n").append(this.appProp()).append("maximumSize -- The (approximate) maximum size file to create, in\noctets.  The default is no maximum.  When a file's size exceeds this value,\nthe file is closed and a new file is started.  Typically a file's size will\nnot exceed this value by more than the maximum size of an IPFIX message, 64k.\nThis value may not be less than ").append(this.MINIMUM_MAXIMUM_SIZE()).append(".\n\n").append(this.appProp()).append("outputIdleSeconds -- The maximum number of seconds to allow an idle\noutput file to remain open so additional incoming records may appended to it.\nIt defaults to the value ").append(this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS()).append(".  This value may\nnot be less than ").append(this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM()).append(".\n\n").append(this.appProp()).append("fileCacheSize -- The maximum size of the open file cache.  This is\nthe maximum number of open files maintained by the file cache for writing to\noutput files.  Once the cache reaches this number of open files, the\napplication closes the least-recently-used file when it needs to open another.\nThis value does not include the file handles required when reading incoming\nfiles.  The default is ").append(this.DEFAULT_FILE_CACHE_SIZE()).append("; the minimum permitted is\n").append(this.MINIMUM_FILE_CACHE_SIZE()).append(".\n\n").append(this.appProp()).append("observationDomainId -- The observationDomainId to use in output\nfiles.  The default is ").append(this.DEFAULT_OBSERVATION_DOMAIN_ID()).append(".\n\nWhen an output file has not been opened yet, it is not opened until the oldest\ninput file reaches a particular age, the number of input files reaches a\ncount, or the sum of the sizes of the input files reaches a value.  (Reaching\nany threshold allows the output file to be opened.)  The next three properties\ndescribe these values:\n\n").append(this.appProp()).append("maxInputAgeSeconds -- The age for an input file that causes its\ndestination output file to be opened.  Here, \"age\" refers to how long ago the\nfile was noticed, not the age of the file itself.  The default is\n").append(this.DEFAULT_MAXIMUM_AGE_SECONDS()).append(" seconds.\n\n").append(this.appProp()).append("minInputCount -- The number of queued input files that causes their\ndestination output file to be opened.  The default is\n").append(this.DEFAULT_MINIMUM_INPUT_COUNT()).append(".\n\n").append(this.appProp()).append("minInputSize -- The sum of the sizes of queued input files that\ncauses their destination output file to be opened, in octets.  The default is\n").append(this.DEFAULT_MINIMUM_INPUT_SIZE()).append(".\n").toString());
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
        System.exit(0);
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$timediff(long t1, long t0) {
        return StringOps$.MODULE$.format$extension("%.03f seconds", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(t1 - t0) / 1000.0))}));
    }

    public void org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        int active = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().getActiveCount();
        long total = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().getTaskCount();
        long completed = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().getCompletedTaskCount();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Task Counts: Active: {}, Queued: {}, Completed: {}, Total: {}", new Object[]{BoxesRunTime.boxToInteger((int)active), BoxesRunTime.boxToLong((long)(total - completed - (long)active)), BoxesRunTime.boxToLong((long)completed), BoxesRunTime.boxToLong((long)total)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output Files: Open: {}, Total: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount()), BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$APP() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$APP;
    }

    private String appProp() {
        return appProp;
    }

    private int SHUTDOWN_PRIORITY() {
        return SHUTDOWN_PRIORITY;
    }

    public String DEFAULT_COMPRESSION() {
        return DEFAULT_COMPRESSION;
    }

    public Option<CompressionCodec> compressCodec() {
        return compressCodec;
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix;
    }

    public int DEFAULT_MAX_THREADS() {
        return DEFAULT_MAX_THREADS;
    }

    public int maxThreads() {
        return maxThreads;
    }

    public long MINIMUM_MAXIMUM_SIZE() {
        return MINIMUM_MAXIMUM_SIZE;
    }

    public Option<Object> maximumSize() {
        return maximumSize;
    }

    public int DEFAULT_OUTPUT_FILE_IDLE_SECONDS() {
        return DEFAULT_OUTPUT_FILE_IDLE_SECONDS;
    }

    public int OUTPUT_FILE_IDLE_SECONDS_MINIMUM() {
        return OUTPUT_FILE_IDLE_SECONDS_MINIMUM;
    }

    public int outputIdleSeconds() {
        return outputIdleSeconds;
    }

    public int DEFAULT_MAXIMUM_AGE_SECONDS() {
        return DEFAULT_MAXIMUM_AGE_SECONDS;
    }

    public int maxInputAge() {
        return maxInputAge;
    }

    public int DEFAULT_MINIMUM_INPUT_COUNT() {
        return DEFAULT_MINIMUM_INPUT_COUNT;
    }

    public int minInputCount() {
        return minInputCount;
    }

    public long DEFAULT_MINIMUM_INPUT_SIZE() {
        return DEFAULT_MINIMUM_INPUT_SIZE;
    }

    public long minInputSize() {
        return minInputSize;
    }

    public int DEFAULT_FILE_CACHE_SIZE() {
        return DEFAULT_FILE_CACHE_SIZE;
    }

    public int MINIMUM_FILE_CACHE_SIZE() {
        return MINIMUM_FILE_CACHE_SIZE;
    }

    public int fileCacheSize() {
        return fileCacheSize;
    }

    public int DEFAULT_POLL_INTERVAL() {
        return DEFAULT_POLL_INTERVAL;
    }

    public int pollingInterval() {
        return pollingInterval;
    }

    public int DEFAULT_OBSERVATION_DOMAIN_ID() {
        return DEFAULT_OBSERVATION_DOMAIN_ID;
    }

    public int observationDomain() {
        return observationDomain;
    }

    public boolean oneshot() {
        return oneshot;
    }

    public void oneshot_$eq(boolean x$1) {
        oneshot = x$1;
    }

    public String[] switches() {
        return switches;
    }

    public String[] positionalArgs() {
        return positionalArgs;
    }

    public Path incomingDir() {
        return incomingDir;
    }

    public Path destinationDir() {
        return destinationDir;
    }

    public Path packLogicPath() {
        return packLogicPath;
    }

    public Object org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex;
    }

    public Map<String, InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles;
    }

    public void org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles_$eq(Map<String, InvariantPackerMain.RepositoryPath> x$1) {
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles = x$1;
    }

    public PackerDeque<InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU;
    }

    public int org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount;
    }

    public void org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount_$eq(int x$1) {
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount = x$1;
    }

    public int org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount;
    }

    public void org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount_$eq(int x$1) {
        org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount = x$1;
    }

    public long org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize;
    }

    private int taskCountInterval() {
        return taskCountInterval;
    }

    public InfoModel infoModel() {
        return infoModel;
    }

    public Configuration hadoopConf() {
        return hadoopConf;
    }

    public CompressionCodecFactory org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory;
    }

    public int org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion;
    }

    public Seq<Partitioner> org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners;
    }

    public String ignored() {
        return ignored;
    }

    public ThreadPoolExecutor org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool;
    }

    public InvariantPackerMain.MyDirWatcher org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher() {
        return org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher;
    }

    public boolean running() {
        return running;
    }

    public void running_$eq(boolean x$1) {
        running = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$x$25$1(String x$24) {
        String string = x$24.substring(0, 2);
        String string2 = "--";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$3(InvariantPackerMain.RepositoryPath rp) {
        MODULE$.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().execute(rp);
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$InvariantPackerMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        String string;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        BoxedUnit boxedUnit14;
        BoxedUnit boxedUnit15;
        BoxedUnit boxedUnit16;
        BoxedUnit boxedUnit17;
        Tuple2 tuple2;
        Object result;
        BoxedUnit boxedUnit18;
        BoxedUnit boxedUnit19;
        None$ none$;
        String compressName;
        org$cert$netsa$mothra$tools$InvariantPackerMain$$APP = "InvariantPacker";
        appProp = "mothra.invariantpacker.";
        SHUTDOWN_PRIORITY = 50;
        DEFAULT_COMPRESSION = "";
        String string2 = compressName = (String)package$.MODULE$.props().get(new StringBuilder(11).append(this.appProp()).append("compression").toString()).getOrElse((Function0 & Serializable)() -> MODULE$.DEFAULT_COMPRESSION());
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            none$ = None$.MODULE$;
        } else {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                CompressionCodec codec = MODULE$.org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory().getCodecByName(compressName);
                codec.createCompressor();
                return codec;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                none$ = Option$.MODULE$.apply((Object)ok);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit20;
                BoxedUnit boxedUnit21;
                BoxedUnit boxedUnit22;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unable to initialize compressor '{}' {}", new Object[]{compressName, e});
                    boxedUnit22 = BoxedUnit.UNIT;
                } else {
                    boxedUnit22 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Unable to initialize compressor '").append(compressName).append("'").toString(), e);
                    boxedUnit21 = BoxedUnit.UNIT;
                } else {
                    boxedUnit21 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit20 = BoxedUnit.UNIT;
                } else {
                    boxedUnit20 = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
        }
        compressCodec = none$;
        org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix = (String)this.compressCodec().map((Function1 & Serializable)c -> c.getDefaultExtension()).getOrElse((Function0 & Serializable)() -> "");
        DEFAULT_MAX_THREADS = 6;
        maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(10).append(this.appProp()).append("maxThreads").toString()).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$15)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_MAX_THREADS()));
        Predef$.MODULE$.require(this.maxThreads() >= 1);
        MINIMUM_MAXIMUM_SIZE = 524288L;
        maximumSize = package$.MODULE$.props().get(new StringBuilder(11).append(this.appProp()).append("maximumSize").toString()).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$16))));
        Predef$.MODULE$.require(this.maximumSize().isEmpty() || BoxesRunTime.unboxToLong((Object)this.maximumSize().get()) >= this.MINIMUM_MAXIMUM_SIZE());
        DEFAULT_OUTPUT_FILE_IDLE_SECONDS = 900;
        OUTPUT_FILE_IDLE_SECONDS_MINIMUM = 60;
        outputIdleSeconds = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(17).append(this.appProp()).append("outputIdleSeconds").toString()).map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$17)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_OUTPUT_FILE_IDLE_SECONDS()));
        Predef$.MODULE$.require(this.outputIdleSeconds() >= this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM());
        DEFAULT_MAXIMUM_AGE_SECONDS = 900;
        maxInputAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(18).append(this.appProp()).append("maxInputAgeSeconds").toString()).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$18)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_MAXIMUM_AGE_SECONDS())) * 1000;
        DEFAULT_MINIMUM_INPUT_COUNT = 3;
        minInputCount = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(13).append(this.appProp()).append("minInputCount").toString()).map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_MINIMUM_INPUT_COUNT()));
        Predef$.MODULE$.require(this.minInputCount() > 0);
        DEFAULT_MINIMUM_INPUT_SIZE = 0x100000L;
        minInputSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get(new StringBuilder(12).append(this.appProp()).append("minInputSize").toString()).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$20)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.DEFAULT_MINIMUM_INPUT_SIZE()));
        Predef$.MODULE$.require(this.minInputSize() > 0L);
        DEFAULT_FILE_CACHE_SIZE = 2000;
        MINIMUM_FILE_CACHE_SIZE = 128;
        fileCacheSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(13).append(this.appProp()).append("fileCacheSize").toString()).map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_FILE_CACHE_SIZE()));
        Predef$.MODULE$.require(this.fileCacheSize() >= this.MINIMUM_FILE_CACHE_SIZE());
        Predef$.MODULE$.require(this.fileCacheSize() >= this.maxThreads());
        DEFAULT_POLL_INTERVAL = 15;
        pollingInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(15).append(this.appProp()).append("pollingInterval").toString()).map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$22)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_POLL_INTERVAL()));
        Predef$.MODULE$.require(this.pollingInterval() > 0);
        DEFAULT_OBSERVATION_DOMAIN_ID = 0;
        observationDomain = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringBuilder(19).append(this.appProp()).append("observationDomainId").toString()).map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$23)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_OBSERVATION_DOMAIN_ID()));
        oneshot = false;
        System.err.println(new StringBuilder(8).append("ARgs is ").append(this.args()).toString());
        Tuple2 tuple22 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])this.args()), (Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)InvariantPackerMain$.$anonfun$x$25$1(x$24)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String[] switches = (String[])tuple22._1();
        String[] positionalArgs = (String[])tuple22._2();
        x$25 = new Tuple2((Object)switches, (Object)positionalArgs);
        InvariantPackerMain$.switches = (String[])x$25._1();
        InvariantPackerMain$.positionalArgs = (String[])x$25._2();
        System.err.println(new StringBuilder(12).append("Switches is ").append(this.switches()).toString());
        ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])this.switches()), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if ("-V".equals(A1) ? true : "--version".equals(A1)) {
                    InvariantPackerMain$.MODULE$.version();
                    return (B1)BoxedUnit.UNIT;
                }
                if ("-h".equals(A1) ? true : "--help".equals(A1)) {
                    InvariantPackerMain$.MODULE$.usage(true);
                    return (B1)BoxedUnit.UNIT;
                }
                if ("--one-shot".equals(A1) ? true : "--oneshot".equals(A1)) {
                    InvariantPackerMain$.MODULE$.oneshot_$eq(true);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    Predef$.MODULE$.println((Object)new StringBuilder(19).append("Unknown argument '").append(A12).append("'").toString());
                    InvariantPackerMain$.MODULE$.usage(InvariantPackerMain$.MODULE$.usage$default$1());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                if ("-V".equals(string) ? true : "--version".equals(string)) {
                    return true;
                }
                if ("-h".equals(string) ? true : "--help".equals(string)) {
                    return true;
                }
                if ("--one-shot".equals(string) ? true : "--oneshot".equals(string)) {
                    return true;
                }
                return string != null;
            }
        }, (ClassTag)ClassTag$.MODULE$.Unit());
        if (this.positionalArgs().length != 3) {
            BoxedUnit boxedUnit23;
            String errmsg = this.positionalArgs().length == 1 ? "Called with 1 argument" : new StringBuilder(22).append("Called with ").append(this.positionalArgs().length).append(" arguments").toString();
            errmsg = new StringBuilder(65).append(errmsg).append("; exactly 3 required (incomingDir destinationDir partitionerFile)").toString();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(errmsg);
                boxedUnit23 = BoxedUnit.UNIT;
            } else {
                boxedUnit23 = BoxedUnit.UNIT;
            }
            Predef$.MODULE$.println((Object)errmsg);
            this.usage(this.usage$default$1());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n============================= {} is starting =============================\n", (Object)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP());
            boxedUnit19 = BoxedUnit.UNIT;
        } else {
            boxedUnit19 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is {} {}", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP(), Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
            boxedUnit18 = BoxedUnit.UNIT;
        } else {
            boxedUnit18 = BoxedUnit.UNIT;
        }
        incomingDir = new Path(this.positionalArgs()[0]);
        destinationDir = new Path(this.positionalArgs()[1]);
        packLogicPath = new Path(this.positionalArgs()[2]);
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex = new Object();
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles = Predef$.MODULE$.Map().empty();
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU = PackerDeque$.MODULE$.empty();
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount = 0;
        org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount = 0;
        org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize = BoxesRunTime.unboxToLong((Object)this.maximumSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MAX_VALUE)) - 65535L;
        taskCountInterval = 3;
        infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        hadoopConf = new Configuration();
        org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory = new CompressionCodecFactory(this.hadoopConf());
        FSDataInputStream stream = this.packLogicPath().getFileSystem(this.hadoopConf()).open(this.packLogicPath());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new RunTimeCodeLoader((InputStream)stream));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new Exception(new StringBuilder(48).append("Failed to compile run-time packing logic in '").append(this.packLogicPath()).append("': ").append(e).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        RunTimeCodeLoader x = (RunTimeCodeLoader)success.value();
        RunTimeCodeLoader loader = x;
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> loader.load());
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                throw new Exception(new StringBuilder(46).append("Failed to load run-time packing logic from '").append(this.packLogicPath()).append(": ").append(e).toString());
            }
            throw new MatchError((Object)try_2);
        }
        Success success2 = (Success)try_2;
        Object x2 = success2.value();
        Object object = result = x2;
        if (object instanceof PartitionerPackLogic) {
            PartitionerPackLogic partitionerPackLogic = (PartitionerPackLogic)object;
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionerPackLogic.version()), partitionerPackLogic.partitioners());
        } else if (object instanceof PartitionerConfigurator) {
            PartitionerConfigurator partitionerConfigurator = (PartitionerConfigurator)object;
            PartitionerPackLogic ppl = new PartitionerPackLogic(partitionerConfigurator.partitioners());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ppl.version()), ppl.partitioners());
        } else {
            if (object instanceof PackingLogic) {
                throw new Exception("partitionerFile must contain partitions, not other PackingLogic");
            }
            throw new Exception("Unexpected type returned from compiled code: result.getClass");
        }
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        int packVersion = tuple23._1$mcI$sp();
        Seq partitioners = (Seq)tuple23._2();
        x$26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)packVersion), (Object)partitioners);
        org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion = x$26._1$mcI$sp();
        org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners = (Seq)x$26._2();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} Settings::", (Object)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP());
            boxedUnit17 = BoxedUnit.UNIT;
        } else {
            boxedUnit17 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Incoming directory: {}", (Object)this.incomingDir());
            boxedUnit16 = BoxedUnit.UNIT;
        } else {
            boxedUnit16 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Destination directory: {}", (Object)this.destinationDir());
            boxedUnit15 = BoxedUnit.UNIT;
        } else {
            boxedUnit15 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Partitioner logic file: {}", (Object)this.packLogicPath());
            boxedUnit14 = BoxedUnit.UNIT;
        } else {
            boxedUnit14 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output compression: {}", this.compressCodec().getOrElse((Function0 & Serializable)() -> "none"));
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum simultaneous writing tasks: {}", (Object)BoxesRunTime.boxToInteger((int)this.maxThreads()));
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.oneshot()) {
            BoxedUnit boxedUnit24;
            BoxedUnit boxedUnit25;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Will shut down after a single scan of the incoming directory");
                boxedUnit25 = BoxedUnit.UNIT;
            } else {
                boxedUnit25 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Ignoring the following settings:");
                boxedUnit24 = BoxedUnit.UNIT;
            } else {
                boxedUnit24 = BoxedUnit.UNIT;
            }
            string = "- ";
        } else {
            string = ignored = "";
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Polling interval of the incoming directory: {}", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.pollingInterval())});
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Open an output file when it has an input file noticed this long ago: {} seconds", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)(this.maxInputAge() / 1000))});
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Open an output file when it has this number of input files: {}", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.minInputCount())});
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Open an output file when the sum of the sizes of the input files exceeds this value: {} octets", new Object[]{this.ignored(), BoxesRunTime.boxToLong((long)this.minInputSize())});
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}Maximum time an output file may remain idle before being closed: {} seconds", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.outputIdleSeconds())});
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Approximate maximum size of output files: {}", this.maximumSize().getOrElse((Function0 & Serializable)() -> "unlimited"));
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of open output files: {}", (Object)BoxesRunTime.boxToInteger((int)this.fileCacheSize()));
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Observation domain for output files: {}", (Object)BoxesRunTime.boxToInteger((int)this.observationDomain()));
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", (Object)Predef$.MODULE$.wrapRefArray(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(","));
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} threads are starting::", (Object)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ShutdownHookManager.get().addShutdownHook((Runnable)new InvariantPackerMain.Cleanup(), this.SHUTDOWN_PRIORITY());
        org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new PackerThreadFactory("ActiveWriter-"));
        org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher = new InvariantPackerMain.MyDirWatcher(this.incomingDir());
        boolean bl = running = !this.oneshot();
        if (this.oneshot()) {
            BoxedUnit boxedUnit26;
            BoxedUnit boxedUnit27;
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher().runOnce();
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher().shutdown();
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles().values().foreach((Function1 & Serializable)rp -> {
                InvariantPackerMain$.$anonfun$new$3(rp);
                return BoxedUnit.UNIT;
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Running with one-shot enabled; waiting for threads to end...");
                boxedUnit27 = BoxedUnit.UNIT;
            } else {
                boxedUnit27 = BoxedUnit.UNIT;
            }
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().shutdown();
            do {
                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts();
            } while (!this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().awaitTermination(1L, TimeUnit.SECONDS));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("All tasks have completed");
                boxedUnit26 = BoxedUnit.UNIT;
            } else {
                boxedUnit26 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("{} is done", (Object)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit28;
            BoxedUnit boxedUnit29;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Starting the incoming directory poller");
                boxedUnit29 = BoxedUnit.UNIT;
            } else {
                boxedUnit29 = BoxedUnit.UNIT;
            }
            this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher().runPeriodically(this.pollingInterval());
            PackerThreadFactory checkFactory = new PackerThreadFactory("OutputFileCheck-");
            ScheduledThreadPoolExecutor checkTaskPool = new ScheduledThreadPoolExecutor(1, checkFactory);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Starting the output file checker");
                boxedUnit28 = BoxedUnit.UNIT;
            } else {
                boxedUnit28 = BoxedUnit.UNIT;
            }
            checkTaskPool.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            checkTaskPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            checkTaskPool.setRemoveOnCancelPolicy(true);
            checkTaskPool.scheduleWithFixedDelay(new InvariantPackerMain.CheckRepositoryPaths(), this.pollingInterval() / 2, this.pollingInterval(), TimeUnit.SECONDS);
            do {
                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts();
            } while (this.running() && !this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool().awaitTermination(this.taskCountInterval(), TimeUnit.SECONDS));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private InvariantPackerMain$() {
    }
}

