/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ShutdownHookManager;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.mothra.packer.CorePacker;
import org.cert.netsa.mothra.packer.CorePacker$;
import org.cert.netsa.mothra.packer.DirMapping;
import org.cert.netsa.mothra.packer.PackFileJob;
import org.cert.netsa.mothra.packer.PackerConfig;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.PackingLogic;
import org.cert.netsa.mothra.packer.PartitionerConfigurator;
import org.cert.netsa.mothra.packer.PartitionerPackLogic;
import org.cert.netsa.mothra.packer.RunTimeCodeLoader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.PackerMain;
import org.cert.netsa.mothra.tools.PackerMain$delayedInit$body;
import org.slf4j.Logger;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class PackerMain$
implements App,
StrictLogging {
    public static final PackerMain$ MODULE$ = new PackerMain$();
    private static int SHUTDOWN_PRIORITY;
    private static int DEFAULT_MAX_PACK_JOBS;
    private static int DEFAULT_PACK_ATTEMPTS;
    private static int DEFAULT_POLL_INTERVAL;
    private static int DEFAULT_WORKDIR_CHECK_INTERVAL;
    private static int DEFAULT_WORKDIR_MAXIMUM_AGE;
    private static int DEFAULT_WORKDIR_MAXIMUM_SIZE;
    private static int DEFAULT_WORKDIR_MINIMUM_AGE;
    private static int DEFAULT_WORKDIR_MINIMUM_SIZE;
    private static /* synthetic */ Tuple2 x$2;
    private static String[] switches;
    private static String[] positionalArgs;
    private static boolean oneShot;
    private static int reqArgs;
    private static Path incomingDir;
    private static Path rootDir;
    private static java.nio.file.Path workDir;
    private static Path packLogicPath;
    private static volatile boolean org$cert$netsa$mothra$tools$PackerMain$$running;
    private static Configuration conf;
    private static InfoModel infoModel;
    private static Option<Path> archiveDir;
    private static Option<CompressionCodec> compressCodec;
    private static int hoursPerFile;
    private static int maxPackJobs;
    private static int packAttempts;
    private static int pollingInterval;
    private static int workdirCheckInterval;
    private static long workdirMinimumSize;
    private static long workdirMaximumSize;
    private static int workdirMinimumAge;
    private static int workdirMaximumAge;
    private static int fileCacheSize;
    private static int numMoveThreads;
    private static PackerConfig packConf;
    private static PackingLogic packLogic;
    private static CorePacker packer;
    private static DirMapping watcher;
    private static ThreadPoolExecutor packerPool;
    private static Queue<PackFileJob> tasks;
    private static ScheduledFuture<?> checkWorkdirResult;
    private static int logTaskCountInterval;
    private static ScheduledFuture<?> logTaskCountThread;
    private static com.typesafe.scalalogging.Logger logger;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        StrictLogging.$init$((StrictLogging)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new PackerMain$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public com.typesafe.scalalogging.Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(com.typesafe.scalalogging.Logger x$1) {
        logger = x$1;
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.PackerMain mothra-tools.jar [--one-shot] <srcDir> <destDir> <workDir> <partitioner>\n\nwhere:\n\nsrcDir:       Source (incoming) directory as Hadoop URI\ndestDir:      Destination directory as Hadoop URI\nworkDir:      Working directory on the local disk (not file://)\npartitioner:  Partitioning file as Hadoop URIs\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringBuilder(4568).append("\nPacker scans the source directory (`srcDir`) for IPFIX files.  It splits\nthe IPFIX records in each file into output file(s) in a time-based\ndirectory structure based on the partitioning rules in the partitioning\nfile (`partitioner`).  The output files are initially created in the\nworking directory (`workDir`), and when they meet size and/or age\nthresholds, they are moved to the destination directory (`destDir`).\n\nIf \"--one-shot\" is included on the command line, the `srcDir` is only\nscanned one time.  Once all files in `srcDir` have been packed (or they\nfail to be packed after some number of attempts), the packer exits.\n\nThe Java property values that are used by the packer are:\n\n`mothra.packer.compression` -- The compression to use for files written to\nHDFS.  Values typically supported by Hadoop include `bzip2`, `gzip`,\n`lz4`, `lzo`, `lzop`, `snappy`, and `default`.  The empty string indicates\nno compression.  The default is `").append(CorePacker$.MODULE$.DEFAULT_COMPRESSION()).append("`.\n\nmothra.packer.maxPackJobs -- The size of the thread pool that determines the\nmaximum number of input files that may be processed simultaneously.  A larger\nvalue provides more throughput.  The default is ").append(this.DEFAULT_MAX_PACK_JOBS()).append(".\n\nmothra.packer.hoursPerFile -- The number of hours covered by each file in the\nrepository.  The valid range is 1 (a file for each hour) to 24 (one file per\nday).  The default is ").append(CorePacker$.MODULE$.DEFAULT_HOURS_PER_FILE()).append(".\n\nmothra.packer.pollingInterval -- How long the main thread sleeps (in seconds)\nbetween scans (polls) of the source directory checking for IPFIX files to\nprocess.  The default is ").append(this.DEFAULT_POLL_INTERVAL()).append(".\n\nmothra.packer.workDir.checkInterval -- The value for how often, in seconds, to\ncheck the sizes and ages of the files in the working directory.  The default\nis ").append(this.DEFAULT_WORKDIR_CHECK_INTERVAL()).append(".\nWhen the checkInterval is reached, the sizes and ages of the files in\nthe working directory are checked.  Files that meet ONE of the following\ncriteria are closed and moved into the data repository.  The criteria are:\n\n* Files that were created more than `maximumAge` seconds ago.  Since files are\nonly checked at this interval, a file could potentially be one interval older\nthan the `maximumAge`.\n\n* Files whose size exceeds `maximumSize`.  Since a file's size is not\ncontinuously monitored, a file could be larger than this size, and the user\nshould set this value appropriately.\n\n* Files whose size is at least `minimumsSize` AND that were created at least\n`minimumAge` seconds ago.\n\nmothra.packer.workDir.maximumAge -- Files in the working directory that were\ncreated over this number of seconds ago are always moved into the repository,\nregardless of their size.  The default value is ").append(this.DEFAULT_WORKDIR_MAXIMUM_AGE()).append(" seconds.\n\nmothra.packer.workDir.maximumSize -- Files in the working directory whose\nsize, in octets, is greater than this value are always moved into the\nrepository, regardless of their age.  The default value is\n").append(this.DEFAULT_WORKDIR_MAXIMUM_SIZE()).append(" octets.\n\nmothra.packer.workDir.minimumAge -- Files in the working directory are only\nmoved into the repository once they reach this age (were created over this\nnumber of seconds ago) unless their size exceeds maximumSize.  The default is\n").append(this.DEFAULT_WORKDIR_MINIMUM_AGE()).append(" seconds.\n\nmothra.packer.workDir.minimumSize -- Files in the working directory are only\nmoved into the repository once they reach this size (in octets) unless their\nage exceeds maximumAge.  The default is ").append(this.DEFAULT_WORKDIR_MINIMUM_SIZE()).append(" octets.\n\n`mothra.packer.numMoveThreads` -- The size of the thread pool that closes\nthe work files and moves them to the destination directory.  A task is\npotentially created every `workdirCheckInterval` seconds if files are\ndetermined to have met the limits.  The default is ").append(CorePacker$.MODULE$.DEFAULT_NUM_MOVE_THREADS()).append(".\n\nmothra.packer.archiveDirectory -- The root directory into which working files\nare moved after the packer copies their content to the repository, as a Hadoop\nURI.  If not specified, the working files are deleted.\n\nmothra.packer.packAttempts -- The number of times the packer attempts to\nprocess a file found in the srcDir.  After this number of failed attempts,\nthe file is ignored by this invocation of the packer.  The default is ").append(this.DEFAULT_PACK_ATTEMPTS()).append(".\n\nmothra.packer.fileCacheSize -- The maximum size of the open file cache.\nThis is the maximum number of open files maintained by the file cache for\nwriting to files in the work directory.  The packer does not limit the\nnumber of files in the work directory; this only limits the number of open\nfiles.  Once the cache reaches this number of open files and the packer\nneeds to (re-)open a file, the packer closes the least-recently-used file.\nThis value does not include the file handles required when reading\nincoming files or when copying files from the work directory to the data\ndirectory.  The default is ").append(CorePacker$.MODULE$.DEFAULT_FILE_CACHE_SIZE()).append("; the minimum\npermitted is ").append(CorePacker$.MODULE$.MINIMUM_FILE_CACHE_SIZE()).append(".\n").toString());
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
        System.exit(0);
    }

    private int SHUTDOWN_PRIORITY() {
        return SHUTDOWN_PRIORITY;
    }

    public int DEFAULT_MAX_PACK_JOBS() {
        return DEFAULT_MAX_PACK_JOBS;
    }

    public int DEFAULT_PACK_ATTEMPTS() {
        return DEFAULT_PACK_ATTEMPTS;
    }

    public int DEFAULT_POLL_INTERVAL() {
        return DEFAULT_POLL_INTERVAL;
    }

    public int DEFAULT_WORKDIR_CHECK_INTERVAL() {
        return DEFAULT_WORKDIR_CHECK_INTERVAL;
    }

    public int DEFAULT_WORKDIR_MAXIMUM_AGE() {
        return DEFAULT_WORKDIR_MAXIMUM_AGE;
    }

    public int DEFAULT_WORKDIR_MAXIMUM_SIZE() {
        return DEFAULT_WORKDIR_MAXIMUM_SIZE;
    }

    public int DEFAULT_WORKDIR_MINIMUM_AGE() {
        return DEFAULT_WORKDIR_MINIMUM_AGE;
    }

    public int DEFAULT_WORKDIR_MINIMUM_SIZE() {
        return DEFAULT_WORKDIR_MINIMUM_SIZE;
    }

    public String[] switches() {
        return switches;
    }

    public String[] positionalArgs() {
        return positionalArgs;
    }

    public boolean oneShot() {
        return oneShot;
    }

    public void oneShot_$eq(boolean x$1) {
        oneShot = x$1;
    }

    public int reqArgs() {
        return reqArgs;
    }

    public Path incomingDir() {
        return incomingDir;
    }

    public Path rootDir() {
        return rootDir;
    }

    public java.nio.file.Path workDir() {
        return workDir;
    }

    public Path packLogicPath() {
        return packLogicPath;
    }

    public boolean org$cert$netsa$mothra$tools$PackerMain$$running() {
        return org$cert$netsa$mothra$tools$PackerMain$$running;
    }

    public void org$cert$netsa$mothra$tools$PackerMain$$running_$eq(boolean x$1) {
        org$cert$netsa$mothra$tools$PackerMain$$running = x$1;
    }

    public Configuration conf() {
        return conf;
    }

    public InfoModel infoModel() {
        return infoModel;
    }

    public Option<Path> archiveDir() {
        return archiveDir;
    }

    public Option<CompressionCodec> compressCodec() {
        return compressCodec;
    }

    public int hoursPerFile() {
        return hoursPerFile;
    }

    public int maxPackJobs() {
        return maxPackJobs;
    }

    public int packAttempts() {
        return packAttempts;
    }

    public int pollingInterval() {
        return pollingInterval;
    }

    public int workdirCheckInterval() {
        return workdirCheckInterval;
    }

    public long workdirMinimumSize() {
        return workdirMinimumSize;
    }

    public long workdirMaximumSize() {
        return workdirMaximumSize;
    }

    public int workdirMinimumAge() {
        return workdirMinimumAge;
    }

    public int workdirMaximumAge() {
        return workdirMaximumAge;
    }

    public int fileCacheSize() {
        return fileCacheSize;
    }

    public int numMoveThreads() {
        return numMoveThreads;
    }

    public PackerConfig packConf() {
        return packConf;
    }

    private PackingLogic packLogic() {
        return packLogic;
    }

    public CorePacker packer() {
        return packer;
    }

    public DirMapping watcher() {
        return watcher;
    }

    private ThreadPoolExecutor packerPool() {
        return packerPool;
    }

    public void org$cert$netsa$mothra$tools$PackerMain$$logPackerTaskCount() {
        BoxedUnit boxedUnit;
        int active = this.packerPool().getActiveCount();
        long completed = this.packerPool().getCompletedTaskCount();
        long total = this.packerPool().getTaskCount();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Packing task count: Completed: {}, Active: {}, Queued: {}", new Object[]{BoxesRunTime.boxToLong((long)completed), BoxesRunTime.boxToInteger((int)active), BoxesRunTime.boxToLong((long)(total - completed - (long)active))});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Queue<PackFileJob> tasks() {
        return tasks;
    }

    private void tasks_$eq(Queue<PackFileJob> x$1) {
        tasks = x$1;
    }

    private ScheduledFuture<?> checkWorkdirResult() {
        return checkWorkdirResult;
    }

    public int logTaskCountInterval() {
        return logTaskCountInterval;
    }

    private ScheduledFuture<?> logTaskCountThread() {
        return logTaskCountThread;
    }

    public static final /* synthetic */ boolean $anonfun$x$2$1(String x$1) {
        String string = x$1.substring(0, 2);
        String string2 = "--";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$3(Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 != null) {
            return MODULE$.org$cert$netsa$mothra$tools$PackerMain$$running();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$new$5(PackFileJob job) {
        if (!job.result().isDone()) {
            return 0;
        }
        if (BoxesRunTime.unboxToBoolean((Object)job.result().get())) {
            return 1;
        }
        if (job.runCount() < MODULE$.packAttempts()) {
            return 2;
        }
        return 3;
    }

    public static final /* synthetic */ boolean $anonfun$new$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$new$7(Tuple2 x$17) {
        Tuple2 tuple2 = x$17;
        if (tuple2 != null) {
            int k = tuple2._1$mcI$sp();
            Queue v = (Queue)tuple2._2();
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("groups({}) contains {} tasks", new Object[]{BoxesRunTime.boxToInteger((int)k), BoxesRunTime.boxToInteger((int)v.size())});
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Tuple2 x$19) {
        Tuple2 tuple2 = x$19;
        if (tuple2 != null) {
            PackFileJob job = (PackFileJob)tuple2._1();
            return MODULE$.watcher().fileExists(job.sourcePath());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$12(Tuple2 x$20) {
        Tuple2 tuple2 = x$20;
        if (tuple2 != null) {
            return MODULE$.org$cert$netsa$mothra$tools$PackerMain$$running();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$15(PackFileJob job) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isWarnEnabled()) {
            MODULE$.logger().underlying().warn("Maximum packing attempts reached for '{}'", (Object)job.sourcePath());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Tuple2 x$23) {
        Tuple2 tuple2 = x$23;
        if (tuple2 != null) {
            return MODULE$.org$cert$netsa$mothra$tools$PackerMain$$running();
        }
        throw new MatchError((Object)tuple2);
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$PackerMain$1() {
        block69: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            PackingLogic packingLogic;
            Object result;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            BoxedUnit boxedUnit7;
            BoxedUnit boxedUnit8;
            BoxedUnit boxedUnit9;
            BoxedUnit boxedUnit10;
            BoxedUnit boxedUnit11;
            BoxedUnit boxedUnit12;
            BoxedUnit boxedUnit13;
            BoxedUnit boxedUnit14;
            BoxedUnit boxedUnit15;
            None$ none$;
            String compressName;
            BoxedUnit boxedUnit16;
            BoxedUnit boxedUnit17;
            SHUTDOWN_PRIORITY = 50;
            DEFAULT_MAX_PACK_JOBS = 1;
            DEFAULT_PACK_ATTEMPTS = 3;
            DEFAULT_POLL_INTERVAL = 30;
            DEFAULT_WORKDIR_CHECK_INTERVAL = 60;
            DEFAULT_WORKDIR_MAXIMUM_AGE = 1800;
            DEFAULT_WORKDIR_MAXIMUM_SIZE = 0x6400000;
            DEFAULT_WORKDIR_MINIMUM_AGE = 300;
            DEFAULT_WORKDIR_MINIMUM_SIZE = 0x4000000;
            Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])this.args()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PackerMain$.$anonfun$x$2$1(x$1)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String[] switches = (String[])tuple2._1();
            String[] positionalArgs = (String[])tuple2._2();
            x$2 = new Tuple2((Object)switches, (Object)positionalArgs);
            PackerMain$.switches = (String[])x$2._1();
            PackerMain$.positionalArgs = (String[])x$2._2();
            oneShot = false;
            ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])this.switches()), (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if ("-V".equals(A1) ? true : "--version".equals(A1)) {
                        PackerMain$.MODULE$.version();
                        return (B1)BoxedUnit.UNIT;
                    }
                    if ("-h".equals(A1) ? true : "--help".equals(A1)) {
                        PackerMain$.MODULE$.usage(true);
                        return (B1)BoxedUnit.UNIT;
                    }
                    if ("--one-shot".equals(A1) ? true : "--oneshot".equals(A1)) {
                        PackerMain$.MODULE$.oneShot_$eq(true);
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 != null) {
                        A1 A12 = A1;
                        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Unknown argument '").append(A12).append("'").toString());
                        PackerMain$.MODULE$.usage(PackerMain$.MODULE$.usage$default$1());
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(String x1) {
                    String string = x1;
                    if ("-V".equals(string) ? true : "--version".equals(string)) {
                        return true;
                    }
                    if ("-h".equals(string) ? true : "--help".equals(string)) {
                        return true;
                    }
                    if ("--one-shot".equals(string) ? true : "--oneshot".equals(string)) {
                        return true;
                    }
                    return string != null;
                }
            }, (ClassTag)ClassTag$.MODULE$.Unit());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("\n============================= Packer is starting =============================\n");
                boxedUnit17 = BoxedUnit.UNIT;
            } else {
                boxedUnit17 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("This is packer {}", (Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
                boxedUnit16 = BoxedUnit.UNIT;
            } else {
                boxedUnit16 = BoxedUnit.UNIT;
            }
            reqArgs = 4;
            if (this.positionalArgs().length != this.reqArgs()) {
                BoxedUnit boxedUnit18;
                BoxedUnit boxedUnit19;
                Predef$.MODULE$.println((Object)new StringBuilder(36).append("Called with ").append(this.positionalArgs().length).append(" args; exactly ").append(this.reqArgs()).append(" required").toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Called with {} args; exactly {} required", new Object[]{BoxesRunTime.boxToInteger((int)this.positionalArgs().length), BoxesRunTime.boxToInteger((int)this.reqArgs())});
                    boxedUnit19 = BoxedUnit.UNIT;
                } else {
                    boxedUnit19 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Args were {}", (Object)this.positionalArgs());
                    boxedUnit18 = BoxedUnit.UNIT;
                } else {
                    boxedUnit18 = BoxedUnit.UNIT;
                }
                this.usage(this.usage$default$1());
            }
            incomingDir = new Path(this.positionalArgs()[0]);
            rootDir = new Path(this.positionalArgs()[1]);
            workDir = Paths.get(this.positionalArgs()[2], new String[0]);
            packLogicPath = new Path(this.positionalArgs()[3]);
            org$cert$netsa$mothra$tools$PackerMain$$running = true;
            conf = new Configuration();
            infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
            archiveDir = package$.MODULE$.props().get("mothra.packer.archiveDirectory").map((Function1 & Serializable)x -> new Path(x));
            String string = compressName = (String)package$.MODULE$.props().get("mothra.packer.compression").getOrElse((Function0 & Serializable)() -> CorePacker$.MODULE$.DEFAULT_COMPRESSION());
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                none$ = None$.MODULE$;
            } else {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    CompressionCodecFactory factory = new CompressionCodecFactory(MODULE$.conf());
                    CompressionCodec codec = factory.getCodecByName(compressName);
                    codec.createCompressor();
                    return codec;
                });
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    CompressionCodec ok = (CompressionCodec)success.value();
                    none$ = Option$.MODULE$.apply((Object)ok);
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit20;
                    BoxedUnit boxedUnit21;
                    BoxedUnit boxedUnit22;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Unable to initialize compressor '{}': {}", new Object[]{compressName, e});
                        boxedUnit22 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit22 = BoxedUnit.UNIT;
                    }
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringBuilder(34).append("Unable to initialize compressor '").append(compressName).append("'").toString(), e);
                        boxedUnit21 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit21 = BoxedUnit.UNIT;
                    }
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Using no compression for IPFIX files");
                        boxedUnit20 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit20 = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
            }
            compressCodec = none$;
            hoursPerFile = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.hoursPerFile").map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> CorePacker$.MODULE$.DEFAULT_HOURS_PER_FILE()));
            Predef$.MODULE$.require(this.hoursPerFile() >= 1 && this.hoursPerFile() <= 24);
            maxPackJobs = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.maxPackJobs").map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_MAX_PACK_JOBS()));
            Predef$.MODULE$.require(this.maxPackJobs() >= 1);
            packAttempts = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.packAttempts").map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_PACK_ATTEMPTS()));
            Predef$.MODULE$.require(this.packAttempts() >= 1);
            pollingInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.pollingInterval").map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$6)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_POLL_INTERVAL()));
            Predef$.MODULE$.require(this.pollingInterval() >= 1);
            workdirCheckInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.workDir.checkInterval").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$7)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_WORKDIR_CHECK_INTERVAL()));
            Predef$.MODULE$.require(this.workdirCheckInterval() >= 1);
            workdirMinimumSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get("mothra.packer.workDir.minimumSize").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.DEFAULT_WORKDIR_MINIMUM_SIZE()));
            Predef$.MODULE$.require(this.workdirMinimumSize() >= 1L);
            workdirMaximumSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get("mothra.packer.workDir.maximumSize").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.DEFAULT_WORKDIR_MAXIMUM_SIZE()));
            Predef$.MODULE$.require(this.workdirMaximumSize() >= 1L);
            workdirMinimumAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.workDir.minimumAge").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$10)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_WORKDIR_MINIMUM_AGE()));
            Predef$.MODULE$.require(this.workdirMinimumAge() >= 1);
            workdirMaximumAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.workDir.maximumAge").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_WORKDIR_MAXIMUM_AGE()));
            Predef$.MODULE$.require(this.workdirMaximumAge() >= 1);
            fileCacheSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.fileCacheSize").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$12)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> CorePacker$.MODULE$.DEFAULT_FILE_CACHE_SIZE()));
            Predef$.MODULE$.require(this.fileCacheSize() >= CorePacker$.MODULE$.MINIMUM_FILE_CACHE_SIZE());
            numMoveThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.numMoveThreads").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$13)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> CorePacker$.MODULE$.DEFAULT_NUM_MOVE_THREADS()));
            Predef$.MODULE$.require(this.numMoveThreads() >= 1);
            packConf = new PackerConfig(this.rootDir(), this.workDir(), this.archiveDir(), this.compressCodec(), this.conf());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Packer settings::");
                boxedUnit15 = BoxedUnit.UNIT;
            } else {
                boxedUnit15 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Output compression: {}", this.compressCodec().getOrElse((Function0 & Serializable)() -> "none"));
                boxedUnit14 = BoxedUnit.UNIT;
            } else {
                boxedUnit14 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Hours covered by each file: {}", (Object)BoxesRunTime.boxToInteger((int)this.hoursPerFile()));
                boxedUnit13 = BoxedUnit.UNIT;
            } else {
                boxedUnit13 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Maximum simultaneous pack jobs: {}", (Object)BoxesRunTime.boxToInteger((int)this.maxPackJobs()));
                boxedUnit12 = BoxedUnit.UNIT;
            } else {
                boxedUnit12 = BoxedUnit.UNIT;
            }
            if (this.oneShot()) {
                BoxedUnit boxedUnit23;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Will shut down after a single scan of the incoming directory");
                    boxedUnit23 = BoxedUnit.UNIT;
                } else {
                    boxedUnit23 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Ignoring polling interval value ({})", (Object)BoxesRunTime.boxToInteger((int)this.pollingInterval()));
                    boxedUnit11 = BoxedUnit.UNIT;
                } else {
                    boxedUnit11 = BoxedUnit.UNIT;
                }
            } else if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Polling interval of the incoming directory: {}", (Object)BoxesRunTime.boxToInteger((int)this.pollingInterval()));
                boxedUnit11 = BoxedUnit.UNIT;
            } else {
                boxedUnit11 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Interval for checking size & age of working files: {}", (Object)BoxesRunTime.boxToInteger((int)this.workdirCheckInterval()));
                boxedUnit10 = BoxedUnit.UNIT;
            } else {
                boxedUnit10 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Approximate size range for closing working files: {} to {}", new Object[]{BoxesRunTime.boxToLong((long)this.workdirMinimumSize()), BoxesRunTime.boxToLong((long)this.workdirMaximumSize())});
                boxedUnit9 = BoxedUnit.UNIT;
            } else {
                boxedUnit9 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Approximate age range for closing working files: {} to {}", new Object[]{BoxesRunTime.boxToInteger((int)this.workdirMinimumAge()), BoxesRunTime.boxToInteger((int)this.workdirMaximumAge())});
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Maximum number of attempts to process a file: {}", (Object)BoxesRunTime.boxToInteger((int)this.packAttempts()));
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Maximum number of open files in the workDir: {}", (Object)BoxesRunTime.boxToInteger((int)this.fileCacheSize()));
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Number of threads that move files from workDir to destDir: {}", (Object)BoxesRunTime.boxToInteger((int)this.numMoveThreads()));
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                String string3;
                Logger logger = this.logger().underlying();
                Option<Path> option = this.archiveDir();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Path dir = (Path)some.value();
                    string3 = new StringBuilder(44).append("Archive location for expired working files: ").append(dir).toString();
                } else if (None$.MODULE$.equals(option)) {
                    string3 = "Do not archive expired working files";
                } else {
                    throw new MatchError(option);
                }
                logger.info(string3);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("JVM Parameters: {}", (Object)Predef$.MODULE$.wrapRefArray(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(","));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            FSDataInputStream stream = this.packLogicPath().getFileSystem(this.conf()).open(this.packLogicPath());
            RunTimeCodeLoader loader = new RunTimeCodeLoader((InputStream)stream);
            Object object = result = loader.load();
            if (object instanceof PackingLogic) {
                PackingLogic packingLogic2;
                packingLogic = packingLogic2 = (PackingLogic)object;
            } else if (object instanceof PartitionerConfigurator) {
                PartitionerConfigurator partitionerConfigurator = (PartitionerConfigurator)object;
                packingLogic = new PartitionerPackLogic(partitionerConfigurator.partitioners());
            } else {
                throw new Exception("Unexpected type returned from compiled code: result.getClass");
            }
            packLogic = packingLogic;
            packer = CorePacker$.MODULE$.apply(this.packLogic(), this.packConf(), this.infoModel(), this.hoursPerFile(), this.fileCacheSize(), this.numMoveThreads(), this.conf());
            watcher = new DirMapping(this.incomingDir(), this.packer(), this.conf());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Packer threads are starting::");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ShutdownHookManager.get().addShutdownHook((Runnable)new PackerMain.Cleanup(), this.SHUTDOWN_PRIORITY());
            packerPool = new ThreadPoolExecutor(this.maxPackJobs(), this.maxPackJobs(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("PackFileThread-"));
            this.packerPool().prestartAllCoreThreads();
            tasks = Queue$.MODULE$.empty();
            this.packer().initializeWorkDir();
            checkWorkdirResult = Executors.newScheduledThreadPool(1, new PackerThreadFactory("CheckWorkFiles-")).scheduleAtFixedRate(new PackerMain.CheckWorkdir(), this.workdirCheckInterval(), this.workdirCheckInterval(), TimeUnit.SECONDS);
            logTaskCountInterval = 5;
            logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-")).scheduleAtFixedRate(new Thread(){

                public void run() {
                    PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$logPackerTaskCount();
                    PackerMain$.MODULE$.packer().logMoverTaskCount();
                }
            }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
            this.tasks_$eq((Queue<PackFileJob>)((Queue)this.tasks().$plus$plus((IterableOnce)this.watcher().jobs(this.conf()).map((Function1 & Serializable)job -> {
                PackFileJob x$14 = job;
                return new Tuple2(job, (Object)x$14);
            }).withFilter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)PackerMain$.$anonfun$new$3(x$15))).map((Function1 & Serializable)x$16 -> {
                Tuple2 tuple2 = x$16;
                if (tuple2 != null) {
                    PackFileJob job = (PackFileJob)tuple2._1();
                    return job.submitTo(MODULE$.packerPool());
                }
                throw new MatchError((Object)tuple2);
            }))));
            while (this.org$cert$netsa$mothra$tools$PackerMain$$running() && (!this.oneShot() || this.tasks().nonEmpty())) {
                if (this.org$cert$netsa$mothra$tools$PackerMain$$running() && this.tasks().nonEmpty()) {
                    Map groups = this.tasks().groupBy((Function1 & Serializable)job -> BoxesRunTime.boxToInteger((int)PackerMain$.$anonfun$new$5(job)));
                    groups.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PackerMain$.$anonfun$new$6(check$ifrefutable$1))).foreach((Function1 & Serializable)x$17 -> {
                        PackerMain$.$anonfun$new$7(x$17);
                        return BoxedUnit.UNIT;
                    });
                    this.tasks_$eq((Queue<PackFileJob>)((Queue)groups.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> Queue$.MODULE$.empty())));
                    groups.get((Object)BoxesRunTime.boxToInteger((int)2)).foreach((Function1 & Serializable)requeue -> {
                        PackerMain$.MODULE$.tasks_$eq((Queue<PackFileJob>)((Queue)PackerMain$.MODULE$.tasks().$plus$plus((IterableOnce)((IterableOps)requeue.map((Function1 & Serializable)job -> {
                            PackFileJob x$18 = job;
                            return new Tuple2(job, (Object)x$18);
                        })).withFilter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)PackerMain$.$anonfun$new$11(x$19))).withFilter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)PackerMain$.$anonfun$new$12(x$20))).map((Function1 & Serializable)x$21 -> {
                            Tuple2 tuple2 = x$21;
                            if (tuple2 != null) {
                                PackFileJob job = (PackFileJob)tuple2._1();
                                return job.submitTo(PackerMain$.MODULE$.packerPool());
                            }
                            throw new MatchError((Object)tuple2);
                        }))));
                        return BoxedUnit.UNIT;
                    });
                    groups.get((Object)BoxesRunTime.boxToInteger((int)3)).foreach((Function1 & Serializable)failed -> {
                        failed.foreach((Function1 & Serializable)job -> {
                            PackerMain$.$anonfun$new$15(job);
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                }
                if (this.oneShot()) {
                    if (!this.tasks().nonEmpty() || !this.org$cert$netsa$mothra$tools$PackerMain$$running()) continue;
                    Thread.sleep(5000L);
                    continue;
                }
                if (!this.org$cert$netsa$mothra$tools$PackerMain$$running()) continue;
                Thread.sleep(this.pollingInterval() * 1000);
                if (!this.org$cert$netsa$mothra$tools$PackerMain$$running()) continue;
                this.tasks_$eq((Queue<PackFileJob>)((Queue)this.tasks().$plus$plus((IterableOnce)this.watcher().jobs(this.conf()).map((Function1 & Serializable)job -> {
                    PackFileJob x$22 = job;
                    return new Tuple2(job, (Object)x$22);
                }).withFilter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)PackerMain$.$anonfun$new$17(x$23))).map((Function1 & Serializable)x$24 -> {
                    Tuple2 tuple2 = x$24;
                    if (tuple2 != null) {
                        PackFileJob job = (PackFileJob)tuple2._1();
                        return job.submitTo(MODULE$.packerPool());
                    }
                    throw new MatchError((Object)tuple2);
                }))));
            }
            if (!this.org$cert$netsa$mothra$tools$PackerMain$$running()) break block69;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("All tasks have completed and one-shot is active. Closing and moving work files...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.checkWorkdirResult().cancel(false);
            this.packer().closeAllWorkFiles(true);
            this.logTaskCountThread().cancel(false);
            this.org$cert$netsa$mothra$tools$PackerMain$$running_$eq(false);
            System.exit(0);
        }
    }

    private PackerMain$() {
    }
}

