/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.io.ipfix.Record;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.Reader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.packer.Writer;
import org.cert.netsa.mothra.tools.RollupDayMain;
import org.cert.netsa.mothra.tools.RollupDayMain$delayedInit$body;
import resource.Resource$;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class RollupDayMain$
implements App,
StrictLogging {
    public static final RollupDayMain$ MODULE$ = new RollupDayMain$();
    private static String DEFAULT_COMPRESSION;
    private static int DEFAULT_MAX_THREADS;
    private static /* synthetic */ Tuple2 x$2;
    private static String[] switches;
    private static String[] positionalArgs;
    private static InfoModel infoModel;
    private static Configuration hadoopConf;
    private static CompressionCodecFactory codecFactory;
    private static Option<CompressionCodec> compressCodec;
    private static int maxThreads;
    private static Option<Object> maximumSize;
    private static List<Path> org$cert$netsa$mothra$tools$RollupDayMain$$dirList;
    private static FileSystem fileSystem;
    private static LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$RollupDayMain$$signalQueue;
    private static ThreadPoolExecutor org$cert$netsa$mothra$tools$RollupDayMain$$pool;
    private static int logTaskCountInterval;
    private static ScheduledExecutorService logTaskCountThread;
    private static Regex repoFileRegex;
    private static Logger logger;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        StrictLogging.$init$((StrictLogging)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new RollupDayMain$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.RollupDayMain mothra-tools.jar <s1> [<s2> <s3> ...]\n\nwhere:\n\ns1..sn:         Directories to process, as Hadoop URIs\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringBuilder(1702).append("\nRollupDay reduces the number of data files in a Mothra repository.  It\nmay also be used to modify the files' compression.\n\nRollupDay runs as a batch process, not as a daemon.\n\nRollupDay makes a single recursive scan of the source directories <s1>, <s2>,\n... for files whose names match the pattern \"YYYYMMDD.HH.\" or\n\"YYYYMMDD.HH-PTddH.\" (It looks for files matching the regular expression\n`^\\d{8}\\.\\d{2}(?:-PT\\d\\d?H)?\\.`) Files whose names match that pattern and\nreside in the same directory are processed by RollupDay to create a single\nnew file (see next paragraph) in the same directory containing the records\nin all files in that directory.\n\nRollupDay joins the files in a directory into a single file by default.\nThe `mothra.rollupday.maximumSize` Java property may be used to limit the\nmaximum file size.  The size is for the compressed file if compression is\nactive.  The value is approximate since it is only checked after the data\nappears on disk which occurs in large blocks because of buffering by the\nJava stream code and the compression algorithm.\n\nThere is always a single thread that recursively scans the directories.\nThe number of threads that joins the files may be set by specifying the\n`mothra.rollupday.maxThreads` Java property.  If not specified, the\ndefault is ").append(this.DEFAULT_MAX_THREADS()).append(".\n\nBy default, RollupDay does not compress the files it writes.\n(NOTE: It should support writing the output using the same compression as\nthe input.)  To specify the compression codec that it should use, specify\nthe `mothra.rollupday.compression` Java property.  Values typically\nsupported by Hadoop include `bzip2`, `gzip`, `lz4`, `lzo`, `lzop`,\n`snappy`, and `default`.  The empty string indicates no compression.\n").toString());
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)new StringBuilder(10).append("RollupDay ").append(Version$.MODULE$.get(Version$.MODULE$.get$default$1())).toString());
        System.exit(0);
    }

    public String DEFAULT_COMPRESSION() {
        return DEFAULT_COMPRESSION;
    }

    public int DEFAULT_MAX_THREADS() {
        return DEFAULT_MAX_THREADS;
    }

    public String[] switches() {
        return switches;
    }

    public String[] positionalArgs() {
        return positionalArgs;
    }

    public void org$cert$netsa$mothra$tools$RollupDayMain$$joinFilesBasename(Path dir, String basename, Set<Path> files) {
        BoxedUnit boxedUnit;
        String dayfile = new StringBuilder(9).append(basename).append("00-PT24H.").toString();
        ObjectRef writer = ObjectRef.create(null);
        ObjectRef newPaths = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef removeList = ObjectRef.create((Object)package$.MODULE$.List().empty());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Joining {} files into '{}*' in {}/", new Object[]{BoxesRunTime.boxToInteger((int)files.size()), dayfile, dir});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long t0 = System.currentTimeMillis();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            writer$1.elem = new Writer(dir, dayfile, MODULE$.compressCodec(), MODULE$.maximumSize(), MODULE$.infoModel(), MODULE$.hadoopConf());
            Option<FsPermission> originalPerm = ((Writer)writer$1.elem).originalPermission();
            if (MODULE$.maximumSize().isEmpty()) {
                files.foreach((Function1 & Serializable)f -> {
                    RollupDayMain$.$anonfun$joinFilesBasename$2(writer, removeList, f);
                    return BoxedUnit.UNIT;
                });
            } else {
                files.foreach((Function1 & Serializable)f -> {
                    RollupDayMain$.$anonfun$joinFilesBasename$6(writer, newPaths, dayfile, dir, removeList, f);
                    return BoxedUnit.UNIT;
                });
            }
            ((Writer)writer$1.elem).close();
            Path path = ((Writer)writer$1.elem).exportFile();
            newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path);
            writer$1.elem = null;
            originalPerm.foreach((Function1 & Serializable)perm -> {
                RollupDayMain$.$anonfun$joinFilesBasename$10(newPaths, perm);
                return BoxedUnit.UNIT;
            });
            ((List)removeList$1.elem).foreach((Function1 & Serializable)f -> {
                RollupDayMain$.$anonfun$joinFilesBasename$12(f);
                return BoxedUnit.UNIT;
            });
        });
        if (try_ instanceof Success) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(StringOps$.MODULE$.format$extension("Finished joining %s files into %s '%s' files in %s/ in %.3f seconds", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)files.size()), BoxesRunTime.boxToInteger((int)((List)newPaths.elem).size()), dayfile, dir, BoxesRunTime.boxToDouble((double)((double)(System.currentTimeMillis() - t0) / 1000.0))})));
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(34).append("Failed to join ").append(files.size()).append(" files into '").append(dayfile).append("' in ").append(dir).append("/").toString(), ex);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Option$.MODULE$.apply((Object)((Writer)writer.elem)).foreach((Function1 & Serializable)w -> {
                RollupDayMain$.$anonfun$joinFilesBasename$14(newPaths, w);
                return BoxedUnit.UNIT;
            });
            ((List)newPaths.elem).foreach((Function1 & Serializable)f -> {
                RollupDayMain$.$anonfun$joinFilesBasename$15(dir, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)try_);
    }

    public InfoModel infoModel() {
        return infoModel;
    }

    public Configuration hadoopConf() {
        return hadoopConf;
    }

    private CompressionCodecFactory codecFactory() {
        return codecFactory;
    }

    public Option<CompressionCodec> compressCodec() {
        return compressCodec;
    }

    public int maxThreads() {
        return maxThreads;
    }

    public Option<Object> maximumSize() {
        return maximumSize;
    }

    public List<Path> org$cert$netsa$mothra$tools$RollupDayMain$$dirList() {
        return org$cert$netsa$mothra$tools$RollupDayMain$$dirList;
    }

    private void dirList_$eq(List<Path> x$1) {
        org$cert$netsa$mothra$tools$RollupDayMain$$dirList = x$1;
    }

    public FileSystem fileSystem() {
        return fileSystem;
    }

    public LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$RollupDayMain$$signalQueue() {
        return org$cert$netsa$mothra$tools$RollupDayMain$$signalQueue;
    }

    public ThreadPoolExecutor org$cert$netsa$mothra$tools$RollupDayMain$$pool() {
        return org$cert$netsa$mothra$tools$RollupDayMain$$pool;
    }

    public int logTaskCountInterval() {
        return logTaskCountInterval;
    }

    private ScheduledExecutorService logTaskCountThread() {
        return logTaskCountThread;
    }

    private Regex repoFileRegex() {
        return repoFileRegex;
    }

    public static final /* synthetic */ boolean $anonfun$x$2$1(String x$1) {
        String string = x$1.substring(0, 1);
        String string2 = "-";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$5(ObjectRef writer$1, Record record) {
        ((Writer)writer$1.elem).add(record);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$4(ObjectRef writer$1, ObjectRef removeList$1, Path f$1, Reader reader) {
        reader.foreach((Function1 & Serializable)record -> {
            RollupDayMain$.$anonfun$joinFilesBasename$5(writer$1, record);
            return BoxedUnit.UNIT;
        });
        Path path = f$1;
        removeList$1.elem = (List)((List)removeList$1.elem).$plus$colon((Object)path);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$2(ObjectRef writer$1, ObjectRef removeList$1, Path f) {
        resource.package$.MODULE$.managed((Function0 & Serializable)() -> new Reader(f, MODULE$.codecFactory(), MODULE$.infoModel(), MODULE$.hadoopConf()), Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1 & Serializable)reader -> {
            RollupDayMain$.$anonfun$joinFilesBasename$4(writer$1, removeList$1, f, reader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$9(ObjectRef writer$1, ObjectRef newPaths$1, String dayfile$1, Path dir$1, Record record) {
        if (((Writer)writer$1.elem).reachedMaxSize()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("Closing file '{}'", (Object)((Writer)writer$1.elem).getName());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((Writer)writer$1.elem).close();
            Path path = ((Writer)writer$1.elem).exportFile();
            newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path);
            writer$1.elem = null;
            if (MODULE$.logger().underlying().isTraceEnabled()) {
                MODULE$.logger().underlying().trace("Creating additional writer for '{}' in {}", new Object[]{dayfile$1, dir$1});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            writer$1.elem = new Writer(dir$1, dayfile$1, MODULE$.compressCodec(), MODULE$.maximumSize(), MODULE$.infoModel(), MODULE$.hadoopConf());
        }
        ((Writer)writer$1.elem).add(record);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$8(ObjectRef writer$1, ObjectRef newPaths$1, String dayfile$1, Path dir$1, ObjectRef removeList$1, Path f$2, Reader reader) {
        reader.foreach((Function1 & Serializable)record -> {
            RollupDayMain$.$anonfun$joinFilesBasename$9(writer$1, newPaths$1, dayfile$1, dir$1, record);
            return BoxedUnit.UNIT;
        });
        Path path = f$2;
        removeList$1.elem = (List)((List)removeList$1.elem).$plus$colon((Object)path);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$6(ObjectRef writer$1, ObjectRef newPaths$1, String dayfile$1, Path dir$1, ObjectRef removeList$1, Path f) {
        resource.package$.MODULE$.managed((Function0 & Serializable)() -> new Reader(f, MODULE$.codecFactory(), MODULE$.infoModel(), MODULE$.hadoopConf()), Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1 & Serializable)reader -> {
            RollupDayMain$.$anonfun$joinFilesBasename$8(writer$1, newPaths$1, dayfile$1, dir$1, removeList$1, f, reader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$11(FsPermission perm$1, Path f) {
        MODULE$.fileSystem().setPermission(f, perm$1);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$10(ObjectRef newPaths$1, FsPermission perm) {
        ((List)newPaths$1.elem).foreach((Function1 & Serializable)f -> {
            RollupDayMain$.$anonfun$joinFilesBasename$11(perm, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$12(Path f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.fileSystem().delete(f, false));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Failed to remove old file '{}': {}", new Object[]{f, e.toString()});
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$14(ObjectRef newPaths$1, Writer w) {
        Path path = w.exportFile();
        newPaths$1.elem = (List)((List)newPaths$1.elem).$plus$colon((Object)path);
    }

    public static final /* synthetic */ void $anonfun$joinFilesBasename$15(Path dir$1, Path f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.fileSystem().delete(f, false));
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(33).append("Failed to remove new file '").append(f.getName()).append("' in ").append(dir$1).append("/").toString(), ex);
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Path x$7) {
        FileSystem fileSystem = x$7.getFileSystem(MODULE$.hadoopConf());
        FileSystem fileSystem2 = MODULE$.fileSystem();
        return fileSystem == null ? fileSystem2 != null : !fileSystem.equals(fileSystem2);
    }

    private final /* synthetic */ RemoteIterator liftedTree1$1(Path dir$2) {
        RemoteIterator remoteIterator;
        try {
            remoteIterator = this.fileSystem().listLocatedStatus(dir$2);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Unable to get status of '{}/': {}", new Object[]{dir$2, throwable2.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                remoteIterator = new RemoteIterator<LocatedFileStatus>(){

                    public boolean hasNext() {
                        return false;
                    }

                    public LocatedFileStatus next() {
                        throw new NoSuchElementException();
                    }
                };
            }
            throw throwable;
        }
        return remoteIterator;
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$RollupDayMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        None$ none$;
        String compressName;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        DEFAULT_COMPRESSION = "";
        DEFAULT_MAX_THREADS = 6;
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])this.args()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RollupDayMain$.$anonfun$x$2$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] switches = (String[])tuple2._1();
        String[] positionalArgs = (String[])tuple2._2();
        x$2 = new Tuple2((Object)switches, (Object)positionalArgs);
        RollupDayMain$.switches = (String[])x$2._1();
        RollupDayMain$.positionalArgs = (String[])x$2._2();
        ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])this.switches()), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if ("-V".equals(A1) ? true : "--version".equals(A1)) {
                    RollupDayMain$.MODULE$.version();
                    return (B1)BoxedUnit.UNIT;
                }
                if ("-h".equals(A1) ? true : "--help".equals(A1)) {
                    RollupDayMain$.MODULE$.usage(true);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    Predef$.MODULE$.println((Object)new StringBuilder(19).append("Unknown argument '").append(A12).append("'").toString());
                    RollupDayMain$.MODULE$.usage(RollupDayMain$.MODULE$.usage$default$1());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                if ("-V".equals(string) ? true : "--version".equals(string)) {
                    return true;
                }
                if ("-h".equals(string) ? true : "--help".equals(string)) {
                    return true;
                }
                return string != null;
            }
        }, (ClassTag)ClassTag$.MODULE$.Unit());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n============================= RollupDay is starting =============================\n");
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is RollupDay {}", (Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.positionalArgs().length == 0) {
            BoxedUnit boxedUnit14;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Called with no args; at least 1 required");
                boxedUnit14 = BoxedUnit.UNIT;
            } else {
                boxedUnit14 = BoxedUnit.UNIT;
            }
            this.usage(this.usage$default$1());
        }
        infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        hadoopConf = new Configuration();
        codecFactory = new CompressionCodecFactory(this.hadoopConf());
        String string = compressName = (String)scala.sys.package$.MODULE$.props().get("mothra.rollupday.compression").getOrElse((Function0 & Serializable)() -> MODULE$.DEFAULT_COMPRESSION());
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
        } else {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                CompressionCodec codec = MODULE$.codecFactory().getCodecByName(compressName);
                codec.createCompressor();
                return codec;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                none$ = Option$.MODULE$.apply((Object)ok);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit15;
                BoxedUnit boxedUnit16;
                BoxedUnit boxedUnit17;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unable to initialize compressor '{}': {}", new Object[]{compressName, e});
                    boxedUnit17 = BoxedUnit.UNIT;
                } else {
                    boxedUnit17 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Unable to initialize compressor '").append(compressName).append("'").toString(), e);
                    boxedUnit16 = BoxedUnit.UNIT;
                } else {
                    boxedUnit16 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit15 = BoxedUnit.UNIT;
                } else {
                    boxedUnit15 = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
        }
        compressCodec = none$;
        maxThreads = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("mothra.rollupday.maxThreads").map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_MAX_THREADS()));
        Predef$.MODULE$.require(this.maxThreads() >= 1);
        maximumSize = scala.sys.package$.MODULE$.props().get("mothra.rollupday.maximumSize").map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$5))));
        org$cert$netsa$mothra$tools$RollupDayMain$$dirList = Predef$.MODULE$.wrapRefArray((Object[])this.positionalArgs()).toList().map((Function1 & Serializable)x$6 -> new Path(x$6));
        fileSystem = ((Path)this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().head()).getFileSystem(this.hadoopConf());
        if (((List)this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().drop(1)).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)RollupDayMain$.$anonfun$new$1(x$7)))) {
            BoxedUnit boxedUnit18;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("source directories use different file systems");
                boxedUnit18 = BoxedUnit.UNIT;
            } else {
                boxedUnit18 = BoxedUnit.UNIT;
            }
            throw new Exception("source directories use different file systems");
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("RollupDay settings::");
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of top-level directories to scan: {}", (Object)BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().size()));
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of file joining threads: {}", (Object)BoxesRunTime.boxToInteger((int)this.maxThreads()));
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Approximate maximum output file size: {}", this.maximumSize().getOrElse((Function0 & Serializable)() -> "unlimited"));
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output file compression: {}", this.compressCodec().getOrElse((Function0 & Serializable)() -> "none"));
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", (Object)Predef$.MODULE$.wrapRefArray(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(","));
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        org$cert$netsa$mothra$tools$RollupDayMain$$signalQueue = new LinkedBlockingQueue();
        org$cert$netsa$mothra$tools$RollupDayMain$$pool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("RollupDayThread-"));
        logTaskCountInterval = 5;
        logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-"));
        this.logTaskCountThread().scheduleAtFixedRate(new Thread(){

            public void run() {
                BoxedUnit boxedUnit;
                int active = RollupDayMain$.MODULE$.org$cert$netsa$mothra$tools$RollupDayMain$$pool().getActiveCount();
                long completed = RollupDayMain$.MODULE$.org$cert$netsa$mothra$tools$RollupDayMain$$pool().getCompletedTaskCount();
                long total = RollupDayMain$.MODULE$.org$cert$netsa$mothra$tools$RollupDayMain$$pool().getTaskCount();
                if (RollupDayMain$.MODULE$.logger().underlying().isInfoEnabled()) {
                    RollupDayMain$.MODULE$.logger().underlying().info("Directories to scan: {}, Total tasks: {}, Completed tasks: {}, Active tasks: {}, Queued tasks: {}", new Object[]{BoxesRunTime.boxToInteger((int)RollupDayMain$.MODULE$.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().size()), BoxesRunTime.boxToLong((long)total), BoxesRunTime.boxToLong((long)completed), BoxesRunTime.boxToInteger((int)active), BoxesRunTime.boxToLong((long)(total - (long)active - completed))});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
        repoFileRegex = new Regex("\\A(\\d{8}\\.)\\d{2}(?:-PT\\d\\d?H)?\\..*\\Z", (Seq)Nil$.MODULE$);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting recursive scan of {} director{}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().size()), 1 == this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().size() ? "y" : "ies"});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        while (this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().nonEmpty()) {
            boolean bl;
            BoxedUnit boxedUnit19;
            Path dir = (Path)this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().head();
            this.dirList_$eq((List<Path>)((List)this.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().tail()));
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Scanning directory '{}/'", (Object)dir);
                boxedUnit19 = BoxedUnit.UNIT;
            } else {
                boxedUnit19 = BoxedUnit.UNIT;
            }
            Map fileMap = (Map)Map$.MODULE$.empty();
            RemoteIterator iter = this.liftedTree1$1(dir);
            do {
                Try try_;
                if ((try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    block2: {
                        LocatedFileStatus entry;
                        block1: {
                            if (!iter.hasNext()) {
                                return false;
                            }
                            entry = (LocatedFileStatus)iter.next();
                            if (!entry.isDirectory()) break block1;
                            Path path = entry.getPath();
                            MODULE$.dirList_$eq((List<Path>)((List)MODULE$.org$cert$netsa$mothra$tools$RollupDayMain$$dirList().$plus$colon((Object)path)));
                            break block2;
                        }
                        if (!entry.isFile()) break block2;
                        MODULE$.repoFileRegex().findFirstMatchIn((CharSequence)entry.getPath().getName()).foreach((Function1 & Serializable)m -> (Set)((Growable)fileMap.getOrElseUpdate((Object)m.group(1), (Function0 & Serializable)() -> (Set)Set$.MODULE$.empty())).$plus$eq((Object)entry.getPath()));
                    }
                    return true;
                })) instanceof Success) {
                    boolean ok;
                    Success success = (Success)try_;
                    bl = ok = BoxesRunTime.unboxToBoolean((Object)success.value());
                    continue;
                }
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit20;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Unable to read directory entry: {}", (Object)e.toString());
                        boxedUnit20 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit20 = BoxedUnit.UNIT;
                    }
                    bl = true;
                    continue;
                }
                throw new MatchError((Object)try_);
            } while (bl);
            this.org$cert$netsa$mothra$tools$RollupDayMain$$pool().execute(new RollupDayMain.DirectoryJob(dir, (Map<String, Set<Path>>)fileMap));
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Completed recursive directory scan");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Waiting for {} of {} tasks to complete...", new Object[]{BoxesRunTime.boxToLong((long)(this.org$cert$netsa$mothra$tools$RollupDayMain$$pool().getTaskCount() - this.org$cert$netsa$mothra$tools$RollupDayMain$$pool().getCompletedTaskCount())), BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$RollupDayMain$$pool().getTaskCount())});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        this.org$cert$netsa$mothra$tools$RollupDayMain$$pool().shutdown();
        this.org$cert$netsa$mothra$tools$RollupDayMain$$signalQueue().clear();
        while (!this.org$cert$netsa$mothra$tools$RollupDayMain$$pool().isTerminated()) {
            this.org$cert$netsa$mothra$tools$RollupDayMain$$signalQueue().poll(5L, TimeUnit.SECONDS);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All tasks have completed");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.logTaskCountThread().shutdown();
        this.logTaskCountThread().awaitTermination(1L, TimeUnit.SECONDS);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("RollupDay is done");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RollupDayMain$() {
    }
}

