/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.StrictLogging;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.cert.netsa.io.ipfix.InfoElement;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.io.ipfix.Record;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.Reader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.FileSanitizerMain;
import org.cert.netsa.mothra.tools.FileSanitizerMain$;
import org.cert.netsa.mothra.tools.FileSanitizerMain$$anonfun$1$;
import org.cert.netsa.mothra.tools.FileSanitizerMain$$anonfun$1$$anonfun$apply$mcV$sp$1$;
import org.cert.netsa.mothra.tools.FileSanitizerMain$$anonfun$1$$anonfun$apply$mcV$sp$2$;
import org.cert.netsa.mothra.tools.FileSanitizerMain$SanitizingWriter$;
import org.slf4j.Logger;
import resource.Resource$;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class FileSanitizerMain$
implements App,
StrictLogging {
    public static final FileSanitizerMain$ MODULE$;
    private final String DEFAULT_COMPRESSION;
    private final int DEFAULT_MAX_THREADS;
    private final String DEFAULT_SPAWN_THREAD;
    private final /* synthetic */ Tuple2 x$2;
    private final String[] switches;
    private final String[] positionalArgs;
    private final Configuration hadoopConf;
    private final InfoModel infoModel;
    private final Set<InfoElement> toRemove;
    public List<Path> org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList;
    public final CompressionCodecFactory org$cert$netsa$mothra$tools$FileSanitizerMain$$codecFactory;
    private final Option<CompressionCodec> compressCodec;
    private final int maxThreads;
    private final Option<Object> maximumSize;
    private final String spawnThread;
    private final scala.collection.immutable.Map<String, Object> spawnThreadMap;
    private final boolean threadPerDirectory;
    private final FileSystem fileSystem;
    public final LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue;
    public final ThreadPoolExecutor org$cert$netsa$mothra$tools$FileSanitizerMain$$pool;
    private final int logTaskCountInterval;
    private final ScheduledExecutorService logTaskCountThread;
    public final Regex org$cert$netsa$mothra$tools$FileSanitizerMain$$repoFileRegex;
    private final com.typesafe.scalalogging.Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new FileSanitizerMain$();
    }

    public com.typesafe.scalalogging.Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(com.typesafe.scalalogging.Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.FileSanitizerMain mothra-tools.jar <f1>[,<f2>[,<f3>...]] <s1> [<s2> <s3> ...]\n\nf1..fn:         Names of InfoElements to be removed from the files\ns1..sn:         Directories to process, as Hadoop URIs\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nFileSanitizer removes Information Element fields from the hourly files in a\nMothra repository.  In addition, when multiple files share the same name\nexcept for the UUID, FileSanitizer combines those files together.\n\nThe IE fields to be removed must be specified in a single argument, as a\ncomma-separated list of names, such as\n'sourceTransportPort,destinationTransportPort'.\n\nEach remaining argument is a single directory to process.\n\nFileSanitizer runs as a batch process, not as a daemon.\n\nFileSanitizer makes a single recursive scan of the source directories\n<s1>, <s2>, ... for files whose names match the pattern \"YYYYMMDD.HH.\" or\n\"YYYYMMDD.HH-PTddH.\" (It looks for files matching the regular expression\n`^\\\\d{8}\\\\.\\\\d{2}(?:PTddH)?\\\\.`) Files whose names match that pattern are\nprocessed by FileSanitizer to remove the named Information Elements.  All\nfiles where the regular expression matched the same string are joined into a\nsingle file, similar to the FileJoiner.  Finally, the original files are\nremoved.\n\nThere is always a single thread that recursively scans the directories.\nThe number of threads that sanitizes and joins the files may be set by\nspecifying the `mothra.filesanitizer.maxThreads` Java property.  If not\nspecified, the default is ", ".\n\nFileSanitizer may be run so that either it spawns a thread for every\ndirectory that contains files to process or it spawns a thread for each\nset of files in a directory that have the same prefix.  The behavior is\ncontrolled whether the `mothra.filesanitizer.spawnThread` Java property is\nset to `by-prefix` or `by-directory`.  The default is `", "`.\n(For backwards compatibility, `by-hour` is an alias for `by-prefix`.)\n\nBy default, FileSanitizer does not compress the files it writes.\n(NOTE: It should support writing the output using the same compression as\nthe input.)  To specify the compression codec that it should use, specify\nthe `mothra.filesanitizer.compression` Java property.  Values typically\nsupported by Hadoop include `bzip2`, `gzip`, `lz4`, `lzo`, `lzop`,\n`snappy`, and `default`.  The empty string indicates no compression.\n\nFileSanitizer joins files sharing the same prefix into a single file\nby default.  The `mothra.filesanitizer.maximumSize` Java property may be\nused to limit the maximum file size.  The size is for the compressed file\nif compression is active.  The value is approximate since it is only\nchecked after the data appears on disk which occurs in large blocks\nbecause of buffering by the Java stream code and the compression algorithm.\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.DEFAULT_MAX_THREADS()), this.DEFAULT_SPAWN_THREAD()})));
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"FileSanitizer ").append((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1())).toString());
        System.exit(0);
    }

    public String DEFAULT_COMPRESSION() {
        return this.DEFAULT_COMPRESSION;
    }

    public int DEFAULT_MAX_THREADS() {
        return this.DEFAULT_MAX_THREADS;
    }

    public String DEFAULT_SPAWN_THREAD() {
        return this.DEFAULT_SPAWN_THREAD;
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Set<InfoElement> toRemove() {
        return this.toRemove;
    }

    public void org$cert$netsa$mothra$tools$FileSanitizerMain$$sanitizeFilesBasename(Path dir, String basename, Set<Path> files) {
        Try try_;
        block11: {
            block10: {
                BoxedUnit boxedUnit;
                ObjectRef newPaths;
                ObjectRef writer;
                block9: {
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    writer = ObjectRef.create(null);
                    newPaths = ObjectRef.create((Object)List$.MODULE$.empty());
                    ObjectRef removeList = ObjectRef.create((Object)List$.MODULE$.empty());
                    if (this.logger().underlying().isTraceEnabled()) {
                        this.logger().underlying().trace("Sanitizing {} '{}*' files in {}/", new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, dir});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    long t0 = System.currentTimeMillis();
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(dir, basename, files, writer, newPaths, removeList){
                        public static final long serialVersionUID = 0L;
                        public final Path dir$1;
                        public final String basename$1;
                        private final Set files$1;
                        public final ObjectRef writer$1;
                        public final ObjectRef newPaths$1;
                        public final ObjectRef removeList$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.writer$1.elem = FileSanitizerMain$SanitizingWriter$.MODULE$.apply(this.dir$1, this.basename$1);
                            Option<FsPermission> originalPerm = ((FileSanitizerMain.SanitizingWriter)this.writer$1.elem).originalPermission();
                            if (FileSanitizerMain$.MODULE$.maximumSize().isEmpty()) {
                                this.files$1.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.1 $outer;

                                    public final void apply(Path f) {
                                        resource.package$.MODULE$.managed((Function0)new Serializable(this, f){
                                            public static final long serialVersionUID = 0L;
                                            private final Path f$1;

                                            public final Reader apply() {
                                                return new Reader(this.f$1, FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$codecFactory, FileSanitizerMain$.MODULE$.infoModel(), FileSanitizerMain$.MODULE$.hadoopConf());
                                            }
                                            {
                                                this.f$1 = f$1;
                                            }
                                        }, Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1)new Serializable(this, f){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                                            private final Path f$1;

                                            public final void apply(Reader reader) {
                                                reader.foreach(new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$1$$anonfun$apply$mcV$sp$1$$anonfun$apply$7 $outer;

                                                    public final void apply(Record record) {
                                                        ((FileSanitizerMain.SanitizingWriter)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem).add(record);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                });
                                                Path path = this.f$1;
                                                this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().removeList$1.elem = (List)((List)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().removeList$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
                                            }

                                            public /* synthetic */ anonfun$1$$anonfun$apply$mcV$sp$1 org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.f$1 = f$1;
                                            }
                                        });
                                    }

                                    public /* synthetic */ anonfun.1 org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            } else {
                                this.files$1.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.1 $outer;

                                    public final void apply(Path f) {
                                        resource.package$.MODULE$.managed((Function0)new Serializable(this, f){
                                            public static final long serialVersionUID = 0L;
                                            private final Path f$2;

                                            public final Reader apply() {
                                                return new Reader(this.f$2, FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$codecFactory, FileSanitizerMain$.MODULE$.infoModel(), FileSanitizerMain$.MODULE$.hadoopConf());
                                            }
                                            {
                                                this.f$2 = f$2;
                                            }
                                        }, Resource$.MODULE$.reflectiveCloseableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Reader.class)).foreach((Function1)new Serializable(this, f){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$1$$anonfun$apply$mcV$sp$2 $outer;
                                            private final Path f$2;

                                            public final void apply(Reader reader) {
                                                reader.foreach(new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10 $outer;

                                                    public final void apply(Record record) {
                                                        if (((FileSanitizerMain.SanitizingWriter)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem).reachedMaxSize()) {
                                                            BoxedUnit boxedUnit;
                                                            BoxedUnit boxedUnit2;
                                                            if (FileSanitizerMain$.MODULE$.logger().underlying().isTraceEnabled()) {
                                                                FileSanitizerMain$.MODULE$.logger().underlying().trace("Closing file '{}'", new Object[]{((FileSanitizerMain.SanitizingWriter)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem).getName()});
                                                                boxedUnit2 = BoxedUnit.UNIT;
                                                            } else {
                                                                boxedUnit2 = BoxedUnit.UNIT;
                                                            }
                                                            ((FileSanitizerMain.SanitizingWriter)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem).close();
                                                            Path path = ((FileSanitizerMain.SanitizingWriter)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem).exportFile();
                                                            this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().newPaths$1.elem = (List)((List)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
                                                            this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem = null;
                                                            if (FileSanitizerMain$.MODULE$.logger().underlying().isTraceEnabled()) {
                                                                FileSanitizerMain$.MODULE$.logger().underlying().trace(new StringBuilder().append((Object)"Creating additional writer for").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "*' files in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().basename$1, this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().dir$1}))).toString());
                                                                boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                boxedUnit = BoxedUnit.UNIT;
                                                            }
                                                            this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem = FileSanitizerMain$SanitizingWriter$.MODULE$.apply(this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().dir$1, this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().basename$1);
                                                        }
                                                        ((FileSanitizerMain.SanitizingWriter)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer().org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().writer$1.elem).add(record);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                });
                                                Path path = this.f$2;
                                                this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().removeList$1.elem = (List)((List)this.$outer.org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer().removeList$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
                                            }

                                            public /* synthetic */ anonfun$1$$anonfun$apply$mcV$sp$2 org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.f$2 = f$2;
                                            }
                                        });
                                    }

                                    public /* synthetic */ anonfun.1 org$cert$netsa$mothra$tools$FileSanitizerMain$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            ((FileSanitizerMain.SanitizingWriter)this.writer$1.elem).close();
                            Path path = ((FileSanitizerMain.SanitizingWriter)this.writer$1.elem).exportFile();
                            this.newPaths$1.elem = (List)((List)this.newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
                            this.writer$1.elem = null;
                            originalPerm.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.1 $outer;

                                public final void apply(FsPermission perm) {
                                    ((List)this.$outer.newPaths$1.elem).foreach((Function1)new Serializable(this, perm){
                                        public static final long serialVersionUID = 0L;
                                        private final FsPermission perm$1;

                                        public final void apply(Path f) {
                                            FileSanitizerMain$.MODULE$.fileSystem().setPermission(f, this.perm$1);
                                        }
                                        {
                                            this.perm$1 = perm$1;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            ((List)this.removeList$1.elem).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Path f) {
                                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final Path f$3;

                                        public final boolean apply() {
                                            return this.apply$mcZ$sp();
                                        }

                                        public boolean apply$mcZ$sp() {
                                            return FileSanitizerMain$.MODULE$.fileSystem().delete(this.f$3, false);
                                        }
                                        {
                                            this.f$3 = f$3;
                                        }
                                    });
                                    if (try_ instanceof Failure) {
                                        BoxedUnit boxedUnit;
                                        Failure failure = (Failure)try_;
                                        Throwable e = failure.exception();
                                        if (FileSanitizerMain$.MODULE$.logger().underlying().isWarnEnabled()) {
                                            FileSanitizerMain$.MODULE$.logger().underlying().warn("Failed to remove old file '{}': {}", new Object[]{f, e.toString()});
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                    } else {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                            });
                        }
                        {
                            this.dir$1 = dir$1;
                            this.basename$1 = basename$1;
                            this.files$1 = files$1;
                            this.writer$1 = writer$1;
                            this.newPaths$1 = newPaths$1;
                            this.removeList$1 = removeList$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block9;
                    if (this.logger().underlying().isDebugEnabled()) {
                        double arg$macro$32 = (double)(System.currentTimeMillis() - t0) / 1000.0;
                        this.logger().underlying().debug(new StringBuilder().append((Object)"Finished sanitizing ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " '", "*' files into ", " files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, BoxesRunTime.boxToInteger((int)((List)newPaths.elem).size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" in ", "/ in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir}))).append((Object)new StringOps("%.3f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$32)}))).append((Object)" seconds").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit2;
                    break block10;
                }
                if (!(try_ instanceof Failure)) break block11;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to sanitize ", " '", "*' files in ", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)files.size()), basename, dir}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.toString()}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option$.MODULE$.apply((Object)((FileSanitizerMain.SanitizingWriter)writer.elem)).foreach((Function1)new Serializable(newPaths){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef newPaths$1;

                    public final void apply(FileSanitizerMain.SanitizingWriter w) {
                        Path path = w.exportFile();
                        this.newPaths$1.elem = (List)((List)this.newPaths$1.elem).$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
                    }
                    {
                        this.newPaths$1 = newPaths$1;
                    }
                });
                ((List)newPaths.elem).foreach((Function1)new Serializable(dir){
                    public static final long serialVersionUID = 0L;
                    private final Path dir$1;

                    public final void apply(Path f) {
                        Try try_;
                        block7: {
                            block6: {
                                BoxedUnit boxedUnit;
                                block5: {
                                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, f){
                                        public static final long serialVersionUID = 0L;
                                        private final Path f$4;

                                        public final boolean apply() {
                                            return this.apply$mcZ$sp();
                                        }

                                        public boolean apply$mcZ$sp() {
                                            return FileSanitizerMain$.MODULE$.fileSystem().delete(this.f$4, false);
                                        }
                                        {
                                            this.f$4 = f$4;
                                        }
                                    });
                                    if (!(try_ instanceof Success)) break block5;
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (!(try_ instanceof Failure)) break block7;
                                Failure failure = (Failure)try_;
                                Throwable ex = failure.exception();
                                if (FileSanitizerMain$.MODULE$.logger().underlying().isErrorEnabled()) {
                                    FileSanitizerMain$.MODULE$.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove new file '", "' in ", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getName(), this.dir$1})), ex);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit3 = boxedUnit;
                            }
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }
                    {
                        this.dir$1 = dir$1;
                    }
                });
                BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public Option<Object> maximumSize() {
        return this.maximumSize;
    }

    public String spawnThread() {
        return this.spawnThread;
    }

    public scala.collection.immutable.Map<String, Object> spawnThreadMap() {
        return this.spawnThreadMap;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public int logTaskCountInterval() {
        return this.logTaskCountInterval;
    }

    private final RemoteIterator liftedTree1$1(Path dir$2) {
        RemoteIterator remoteIterator;
        try {
            remoteIterator = this.fileSystem().listLocatedStatus(dir$2);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unable to get status of '{}/': {}", new Object[]{dir$2, e.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            RemoteIterator<LocatedFileStatus> remoteIterator2 = new RemoteIterator<LocatedFileStatus>(){

                public boolean hasNext() {
                    return false;
                }

                public LocatedFileStatus next() {
                    throw new NoSuchElementException();
                }
            };
            remoteIterator = remoteIterator2;
        }
        return remoteIterator;
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$FileSanitizerMain$1() {
        Tuple2 tuple2;
        block54: {
            Try try_;
            block59: {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                BoxedUnit boxedUnit3;
                BoxedUnit boxedUnit4;
                BoxedUnit boxedUnit5;
                BoxedUnit boxedUnit6;
                BoxedUnit boxedUnit7;
                BoxedUnit boxedUnit8;
                BoxedUnit boxedUnit9;
                BoxedUnit boxedUnit10;
                BoxedUnit boxedUnit11;
                None$ none$;
                block56: {
                    Option option;
                    block58: {
                        BoxedUnit boxedUnit12;
                        BoxedUnit boxedUnit13;
                        BoxedUnit boxedUnit14;
                        String compressName;
                        block57: {
                            block55: {
                                BoxedUnit boxedUnit15;
                                BoxedUnit boxedUnit16;
                                Tuple2 tuple22;
                                this.DEFAULT_COMPRESSION = "";
                                this.DEFAULT_MAX_THREADS = 6;
                                this.DEFAULT_SPAWN_THREAD = "by-directory";
                                tuple2 = Predef$.MODULE$.refArrayOps((Object[])this.args()).partition((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(String x$1) {
                                        String string = x$1.substring(0, 1);
                                        String string2 = "-";
                                        return !(string != null ? !string.equals(string2) : string2 != null);
                                    }
                                });
                                if (tuple2 == null) break block54;
                                String[] switches = (String[])tuple2._1();
                                String[] positionalArgs = (String[])tuple2._2();
                                this.x$2 = tuple22 = new Tuple2((Object)switches, (Object)positionalArgs);
                                this.switches = (String[])this.x$2._1();
                                this.positionalArgs = (String[])this.x$2._2();
                                Predef$.MODULE$.refArrayOps((Object[])this.switches()).collect((PartialFunction)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                        Object object;
                                        A1 A1 = x1;
                                        boolean bl = "-V".equals(A1) ? true : "--version".equals(A1);
                                        if (bl) {
                                            FileSanitizerMain$.MODULE$.version();
                                            object = BoxedUnit.UNIT;
                                        } else {
                                            boolean bl2 = "-h".equals(A1) ? true : "--help".equals(A1);
                                            if (bl2) {
                                                FileSanitizerMain$.MODULE$.usage(true);
                                                object = BoxedUnit.UNIT;
                                            } else if (A1 != null) {
                                                A1 A12 = A1;
                                                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown argument '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A12})));
                                                FileSanitizerMain$.MODULE$.usage(FileSanitizerMain$.MODULE$.usage$default$1());
                                                object = BoxedUnit.UNIT;
                                            } else {
                                                object = function1.apply(x1);
                                            }
                                        }
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(String x1) {
                                        boolean bl;
                                        String string = x1;
                                        boolean bl2 = "-V".equals(string) ? true : "--version".equals(string);
                                        if (bl2) {
                                            bl = true;
                                        } else {
                                            boolean bl3 = "-h".equals(string) ? true : "--help".equals(string);
                                            bl = bl3 ? true : string != null;
                                        }
                                        return bl;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                                if (this.positionalArgs().length < 2) {
                                    BoxedUnit boxedUnit17;
                                    if (this.logger().underlying().isErrorEnabled()) {
                                        this.logger().underlying().error("Must specify at least two arguments: IE[,IE...] DIR [DIR...]");
                                        boxedUnit17 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit17 = BoxedUnit.UNIT;
                                    }
                                    this.usage(this.usage$default$1());
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("\n============================= FileSanitizer is starting =============================\n");
                                    boxedUnit16 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit16 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("This is FileSanitizer {}", new Object[]{Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
                                    boxedUnit15 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit15 = BoxedUnit.UNIT;
                                }
                                this.hadoopConf = new Configuration();
                                this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
                                this.toRemove = Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.positionalArgs()[0].split(",")).withFilter((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(String ieName) {
                                        String string = ieName;
                                        String string2 = "";
                                        return string != null ? !string.equals(string2) : string2 != null;
                                    }
                                }).flatMap((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Iterable<InfoElement> apply(String ieName) {
                                        return Option$.MODULE$.option2Iterable(FileSanitizerMain$.MODULE$.infoModel().get(ieName).orElse((Function0)new Serializable(this, ieName){
                                            public static final long serialVersionUID = 0L;
                                            private final String ieName$1;

                                            public final Nothing$ apply() {
                                                BoxedUnit boxedUnit;
                                                if (FileSanitizerMain$.MODULE$.logger().underlying().isErrorEnabled()) {
                                                    FileSanitizerMain$.MODULE$.logger().underlying().error("Unknown IE name '{}'", new Object[]{this.ieName$1});
                                                    boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown IE name '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ieName$1})));
                                            }
                                            {
                                                this.ieName$1 = ieName$1;
                                            }
                                        }).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final InfoElement apply(InfoElement ie) {
                                                return ie;
                                            }
                                        }));
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InfoElement.class)))));
                                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList = (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.positionalArgs()).tail()).toList().map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Path apply(String x$3) {
                                        return new Path(x$3);
                                    }
                                }, List$.MODULE$.canBuildFrom());
                                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$codecFactory = new CompressionCodecFactory(this.hadoopConf());
                                String string = compressName = (String)package$.MODULE$.props().get("mothra.filesanitizer.compression").getOrElse((Function0)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return FileSanitizerMain$.MODULE$.DEFAULT_COMPRESSION();
                                    }
                                });
                                String string2 = "";
                                if (string != null ? !string.equals(string2) : string2 != null) break block55;
                                none$ = None$.MODULE$;
                                break block56;
                            }
                            try_ = Try$.MODULE$.apply((Function0)new Serializable(compressName){
                                public static final long serialVersionUID = 0L;
                                private final String compressName$1;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final CompressionCodec apply() {
                                    void var1_1;
                                    CompressionCodec codec = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$codecFactory.getCodecByName(this.compressName$1);
                                    codec.createCompressor();
                                    return var1_1;
                                }
                                {
                                    this.compressName$1 = compressName$1;
                                }
                            });
                            if (!(try_ instanceof Success)) break block57;
                            Success success = (Success)try_;
                            CompressionCodec ok = (CompressionCodec)success.value();
                            option = Option$.MODULE$.apply((Object)ok);
                            break block58;
                        }
                        if (!(try_ instanceof Failure)) break block59;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, e.toString()}))).toString());
                            boxedUnit14 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit14 = BoxedUnit.UNIT;
                        }
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, sw.toString()}))).toString());
                            boxedUnit13 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit13 = BoxedUnit.UNIT;
                        }
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Using no compression for IPFIX files");
                            boxedUnit12 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit12 = BoxedUnit.UNIT;
                        }
                        option = None$.MODULE$;
                    }
                    none$ = option;
                }
                this.compressCodec = none$;
                this.maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.filesanitizer.maxThreads").map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$12) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return FileSanitizerMain$.MODULE$.DEFAULT_MAX_THREADS();
                    }
                }));
                Predef$.MODULE$.require(this.maxThreads() >= 1);
                this.maximumSize = package$.MODULE$.props().get("mothra.filesanitizer.maximumSize").map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final long apply(String x$13) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toLong();
                    }
                });
                this.spawnThread = (String)package$.MODULE$.props().get("mothra.filesanitizer.spawnThread").getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return FileSanitizerMain$.MODULE$.DEFAULT_SPAWN_THREAD();
                    }
                });
                this.spawnThreadMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-directory"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-prefix"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"by-hour"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
                this.threadPerDirectory = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return BoxesRunTime.unboxToBoolean((Object)FileSanitizerMain$.MODULE$.spawnThreadMap().apply((Object)FileSanitizerMain$.MODULE$.spawnThread()));
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        StringBuilder sb = new StringBuilder();
                        FileSanitizerMain$.MODULE$.spawnThreadMap().keys().addString(sb, "mothra.filesanitizer.spawnThread must be one of: '", "', '", "'");
                        throw new Exception(sb.mkString());
                    }
                }));
                this.fileSystem = ((Path)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.head()).getFileSystem(this.hadoopConf());
                if (this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.drop(1).exists((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Path x$14) {
                        FileSystem fileSystem = x$14.getFileSystem(FileSanitizerMain$.MODULE$.hadoopConf());
                        FileSystem fileSystem2 = FileSanitizerMain$.MODULE$.fileSystem();
                        return fileSystem != null ? !fileSystem.equals(fileSystem2) : fileSystem2 != null;
                    }
                })) {
                    BoxedUnit boxedUnit18;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("source directories use different file systems");
                        boxedUnit18 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit18 = BoxedUnit.UNIT;
                    }
                    throw new Exception("source directories use different file systems");
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("FileSanitizer settings::");
                    boxedUnit11 = BoxedUnit.UNIT;
                } else {
                    boxedUnit11 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Number of top-level directories to scan: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.size())});
                    boxedUnit10 = BoxedUnit.UNIT;
                } else {
                    boxedUnit10 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Maximum number of file joining threads: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxThreads())});
                    boxedUnit9 = BoxedUnit.UNIT;
                } else {
                    boxedUnit9 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Policy for starting threads: {}", new Object[]{this.spawnThread()});
                    boxedUnit8 = BoxedUnit.UNIT;
                } else {
                    boxedUnit8 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Approximate maximum output file size: ").append(this.maximumSize().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(long x$15) {
                            return ((Object)BoxesRunTime.boxToLong((long)x$15)).toString();
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "unlimited";
                        }
                    })).toString());
                    boxedUnit7 = BoxedUnit.UNIT;
                } else {
                    boxedUnit7 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Output file compression: {}", new Object[]{this.compressCodec().getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "none";
                        }
                    })});
                    boxedUnit6 = BoxedUnit.UNIT;
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("JVM Parameters: {}", new Object[]{Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(",")});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    Logger logger = this.logger().underlying();
                    StringBuilder stringBuilder = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elements to remove: "})).s((Seq)Nil$.MODULE$));
                    StringBuilder sb = new StringBuilder();
                    ((TraversableOnce)this.toRemove().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(InfoElement x$16) {
                            return x$16.name();
                        }
                    }, Set$.MODULE$.canBuildFrom())).addString(sb, ",");
                    logger.info(stringBuilder.append((Object)sb.mkString()).toString());
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue = new LinkedBlockingQueue();
                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("FileSanitizerThread-"));
                this.logTaskCountInterval = 5;
                this.logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-"));
                this.logTaskCountThread.scheduleAtFixedRate(new Thread(){

                    public void run() {
                        BoxedUnit boxedUnit;
                        int active = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.getActiveCount();
                        long completed = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.getCompletedTaskCount();
                        long total = FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.getTaskCount();
                        if (FileSanitizerMain$.MODULE$.logger().underlying().isInfoEnabled()) {
                            FileSanitizerMain$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Directories to scan: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Total tasks: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)total)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Completed tasks: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)completed)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Active tasks: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)active)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Queued tasks: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(total - (long)active - completed))}))).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$repoFileRegex = new Regex("\\A(\\d{8}\\.\\d{2}(?:-PT\\d\\d?H)?\\.).*\\Z", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting recursive scan of ", " director"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.size())}))).append((Object)(1 == this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.size() ? "y" : "ies")).toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                while (this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.nonEmpty()) {
                    Try try_2;
                    block53: {
                        boolean bl;
                        BoxedUnit boxedUnit19;
                        Path dir = (Path)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.head();
                        this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList = (List)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.tail();
                        if (this.logger().underlying().isTraceEnabled()) {
                            this.logger().underlying().trace("Scanning directory '{}/'", new Object[]{dir});
                            boxedUnit19 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit19 = BoxedUnit.UNIT;
                        }
                        Map fileMap = Map$.MODULE$.empty();
                        RemoteIterator iter = this.liftedTree1$1(dir);
                        do {
                            BoxedUnit boxedUnit20;
                            if ((try_2 = Try$.MODULE$.apply((Function0)new Serializable(fileMap, iter){
                                public static final long serialVersionUID = 0L;
                                public final Map fileMap$1;
                                private final RemoteIterator iter$1;

                                public final boolean apply() {
                                    return this.apply$mcZ$sp();
                                }

                                public boolean apply$mcZ$sp() {
                                    boolean bl;
                                    if (this.iter$1.hasNext()) {
                                        LocatedFileStatus entry = (LocatedFileStatus)this.iter$1.next();
                                        if (entry.isDirectory()) {
                                            Path path = entry.getPath();
                                            FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList = (List)FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$dirList.$plus$colon((Object)path, List$.MODULE$.canBuildFrom());
                                        } else if (entry.isFile()) {
                                            FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$repoFileRegex.findFirstMatchIn((CharSequence)entry.getPath().getName()).foreach((Function1)new Serializable(this, entry){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun.6 $outer;
                                                private final LocatedFileStatus entry$1;

                                                public final Set<Path> apply(Regex.Match m) {
                                                    return (Set)((SetLike)this.$outer.fileMap$1.getOrElseUpdate((Object)m.group(1), (Function0)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Set<Path> apply() {
                                                            return Set$.MODULE$.empty();
                                                        }
                                                    })).$plus$eq((Object)this.entry$1.getPath());
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.entry$1 = entry$1;
                                                }
                                            });
                                        }
                                        bl = true;
                                    } else {
                                        bl = false;
                                    }
                                    return bl;
                                }
                                {
                                    this.fileMap$1 = fileMap$1;
                                    this.iter$1 = iter$1;
                                }
                            })) instanceof Success) {
                                boolean ok;
                                Success success = (Success)try_2;
                                bl = ok = BoxesRunTime.unboxToBoolean((Object)success.value());
                                continue;
                            }
                            if (!(try_2 instanceof Failure)) break block53;
                            Failure failure = (Failure)try_2;
                            Throwable e = failure.exception();
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Unable to read directory entry: {}", new Object[]{e.toString()});
                                boxedUnit20 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit20 = BoxedUnit.UNIT;
                            }
                            bl = true;
                        } while (bl);
                        if (this.threadPerDirectory) {
                            this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.execute(new FileSanitizerMain.DirectoryJob(dir, (Map<String, Set<Path>>)fileMap));
                            continue;
                        }
                        fileMap.withFilter((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, Set<Path>> check$ifrefutable$4) {
                                Tuple2<String, Set<Path>> tuple2 = check$ifrefutable$4;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(dir){
                            public static final long serialVersionUID = 0L;
                            private final Path dir$2;

                            public final void apply(Tuple2<String, Set<Path>> x$18) {
                                Tuple2<String, Set<Path>> tuple2 = x$18;
                                if (tuple2 != null) {
                                    String basename = (String)tuple2._1();
                                    Set set = (Set)tuple2._2();
                                    FileSanitizerMain$.MODULE$.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.execute(new FileSanitizerMain.BasenameFilesJob(this.dir$2, basename, (Set<Path>)set));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.dir$2 = dir$2;
                            }
                        });
                        continue;
                    }
                    throw new MatchError((Object)try_2);
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Completed recursive directory scan");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.getTaskCount() - this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.getCompletedTaskCount()))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" of ", " tasks to complete..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.getTaskCount())}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.shutdown();
                this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue.clear();
                while (true) {
                    if (this.org$cert$netsa$mothra$tools$FileSanitizerMain$$pool.isTerminated()) {
                        BoxedUnit boxedUnit21;
                        BoxedUnit boxedUnit22;
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("All tasks have completed");
                            boxedUnit22 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit22 = BoxedUnit.UNIT;
                        }
                        this.logTaskCountThread.shutdown();
                        this.logTaskCountThread.awaitTermination(1L, TimeUnit.SECONDS);
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("FileSanitizer is done");
                            boxedUnit21 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit21 = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    this.org$cert$netsa$mothra$tools$FileSanitizerMain$$signalQueue.poll(5L, TimeUnit.SECONDS);
                }
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)tuple2);
    }

    private FileSanitizerMain$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        StrictLogging.class.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new FileSanitizerMain.delayedInit.body(this));
    }
}

