/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ShutdownHookManager;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.mothra.packer.PackerDeque;
import org.cert.netsa.mothra.packer.PackerDeque$;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.PackingLogic;
import org.cert.netsa.mothra.packer.Partitioner;
import org.cert.netsa.mothra.packer.PartitionerConfigurator;
import org.cert.netsa.mothra.packer.PartitionerPackLogic;
import org.cert.netsa.mothra.packer.RunTimeCodeLoader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.InvariantPackerMain;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class InvariantPackerMain$
implements App,
StrictLogging {
    public static final InvariantPackerMain$ MODULE$;
    private final String org$cert$netsa$mothra$tools$InvariantPackerMain$$APP;
    private final String appProp;
    private final int SHUTDOWN_PRIORITY;
    private final String DEFAULT_COMPRESSION;
    private final Option<CompressionCodec> compressCodec;
    public final String org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix;
    private final int DEFAULT_MAX_THREADS;
    private final int maxThreads;
    private final long MINIMUM_MAXIMUM_SIZE;
    private final Option<Object> maximumSize;
    private final int DEFAULT_OUTPUT_FILE_IDLE_SECONDS;
    private final int OUTPUT_FILE_IDLE_SECONDS_MINIMUM;
    private final int outputIdleSeconds;
    private final int DEFAULT_MAXIMUM_AGE_SECONDS;
    private final int maxInputAge;
    private final int DEFAULT_MINIMUM_INPUT_COUNT;
    private final int minInputCount;
    private final long DEFAULT_MINIMUM_INPUT_SIZE;
    private final long minInputSize;
    private final int DEFAULT_FILE_CACHE_SIZE;
    private final int MINIMUM_FILE_CACHE_SIZE;
    private final int fileCacheSize;
    private final int DEFAULT_POLL_INTERVAL;
    private final int pollingInterval;
    private final int DEFAULT_OBSERVATION_DOMAIN_ID;
    private final int observationDomain;
    private boolean oneshot;
    private final /* synthetic */ Tuple2 x$17;
    private final String[] switches;
    private final String[] positionalArgs;
    private final Path incomingDir;
    private final Path destinationDir;
    private final Path packLogicPath;
    public final Object org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex;
    public Map<String, InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles;
    public PackerDeque<InvariantPackerMain.RepositoryPath> org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU;
    public volatile int org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount;
    public volatile int org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount;
    public final long org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize;
    private final int taskCountInterval;
    private final InfoModel infoModel;
    private final Configuration hadoopConf;
    public final CompressionCodecFactory org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory;
    private final /* synthetic */ Tuple2 x$18;
    public final int org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion;
    public final Seq<Partitioner> org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners;
    private final String ignored;
    public final ThreadPoolExecutor org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool;
    public final InvariantPackerMain.MyDirWatcher org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher;
    private boolean running;
    private final Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new InvariantPackerMain$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.InvariantPackerMain mothra-tools.jar [--version] [--one-shot] <sourceDir> <destinationDir> <partitionerFile>\n\nsourceDir:         Directory to read from, as Hadoop URI\ndestinationDir:    Directory to write to, as Hadoop URI\npartitionerFile:   A Scala source file containing Partitioner Packing Logic\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n", " processes files created by super_mediator running in invariant mode and\nwrites them into HDFS.  It reads IPRIX records from files from `sourceDir` and\nwrites the records to files in `destinationDir`.\n\nThe `partitionerFile` is a Scala source file that may contain either\nPartitionerConfigurator or PartitionerPackLogic.  ", " reads, parses,\ncompiles, and loads the Scala code contained in the file, then extracts the\nsequence of Partitions defined in that file.  The partitioners are used by\n", " when writing flow records to the `destinationDir`.\n\nIf \"--version\" is included on the command line, the application prints its\nversion number and exists.\n\nIf \"--one-shot\" is included on the command line, the `sourceDir` is only\nscanned one time.  Once all files in sourceDir have been packed, the\napplication exits.  When \"--one-shot\" is not provided, the application runs\nuntil it is signaled to end.\n\nThe Java property values that are used by this application are:\n\n", "compression -- The compression to use for files written to\nHDFS.  Values typically supported by Hadoop include `bzip2`, `gzip`,\n`lz4`, `lzo`, `lzop`, `snappy`, and `default`.  The empty string indicates\nno compression.  The default is `", "`.\n\n", "maxThreads -- The maximum number of threads that attempt to write to\noutput files simultaneously.  The default is ", ".\n\n", "pollingInterval -- How often the `sourceDir` is checked (polled) for\nIPFIX files to process.  The default is ", " seconds.\n\n", "maximumSize -- The (approximate) maximum size file to create, in\noctets.  The default is no maximum.  When a file's size exceeds this value,\nthe file is closed and a new file is started.  Typically a file's size will\nnot exceed this value by more than the maximum size of an IPFIX message, 64k.\nThis value may not be less than ", ".\n\n", "outputIdleSeconds -- The maximum number of seconds to allow an idle\noutput file to remain open so additional incoming records may appended to it.\nIt defaults to the value ", ".  This value may\nnot be less than ", ".\n\n", "fileCacheSize -- The maximum size of the open file cache.  This is\nthe maximum number of open files maintained by the file cache for writing to\noutput files.  Once the cache reaches this number of open files, the\napplication closes the least-recently-used file when it needs to open another.\nThis value does not include the file handles required when reading incoming\nfiles.  The default is ", "; the minimum permitted is\n", ".\n\n", "observationDomainId -- The observationDomainId to use in output\nfiles.  The default is ", ".\n\nWhen an output file has not been opened yet, it is not opened until the oldest\ninput file reaches a particular age, the number of input files reaches a\ncount, or the sum of the sizes of the input files reaches a value.  (Reaching\nany threshold allows the output file to be opened.)  The next three properties\ndescribe these values:\n\n", "maxInputAgeSeconds -- The age for an input file that causes its\ndestination output file to be opened.  Here, \"age\" refers to how long ago the\nfile was noticed, not the age of the file itself.  The default is\n", " seconds.\n\n", "minInputCount -- The number of queued input files that causes their\ndestination output file to be opened.  The default is\n", ".\n\n", "minInputSize -- The sum of the sizes of queued input files that\ncauses their destination output file to be opened, in octets.  The default is\n", ".\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP(), this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP(), this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP(), this.appProp(), this.DEFAULT_COMPRESSION(), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MAX_THREADS()), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_POLL_INTERVAL()), this.appProp(), BoxesRunTime.boxToLong((long)this.MINIMUM_MAXIMUM_SIZE()), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS()), BoxesRunTime.boxToInteger((int)this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM()), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_FILE_CACHE_SIZE()), BoxesRunTime.boxToInteger((int)this.MINIMUM_FILE_CACHE_SIZE()), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_OBSERVATION_DOMAIN_ID()), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MAXIMUM_AGE_SECONDS()), this.appProp(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MINIMUM_INPUT_COUNT()), this.appProp(), BoxesRunTime.boxToLong((long)this.DEFAULT_MINIMUM_INPUT_SIZE())})));
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
        System.exit(0);
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$timediff(long t1, long t0) {
        double arg$macro$40 = (double)(t1 - t0) / 1000.0;
        return new StringOps("%.03f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$40)}));
    }

    public void org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        int active = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.getActiveCount();
        long total = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.getTaskCount();
        long completed = this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.getCompletedTaskCount();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task Counts: Active: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)active)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Queued: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(total - completed - (long)active))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Completed: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)completed)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Total: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)total)}))).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output Files: Open: {}, Total: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount), BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String org$cert$netsa$mothra$tools$InvariantPackerMain$$APP() {
        return this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP;
    }

    private String appProp() {
        return this.appProp;
    }

    private int SHUTDOWN_PRIORITY() {
        return this.SHUTDOWN_PRIORITY;
    }

    public String DEFAULT_COMPRESSION() {
        return this.DEFAULT_COMPRESSION;
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public int DEFAULT_MAX_THREADS() {
        return this.DEFAULT_MAX_THREADS;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public long MINIMUM_MAXIMUM_SIZE() {
        return this.MINIMUM_MAXIMUM_SIZE;
    }

    public Option<Object> maximumSize() {
        return this.maximumSize;
    }

    public int DEFAULT_OUTPUT_FILE_IDLE_SECONDS() {
        return this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS;
    }

    public int OUTPUT_FILE_IDLE_SECONDS_MINIMUM() {
        return this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM;
    }

    public int outputIdleSeconds() {
        return this.outputIdleSeconds;
    }

    public int DEFAULT_MAXIMUM_AGE_SECONDS() {
        return this.DEFAULT_MAXIMUM_AGE_SECONDS;
    }

    public int maxInputAge() {
        return this.maxInputAge;
    }

    public int DEFAULT_MINIMUM_INPUT_COUNT() {
        return this.DEFAULT_MINIMUM_INPUT_COUNT;
    }

    public int minInputCount() {
        return this.minInputCount;
    }

    public long DEFAULT_MINIMUM_INPUT_SIZE() {
        return this.DEFAULT_MINIMUM_INPUT_SIZE;
    }

    public long minInputSize() {
        return this.minInputSize;
    }

    public int DEFAULT_FILE_CACHE_SIZE() {
        return this.DEFAULT_FILE_CACHE_SIZE;
    }

    public int MINIMUM_FILE_CACHE_SIZE() {
        return this.MINIMUM_FILE_CACHE_SIZE;
    }

    public int fileCacheSize() {
        return this.fileCacheSize;
    }

    public int DEFAULT_POLL_INTERVAL() {
        return this.DEFAULT_POLL_INTERVAL;
    }

    public int pollingInterval() {
        return this.pollingInterval;
    }

    public int DEFAULT_OBSERVATION_DOMAIN_ID() {
        return this.DEFAULT_OBSERVATION_DOMAIN_ID;
    }

    public int observationDomain() {
        return this.observationDomain;
    }

    public boolean oneshot() {
        return this.oneshot;
    }

    public void oneshot_$eq(boolean x$1) {
        this.oneshot = x$1;
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public Path incomingDir() {
        return this.incomingDir;
    }

    public Path destinationDir() {
        return this.destinationDir;
    }

    public Path packLogicPath() {
        return this.packLogicPath;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String ignored() {
        return this.ignored;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public final void delayedEndpoint$org$cert$netsa$mothra$tools$InvariantPackerMain$1() {
        Try try_;
        block76: {
            Tuple2 tuple2;
            block77: {
                Try try_2;
                block78: {
                    Try try_3;
                    block79: {
                        Object object;
                        block82: {
                            Tuple2 tuple22;
                            block81: {
                                block80: {
                                    BoxedUnit boxedUnit;
                                    BoxedUnit boxedUnit2;
                                    Tuple2 tuple23;
                                    None$ none$;
                                    block73: {
                                        Option option;
                                        block75: {
                                            BoxedUnit boxedUnit3;
                                            BoxedUnit boxedUnit4;
                                            BoxedUnit boxedUnit5;
                                            String compressName;
                                            block74: {
                                                block72: {
                                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP = "InvariantPacker";
                                                    this.appProp = "mothra.invariantpacker.";
                                                    this.SHUTDOWN_PRIORITY = 50;
                                                    this.DEFAULT_COMPRESSION = "";
                                                    String string = compressName = (String)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "compression"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).getOrElse((Function0)new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final String apply() {
                                                            return InvariantPackerMain$.MODULE$.DEFAULT_COMPRESSION();
                                                        }
                                                    });
                                                    String string2 = "";
                                                    if (string != null ? !string.equals(string2) : string2 != null) break block72;
                                                    none$ = None$.MODULE$;
                                                    break block73;
                                                }
                                                try_ = Try$.MODULE$.apply((Function0)new Serializable(compressName){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String compressName$1;

                                                    /*
                                                     * WARNING - void declaration
                                                     */
                                                    public final CompressionCodec apply() {
                                                        void var1_1;
                                                        CompressionCodec codec = InvariantPackerMain$.MODULE$.org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory.getCodecByName(this.compressName$1);
                                                        codec.createCompressor();
                                                        return var1_1;
                                                    }
                                                    {
                                                        this.compressName$1 = compressName$1;
                                                    }
                                                });
                                                if (!(try_ instanceof Success)) break block74;
                                                Success success = (Success)try_;
                                                CompressionCodec ok = (CompressionCodec)success.value();
                                                option = Option$.MODULE$.apply((Object)ok);
                                                break block75;
                                            }
                                            if (!(try_ instanceof Failure)) break block76;
                                            Failure failure = (Failure)try_;
                                            Throwable e = failure.exception();
                                            if (this.logger().underlying().isErrorEnabled()) {
                                                this.logger().underlying().error(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, e.toString()}))).toString());
                                                boxedUnit5 = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit5 = BoxedUnit.UNIT;
                                            }
                                            StringWriter sw = new StringWriter();
                                            e.printStackTrace(new PrintWriter(sw));
                                            if (this.logger().underlying().isInfoEnabled()) {
                                                this.logger().underlying().info(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, sw.toString()}))).toString());
                                                boxedUnit4 = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit4 = BoxedUnit.UNIT;
                                            }
                                            if (this.logger().underlying().isWarnEnabled()) {
                                                this.logger().underlying().warn("Using no compression for IPFIX files");
                                                boxedUnit3 = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit3 = BoxedUnit.UNIT;
                                            }
                                            option = None$.MODULE$;
                                        }
                                        none$ = option;
                                    }
                                    this.compressCodec = none$;
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$compressSuffix = (String)this.compressCodec().map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(CompressionCodec c) {
                                            return c.getDefaultExtension();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    this.DEFAULT_MAX_THREADS = 6;
                                    this.maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "maxThreads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$7) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_MAX_THREADS();
                                        }
                                    }));
                                    Predef$.MODULE$.require(this.maxThreads() >= 1);
                                    this.MINIMUM_MAXIMUM_SIZE = 524288L;
                                    this.maximumSize = package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "maximumSize"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(String x$8) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
                                        }
                                    });
                                    Predef$.MODULE$.require(this.maximumSize().isEmpty() || BoxesRunTime.unboxToLong((Object)this.maximumSize().get()) >= this.MINIMUM_MAXIMUM_SIZE());
                                    this.DEFAULT_OUTPUT_FILE_IDLE_SECONDS = 900;
                                    this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM = 60;
                                    this.outputIdleSeconds = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "outputIdleSeconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$9) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_OUTPUT_FILE_IDLE_SECONDS();
                                        }
                                    }));
                                    Predef$.MODULE$.require(this.outputIdleSeconds() >= this.OUTPUT_FILE_IDLE_SECONDS_MINIMUM());
                                    this.DEFAULT_MAXIMUM_AGE_SECONDS = 900;
                                    this.maxInputAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "maxInputAgeSeconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$10) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_MAXIMUM_AGE_SECONDS();
                                        }
                                    })) * 1000;
                                    this.DEFAULT_MINIMUM_INPUT_COUNT = 3;
                                    this.minInputCount = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "minInputCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$11) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_MINIMUM_INPUT_COUNT();
                                        }
                                    }));
                                    Predef$.MODULE$.require(this.minInputCount() > 0);
                                    this.DEFAULT_MINIMUM_INPUT_SIZE = 0x100000L;
                                    this.minInputSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "minInputSize"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(String x$12) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$12)).toLong();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply() {
                                            return this.apply$mcJ$sp();
                                        }

                                        public long apply$mcJ$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_MINIMUM_INPUT_SIZE();
                                        }
                                    }));
                                    Predef$.MODULE$.require(this.minInputSize() > 0L);
                                    this.DEFAULT_FILE_CACHE_SIZE = 2000;
                                    this.MINIMUM_FILE_CACHE_SIZE = 128;
                                    this.fileCacheSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "fileCacheSize"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$13) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$13)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_FILE_CACHE_SIZE();
                                        }
                                    }));
                                    Predef$.MODULE$.require(this.fileCacheSize() >= this.MINIMUM_FILE_CACHE_SIZE());
                                    Predef$.MODULE$.require(this.fileCacheSize() >= this.maxThreads());
                                    this.DEFAULT_POLL_INTERVAL = 15;
                                    this.pollingInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "pollingInterval"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$14) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$14)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_POLL_INTERVAL();
                                        }
                                    }));
                                    Predef$.MODULE$.require(this.pollingInterval() > 0);
                                    this.DEFAULT_OBSERVATION_DOMAIN_ID = 0;
                                    this.observationDomain = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "observationDomainId"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appProp()}))).map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(String x$15) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return InvariantPackerMain$.MODULE$.DEFAULT_OBSERVATION_DOMAIN_ID();
                                        }
                                    }));
                                    this.oneshot = false;
                                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ARgs is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args()})));
                                    tuple2 = Predef$.MODULE$.refArrayOps((Object[])this.args()).partition((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$16) {
                                            String string = x$16.substring(0, 2);
                                            String string2 = "--";
                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                        }
                                    });
                                    if (tuple2 == null) break block77;
                                    String[] switches = (String[])tuple2._1();
                                    String[] positionalArgs = (String[])tuple2._2();
                                    this.x$17 = tuple23 = new Tuple2((Object)switches, (Object)positionalArgs);
                                    this.switches = (String[])this.x$17._1();
                                    this.positionalArgs = (String[])this.x$17._2();
                                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Switches is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.switches()})));
                                    Predef$.MODULE$.refArrayOps((Object[])this.switches()).collect((PartialFunction)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                            Object object;
                                            A1 A1 = x1;
                                            boolean bl = "-V".equals(A1) ? true : "--version".equals(A1);
                                            if (bl) {
                                                InvariantPackerMain$.MODULE$.version();
                                                object = BoxedUnit.UNIT;
                                            } else {
                                                boolean bl2 = "-h".equals(A1) ? true : "--help".equals(A1);
                                                if (bl2) {
                                                    InvariantPackerMain$.MODULE$.usage(true);
                                                    object = BoxedUnit.UNIT;
                                                } else {
                                                    boolean bl3 = "--one-shot".equals(A1) ? true : "--oneshot".equals(A1);
                                                    if (bl3) {
                                                        InvariantPackerMain$.MODULE$.oneshot_$eq(true);
                                                        object = BoxedUnit.UNIT;
                                                    } else if (A1 != null) {
                                                        A1 A12 = A1;
                                                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown argument '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A12})));
                                                        InvariantPackerMain$.MODULE$.usage(InvariantPackerMain$.MODULE$.usage$default$1());
                                                        object = BoxedUnit.UNIT;
                                                    } else {
                                                        object = function1.apply(x1);
                                                    }
                                                }
                                            }
                                            return (B1)object;
                                        }

                                        public final boolean isDefinedAt(String x1) {
                                            boolean bl;
                                            String string = x1;
                                            boolean bl2 = "-V".equals(string) ? true : "--version".equals(string);
                                            if (bl2) {
                                                bl = true;
                                            } else {
                                                boolean bl3 = "-h".equals(string) ? true : "--help".equals(string);
                                                if (bl3) {
                                                    bl = true;
                                                } else {
                                                    boolean bl4 = "--one-shot".equals(string) ? true : "--oneshot".equals(string);
                                                    bl = bl4 ? true : string != null;
                                                }
                                            }
                                            return bl;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                                    if (this.positionalArgs().length != 3) {
                                        BoxedUnit boxedUnit6;
                                        String errmsg = this.positionalArgs().length == 1 ? "Called with 1 argument" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Called with ", " arguments"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.positionalArgs().length)}));
                                        errmsg = new StringBuilder().append((Object)errmsg).append((Object)"; exactly 3 required (incomingDir destinationDir partitionerFile)").toString();
                                        if (this.logger().underlying().isErrorEnabled()) {
                                            this.logger().underlying().error(errmsg);
                                            boxedUnit6 = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit6 = BoxedUnit.UNIT;
                                        }
                                        Predef$.MODULE$.println((Object)errmsg);
                                        this.usage(this.usage$default$1());
                                    }
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info(new StringBuilder().append((Object)"\n=============================").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " is starting =============================\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()}))).toString());
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("This is {} {}", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP(), Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    this.incomingDir = new Path(this.positionalArgs()[0]);
                                    this.destinationDir = new Path(this.positionalArgs()[1]);
                                    this.packLogicPath = new Path(this.positionalArgs()[2]);
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFilesMutex = new Object();
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles = Predef$.MODULE$.Map().empty();
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoLRU = PackerDeque$.MODULE$.empty();
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileCount = 0;
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$openFileCount = 0;
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFileMaxSize = BoxesRunTime.unboxToLong((Object)this.maximumSize().getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply() {
                                            return this.apply$mcJ$sp();
                                        }

                                        public long apply$mcJ$sp() {
                                            return Long.MAX_VALUE;
                                        }
                                    })) - 65535L;
                                    this.taskCountInterval = 3;
                                    this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
                                    this.hadoopConf = new Configuration();
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$codecFactory = new CompressionCodecFactory(this.hadoopConf());
                                    FSDataInputStream stream = this.packLogicPath().getFileSystem(this.hadoopConf()).open(this.packLogicPath());
                                    try_2 = Try$.MODULE$.apply((Function0)new Serializable(stream){
                                        public static final long serialVersionUID = 0L;
                                        private final FSDataInputStream stream$1;

                                        public final RunTimeCodeLoader apply() {
                                            return new RunTimeCodeLoader((InputStream)this.stream$1);
                                        }
                                        {
                                            this.stream$1 = stream$1;
                                        }
                                    });
                                    if (!(try_2 instanceof Success)) break block78;
                                    Success success = (Success)try_2;
                                    RunTimeCodeLoader x = (RunTimeCodeLoader)success.value();
                                    RunTimeCodeLoader runTimeCodeLoader = x;
                                    RunTimeCodeLoader loader = runTimeCodeLoader;
                                    try_3 = Try$.MODULE$.apply((Function0)new Serializable(loader){
                                        public static final long serialVersionUID = 0L;
                                        private final RunTimeCodeLoader loader$1;

                                        public final Object apply() {
                                            return this.loader$1.load();
                                        }
                                        {
                                            this.loader$1 = loader$1;
                                        }
                                    });
                                    if (!(try_3 instanceof Success)) break block79;
                                    Success success2 = (Success)try_3;
                                    Object x2 = success2.value();
                                    Object object2 = x2;
                                    Object result = object2;
                                    object = result;
                                    if (!(object instanceof PartitionerPackLogic)) break block80;
                                    PartitionerPackLogic partitionerPackLogic = (PartitionerPackLogic)object;
                                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionerPackLogic.version()), partitionerPackLogic.partitioners());
                                    break block81;
                                }
                                if (!(object instanceof PartitionerConfigurator)) break block82;
                                PartitionerConfigurator partitionerConfigurator = (PartitionerConfigurator)object;
                                PartitionerPackLogic ppl = new PartitionerPackLogic(partitionerConfigurator.partitioners());
                                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ppl.version()), ppl.partitioners());
                            }
                            Tuple2 tuple24 = tuple22;
                            if (tuple24 != null) {
                                BoxedUnit boxedUnit;
                                BoxedUnit boxedUnit7;
                                BoxedUnit boxedUnit8;
                                BoxedUnit boxedUnit9;
                                BoxedUnit boxedUnit10;
                                BoxedUnit boxedUnit11;
                                BoxedUnit boxedUnit12;
                                BoxedUnit boxedUnit13;
                                BoxedUnit boxedUnit14;
                                BoxedUnit boxedUnit15;
                                BoxedUnit boxedUnit16;
                                String string;
                                BoxedUnit boxedUnit17;
                                BoxedUnit boxedUnit18;
                                BoxedUnit boxedUnit19;
                                BoxedUnit boxedUnit20;
                                BoxedUnit boxedUnit21;
                                BoxedUnit boxedUnit22;
                                Tuple2 tuple25;
                                int packVersion = tuple24._1$mcI$sp();
                                Seq partitioners = (Seq)tuple24._2();
                                this.x$18 = tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)packVersion), (Object)partitioners);
                                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$packVersion = this.x$18._1$mcI$sp();
                                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$partitioners = (Seq)this.x$18._2();
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{} Settings::", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()});
                                    boxedUnit22 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit22 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Incoming directory: {}", new Object[]{this.incomingDir()});
                                    boxedUnit21 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit21 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Destination directory: {}", new Object[]{this.destinationDir()});
                                    boxedUnit20 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit20 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Partitioner logic file: {}", new Object[]{this.packLogicPath()});
                                    boxedUnit19 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit19 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Output compression: {}", new Object[]{this.compressCodec().getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "none";
                                        }
                                    })});
                                    boxedUnit18 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit18 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Maximum simultaneous writing tasks: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxThreads())});
                                    boxedUnit17 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit17 = BoxedUnit.UNIT;
                                }
                                if (this.oneshot()) {
                                    BoxedUnit boxedUnit23;
                                    BoxedUnit boxedUnit24;
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Will shut down after a single scan of the incoming directory");
                                        boxedUnit24 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit24 = BoxedUnit.UNIT;
                                    }
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Ignoring the following settings:");
                                        boxedUnit23 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit23 = BoxedUnit.UNIT;
                                    }
                                    string = "- ";
                                } else {
                                    string = this.ignored = "";
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{}Polling interval of the incoming directory: {}", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.pollingInterval())});
                                    boxedUnit16 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit16 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{}Open an output file when it has an input file noticed this long ago: {} seconds", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)(this.maxInputAge() / 1000))});
                                    boxedUnit15 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit15 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{}Open an output file when it has this number of input files: {}", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.minInputCount())});
                                    boxedUnit14 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit14 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{}Open an output file when the sum of the sizes of the input files exceeds this value: {} octets", new Object[]{this.ignored(), BoxesRunTime.boxToLong((long)this.minInputSize())});
                                    boxedUnit13 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit13 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{}Maximum time an output file may remain idle before being closed: {} seconds", new Object[]{this.ignored(), BoxesRunTime.boxToInteger((int)this.outputIdleSeconds())});
                                    boxedUnit12 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit12 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info(new StringBuilder().append((Object)"Approximate maximum size of output files: ").append(this.maximumSize().map((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(long x$19) {
                                            return ((Object)BoxesRunTime.boxToLong((long)x$19)).toString();
                                        }
                                    }).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "unlimited";
                                        }
                                    })).toString());
                                    boxedUnit11 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit11 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Maximum number of open output files: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.fileCacheSize())});
                                    boxedUnit10 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit10 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Observation domain for output files: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.observationDomain())});
                                    boxedUnit9 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit9 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("JVM Parameters: {}", new Object[]{Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(",")});
                                    boxedUnit8 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit8 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("{} threads are starting::", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()});
                                    boxedUnit7 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit7 = BoxedUnit.UNIT;
                                }
                                ShutdownHookManager.get().addShutdownHook((Runnable)new InvariantPackerMain.Cleanup(), this.SHUTDOWN_PRIORITY());
                                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new PackerThreadFactory("ActiveWriter-"));
                                this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher = new InvariantPackerMain.MyDirWatcher(this.incomingDir());
                                boolean bl = this.running = !this.oneshot();
                                if (this.oneshot()) {
                                    BoxedUnit boxedUnit25;
                                    BoxedUnit boxedUnit26;
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher.runOnce();
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher.shutdown();
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$repoFiles.values().foreach((Function1)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(InvariantPackerMain.RepositoryPath rp) {
                                            InvariantPackerMain$.MODULE$.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.execute(rp);
                                        }
                                    });
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug("Running with one-shot enabled; waiting for threads to end...");
                                        boxedUnit26 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit26 = BoxedUnit.UNIT;
                                    }
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.shutdown();
                                    do {
                                        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts();
                                    } while (!this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.awaitTermination(1L, TimeUnit.SECONDS));
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug("All tasks have completed");
                                        boxedUnit25 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit25 = BoxedUnit.UNIT;
                                    }
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("{} is done", new Object[]{this.org$cert$netsa$mothra$tools$InvariantPackerMain$$APP()});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    BoxedUnit boxedUnit27;
                                    BoxedUnit boxedUnit28;
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug("Starting the incoming directory poller");
                                        boxedUnit28 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit28 = BoxedUnit.UNIT;
                                    }
                                    this.org$cert$netsa$mothra$tools$InvariantPackerMain$$watcher.runPeriodically(this.pollingInterval());
                                    PackerThreadFactory checkFactory = new PackerThreadFactory("OutputFileCheck-");
                                    ScheduledThreadPoolExecutor checkTaskPool = new ScheduledThreadPoolExecutor(1, checkFactory);
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug("Starting the output file checker");
                                        boxedUnit27 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit27 = BoxedUnit.UNIT;
                                    }
                                    checkTaskPool.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                                    checkTaskPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                                    checkTaskPool.setRemoveOnCancelPolicy(true);
                                    checkTaskPool.scheduleWithFixedDelay(new InvariantPackerMain.CheckRepositoryPaths(), this.pollingInterval() / 2, this.pollingInterval(), TimeUnit.SECONDS);
                                    do {
                                        this.org$cert$netsa$mothra$tools$InvariantPackerMain$$printTaskCounts();
                                    } while (this.running() && !this.org$cert$netsa$mothra$tools$InvariantPackerMain$$writerPool.awaitTermination(this.taskCountInterval, TimeUnit.SECONDS));
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new MatchError((Object)tuple24);
                        }
                        if (object instanceof PackingLogic) {
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionerFile must contain partitions, not other PackingLogic"})).s((Seq)Nil$.MODULE$));
                        }
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected type returned from compiled code: result.getClass"})).s((Seq)Nil$.MODULE$));
                    }
                    if (try_3 instanceof Failure) {
                        Failure failure = (Failure)try_3;
                        Throwable e = failure.exception();
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load run-time packing logic from '", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.packLogicPath(), e})));
                    }
                    throw new MatchError((Object)try_3);
                }
                if (try_2 instanceof Failure) {
                    Failure failure = (Failure)try_2;
                    Throwable e = failure.exception();
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to compile run-time packing logic in '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.packLogicPath(), e})));
                }
                throw new MatchError((Object)try_2);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)try_);
    }

    private InvariantPackerMain$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        StrictLogging.class.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new InvariantPackerMain.delayedInit.body(this));
    }
}

