/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ShutdownHookManager;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.mothra.packer.CorePacker;
import org.cert.netsa.mothra.packer.CorePacker$;
import org.cert.netsa.mothra.packer.DirMapping;
import org.cert.netsa.mothra.packer.PackFileJob;
import org.cert.netsa.mothra.packer.PackerConfig;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.PackingLogic;
import org.cert.netsa.mothra.packer.PartitionerConfigurator;
import org.cert.netsa.mothra.packer.PartitionerPackLogic;
import org.cert.netsa.mothra.packer.RunTimeCodeLoader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.PackerMain;
import org.slf4j.Logger;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class PackerMain$
implements App,
StrictLogging {
    public static final PackerMain$ MODULE$;
    private final int SHUTDOWN_PRIORITY;
    private final int DEFAULT_MAX_PACK_JOBS;
    private final int DEFAULT_PACK_ATTEMPTS;
    private final int DEFAULT_POLL_INTERVAL;
    private final int DEFAULT_WORKDIR_CHECK_INTERVAL;
    private final int DEFAULT_WORKDIR_MAXIMUM_AGE;
    private final int DEFAULT_WORKDIR_MAXIMUM_SIZE;
    private final int DEFAULT_WORKDIR_MINIMUM_AGE;
    private final int DEFAULT_WORKDIR_MINIMUM_SIZE;
    private final /* synthetic */ Tuple2 x$2;
    private final String[] switches;
    private final String[] positionalArgs;
    private boolean oneShot;
    private final int reqArgs;
    private final Path incomingDir;
    private final Path rootDir;
    private final java.nio.file.Path workDir;
    private final Path packLogicPath;
    private volatile boolean org$cert$netsa$mothra$tools$PackerMain$$running;
    private final Configuration conf;
    private final InfoModel infoModel;
    private final Option<Path> archiveDir;
    private final Option<CompressionCodec> compressCodec;
    private final int hoursPerFile;
    private final int maxPackJobs;
    private final int packAttempts;
    private final int pollingInterval;
    private final int workdirCheckInterval;
    private final long workdirMinimumSize;
    private final long workdirMaximumSize;
    private final int workdirMinimumAge;
    private final int workdirMaximumAge;
    private final int fileCacheSize;
    private final int numMoveThreads;
    private final PackerConfig packConf;
    private final PackingLogic packLogic;
    private final CorePacker packer;
    private final DirMapping watcher;
    public final ThreadPoolExecutor org$cert$netsa$mothra$tools$PackerMain$$packerPool;
    public Queue<PackFileJob> org$cert$netsa$mothra$tools$PackerMain$$tasks;
    private final ScheduledFuture<?> checkWorkdirResult;
    private final int logTaskCountInterval;
    private final ScheduledFuture<?> logTaskCountThread;
    private final com.typesafe.scalalogging.Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new PackerMain$();
    }

    public com.typesafe.scalalogging.Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(com.typesafe.scalalogging.Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.PackerMain mothra-tools.jar [--one-shot] <srcDir> <destDir> <workDir> <partitioner>\n\nwhere:\n\nsrcDir:       Source (incoming) directory as Hadoop URI\ndestDir:      Destination directory as Hadoop URI\nworkDir:      Working directory on the local disk (not file://)\npartitioner:  Partitioning file as Hadoop URIs\n"})).s((Seq)Nil$.MODULE$));
        if (full) {
            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nPacker scans the source directory (`srcDir`) for IPFIX files.  It splits\nthe IPFIX records in each file into output file(s) in a time-based\ndirectory structure based on the partitioning rules in the partitioning\nfile (`partitioner`).  The output files are initially created in the\nworking directory (`workDir`), and when they meet size and/or age\nthresholds, they are moved to the destination directory (`destDir`).\n\nIf \"--one-shot\" is included on the command line, the `srcDir` is only\nscanned one time.  Once all files in `srcDir` have been packed (or they\nfail to be packed after some number of attempts), the packer exits.\n\nThe Java property values that are used by the packer are:\n\n`mothra.packer.compression` -- The compression to use for files written to\nHDFS.  Values typically supported by Hadoop include `bzip2`, `gzip`,\n`lz4`, `lzo`, `lzop`, `snappy`, and `default`.  The empty string indicates\nno compression.  The default is `", "`.\n\nmothra.packer.maxPackJobs -- The size of the thread pool that determines the\nmaximum number of input files that may be processed simultaneously.  A larger\nvalue provides more throughput.  The default is ", ".\n\nmothra.packer.hoursPerFile -- The number of hours covered by each file in the\nrepository.  The valid range is 1 (a file for each hour) to 24 (one file per\nday).  The default is ", ".\n\nmothra.packer.pollingInterval -- How long the main thread sleeps (in seconds)\nbetween scans (polls) of the source directory checking for IPFIX files to\nprocess.  The default is ", ".\n\nmothra.packer.workDir.checkInterval -- The value for how often, in seconds, to\ncheck the sizes and ages of the files in the working directory.  The default\nis ", ".\nWhen the checkInterval is reached, the sizes and ages of the files in\nthe working directory are checked.  Files that meet ONE of the following\ncriteria are closed and moved into the data repository.  The criteria are:\n\n* Files that were created more than `maximumAge` seconds ago.  Since files are\nonly checked at this interval, a file could potentially be one interval older\nthan the `maximumAge`.\n\n* Files whose size exceeds `maximumSize`.  Since a file's size is not\ncontinuously monitored, a file could be larger than this size, and the user\nshould set this value appropriately.\n\n* Files whose size is at least `minimumsSize` AND that were created at least\n`minimumAge` seconds ago.\n\nmothra.packer.workDir.maximumAge -- Files in the working directory that were\ncreated over this number of seconds ago are always moved into the repository,\nregardless of their size.  The default value is ", " seconds.\n\nmothra.packer.workDir.maximumSize -- Files in the working directory whose\nsize, in octets, is greater than this value are always moved into the\nrepository, regardless of their age.  The default value is\n", " octets.\n\nmothra.packer.workDir.minimumAge -- Files in the working directory are only\nmoved into the repository once they reach this age (were created over this\nnumber of seconds ago) unless their size exceeds maximumSize.  The default is\n", " seconds.\n\nmothra.packer.workDir.minimumSize -- Files in the working directory are only\nmoved into the repository once they reach this size (in octets) unless their\nage exceeds maximumAge.  The default is ", " octets.\n\n`mothra.packer.numMoveThreads` -- The size of the thread pool that closes\nthe work files and moves them to the destination directory.  A task is\npotentially created every `workdirCheckInterval` seconds if files are\ndetermined to have met the limits.  The default is ", ".\n\nmothra.packer.archiveDirectory -- The root directory into which working files\nare moved after the packer copies their content to the repository, as a Hadoop\nURI.  If not specified, the working files are deleted.\n\nmothra.packer.packAttempts -- The number of times the packer attempts to\nprocess a file found in the srcDir.  After this number of failed attempts,\nthe file is ignored by this invocation of the packer.  The default is ", ".\n\nmothra.packer.fileCacheSize -- The maximum size of the open file cache.\nThis is the maximum number of open files maintained by the file cache for\nwriting to files in the work directory.  The packer does not limit the\nnumber of files in the work directory; this only limits the number of open\nfiles.  Once the cache reaches this number of open files and the packer\nneeds to (re-)open a file, the packer closes the least-recently-used file.\nThis value does not include the file handles required when reading\nincoming files or when copying files from the work directory to the data\ndirectory.  The default is ", "; the minimum\npermitted is ", ".\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CorePacker$.MODULE$.DEFAULT_COMPRESSION(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MAX_PACK_JOBS()), BoxesRunTime.boxToInteger((int)CorePacker$.MODULE$.DEFAULT_HOURS_PER_FILE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_POLL_INTERVAL()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WORKDIR_CHECK_INTERVAL()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WORKDIR_MAXIMUM_AGE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WORKDIR_MAXIMUM_SIZE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WORKDIR_MINIMUM_AGE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WORKDIR_MINIMUM_SIZE()), BoxesRunTime.boxToInteger((int)CorePacker$.MODULE$.DEFAULT_NUM_MOVE_THREADS()), BoxesRunTime.boxToInteger((int)this.DEFAULT_PACK_ATTEMPTS()), BoxesRunTime.boxToInteger((int)CorePacker$.MODULE$.DEFAULT_FILE_CACHE_SIZE()), BoxesRunTime.boxToInteger((int)CorePacker$.MODULE$.MINIMUM_FILE_CACHE_SIZE())})));
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1()));
        System.exit(0);
    }

    private int SHUTDOWN_PRIORITY() {
        return this.SHUTDOWN_PRIORITY;
    }

    public int DEFAULT_MAX_PACK_JOBS() {
        return this.DEFAULT_MAX_PACK_JOBS;
    }

    public int DEFAULT_PACK_ATTEMPTS() {
        return this.DEFAULT_PACK_ATTEMPTS;
    }

    public int DEFAULT_POLL_INTERVAL() {
        return this.DEFAULT_POLL_INTERVAL;
    }

    public int DEFAULT_WORKDIR_CHECK_INTERVAL() {
        return this.DEFAULT_WORKDIR_CHECK_INTERVAL;
    }

    public int DEFAULT_WORKDIR_MAXIMUM_AGE() {
        return this.DEFAULT_WORKDIR_MAXIMUM_AGE;
    }

    public int DEFAULT_WORKDIR_MAXIMUM_SIZE() {
        return this.DEFAULT_WORKDIR_MAXIMUM_SIZE;
    }

    public int DEFAULT_WORKDIR_MINIMUM_AGE() {
        return this.DEFAULT_WORKDIR_MINIMUM_AGE;
    }

    public int DEFAULT_WORKDIR_MINIMUM_SIZE() {
        return this.DEFAULT_WORKDIR_MINIMUM_SIZE;
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public boolean oneShot() {
        return this.oneShot;
    }

    public void oneShot_$eq(boolean x$1) {
        this.oneShot = x$1;
    }

    public int reqArgs() {
        return this.reqArgs;
    }

    public Path incomingDir() {
        return this.incomingDir;
    }

    public Path rootDir() {
        return this.rootDir;
    }

    public java.nio.file.Path workDir() {
        return this.workDir;
    }

    public Path packLogicPath() {
        return this.packLogicPath;
    }

    public boolean org$cert$netsa$mothra$tools$PackerMain$$running() {
        return this.org$cert$netsa$mothra$tools$PackerMain$$running;
    }

    public void org$cert$netsa$mothra$tools$PackerMain$$running_$eq(boolean x$1) {
        this.org$cert$netsa$mothra$tools$PackerMain$$running = x$1;
    }

    public Configuration conf() {
        return this.conf;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Option<Path> archiveDir() {
        return this.archiveDir;
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public int hoursPerFile() {
        return this.hoursPerFile;
    }

    public int maxPackJobs() {
        return this.maxPackJobs;
    }

    public int packAttempts() {
        return this.packAttempts;
    }

    public int pollingInterval() {
        return this.pollingInterval;
    }

    public int workdirCheckInterval() {
        return this.workdirCheckInterval;
    }

    public long workdirMinimumSize() {
        return this.workdirMinimumSize;
    }

    public long workdirMaximumSize() {
        return this.workdirMaximumSize;
    }

    public int workdirMinimumAge() {
        return this.workdirMinimumAge;
    }

    public int workdirMaximumAge() {
        return this.workdirMaximumAge;
    }

    public int fileCacheSize() {
        return this.fileCacheSize;
    }

    public int numMoveThreads() {
        return this.numMoveThreads;
    }

    public PackerConfig packConf() {
        return this.packConf;
    }

    public CorePacker packer() {
        return this.packer;
    }

    public DirMapping watcher() {
        return this.watcher;
    }

    public void org$cert$netsa$mothra$tools$PackerMain$$logPackerTaskCount() {
        BoxedUnit boxedUnit;
        int active = this.org$cert$netsa$mothra$tools$PackerMain$$packerPool.getActiveCount();
        long completed = this.org$cert$netsa$mothra$tools$PackerMain$$packerPool.getCompletedTaskCount();
        long total = this.org$cert$netsa$mothra$tools$PackerMain$$packerPool.getTaskCount();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Packing task count: Completed: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)completed)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Active: ", ", Queued: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)active), BoxesRunTime.boxToLong((long)(total - completed - (long)active))}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public int logTaskCountInterval() {
        return this.logTaskCountInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void delayedEndpoint$org$cert$netsa$mothra$tools$PackerMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        PackingLogic packingLogic;
        Object result;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        BoxedUnit boxedUnit14;
        BoxedUnit boxedUnit15;
        None$ none$;
        String compressName;
        BoxedUnit boxedUnit16;
        BoxedUnit boxedUnit17;
        Tuple2 tuple2;
        this.SHUTDOWN_PRIORITY = 50;
        this.DEFAULT_MAX_PACK_JOBS = 1;
        this.DEFAULT_PACK_ATTEMPTS = 3;
        this.DEFAULT_POLL_INTERVAL = 30;
        this.DEFAULT_WORKDIR_CHECK_INTERVAL = 60;
        this.DEFAULT_WORKDIR_MAXIMUM_AGE = 1800;
        this.DEFAULT_WORKDIR_MAXIMUM_SIZE = 0x6400000;
        this.DEFAULT_WORKDIR_MINIMUM_AGE = 300;
        this.DEFAULT_WORKDIR_MINIMUM_SIZE = 0x4000000;
        Tuple2 tuple22 = Predef$.MODULE$.refArrayOps((Object[])this.args()).partition((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1.substring(0, 2);
                String string2 = "--";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        String[] switches = (String[])tuple22._1();
        String[] positionalArgs = (String[])tuple22._2();
        this.x$2 = tuple2 = new Tuple2((Object)switches, (Object)positionalArgs);
        this.switches = (String[])this.x$2._1();
        this.positionalArgs = (String[])this.x$2._2();
        this.oneShot = false;
        Predef$.MODULE$.refArrayOps((Object[])this.switches()).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                boolean bl = "-V".equals(A1) ? true : "--version".equals(A1);
                if (bl) {
                    PackerMain$.MODULE$.version();
                    object = BoxedUnit.UNIT;
                } else {
                    boolean bl2 = "-h".equals(A1) ? true : "--help".equals(A1);
                    if (bl2) {
                        PackerMain$.MODULE$.usage(true);
                        object = BoxedUnit.UNIT;
                    } else {
                        boolean bl3 = "--one-shot".equals(A1) ? true : "--oneshot".equals(A1);
                        if (bl3) {
                            PackerMain$.MODULE$.oneShot_$eq(true);
                            object = BoxedUnit.UNIT;
                        } else if (A1 != null) {
                            A1 A12 = A1;
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown argument '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A12})));
                            PackerMain$.MODULE$.usage(PackerMain$.MODULE$.usage$default$1());
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                boolean bl;
                String string = x1;
                boolean bl2 = "-V".equals(string) ? true : "--version".equals(string);
                if (bl2) {
                    bl = true;
                } else {
                    boolean bl3 = "-h".equals(string) ? true : "--help".equals(string);
                    if (bl3) {
                        bl = true;
                    } else {
                        boolean bl4 = "--one-shot".equals(string) ? true : "--oneshot".equals(string);
                        bl = bl4 ? true : string != null;
                    }
                }
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n============================= Packer is starting =============================\n");
            boxedUnit17 = BoxedUnit.UNIT;
        } else {
            boxedUnit17 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is packer {}", new Object[]{Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
            boxedUnit16 = BoxedUnit.UNIT;
        } else {
            boxedUnit16 = BoxedUnit.UNIT;
        }
        this.reqArgs = 4;
        if (this.positionalArgs().length != this.reqArgs()) {
            BoxedUnit boxedUnit18;
            BoxedUnit boxedUnit19;
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Called with ", " args;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.positionalArgs().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" exactly ", " required"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.reqArgs())}))).toString());
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Called with {} args; exactly {} required", new Object[]{BoxesRunTime.boxToInteger((int)this.positionalArgs().length), BoxesRunTime.boxToInteger((int)this.reqArgs())});
                boxedUnit19 = BoxedUnit.UNIT;
            } else {
                boxedUnit19 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Args were {}", new Object[]{this.positionalArgs()});
                boxedUnit18 = BoxedUnit.UNIT;
            } else {
                boxedUnit18 = BoxedUnit.UNIT;
            }
            this.usage(this.usage$default$1());
        }
        this.incomingDir = new Path(this.positionalArgs()[0]);
        this.rootDir = new Path(this.positionalArgs()[1]);
        this.workDir = Paths.get(this.positionalArgs()[2], new String[0]);
        this.packLogicPath = new Path(this.positionalArgs()[3]);
        this.org$cert$netsa$mothra$tools$PackerMain$$running = true;
        this.conf = new Configuration();
        this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        this.archiveDir = package$.MODULE$.props().get("mothra.packer.archiveDirectory").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x) {
                return new Path(x);
            }
        });
        String string = compressName = (String)package$.MODULE$.props().get("mothra.packer.compression").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return CorePacker$.MODULE$.DEFAULT_COMPRESSION();
            }
        });
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
        } else {
            Option option;
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(compressName){
                public static final long serialVersionUID = 0L;
                private final String compressName$1;

                /*
                 * WARNING - void declaration
                 */
                public final CompressionCodec apply() {
                    void var2_2;
                    CompressionCodecFactory factory = new CompressionCodecFactory(PackerMain$.MODULE$.conf());
                    CompressionCodec codec = factory.getCodecByName(this.compressName$1);
                    codec.createCompressor();
                    return var2_2;
                }
                {
                    this.compressName$1 = compressName$1;
                }
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                option = Option$.MODULE$.apply((Object)ok);
            } else {
                BoxedUnit boxedUnit20;
                BoxedUnit boxedUnit21;
                BoxedUnit boxedUnit22;
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, e.toString()}))).toString());
                    boxedUnit22 = BoxedUnit.UNIT;
                } else {
                    boxedUnit22 = BoxedUnit.UNIT;
                }
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, sw.toString()}))).toString());
                    boxedUnit21 = BoxedUnit.UNIT;
                } else {
                    boxedUnit21 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit20 = BoxedUnit.UNIT;
                } else {
                    boxedUnit20 = BoxedUnit.UNIT;
                }
                option = None$.MODULE$;
            }
            none$ = option;
        }
        this.compressCodec = none$;
        this.hoursPerFile = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.hoursPerFile").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return CorePacker$.MODULE$.DEFAULT_HOURS_PER_FILE();
            }
        }));
        Predef$.MODULE$.require(this.hoursPerFile() >= 1 && this.hoursPerFile() <= 24);
        this.maxPackJobs = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.maxPackJobs").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return PackerMain$.MODULE$.DEFAULT_MAX_PACK_JOBS();
            }
        }));
        Predef$.MODULE$.require(this.maxPackJobs() >= 1);
        this.packAttempts = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.packAttempts").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return PackerMain$.MODULE$.DEFAULT_PACK_ATTEMPTS();
            }
        }));
        Predef$.MODULE$.require(this.packAttempts() >= 1);
        this.pollingInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.pollingInterval").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return PackerMain$.MODULE$.DEFAULT_POLL_INTERVAL();
            }
        }));
        Predef$.MODULE$.require(this.pollingInterval() >= 1);
        this.workdirCheckInterval = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.workDir.checkInterval").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return PackerMain$.MODULE$.DEFAULT_WORKDIR_CHECK_INTERVAL();
            }
        }));
        Predef$.MODULE$.require(this.workdirCheckInterval() >= 1);
        this.workdirMinimumSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get("mothra.packer.workDir.minimumSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return PackerMain$.MODULE$.DEFAULT_WORKDIR_MINIMUM_SIZE();
            }
        }));
        Predef$.MODULE$.require(this.workdirMinimumSize() >= 1L);
        this.workdirMaximumSize = BoxesRunTime.unboxToLong((Object)package$.MODULE$.props().get("mothra.packer.workDir.maximumSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$9) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return PackerMain$.MODULE$.DEFAULT_WORKDIR_MAXIMUM_SIZE();
            }
        }));
        Predef$.MODULE$.require(this.workdirMaximumSize() >= 1L);
        this.workdirMinimumAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.workDir.minimumAge").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return PackerMain$.MODULE$.DEFAULT_WORKDIR_MINIMUM_AGE();
            }
        }));
        Predef$.MODULE$.require(this.workdirMinimumAge() >= 1);
        this.workdirMaximumAge = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.workDir.maximumAge").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$11) {
                return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return PackerMain$.MODULE$.DEFAULT_WORKDIR_MAXIMUM_AGE();
            }
        }));
        Predef$.MODULE$.require(this.workdirMaximumAge() >= 1);
        this.fileCacheSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.fileCacheSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$12) {
                return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return CorePacker$.MODULE$.DEFAULT_FILE_CACHE_SIZE();
            }
        }));
        Predef$.MODULE$.require(this.fileCacheSize() >= CorePacker$.MODULE$.MINIMUM_FILE_CACHE_SIZE());
        this.numMoveThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.packer.numMoveThreads").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$13) {
                return new StringOps(Predef$.MODULE$.augmentString(x$13)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return CorePacker$.MODULE$.DEFAULT_NUM_MOVE_THREADS();
            }
        }));
        Predef$.MODULE$.require(this.numMoveThreads() >= 1);
        this.packConf = new PackerConfig(this.rootDir(), this.workDir(), this.archiveDir(), this.compressCodec(), this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Packer settings::");
            boxedUnit15 = BoxedUnit.UNIT;
        } else {
            boxedUnit15 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output compression: {}", new Object[]{this.compressCodec().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "none";
                }
            })});
            boxedUnit14 = BoxedUnit.UNIT;
        } else {
            boxedUnit14 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Hours covered by each file: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hoursPerFile())});
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum simultaneous pack jobs: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxPackJobs())});
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.oneShot()) {
            BoxedUnit boxedUnit23;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Will shut down after a single scan of the incoming directory");
                boxedUnit23 = BoxedUnit.UNIT;
            } else {
                boxedUnit23 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Ignoring polling interval value ({})", new Object[]{BoxesRunTime.boxToInteger((int)this.pollingInterval())});
                boxedUnit11 = BoxedUnit.UNIT;
            } else {
                boxedUnit11 = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Polling interval of the incoming directory: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.pollingInterval())});
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Interval for checking size & age of working files: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.workdirCheckInterval())});
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Approximate size range for closing working files: {} to {}", new Object[]{BoxesRunTime.boxToLong((long)this.workdirMinimumSize()), BoxesRunTime.boxToLong((long)this.workdirMaximumSize())});
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Approximate age range for closing working files: {} to {}", new Object[]{BoxesRunTime.boxToInteger((int)this.workdirMinimumAge()), BoxesRunTime.boxToInteger((int)this.workdirMaximumAge())});
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of attempts to process a file: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.packAttempts())});
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of open files in the workDir: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.fileCacheSize())});
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of threads that move files from workDir to destDir: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.numMoveThreads())});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String string3;
            Logger logger = this.logger().underlying();
            Option<Path> option = this.archiveDir();
            if (option instanceof Some) {
                Some some = (Some)option;
                Path dir = (Path)some.x();
                string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archive location for expired working files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir}));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string3 = "Do not archive expired working files";
            }
            logger.info(string3);
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", new Object[]{Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(",")});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        FSDataInputStream stream = this.packLogicPath().getFileSystem(this.conf()).open(this.packLogicPath());
        RunTimeCodeLoader loader = new RunTimeCodeLoader((InputStream)stream);
        Object object = result = loader.load();
        if (object instanceof PackingLogic) {
            PackingLogic packingLogic2;
            packingLogic = packingLogic2 = (PackingLogic)object;
        } else {
            if (!(object instanceof PartitionerConfigurator)) throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected type returned from compiled code: result.getClass"})).s((Seq)Nil$.MODULE$));
            PartitionerConfigurator partitionerConfigurator = (PartitionerConfigurator)object;
            packingLogic = new PartitionerPackLogic(partitionerConfigurator.partitioners());
        }
        this.packLogic = packingLogic;
        this.packer = CorePacker$.MODULE$.apply(this.packLogic, this.packConf(), this.infoModel(), this.hoursPerFile(), this.fileCacheSize(), this.numMoveThreads(), this.conf());
        this.watcher = new DirMapping(this.incomingDir(), this.packer(), this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Packer threads are starting::");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ShutdownHookManager.get().addShutdownHook((Runnable)new PackerMain.Cleanup(), this.SHUTDOWN_PRIORITY());
        this.org$cert$netsa$mothra$tools$PackerMain$$packerPool = new ThreadPoolExecutor(this.maxPackJobs(), this.maxPackJobs(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("PackFileThread-"));
        this.org$cert$netsa$mothra$tools$PackerMain$$packerPool.prestartAllCoreThreads();
        this.org$cert$netsa$mothra$tools$PackerMain$$tasks = Queue$.MODULE$.empty();
        this.packer().initializeWorkDir();
        this.checkWorkdirResult = Executors.newScheduledThreadPool(1, new PackerThreadFactory("CheckWorkFiles-")).scheduleAtFixedRate(new PackerMain.CheckWorkdir(), this.workdirCheckInterval(), this.workdirCheckInterval(), TimeUnit.SECONDS);
        this.logTaskCountInterval = 5;
        this.logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-")).scheduleAtFixedRate(new Thread(){

            public void run() {
                PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$logPackerTaskCount();
                PackerMain$.MODULE$.packer().logMoverTaskCount();
            }
        }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
        this.org$cert$netsa$mothra$tools$PackerMain$$tasks = (Queue)this.org$cert$netsa$mothra$tools$PackerMain$$tasks.$plus$plus((GenTraversableOnce)this.watcher().jobs(this.conf()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<PackFileJob, PackFileJob> apply(PackFileJob job) {
                PackFileJob x$14 = job;
                return new Tuple2((Object)job, (Object)x$14);
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<PackFileJob, PackFileJob> x$15) {
                Tuple2<PackFileJob, PackFileJob> tuple2 = x$15;
                if (tuple2 != null) {
                    boolean bl = PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$running();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PackFileJob apply(Tuple2<PackFileJob, PackFileJob> x$16) {
                Tuple2<PackFileJob, PackFileJob> tuple2 = x$16;
                if (tuple2 != null) {
                    PackFileJob job = (PackFileJob)tuple2._1();
                    PackFileJob packFileJob = job.submitTo(PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$packerPool);
                    return packFileJob;
                }
                throw new MatchError(tuple2);
            }
        }), Queue$.MODULE$.canBuildFrom());
        while (this.org$cert$netsa$mothra$tools$PackerMain$$running() && (!this.oneShot() || this.org$cert$netsa$mothra$tools$PackerMain$$tasks.nonEmpty())) {
            if (this.org$cert$netsa$mothra$tools$PackerMain$$running() && this.org$cert$netsa$mothra$tools$PackerMain$$tasks.nonEmpty()) {
                Map groups = this.org$cert$netsa$mothra$tools$PackerMain$$tasks.groupBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(PackFileJob job) {
                        return job.result().isDone() ? (BoxesRunTime.unboxToBoolean((Object)job.result().get()) ? 1 : (job.runCount() < PackerMain$.MODULE$.packAttempts() ? 2 : 3)) : 0;
                    }
                });
                groups.withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Queue<PackFileJob>> check$ifrefutable$1) {
                        Tuple2<Object, Queue<PackFileJob>> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Object, Queue<PackFileJob>> x$17) {
                        Tuple2<Object, Queue<PackFileJob>> tuple2 = x$17;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            int k = tuple2._1$mcI$sp();
                            Queue v = (Queue)tuple2._2();
                            if (PackerMain$.MODULE$.logger().underlying().isTraceEnabled()) {
                                PackerMain$.MODULE$.logger().underlying().trace("groups({}) contains {} tasks", new Object[]{BoxesRunTime.boxToInteger((int)k), BoxesRunTime.boxToInteger((int)v.size())});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                this.org$cert$netsa$mothra$tools$PackerMain$$tasks = (Queue)groups.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Queue<PackFileJob> apply() {
                        return Queue$.MODULE$.empty();
                    }
                });
                groups.get((Object)BoxesRunTime.boxToInteger((int)2)).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Queue<PackFileJob> requeue) {
                        PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$tasks = (Queue)PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$tasks.$plus$plus((GenTraversableOnce)((TraversableLike)requeue.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<PackFileJob, PackFileJob> apply(PackFileJob job) {
                                PackFileJob x$18 = job;
                                return new Tuple2((Object)job, (Object)x$18);
                            }
                        }, Queue$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<PackFileJob, PackFileJob> x$19) {
                                Tuple2<PackFileJob, PackFileJob> tuple2 = x$19;
                                if (tuple2 != null) {
                                    PackFileJob job = (PackFileJob)tuple2._1();
                                    boolean bl = PackerMain$.MODULE$.watcher().fileExists(job.sourcePath());
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                        }).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<PackFileJob, PackFileJob> x$20) {
                                Tuple2<PackFileJob, PackFileJob> tuple2 = x$20;
                                if (tuple2 != null) {
                                    boolean bl = PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$running();
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final PackFileJob apply(Tuple2<PackFileJob, PackFileJob> x$21) {
                                Tuple2<PackFileJob, PackFileJob> tuple2 = x$21;
                                if (tuple2 != null) {
                                    PackFileJob job = (PackFileJob)tuple2._1();
                                    PackFileJob packFileJob = job.submitTo(PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$packerPool);
                                    return packFileJob;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Queue$.MODULE$.canBuildFrom()), Queue$.MODULE$.canBuildFrom());
                    }
                });
                groups.get((Object)BoxesRunTime.boxToInteger((int)3)).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Queue<PackFileJob> failed) {
                        failed.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(PackFileJob job) {
                                BoxedUnit boxedUnit;
                                if (PackerMain$.MODULE$.logger().underlying().isWarnEnabled()) {
                                    PackerMain$.MODULE$.logger().underlying().warn("Maximum packing attempts reached for '{}'", new Object[]{job.sourcePath()});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        });
                    }
                });
            }
            if (this.oneShot()) {
                if (!this.org$cert$netsa$mothra$tools$PackerMain$$tasks.nonEmpty() || !this.org$cert$netsa$mothra$tools$PackerMain$$running()) continue;
                Thread.sleep(5000L);
                continue;
            }
            if (!this.org$cert$netsa$mothra$tools$PackerMain$$running()) continue;
            Thread.sleep(this.pollingInterval() * 1000);
            if (!this.org$cert$netsa$mothra$tools$PackerMain$$running()) continue;
            this.org$cert$netsa$mothra$tools$PackerMain$$tasks = (Queue)this.org$cert$netsa$mothra$tools$PackerMain$$tasks.$plus$plus((GenTraversableOnce)this.watcher().jobs(this.conf()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<PackFileJob, PackFileJob> apply(PackFileJob job) {
                    PackFileJob x$22 = job;
                    return new Tuple2((Object)job, (Object)x$22);
                }
            }).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<PackFileJob, PackFileJob> x$23) {
                    Tuple2<PackFileJob, PackFileJob> tuple2 = x$23;
                    if (tuple2 != null) {
                        boolean bl = PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$running();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final PackFileJob apply(Tuple2<PackFileJob, PackFileJob> x$24) {
                    Tuple2<PackFileJob, PackFileJob> tuple2 = x$24;
                    if (tuple2 != null) {
                        PackFileJob job = (PackFileJob)tuple2._1();
                        PackFileJob packFileJob = job.submitTo(PackerMain$.MODULE$.org$cert$netsa$mothra$tools$PackerMain$$packerPool);
                        return packFileJob;
                    }
                    throw new MatchError(tuple2);
                }
            }), Queue$.MODULE$.canBuildFrom());
        }
        if (!this.org$cert$netsa$mothra$tools$PackerMain$$running()) return;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("All tasks have completed and one-shot is active. Closing and moving work files...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.checkWorkdirResult.cancel(false);
        this.packer().closeAllWorkFiles(true);
        this.logTaskCountThread.cancel(false);
        this.org$cert$netsa$mothra$tools$PackerMain$$running_$eq(false);
        System.exit(0);
    }

    private PackerMain$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        StrictLogging.class.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new PackerMain.delayedInit.body(this));
    }
}

