/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.tools;

import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InfoModel$;
import org.cert.netsa.mothra.packer.CorePacker;
import org.cert.netsa.mothra.packer.CorePacker$;
import org.cert.netsa.mothra.packer.PackerConfig;
import org.cert.netsa.mothra.packer.PackerThreadFactory;
import org.cert.netsa.mothra.packer.PackingLogic;
import org.cert.netsa.mothra.packer.PartitionerConfigurator;
import org.cert.netsa.mothra.packer.PartitionerPackLogic;
import org.cert.netsa.mothra.packer.RunTimeCodeLoader;
import org.cert.netsa.mothra.packer.Version$;
import org.cert.netsa.mothra.tools.RepackerMain;
import org.slf4j.Logger;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class RepackerMain$
implements App,
StrictLogging {
    public static final RepackerMain$ MODULE$;
    private final /* synthetic */ Tuple2 x$2;
    private final String[] switches;
    private final String[] positionalArgs;
    private final Configuration hadoopConf;
    private final Option<CompressionCodec> compressCodec;
    private final Option<Path> archiveDir;
    private final int hoursPerFile;
    private final Option<Object> maximumSize;
    private final int fileCacheSize;
    private final InfoModel infoModel;
    private final Path runTimePackConf;
    private final Path rootDir;
    private final java.nio.file.Path workDir;
    private final Path[] sourceDirs;
    private final FileSystem sourceFileSystem;
    private final PackerConfig packConf;
    private final PackingLogic packLogic;
    private final CorePacker packer;
    private int readersPerScanner;
    private final int maxScanJobs;
    private final int maxThreads;
    private final ConcurrentLinkedQueue<Path> removeList;
    private final LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$RepackerMain$$signalQueue;
    public final ThreadPoolExecutor org$cert$netsa$mothra$tools$RepackerMain$$pool;
    private final int logTaskCountInterval;
    private final ScheduledExecutorService logTaskCountThread;
    private volatile boolean running;
    private final com.typesafe.scalalogging.Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new RepackerMain$();
    }

    public com.typesafe.scalalogging.Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(com.typesafe.scalalogging.Logger x$1) {
        this.logger = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public void usage(boolean full) {
        Predef$.MODULE$.print((Object)"\nUsage: spark-submit --class org.cert.netsa.mothra.packer.tools.RepackerMain mothra-tools.jar <partition-conf> <dest-dir> <work-dir> <s1> [<s2> <s3> ...]\n\npartition-conf: Partitioning configuration file as Hadoop URI\ndest-dir:       Root destination directory as Hadoop URI\nwork-dir:       Working directory on the local disk (not file://)\ns1..sn:         Source directories as Hadoop URIs\n");
        if (full) {
            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nMakes a single recursive scan of the source directories <s1>,<s2>,... for\nIPFIX files.  Splits the IPFIX records in the source files into output file(s)\nin a time-based directory structure based on the partitioning rules in the\npartitioning configuration file <partition-conf>.  The output files are\ninitially created in the working directory <work-dir>, and, once ALL input\nfiles have been read, are moved to the destination directory and the initial\nsource files removed.\n\nThe repacker runs as a batch process; not as a daemon.\n\nExample/Intended uses for the repacker include:\n\n(1)Changing how the records are packed---for example packing by the\nsilkAppLabel instead of the protocolIdentifier.\n\n(2)Combining multiple files for an hour into a single file for that hour,\nmerging hourly files into a file that covers a longer duration, or\nspliting a longer duration file into smaller files.\n\n(3)Changing the compression algorithm used on the IPFIX files.\n\nCurrently the repacker does NOT support modifying the records, it only moves\nthe records into different files.\n\nRepacker uses multiple threads.  By default, each source directory specified\non the command line gets a dedicated thread to scanning that directory and its\nsubdirectories recursively for IPFIX files, and another thread decidated to\nreading those files and repacking them.  The repacker does not support having\nmultiple threads scan a directory, but it does allow multiple threads to\nprocess a single directory's files.\n\nThe <work-dir> must NOT be a source directory or a subdirectory of a source\ndirectory.  To repack the files in an existing working directory, use a\ndifferent working directory.  The repacker ignores any files in the <work-dir>\nthat exist when the repacker is started, and it ignores files placed there by\nother programs.\n\nThe property values that are used by the repacker are:\n\nmothra.repacker.compression -- the compression algorithm used for the new\nIPFIX files.  Values typically supported by Hadoop include bzip2, gzip,\nlz4, lzo, lzop, snappy, and default.  The empty string indicates no\ncompression.  The default compression is '", "'.\n\n`mothra.repacker.hoursPerFile` -- The number of hours covered by each file\nin the repository.  The valid range is 1 (a file for each hour) to 24 (one\nfile per day).  The default is ", ".\n\nmothra.repacker.maxScanJobs -- the maximum number of threads dedicated to\nscanning the source directories.  The default (and maximum) value is the\nnumber of source directories.\n\nmothra.repacker.readersPerScanner -- the number of reader/repacker threads to\ncreate for each source directory.  The default is 1.\n\nmothra.repacker.maxThreads -- the maximum number of worker (scanner and\nrepacker) threads to create.  The default value is computed using the formula:\n(maxScanJobs * (1 + readersPerScanner)).\n\n`mothra.repacker.maximumSize` -- the (approximate) maximum file size to\ncreate.  When specified, a work-file that exceeds this size is closed and\nmoved into the repository.  NOTES: (1)This value uses the uncompressed\nfile size, and does not consider any compression that may occur when the\nfile is moved from the workDir to the tgtDir.  In addition, a file's size\ntends to grow in large steps because of buffering by the Java stream code.\n(2)Specifying a `maximumSize` may temporarially cause duplicate records to\nappear in the repository because of some records in the original files and\nsome in the new file.  Once Repacker finishes scanning all files, the\noriginal files are removed and only the newly packed files are left.  This\nissue of temporary having duplicate records in the repository will be\nresolved in a future release.  The default is no maximum.\n\nmothra.repacker.archiveDirectory -- the root directory into which working\nfiles are moved after the repacker has finished running, as a Hadoop URI.  If\nnot specified, the working files are deleted.\n\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CorePacker$.MODULE$.DEFAULT_COMPRESSION(), BoxesRunTime.boxToInteger((int)CorePacker$.MODULE$.DEFAULT_HOURS_PER_FILE())})));
        }
        System.exit(full ? 0 : 1);
    }

    public boolean usage$default$1() {
        return false;
    }

    public void version() {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Repacker ").append((Object)Version$.MODULE$.get(Version$.MODULE$.get$default$1())).toString());
        System.exit(0);
    }

    public String[] switches() {
        return this.switches;
    }

    public String[] positionalArgs() {
        return this.positionalArgs;
    }

    public final void org$cert$netsa$mothra$tools$RepackerMain$$scanDir(Path dir, LinkedBlockingQueue<Path> queue) {
        BoxedUnit boxedUnit;
        String numFiles;
        RemoteIterator iter;
        RemoteIterator remoteIterator;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Recursively scanning directory '{}'...", new Object[]{dir});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        int count = 0;
        try {
            remoteIterator = this.sourceFileSystem().listFiles(dir, true);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unable to get status of '{}/': {}", new Object[]{dir, e.getMessage()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            RemoteIterator<LocatedFileStatus> remoteIterator2 = new RemoteIterator<LocatedFileStatus>(){

                public boolean hasNext() {
                    return false;
                }

                public LocatedFileStatus next() {
                    throw new NoSuchElementException();
                }
            };
            remoteIterator = iter = remoteIterator2;
        }
        while (iter.hasNext()) {
            BoxedUnit boxedUnit4;
            LocatedFileStatus status = (LocatedFileStatus)iter.next();
            if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(status){
                public static final long serialVersionUID = 0L;
                private final LocatedFileStatus status$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.status$1.isFile();
                }
                {
                    this.status$1 = status$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }))) continue;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Found file '{}'", new Object[]{status.getPath()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            queue.put(status.getPath());
            ++count;
        }
        String string = count > 1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})) : (numFiles = count == 1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})) : "no files");
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Found {} files to process in '{}' and its subdirectories", new Object[]{numFiles, dir});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public Option<CompressionCodec> compressCodec() {
        return this.compressCodec;
    }

    public Option<Path> archiveDir() {
        return this.archiveDir;
    }

    public int hoursPerFile() {
        return this.hoursPerFile;
    }

    public Option<Object> maximumSize() {
        return this.maximumSize;
    }

    public int fileCacheSize() {
        return this.fileCacheSize;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public Path runTimePackConf() {
        return this.runTimePackConf;
    }

    public Path rootDir() {
        return this.rootDir;
    }

    public java.nio.file.Path workDir() {
        return this.workDir;
    }

    public Path[] sourceDirs() {
        return this.sourceDirs;
    }

    public FileSystem sourceFileSystem() {
        return this.sourceFileSystem;
    }

    public PackerConfig packConf() {
        return this.packConf;
    }

    public PackingLogic packLogic() {
        return this.packLogic;
    }

    public CorePacker packer() {
        return this.packer;
    }

    public int readersPerScanner() {
        return this.readersPerScanner;
    }

    public void readersPerScanner_$eq(int x$1) {
        this.readersPerScanner = x$1;
    }

    public int maxScanJobs() {
        return this.maxScanJobs;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public ConcurrentLinkedQueue<Path> removeList() {
        return this.removeList;
    }

    public LinkedBlockingQueue<Object> org$cert$netsa$mothra$tools$RepackerMain$$signalQueue() {
        return this.org$cert$netsa$mothra$tools$RepackerMain$$signalQueue;
    }

    public int logTaskCountInterval() {
        return this.logTaskCountInterval;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void delayedEndpoint$org$cert$netsa$mothra$tools$RepackerMain$1() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        BoxedUnit boxedUnit9;
        BoxedUnit boxedUnit10;
        BoxedUnit boxedUnit11;
        BoxedUnit boxedUnit12;
        BoxedUnit boxedUnit13;
        int rps;
        PackingLogic packingLogic;
        Object result;
        None$ none$;
        String compressName;
        BoxedUnit boxedUnit14;
        BoxedUnit boxedUnit15;
        Tuple2 tuple2;
        Tuple2 tuple22 = Predef$.MODULE$.refArrayOps((Object[])this.args()).partition((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1.substring(0, 2);
                String string2 = "-";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        String[] switches = (String[])tuple22._1();
        String[] positionalArgs = (String[])tuple22._2();
        this.x$2 = tuple2 = new Tuple2((Object)switches, (Object)positionalArgs);
        this.switches = (String[])this.x$2._1();
        this.positionalArgs = (String[])this.x$2._2();
        Predef$.MODULE$.refArrayOps((Object[])this.switches()).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                boolean bl = "-V".equals(A1) ? true : "--version".equals(A1);
                if (bl) {
                    RepackerMain$.MODULE$.version();
                    object = BoxedUnit.UNIT;
                } else {
                    boolean bl2 = "-h".equals(A1) ? true : "--help".equals(A1);
                    if (bl2) {
                        RepackerMain$.MODULE$.usage(true);
                        object = BoxedUnit.UNIT;
                    } else if (A1 != null) {
                        A1 A12 = A1;
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown argument '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A12})));
                        RepackerMain$.MODULE$.usage(RepackerMain$.MODULE$.usage$default$1());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                boolean bl;
                String string = x1;
                boolean bl2 = "-V".equals(string) ? true : "--version".equals(string);
                if (bl2) {
                    bl = true;
                } else {
                    boolean bl3 = "-h".equals(string) ? true : "--help".equals(string);
                    bl = bl3 ? true : string != null;
                }
                return bl;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        if (this.positionalArgs().length < 4) {
            BoxedUnit boxedUnit16;
            BoxedUnit boxedUnit17;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Called with only {} args; at least 4 required", new Object[]{BoxesRunTime.boxToInteger((int)this.positionalArgs().length)});
                boxedUnit17 = BoxedUnit.UNIT;
            } else {
                boxedUnit17 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Args were {}", new Object[]{this.positionalArgs()});
                boxedUnit16 = BoxedUnit.UNIT;
            } else {
                boxedUnit16 = BoxedUnit.UNIT;
            }
            this.usage(this.usage$default$1());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n============================= Repacker is starting =============================\n");
            boxedUnit15 = BoxedUnit.UNIT;
        } else {
            boxedUnit15 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("This is Repacker {}", new Object[]{Version$.MODULE$.get(Version$.MODULE$.get$default$1())});
            boxedUnit14 = BoxedUnit.UNIT;
        } else {
            boxedUnit14 = BoxedUnit.UNIT;
        }
        this.hadoopConf = new Configuration();
        String string = compressName = (String)package$.MODULE$.props().get("mothra.repacker.compression").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return CorePacker$.MODULE$.DEFAULT_COMPRESSION();
            }
        });
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
        } else {
            Option option;
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(compressName){
                public static final long serialVersionUID = 0L;
                private final String compressName$1;

                /*
                 * WARNING - void declaration
                 */
                public final CompressionCodec apply() {
                    void var2_2;
                    CompressionCodecFactory factory = new CompressionCodecFactory(RepackerMain$.MODULE$.hadoopConf());
                    CompressionCodec codec = factory.getCodecByName(this.compressName$1);
                    codec.createCompressor();
                    return var2_2;
                }
                {
                    this.compressName$1 = compressName$1;
                }
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                CompressionCodec ok = (CompressionCodec)success.value();
                option = Option$.MODULE$.apply((Object)ok);
            } else {
                BoxedUnit boxedUnit18;
                BoxedUnit boxedUnit19;
                BoxedUnit boxedUnit20;
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, e.toString()}))).toString());
                    boxedUnit20 = BoxedUnit.UNIT;
                } else {
                    boxedUnit20 = BoxedUnit.UNIT;
                }
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Unable to initialize compressor").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressName, sw.toString()}))).toString());
                    boxedUnit19 = BoxedUnit.UNIT;
                } else {
                    boxedUnit19 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Using no compression for IPFIX files");
                    boxedUnit18 = BoxedUnit.UNIT;
                } else {
                    boxedUnit18 = BoxedUnit.UNIT;
                }
                option = None$.MODULE$;
            }
            none$ = option;
        }
        this.compressCodec = none$;
        this.archiveDir = package$.MODULE$.props().get("mothra.repacker.archiveDirectory").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x) {
                return new Path(x);
            }
        });
        this.hoursPerFile = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.repacker.hoursPerFile").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return CorePacker$.MODULE$.DEFAULT_HOURS_PER_FILE();
            }
        }));
        Predef$.MODULE$.require(this.hoursPerFile() >= 1 && this.hoursPerFile() <= 24);
        this.maximumSize = package$.MODULE$.props().get("mothra.repacker.maximumSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
            }
        });
        this.maximumSize().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(long ms) {
                this.apply$mcVJ$sp(ms);
            }

            public void apply$mcVJ$sp(long ms) {
                Predef$.MODULE$.require(ms >= 1L);
            }
        });
        this.fileCacheSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.repacker.fileCacheSize").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return CorePacker$.MODULE$.DEFAULT_FILE_CACHE_SIZE();
            }
        }));
        Predef$.MODULE$.require(this.fileCacheSize() >= CorePacker$.MODULE$.MINIMUM_FILE_CACHE_SIZE());
        this.infoModel = InfoModel$.MODULE$.getCERTStandardInfoModel();
        this.runTimePackConf = new Path(this.positionalArgs()[0]);
        this.rootDir = new Path(this.positionalArgs()[1]);
        this.workDir = Paths.get(this.positionalArgs()[2], new String[0]);
        this.sourceDirs = (Path[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.positionalArgs()).drop(3)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$6) {
                return new Path(x$6);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        this.sourceFileSystem = this.sourceDirs()[0].getFileSystem(this.hadoopConf());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).drop(1)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Path sd) {
                BoxedUnit boxedUnit;
                FileSystem fileSystem = sd.getFileSystem(RepackerMain$.MODULE$.hadoopConf());
                FileSystem fileSystem2 = RepackerMain$.MODULE$.sourceFileSystem();
                if (!(fileSystem != null ? !fileSystem.equals(fileSystem2) : fileSystem2 != null)) {
                    return;
                }
                if (RepackerMain$.MODULE$.logger().underlying().isErrorEnabled()) {
                    RepackerMain$.MODULE$.logger().underlying().error("source directories use different file systems");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new Exception("source directories use different file systems");
            }
        });
        this.packConf = new PackerConfig(this.rootDir(), this.workDir(), (Option<Path>)None$.MODULE$, this.compressCodec(), this.hadoopConf());
        FSDataInputStream stream = this.runTimePackConf().getFileSystem(this.hadoopConf()).open(this.runTimePackConf());
        RunTimeCodeLoader loader = new RunTimeCodeLoader((InputStream)stream);
        Object object = result = loader.load();
        if (object instanceof PackingLogic) {
            PackingLogic packingLogic2;
            packingLogic = packingLogic2 = (PackingLogic)object;
        } else {
            if (!(object instanceof PartitionerConfigurator)) throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected type returned from compiled code: result.getClass"})).s((Seq)Nil$.MODULE$));
            PartitionerConfigurator partitionerConfigurator = (PartitionerConfigurator)object;
            packingLogic = new PartitionerPackLogic(partitionerConfigurator.partitioners());
        }
        this.packLogic = packingLogic;
        this.packer = CorePacker$.MODULE$.apply(this.packLogic(), this.packConf(), this.infoModel(), this.hoursPerFile(), this.fileCacheSize(), CorePacker$.MODULE$.apply$default$6(), this.hadoopConf());
        if (this.maximumSize().isDefined()) {
            this.packer().addFileEvent(new RepackerMain.EnableSizeChecker(this.packer()));
        }
        this.readersPerScanner = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.repacker.readersPerScanner").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }));
        Predef$.MODULE$.require(this.readersPerScanner() >= 1);
        int msj = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.repacker.maxScanJobs").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Predef$.MODULE$.refArrayOps((Object[])RepackerMain$.MODULE$.sourceDirs()).size();
            }
        }));
        this.maxScanJobs = msj > Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).size() ? Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).size() : msj;
        this.maxThreads = BoxesRunTime.unboxToInt((Object)package$.MODULE$.props().get("mothra.repacker.maxThreads").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$9) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return RepackerMain$.MODULE$.maxScanJobs() * (1 + RepackerMain$.MODULE$.readersPerScanner());
            }
        }));
        Predef$.MODULE$.require(this.maxThreads() >= 1);
        if (this.maxThreads() > this.maxScanJobs() * (1 + this.readersPerScanner()) && package$.MODULE$.props().get("mothra.repacker.readersPerScanner").isEmpty() && (rps = this.maxThreads() / this.maxScanJobs() - 1) > this.readersPerScanner()) {
            this.readersPerScanner_$eq(rps);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Repacker settings::");
            boxedUnit13 = BoxedUnit.UNIT;
        } else {
            boxedUnit13 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Output compression: {}", new Object[]{this.compressCodec().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "none";
                }
            })});
            boxedUnit12 = BoxedUnit.UNIT;
        } else {
            boxedUnit12 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Hours covered by each file: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hoursPerFile())});
            boxedUnit11 = BoxedUnit.UNIT;
        } else {
            boxedUnit11 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of top-level directories to scan: {}", new Object[]{BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).size())});
            boxedUnit10 = BoxedUnit.UNIT;
        } else {
            boxedUnit10 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of scanning threads: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxScanJobs())});
            boxedUnit9 = BoxedUnit.UNIT;
        } else {
            boxedUnit9 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Number of repacker threads per scanner: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.readersPerScanner())});
            boxedUnit8 = BoxedUnit.UNIT;
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Total number or scanning and repacker threads: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.maxThreads())});
            boxedUnit7 = BoxedUnit.UNIT;
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Approximate maximum output file size: ").append(this.maximumSize().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(long x$10) {
                    return ((Object)BoxesRunTime.boxToLong((long)x$10)).toString();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "unlimited";
                }
            })).toString());
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Maximum number of open files in the workDir: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.fileCacheSize())});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String string3;
            Logger logger = this.logger().underlying();
            Option<Path> option = this.archiveDir();
            if (option instanceof Some) {
                Some some = (Some)option;
                Path dir = (Path)some.x();
                string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archive location for expired working files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir}));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string3 = "Do not archive expired working files";
            }
            logger.info(string3);
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JVM Parameters: {}", new Object[]{Predef$.MODULE$.refArrayOps(ManagementFactory.getRuntimeMXBean().getInputArguments().toArray()).mkString(",")});
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        this.removeList = new ConcurrentLinkedQueue();
        this.org$cert$netsa$mothra$tools$RepackerMain$$signalQueue = new LinkedBlockingQueue();
        this.org$cert$netsa$mothra$tools$RepackerMain$$pool = new ThreadPoolExecutor(this.maxThreads(), this.maxThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PackerThreadFactory("RepackerThread-"));
        this.logTaskCountInterval = 5;
        this.logTaskCountThread = Executors.newScheduledThreadPool(1, new PackerThreadFactory("LogTaskCounts-"));
        this.logTaskCountThread.scheduleAtFixedRate(new Thread(){

            public void run() {
                BoxedUnit boxedUnit;
                int active = RepackerMain$.MODULE$.org$cert$netsa$mothra$tools$RepackerMain$$pool.getActiveCount();
                long completed = RepackerMain$.MODULE$.org$cert$netsa$mothra$tools$RepackerMain$$pool.getCompletedTaskCount();
                long total = RepackerMain$.MODULE$.org$cert$netsa$mothra$tools$RepackerMain$$pool.getTaskCount();
                if (RepackerMain$.MODULE$.logger().underlying().isInfoEnabled()) {
                    RepackerMain$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total tasks: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)total)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Completed tasks: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)completed)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Active tasks: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)active)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Queued tasks: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(total - (long)active - completed))}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }, this.logTaskCountInterval(), this.logTaskCountInterval(), TimeUnit.SECONDS);
        this.running = true;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting recursive scan of ", " director"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).size())}))).append((Object)(1 == Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).size() ? "y" : "ies")).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.refArrayOps((Object[])this.sourceDirs()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Path s) {
                LinkedBlockingQueue<Path> files = new LinkedBlockingQueue<Path>();
                Future<?> scanner = RepackerMain$.MODULE$.org$cert$netsa$mothra$tools$RepackerMain$$pool.submit(new RepackerMain.HadoopDirectoryScanner(s, files));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), RepackerMain$.MODULE$.readersPerScanner()).foreach$mVc$sp((Function1)new Serializable(this, files, scanner, s){
                    public static final long serialVersionUID = 0L;
                    private final LinkedBlockingQueue files$1;
                    private final Future scanner$1;
                    private final Path s$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repacker #", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.s$1}));
                        RepackerMain$.MODULE$.org$cert$netsa$mothra$tools$RepackerMain$$pool.execute(new RepackerMain.RepackFromQueue<T>(this.files$1, this.scanner$1, name));
                    }
                    {
                        this.files$1 = files$1;
                        this.scanner$1 = scanner$1;
                        this.s$1 = s$1;
                    }
                });
            }
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.org$cert$netsa$mothra$tools$RepackerMain$$pool.getTaskCount() - this.org$cert$netsa$mothra$tools$RepackerMain$$pool.getCompletedTaskCount()))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" of ", " scanner and repacker tasks to complete..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$RepackerMain$$pool.getTaskCount())}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.org$cert$netsa$mothra$tools$RepackerMain$$pool.shutdown();
        while (true) {
            BoxedUnit boxedUnit21;
            if (this.org$cert$netsa$mothra$tools$RepackerMain$$pool.isTerminated()) {
                BoxedUnit boxedUnit22;
                BoxedUnit boxedUnit23;
                BoxedUnit boxedUnit24;
                BoxedUnit boxedUnit25;
                this.running_$eq(false);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("All repacking tasks have completed");
                    boxedUnit25 = BoxedUnit.UNIT;
                } else {
                    boxedUnit25 = BoxedUnit.UNIT;
                }
                this.logTaskCountThread.shutdown();
                this.logTaskCountThread.awaitTermination(1L, TimeUnit.SECONDS);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Flushing output files");
                    boxedUnit24 = BoxedUnit.UNIT;
                } else {
                    boxedUnit24 = BoxedUnit.UNIT;
                }
                this.packer().flushAllWorkFiles();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Moving new files into the repository");
                    boxedUnit23 = BoxedUnit.UNIT;
                } else {
                    boxedUnit23 = BoxedUnit.UNIT;
                }
                this.packer().shutdown();
                if (!this.removeList().isEmpty()) {
                    BoxedUnit boxedUnit26;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Removing files that were repacked");
                        boxedUnit26 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit26 = BoxedUnit.UNIT;
                    }
                    do {
                        this.sourceFileSystem().delete(this.removeList().poll(), false);
                    } while (!this.removeList().isEmpty());
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Repacker is done");
                    boxedUnit22 = BoxedUnit.UNIT;
                    return;
                } else {
                    boxedUnit22 = BoxedUnit.UNIT;
                }
                return;
            }
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActiveCount: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$cert$netsa$mothra$tools$RepackerMain$$pool.getActiveCount())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" CompletedCount: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$RepackerMain$$pool.getCompletedTaskCount())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" TaskCount: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$cert$netsa$mothra$tools$RepackerMain$$pool.getTaskCount())}))).toString());
                boxedUnit21 = BoxedUnit.UNIT;
            } else {
                boxedUnit21 = BoxedUnit.UNIT;
            }
            this.org$cert$netsa$mothra$tools$RepackerMain$$signalQueue().poll(3L, TimeUnit.SECONDS);
            this.org$cert$netsa$mothra$tools$RepackerMain$$signalQueue().clear();
        }
    }

    private RepackerMain$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        StrictLogging.class.$init$((StrictLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new RepackerMain.delayedInit.body(this));
    }
}

