// Copyright 2015-2022 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.ipfix


/**
  * A RecordReader is an [[Iterator]] over the [[CollectedRecord
  * CollectedRecords]] found in [[Message Messages]] read from a
  * [[MessageReader]].
  *
  * @param msgReader The object that provides [[Message Messages]] from which
  * to read records
  */
final case class RecordReader(msgReader: MessageReader)
    extends Iterator[Record]
{

  /** Iterator over the IpfixSets in the current Message */
  private[this] var setIter: Iterator[IpfixSet] = Iterator.empty

  /** Iterator over the Records in the current IpfixSet (RecordSet) */
  private[this] var recIter: Iterator[Record] = Iterator.empty

  /**
    * Returns `true` if a Record is available.
    */
  def hasNext: Boolean = {
    if ( recIter.hasNext ) {
      true
    } else {
      while ( !recIter.hasNext && setIter.hasNext ) {
        val set = setIter.next()
        recIter = set.recordIterator
      }
      while ( !recIter.hasNext && msgReader.hasNext ) {
        val msg = msgReader.next()
        setIter = msg.iterator
        while ( !recIter.hasNext && setIter.hasNext ) {
          val set = setIter.next()
          recIter = set.recordIterator
        }
      }
      recIter.hasNext
    }
  }

  /**
    * Returns the next Record.
    */
  def next(): Record = {
    if ( recIter.hasNext || hasNext ) {
      recIter.next()
    } else {
      throw new NoSuchElementException("RecordReader contains no more records")
    }
  }

}

// @LICENSE_FOOTER@
//
// Copyright 2015-2022 Carnegie Mellon University. All Rights Reserved.
//
// This material is based upon work funded and supported by the
// Department of Defense and Department of Homeland Security under
// Contract No. FA8702-15-D-0002 with Carnegie Mellon University for the
// operation of the Software Engineering Institute, a federally funded
// research and development center sponsored by the United States
// Department of Defense. The U.S. Government has license rights in this
// software pursuant to DFARS 252.227.7014.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
// INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
// UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
// IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
// FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
// OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
// MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
// TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
// contact permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public
// release and unlimited distribution. Please see Copyright notice for
// non-US Government use and distribution.
//
// Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
// Trademark Office by Carnegie Mellon University.
//
// This software includes and/or makes use of third party software each
// subject to its own license as detailed in LICENSE-thirdparty.tx
//
// DM20-1143
