// Copyright 2015-2022 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.ipfix.testing

/** An IPFIX field specifier, including the field ID, encoded length
  * of the field, and the optional enterprise number. Used by template
  * records, options template records, and the basicList datatype.
  */
case class FieldSpecifier(
  id: Int, length: Int, enterprise: Option[Int])
    extends Encoded
{
  require(length >= 0 && length <= 65535)
  require(id >= 0 && id <= 32767)
  def encodedLength = enterprise match {
    case None => 4
    case _ => 8
  }
  def encodedBytes = enterprise match {
    case None =>
      b2(id) ++ b2(length)
    case Some(enterpriseId) =>
      b2(id | 0x8000) ++ b2(length) ++ b4(enterpriseId)
  }
}

object FieldSpecifier {
  def apply(id: Int, length: Int): FieldSpecifier =
    FieldSpecifier(id, length, None)
  def apply(id: Int, length: Int, eid: Int): FieldSpecifier =
    FieldSpecifier(id, length, Some(eid))
}

// @LICENSE_FOOTER@
//
// Copyright 2015-2022 Carnegie Mellon University. All Rights Reserved.
//
// This material is based upon work funded and supported by the
// Department of Defense and Department of Homeland Security under
// Contract No. FA8702-15-D-0002 with Carnegie Mellon University for the
// operation of the Software Engineering Institute, a federally funded
// research and development center sponsored by the United States
// Department of Defense. The U.S. Government has license rights in this
// software pursuant to DFARS 252.227.7014.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
// INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
// UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
// IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
// FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
// OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
// MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
// TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
// contact permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public
// release and unlimited distribution. Please see Copyright notice for
// non-US Government use and distribution.
//
// Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
// Trademark Office by Carnegie Mellon University.
//
// This software includes and/or makes use of third party software each
// subject to its own license as detailed in LICENSE-thirdparty.tx
//
// DM20-1143
