// Copyright 2015-2022 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.ipfix.testing

/** Classes for structured IPFIX data. */
object Struct {

  /** An IPFIX basic list value. Should probably be encoded using
    * Encoded.varLen or Encoded.padLen */
  case class BasicList(semantic: Int, field: FieldSpecifier, values: Encoded*)
      extends Encoded
  {
    def encodedLength =
      1 + field.encodedLength + values.iterator.map(_.encodedLength).sum
    def encodedBytes =
      (b1(semantic) ++ field.encodedBytes ++
        values.iterator.flatMap(_.encodedBytes))
  }

  /** An IPFIX subtemplate list value. Should probably be encoded using
    * Encoded.varLen or Encoded.padLen */
  case class SubTemplateList(semantic: Int, id: Int, records: Rec.Data*)
      extends Encoded
  {
    def encodedLength = 3 + records.map(_.encodedLength).sum
    def encodedBytes =
      b1(semantic) ++ b2(id) ++ records.flatMap(_.encodedBytes)
  }

  /** An IPFIX subtemplate multi list value. Should probably be encoded
    * using Encoded.varLen or Encoded.padLen */
  case class SubTemplateMultiList(semantic: Int, sets: Set.Data*)
      extends Encoded
  {
    def encodedLength = 1 + sets.map(_.encodedLength).sum
    def encodedBytes = b1(semantic) ++ sets.flatMap(_.encodedBytes)
  }

}

// @LICENSE_FOOTER@
//
// Copyright 2015-2022 Carnegie Mellon University. All Rights Reserved.
//
// This material is based upon work funded and supported by the
// Department of Defense and Department of Homeland Security under
// Contract No. FA8702-15-D-0002 with Carnegie Mellon University for the
// operation of the Software Engineering Institute, a federally funded
// research and development center sponsored by the United States
// Department of Defense. The U.S. Government has license rights in this
// software pursuant to DFARS 252.227.7014.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
// INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
// UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
// IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
// FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
// OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
// MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
// TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
// contact permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public
// release and unlimited distribution. Please see Copyright notice for
// non-US Government use and distribution.
//
// Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
// Trademark Office by Carnegie Mellon University.
//
// This software includes and/or makes use of third party software each
// subject to its own license as detailed in LICENSE-thirdparty.tx
//
// DM20-1143
