/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.ipfix;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.cert.netsa.io.ipfix.IllegalSetException;
import org.cert.netsa.io.ipfix.IpfixSet;
import org.cert.netsa.io.ipfix.Message;
import org.cert.netsa.io.ipfix.RecordSet$;
import org.cert.netsa.io.ipfix.TemplateSet$;
import org.cert.netsa.io.ipfix.TruncatedReadException;
import org.cert.netsa.io.ipfix.package$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class IpfixSet$ {
    public static final IpfixSet$ MODULE$;
    private final int headerLength;

    static {
        new IpfixSet$();
    }

    public int headerLength() {
        return this.headerLength;
    }

    public IpfixSet fromBuffer(ByteBuffer buffer, Message message) {
        Tuple2 tuple2;
        block5: {
            int settype;
            block8: {
                IpfixSet ipfixSet;
                block7: {
                    ByteBuffer setbuffer;
                    block6: {
                        Tuple2.mcII.sp sp2;
                        tuple2 = this.liftedTree1$1(buffer);
                        if (tuple2 == null) break block5;
                        int settype2 = tuple2._1$mcI$sp();
                        int length = tuple2._2$mcI$sp();
                        int n = settype2;
                        int n2 = length;
                        Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(n, n2);
                        settype = sp3._1$mcI$sp();
                        int length2 = sp3._2$mcI$sp();
                        if (length2 < this.headerLength()) {
                            throw new TruncatedReadException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set header contains an illegal length (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length2)})));
                        }
                        if (length2 > buffer.remaining()) {
                            throw new TruncatedReadException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Length in Set header (", ") is larger than octets available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)buffer.remaining())}))).toString());
                        }
                        setbuffer = buffer.slice();
                        setbuffer.limit(length2);
                        buffer.position(buffer.position() + length2);
                        if (settype < package$.MODULE$.MIN_TEMPLATE_ID()) break block6;
                        ipfixSet = RecordSet$.MODULE$.fromBuffer(settype, setbuffer, message);
                        break block7;
                    }
                    if (settype != package$.MODULE$.TEMPLATE_SET_ID() && settype != package$.MODULE$.OPTIONS_TEMPLATE_SET_ID()) break block8;
                    ipfixSet = TemplateSet$.MODULE$.fromBuffer(settype, setbuffer, message);
                }
                return ipfixSet;
            }
            throw new IllegalSetException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ID in Set header is invalid (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)settype)})));
        }
        throw new MatchError((Object)tuple2);
    }

    private final Tuple2 liftedTree1$1(ByteBuffer buffer$1) {
        try {
            return new Tuple2.mcII.sp(0xFFFF & buffer$1.getShort(buffer$1.position()), 0xFFFF & buffer$1.getShort(buffer$1.position() + 2));
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new TruncatedReadException(new StringBuilder().append((Object)"Not enough octets available for a Set header").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", " of ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)buffer$1.remaining()), BoxesRunTime.boxToInteger((int)this.headerLength())}))).toString());
        }
    }

    private IpfixSet$() {
        MODULE$ = this;
        this.headerLength = 4;
    }
}

