/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.ipfix;

import java.nio.ByteBuffer;
import org.cert.netsa.io.ipfix.CollectedRecord;
import org.cert.netsa.io.ipfix.InfoElement$;
import org.cert.netsa.io.ipfix.InfoElementMetadata;
import org.cert.netsa.io.ipfix.InfoElementMetadata$;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.IpfixSet$;
import org.cert.netsa.io.ipfix.Message;
import org.cert.netsa.io.ipfix.Record;
import org.cert.netsa.io.ipfix.RecordSet;
import org.cert.netsa.io.ipfix.Session;
import org.cert.netsa.io.ipfix.Template;
import org.cert.netsa.io.ipfix.TemplateMetadata;
import org.cert.netsa.io.ipfix.TemplateMetadata$;
import scala.Array$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;

public final class RecordSet$ {
    public static final RecordSet$ MODULE$;

    static {
        new RecordSet$();
    }

    public RecordSet fromBuffer(int id, ByteBuffer buffer, Message message) {
        Template template2 = message.session().apply(id);
        int minSize = template2.minimumLength();
        ArrayBuffer builder = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        buffer.position(IpfixSet$.MODULE$.headerLength());
        if (template2.isMetadataTemplate()) {
            if (template2.isTemplateMetadataTemplate()) {
                while (buffer.remaining() >= minSize) {
                    CollectedRecord r = template2.readRecord(buffer, message.session(), (Option<Message>)Option$.MODULE$.apply((Object)message));
                    builder.$plus$eq((Object)r);
                    TemplateMetadata metadata = TemplateMetadata$.MODULE$.createFrom(r);
                    if (!new StringOps(Predef$.MODULE$.augmentString(metadata.name())).nonEmpty()) continue;
                    message.session().addTemplateMetadata(metadata);
                }
            } else {
                Predef$.MODULE$.assert(template2.isInfoElementMetadataTemplate());
                InfoModel model = message.session().infoModel();
                while (buffer.remaining() >= minSize) {
                    CollectedRecord r = template2.readRecord(buffer, message.session(), (Option<Message>)Option$.MODULE$.apply((Object)message));
                    builder.$plus$eq((Object)r);
                    InfoElementMetadata metadata = InfoElementMetadata$.MODULE$.createFrom(r);
                    if (model.contains(metadata.id(), metadata.pen())) continue;
                    model.add(InfoElement$.MODULE$.fromInfoElementMetadata(metadata));
                }
            }
        } else {
            while (buffer.remaining() >= minSize) {
                builder.$plus$eq((Object)template2.readRecord(buffer, message.session(), (Option<Message>)Option$.MODULE$.apply((Object)message)));
            }
        }
        return new RecordSet(id, message.session(), template2, (Record[])builder.toArray(ClassTag$.MODULE$.apply(Record.class)), buffer.limit());
    }

    public RecordSet empty(Template template2, Session session) {
        int id = session.getOrAdd(template2, session.getOrAdd$default$2());
        return new RecordSet(id, session, template2, (Record[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Record.class)), this.$lessinit$greater$default$5());
    }

    private int $lessinit$greater$default$5() {
        return IpfixSet$.MODULE$.headerLength();
    }

    private RecordSet$() {
        MODULE$ = this;
    }
}

