// Copyright 2015-2022 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.ipfix;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;

/**
 * The {@link IPFIXExtract} annotation may be used on the variables of
 * a class that mixes in the Scala <a target="_top"
 * href="../../../../../scaladoc/index.html#org.cert.netsa.io.ipfix.Fillable">
 * {@code Fillable}</a> trait. When an instance of that class is used
 * as a parameter to a <a target="_top"
 * href="../../../../../scaladoc/index.html#org.cert.netsa.io.ipfix.Record">
 * {@code Record}</a>'s {@code fill()} method, values from the <a
 * target="_top"
 * href="../../../../../scaladoc/index.html#org.cert.netsa.io.ipfix.Record">
 * {@code Record}</a> are copied into the annotated variables of the
 * <a target="_top"
 * href="../../../../../scaladoc/index.html#org.cert.netsa.io.ipfix.Fillable">
 * {@code Fillable}</a> instance.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
@Inherited
@Documented
public @interface IPFIXExtract
{
    /**
     * Name of the IPFIX information element to use to fill this field.
     * @return the name of the IPFIX information element
     */
    String name();
    /**
     * One-based integer index specifying which instance of the
     * named information element should be chosen when multiple
     * elements are present on the record. Defaults to the first
     * occurrence.
     * @return the one-based index of the occurrence to choose
     */
    int nth() default 1;
}

// @LICENSE_FOOTER@
//
// Copyright 2015-2022 Carnegie Mellon University. All Rights Reserved.
//
// This material is based upon work funded and supported by the
// Department of Defense and Department of Homeland Security under
// Contract No. FA8702-15-D-0002 with Carnegie Mellon University for the
// operation of the Software Engineering Institute, a federally funded
// research and development center sponsored by the United States
// Department of Defense. The U.S. Government has license rights in this
// software pursuant to DFARS 252.227.7014.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
// INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
// UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
// IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
// FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
// OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
// MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
// TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
// contact permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public
// release and unlimited distribution. Please see Copyright notice for
// non-US Government use and distribution.
//
// Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
// Trademark Office by Carnegie Mellon University.
//
// This software includes and/or makes use of third party software each
// subject to its own license as detailed in LICENSE-thirdparty.tx
//
// DM20-1143
