// Copyright 2015-2022 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.ipfix

/**
  * A class which mixes in the [[Fillable]] trait may be used as a
  * target of a [[Record Record's]] [[Record#fill fill()]] method.
  *
  * A class which mixes in Fillable must use the
  * <a target="_top" href="../../../../../javadoc/index.html?org/cert/netsa/io/ipfix/IPFIXExtract.html">IPFIXExtract</a>
  * annotation to mark the variables that it wishes to be filled with
  * the [[InfoElement information element]] values from a [[Record]].
  * If a variable is marked but the corresponding element is not
  * present in the record from which the object is being filled, the
  * variables's value is left unchanged.
  *
  * The IPFIXExtract annotation defines two values that are used to
  * create a [[FieldSpec]] that is used to specify which element in
  * the Record is to used to fill the annotated variable. The two
  * values are:
  *
  *  - `name` is a `String` and must be specified: it is
  *     the name of the [[InfoElement information element]] to use.
  *
  *  - `nth` is an `int` that is optional: it specifies which `name`
  *     element to choose when multiple `name` elements are present on
  *     the record; the first `name` field is chosen when `nth` is not
  *     specified.
  *
  * It is important that the types of the variables in the [[Fillable]]
  * object match the IPFIX data types of the referenced IPFIX fields. If
  * they do not, a java.lang.ClassCastException will be thrown when the
  * record is filled. See [[Record]] for a mapping from IPFIX data type
  * to Java data type.
  *
  * @example Here is a class whose `sport` and `dport` variables can
  * be filled by a record's `sourceTransportPort` and
  * `destinationTransportPort` elements:
  *
  * {{{
  * class Ports extends Fillable {
  *   @IPFIXExtract(name="sourceTransportPort")
  *   var sport: Int = _
  *
  *   @IPFIXExtract(name="destinationTransportPort")
  *   var dport: Int = _
  * }
  * }}}
  *
  * @see <a target="_top" href="../../../../../javadoc/index.html?org/cert/netsa/io/ipfix/IPFIXExtract.html">IPFIXExtract</a>
  * @see [[Record]]
  */
trait Fillable

// @LICENSE_FOOTER@
//
// Copyright 2015-2022 Carnegie Mellon University. All Rights Reserved.
//
// This material is based upon work funded and supported by the
// Department of Defense and Department of Homeland Security under
// Contract No. FA8702-15-D-0002 with Carnegie Mellon University for the
// operation of the Software Engineering Institute, a federally funded
// research and development center sponsored by the United States
// Department of Defense. The U.S. Government has license rights in this
// software pursuant to DFARS 252.227.7014.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
// INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
// UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
// IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
// FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
// OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
// MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
// TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
// contact permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public
// release and unlimited distribution. Please see Copyright notice for
// non-US Government use and distribution.
//
// Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
// Trademark Office by Carnegie Mellon University.
//
// This software includes and/or makes use of third party software each
// subject to its own license as detailed in LICENSE-thirdparty.tx
//
// DM20-1143
