/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.DataInputStream;
import java.io.InputStream;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$;
import org.cert.netsa.io.silk.FileFormat;
import org.cert.netsa.io.silk.FileFormat$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.HeaderEntry$EndOfHeaders$;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.SilkVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple8;
import scala.collection.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Header$
implements Serializable {
    public static final Header$ MODULE$;
    private final byte FileVersion;
    private final byte BigEndian;
    private final byte LittleEndian;
    private final int magicNumber;

    static {
        new Header$();
    }

    public byte FileVersion() {
        return this.FileVersion;
    }

    public byte BigEndian() {
        return this.BigEndian;
    }

    public byte LittleEndian() {
        return this.LittleEndian;
    }

    public int magicNumber() {
        return this.magicNumber;
    }

    public Header readFrom(InputStream inputStream) {
        DataInputStream dataInputStream;
        InputStream inputStream2 = inputStream;
        DataInputStream dataInputStream2 = inputStream2 instanceof DataInputStream ? (dataInputStream = (DataInputStream)inputStream2) : new DataInputStream(inputStream2);
        DataInputStream in = dataInputStream2;
        return this.readHeader(in);
    }

    private Header readHeader(DataInputStream in) {
        int magic = in.readInt();
        if (magic != this.magicNumber()) {
            throw new SilkDataFormatException("Magic number does not match");
        }
        byte fileFlags = in.readByte();
        FileFormat fileFormat = FileFormat$.MODULE$.apply(in.readByte());
        byte fileVersion = in.readByte();
        CompressionMethod compressionMethod = CompressionMethod$.MODULE$.apply(in.readByte());
        if (fileVersion != this.FileVersion()) {
            String dir = fileVersion < this.FileVersion() ? "old: " : "new: ";
            throw new SilkDataFormatException(new StringBuilder().append((Object)"File version too ").append((Object)dir).append((Object)BoxesRunTime.boxToByte((byte)fileVersion)).toString());
        }
        int silkVersion = in.readInt();
        short recordSize = in.readShort();
        short recordVersion = in.readShort();
        IndexedSeq<HeaderEntry> headerEntries = this.readHeaderEntries(in);
        return new Header(fileFlags, fileFormat, fileVersion, compressionMethod, silkVersion, recordSize, recordVersion, headerEntries);
    }

    private IndexedSeq<HeaderEntry> readHeaderEntries(DataInputStream in) {
        return package$.MODULE$.Iterator().continually((Function0)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$1;

            public final HeaderEntry apply() {
                return Header$.MODULE$.org$cert$netsa$io$silk$Header$$readHeaderEntry(this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        }).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HeaderEntry x$1) {
                HeaderEntry headerEntry = x$1;
                HeaderEntry$EndOfHeaders$ headerEntry$EndOfHeaders$ = HeaderEntry$EndOfHeaders$.MODULE$;
                return headerEntry != null ? !headerEntry.equals(headerEntry$EndOfHeaders$) : headerEntry$EndOfHeaders$ != null;
            }
        }).toIndexedSeq();
    }

    public HeaderEntry org$cert$netsa$io$silk$Header$$readHeaderEntry(DataInputStream in) {
        HeaderEntry headerEntry;
        int headerEntryId = in.readInt();
        int headerEntryLength = in.readInt();
        int n = headerEntryId;
        switch (n) {
            default: {
                byte[] buf = (byte[])Array$.MODULE$.ofDim(headerEntryLength - 8, ClassTag$.MODULE$.Byte());
                in.readFully(buf);
                headerEntry = new HeaderEntry.Unknown(headerEntryId, buf);
                break;
            }
            case 7: {
                int childNode = in.readInt();
                int leafCount = in.readInt();
                int leafSize = in.readInt();
                int nodeCount = in.readInt();
                int nodeSize = in.readInt();
                int rootIndex = in.readInt();
                headerEntry = new HeaderEntry.IPSet(childNode, leafCount, leafSize, nodeCount, nodeSize, rootIndex);
                break;
            }
            case 6: {
                short keyType = in.readShort();
                short keyLength = in.readShort();
                short counterType = in.readShort();
                short counterLength = in.readShort();
                headerEntry = new HeaderEntry.Bag(keyType, keyLength, counterType, counterLength);
                break;
            }
            case 5: {
                int version2 = in.readInt();
                byte[] buf = (byte[])Array$.MODULE$.ofDim(headerEntryLength - 8 - 4, ClassTag$.MODULE$.Byte());
                in.readFully(buf);
                int end = Predef$.MODULE$.byteArrayOps(buf).indexWhere((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(byte b) {
                        return b == 0;
                    }
                });
                String mapName = new String((char[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(buf).take(end)).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final char apply(byte b) {
                        return (char)(b & 0xFF);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())));
                headerEntry = new HeaderEntry.PrefixMap(version2, mapName);
                break;
            }
            case 4: {
                byte[] buf = (byte[])Array$.MODULE$.ofDim(headerEntryLength - 8, ClassTag$.MODULE$.Byte());
                in.readFully(buf);
                String probeName2 = new String((char[])Predef$.MODULE$.byteArrayOps(buf).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final char apply(byte b) {
                        return (char)(b & 0xFF);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())));
                headerEntry = new HeaderEntry.ProbeName(probeName2);
                break;
            }
            case 3: {
                byte[] buf = (byte[])Array$.MODULE$.ofDim(headerEntryLength - 8, ClassTag$.MODULE$.Byte());
                in.readFully(buf);
                String annotation = new String((char[])Predef$.MODULE$.byteArrayOps(buf).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final char apply(byte b) {
                        return (char)(b & 0xFF);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())));
                headerEntry = new HeaderEntry.Annotation(annotation);
                break;
            }
            case 2: {
                byte[] buf = (byte[])Array$.MODULE$.ofDim(headerEntryLength - 8, ClassTag$.MODULE$.Byte());
                in.readFully(buf);
                String commandLine = new String((char[])Predef$.MODULE$.byteArrayOps(buf).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final char apply(byte b) {
                        return (char)(b & 0xFF);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())));
                headerEntry = new HeaderEntry.Invocation(commandLine);
                break;
            }
            case 1: {
                long startTime = in.readLong();
                byte flowtypeId = (byte)in.readInt();
                short sensorId2 = (short)in.readInt();
                headerEntry = new HeaderEntry.PackedFile(startTime, flowtypeId, sensorId2);
                break;
            }
            case 0: {
                in.skipBytes(headerEntryLength - 8);
                headerEntry = HeaderEntry$EndOfHeaders$.MODULE$;
            }
        }
        return headerEntry;
    }

    public Header apply(byte fileFlags, FileFormat fileFormat, byte fileVersion, CompressionMethod compressionMethod, int silkVersion, short recordSize, short recordVersion, IndexedSeq<HeaderEntry> headerEntries) {
        return new Header(fileFlags, fileFormat, fileVersion, compressionMethod, silkVersion, recordSize, recordVersion, headerEntries);
    }

    public Option<Tuple8<Object, FileFormat, Object, CompressionMethod, SilkVersion, Object, Object, IndexedSeq<HeaderEntry>>> unapply(Header x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)BoxesRunTime.boxToByte((byte)x$0.fileFlags()), (Object)x$0.fileFormat(), (Object)BoxesRunTime.boxToByte((byte)x$0.fileVersion()), (Object)x$0.compressionMethod(), (Object)new SilkVersion(x$0.silkVersion()), (Object)BoxesRunTime.boxToShort((short)x$0.recordSize()), (Object)BoxesRunTime.boxToShort((short)x$0.recordVersion()), x$0.headerEntries()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Header$() {
        MODULE$ = this;
        this.FileVersion = (byte)16;
        this.BigEndian = 1;
        this.LittleEndian = 0;
        this.magicNumber = -559038737;
    }
}

