/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$FT_IPSET$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.IPSetReader;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ipset.IPSetV2Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV3IPv4Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV3IPv6Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV4IPv4Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV4IPv6Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV5Reader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class IPSetReader$ {
    public static final IPSetReader$ MODULE$;

    static {
        new IPSetReader$();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Header, Object> checkHeader(InputStream s) {
        Header header = Header$.MODULE$.readFrom(s);
        boolean isIPv6 = false;
        if (((Object)((Object)FileFormat$FT_IPSET$.MODULE$)).equals((Object)header.fileFormat())) {
            void var3_3;
            void var2_2;
            if (1 != header.recordSize()) {
                throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected record size: ").append((Object)BoxesRunTime.boxToShort((short)header.recordSize())).toString());
            }
            short s2 = header.recordVersion();
            switch (s2) {
                default: {
                    throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected record version: ").append((Object)BoxesRunTime.boxToShort((short)header.recordVersion())).toString());
                }
                case 3: 
                case 4: 
                case 5: {
                    HeaderEntry.IPSet iPSet;
                    Option hentry_opt;
                    Option option = hentry_opt = header.headerEntries().collectFirst((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends HeaderEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof HeaderEntry.IPSet) {
                                HeaderEntry.IPSet iPSet = (HeaderEntry.IPSet)A1;
                                object = iPSet;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(HeaderEntry x1) {
                            HeaderEntry headerEntry = x1;
                            boolean bl = headerEntry instanceof HeaderEntry.IPSet;
                            return bl;
                        }
                    });
                    if (None$.MODULE$.equals(option)) {
                        throw new SilkDataFormatException("File is missing the IPset header entry");
                    }
                    HeaderEntry.IPSet hentry = iPSet = (HeaderEntry.IPSet)hentry_opt.get();
                    if (3 == header.recordVersion()) {
                        boolean leafIsV6;
                        boolean bl;
                        if (16 != hentry.childNode()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected child-per-node count: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.childNode())).toString());
                        }
                        int n = hentry.nodeSize();
                        switch (n) {
                            default: {
                                throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected node size: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.nodeSize())).toString());
                            }
                            case 80: {
                                bl = false;
                                break;
                            }
                            case 96: {
                                bl = true;
                            }
                        }
                        boolean nodeIsV6 = bl;
                        int n2 = hentry.leafSize();
                        switch (n2) {
                            default: {
                                throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected leaf size: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.leafSize())).toString());
                            }
                            case 8: {
                                boolean bl2 = false;
                                break;
                            }
                            case 24: {
                                boolean bl2 = leafIsV6 = true;
                            }
                        }
                        if (nodeIsV6 != leafIsV6) {
                            throw new SilkDataFormatException("IPset file has mismatched node and leaf sizes");
                        }
                        isIPv6 = nodeIsV6;
                    } else {
                        int n = hentry.leafSize();
                        switch (n) {
                            default: {
                                throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected leaf size: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.leafSize())).toString());
                            }
                            case 4: {
                                boolean bl = false;
                                break;
                            }
                            case 16: {
                                boolean bl = isIPv6 = true;
                            }
                        }
                        if (!isIPv6 && 5 == header.recordVersion()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected leaf size: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.leafSize())).toString());
                        }
                        if (0 != hentry.childNode()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected child-per-node count: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.childNode())).toString());
                        }
                        if (0 != hentry.nodeCount()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected node count: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.nodeCount())).toString());
                        }
                        if (0 != hentry.nodeSize()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected node size: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.nodeSize())).toString());
                        }
                        if (0 != hentry.leafCount()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected leaf count: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.leafCount())).toString());
                        }
                        if (0 != hentry.rootIndex()) {
                            throw new SilkDataFormatException(new StringBuilder().append((Object)"IPset file has unexpected root index: ").append((Object)BoxesRunTime.boxToInteger((int)hentry.rootIndex())).toString());
                        }
                    }
                    return new Tuple2((Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv6));
                }
                case 2: 
            }
            return new Tuple2((Object)var2_2, (Object)BoxesRunTime.boxToBoolean((boolean)var3_3));
        }
        throw new SilkDataFormatException("File is not an IPset file");
    }

    private IPSetReader createReader(BufferReader bufferReader, Header header, boolean isIPv6) {
        short s = header.recordVersion();
        switch (s) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToShort((short)s));
            }
            case 5: {
                return new IPSetV5Reader(bufferReader, header);
            }
            case 4: {
                if (isIPv6) {
                    return new IPSetV4IPv6Reader(bufferReader, header);
                }
                return new IPSetV4IPv4Reader(bufferReader, header);
            }
            case 3: {
                if (isIPv6) {
                    return new IPSetV3IPv6Reader(bufferReader, header);
                }
                return new IPSetV3IPv4Reader(bufferReader, header);
            }
            case 2: 
        }
        return new IPSetV2Reader(bufferReader, header);
    }

    public IPSetReader ofInputStream(InputStream s) {
        Tuple2<Header, Object> tuple2;
        block2: {
            block6: {
                BufferReader bufferReader;
                boolean isIPv6;
                Header header;
                block4: {
                    CompressionMethod compressionMethod;
                    block5: {
                        block3: {
                            Tuple2 tuple22;
                            tuple2 = this.checkHeader(s);
                            if (tuple2 == null) break block2;
                            Header header2 = (Header)tuple2._1();
                            boolean isIPv62 = tuple2._2$mcZ$sp();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)header2, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv62));
                            header = (Header)tuple23._1();
                            isIPv6 = tuple23._2$mcZ$sp();
                            int bufferSize = 65536;
                            compressionMethod = header.compressionMethod();
                            if (!((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) break block3;
                            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
                            break block4;
                        }
                        if (!((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) break block5;
                        bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(s);
                        break block4;
                    }
                    if (!((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) break block6;
                    bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(s);
                }
                RawInputStreamBuffer bufferReader2 = bufferReader;
                return this.createReader(bufferReader2, header, isIPv6);
            }
            throw new SilkDataFormatException("Unsupported compression method (without Hadoop)");
        }
        throw new MatchError(tuple2);
    }

    public IPSetReader ofInputStream(Configuration conf, InputStream s) {
        Tuple2<Header, Object> tuple2;
        block2: {
            block7: {
                BufferReader bufferReader;
                boolean isIPv6;
                Header header;
                block4: {
                    CompressionMethod compressionMethod;
                    block6: {
                        block5: {
                            block3: {
                                Tuple2 tuple22;
                                tuple2 = this.checkHeader(s);
                                if (tuple2 == null) break block2;
                                Header header2 = (Header)tuple2._1();
                                boolean isIPv62 = tuple2._2$mcZ$sp();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)header2, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv62));
                                header = (Header)tuple23._1();
                                isIPv6 = tuple23._2$mcZ$sp();
                                int bufferSize = 65536;
                                compressionMethod = header.compressionMethod();
                                if (!((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) break block3;
                                bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
                                break block4;
                            }
                            if (!((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) break block5;
                            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(conf, s);
                            break block4;
                        }
                        if (!((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod)) break block6;
                        bufferReader = LzoInputStreamBuffer$.MODULE$.apply(conf, s);
                        break block4;
                    }
                    if (!((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) break block7;
                    bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(conf, s);
                }
                RawInputStreamBuffer bufferReader2 = bufferReader;
                return this.createReader(bufferReader2, header, isIPv6);
            }
            throw new SilkDataFormatException("Unrecognized compression method");
        }
        throw new MatchError(tuple2);
    }

    private IPSetReader$() {
        MODULE$ = this;
    }
}

