/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.PrefixMapResult;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibInputStreamBuffer$;
import org.cert.netsa.io.silk.io.prefixmap.PrefixMapReaderIPv4;
import org.cert.netsa.io.silk.io.prefixmap.PrefixMapReaderIPv6;
import org.cert.netsa.io.silk.io.prefixmap.PrefixMapReaderProtoPort;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class PrefixMapReader$ {
    public static final PrefixMapReader$ MODULE$;

    static {
        new PrefixMapReader$();
    }

    private PrefixMapResult createReader(BufferReader bufferReader, Header header) {
        PrefixMapResult prefixMapResult;
        if (header.recordVersion() < 1 || header.recordVersion() > 5) {
            throw new SilkDataFormatException(new StringBuilder().append((Object)"PrefixMap file has unexpected record version: ").append((Object)BoxesRunTime.boxToShort((short)header.recordVersion())).toString());
        }
        if (1 != header.recordSize()) {
            throw new SilkDataFormatException(new StringBuilder().append((Object)"PrefixMap file has unexpected recordLength: ").append((Object)BoxesRunTime.boxToShort((short)header.recordSize())).toString());
        }
        short s = header.recordVersion();
        switch (s) {
            default: {
                throw new SilkDataFormatException(new StringBuilder().append((Object)"PrefixMap file has unexpected record version: ").append((Object)BoxesRunTime.boxToShort((short)header.recordVersion())).toString());
            }
            case 5: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv6(bufferReader, header));
                break;
            }
            case 4: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv6(bufferReader, header));
                break;
            }
            case 3: {
                prefixMapResult = new PrefixMapResult.ProtocolPortPrefixMap(new PrefixMapReaderProtoPort(bufferReader, header));
                break;
            }
            case 2: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv4(bufferReader, header));
                break;
            }
            case 1: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv4(bufferReader, header));
            }
        }
        return prefixMapResult;
    }

    public PrefixMapResult ofInputStream(InputStream s) {
        block5: {
            BufferReader bufferReader;
            Header header;
            block3: {
                CompressionMethod compressionMethod;
                block4: {
                    block2: {
                        header = Header$.MODULE$.readFrom(s);
                        int bufferSize = 65536;
                        compressionMethod = header.compressionMethod();
                        if (!((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) break block2;
                        bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
                        break block3;
                    }
                    if (!((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) break block4;
                    bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(s);
                    break block3;
                }
                if (!((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) break block5;
                bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(s);
            }
            RawInputStreamBuffer bufferReader2 = bufferReader;
            return this.createReader(bufferReader2, header);
        }
        throw new SilkDataFormatException("Unsupported compression method (without Hadoop)");
    }

    public PrefixMapResult ofInputStream(Configuration conf, InputStream s) {
        block6: {
            BufferReader bufferReader;
            Header header;
            block3: {
                CompressionMethod compressionMethod;
                block5: {
                    block4: {
                        block2: {
                            header = Header$.MODULE$.readFrom(s);
                            int bufferSize = 65536;
                            compressionMethod = header.compressionMethod();
                            if (!((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) break block2;
                            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
                            break block3;
                        }
                        if (!((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) break block4;
                        bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(conf, s);
                        break block3;
                    }
                    if (!((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod)) break block5;
                    bufferReader = LzoInputStreamBuffer$.MODULE$.apply(conf, s);
                    break block3;
                }
                if (!((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) break block6;
                bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(conf, s);
            }
            RawInputStreamBuffer bufferReader2 = bufferReader;
            return this.createReader(bufferReader2, header);
        }
        throw new SilkDataFormatException("Unrecognized compression method");
    }

    private PrefixMapReader$() {
        MODULE$ = this;
    }
}

