/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.DataInputStream;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4Q!\u0001\u0002\u0001\t5\u0011A\u0003\u0014>p\u0013:\u0004X\u000f^*ue\u0016\fWNQ;gM\u0016\u0014(BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005!1/\u001b7l\u0015\t\u0019qA\u0003\u0002\t\u0013\u0005)a.\u001a;tC*\u0011!bC\u0001\u0005G\u0016\u0014HOC\u0001\r\u0003\ry'oZ\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\ta!)\u001e4gKJ\u0014V-\u00193fe\"A\u0011\u0004\u0001B\u0001B\u0003%1$A\u0007d_:4\u0017nZ;sCRLwN\\\u0002\u0001!\ta2%D\u0001\u001e\u0015\tqr$\u0001\u0003d_:4'B\u0001\u0011\"\u0003\u0019A\u0017\rZ8pa*\u0011!eC\u0001\u0007CB\f7\r[3\n\u0005\u0011j\"!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003!Ign\u0015;sK\u0006l\u0007C\u0001\u0015-\u001b\u0005I#BA\u0002+\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!L\u0015\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u00124\u0007\u0005\u0002\u0016\u0001!)\u0011D\fa\u00017!)aE\fa\u0001O!9Q\u0007\u0001b\u0001\n\u00131\u0014AA5o+\u00059\u0004C\u0001\u00159\u0013\tI\u0014FA\bECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0019Y\u0004\u0001)A\u0005o\u0005\u0019\u0011N\u001c\u0011\t\u000fu\u0002!\u0019!C\u0005}\u0005aA-Z2p[B\u0014Xm]:peV\tq\b\u0005\u0002A\t6\t\u0011I\u0003\u0002C\u0007\u0006A1m\\7qe\u0016\u001c8O\u0003\u0002\u0004?%\u0011Q)\u0011\u0002\r\t\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0005\u0007\u000f\u0002\u0001\u000b\u0011B \u0002\u001b\u0011,7m\\7qe\u0016\u001c8o\u001c:!\u0011\u0015I\u0005\u0001\"\u0001K\u0003\u0015\u0019Gn\\:f)\u0005Y\u0005CA\bM\u0013\ti\u0005C\u0001\u0003V]&$\b\"B(\u0001\t\u0003\u0001\u0016!D4fi:+\u0007\u0010\u001e\"vM\u001a,'\u000fF\u0001R!\u0011y!\u000b\u0016.\n\u0005M\u0003\"A\u0002+va2,'\u0007E\u0002\u0010+^K!A\u0016\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=A\u0016BA-\u0011\u0005\u0011\u0011\u0015\u0010^3\u0011\u0005=Y\u0016B\u0001/\u0011\u0005\rIe\u000e^\u0004\u0007=\nA\t\u0001B0\u0002)1Sx.\u00138qkR\u001cFO]3b[\n+hMZ3s!\t)\u0002M\u0002\u0004\u0002\u0005!\u0005A!Y\n\u0003A:AQa\f1\u0005\u0002\r$\u0012a\u0018\u0005\u0006K\u0002$\tAZ\u0001\u0006CB\u0004H.\u001f\u000b\u0004c\u001dD\u0007\"\u0002\u0010e\u0001\u0004Y\u0002\"\u0002\u0014e\u0001\u00049\u0003")
public class LzoInputStreamBuffer
implements BufferReader {
    private final Configuration configuration;
    private final DataInputStream in;
    private final Decompressor decompressor;

    public static LzoInputStreamBuffer apply(Configuration configuration, InputStream inputStream) {
        return LzoInputStreamBuffer$.MODULE$.apply(configuration, inputStream);
    }

    private DataInputStream in() {
        return this.in;
    }

    private Decompressor decompressor() {
        return this.decompressor;
    }

    @Override
    public void close() {
        this.in().close();
    }

    @Override
    public Tuple2<byte[], Object> getNextBuffer() {
        int compressedSize = this.in().readInt();
        int uncompressedSize = this.in().readInt();
        byte[] compressedData = (byte[])Array$.MODULE$.ofDim(compressedSize, ClassTag$.MODULE$.Byte());
        byte[] uncompressedData = (byte[])Array$.MODULE$.ofDim(uncompressedSize, ClassTag$.MODULE$.Byte());
        this.in().readFully(compressedData);
        this.decompressor().setInput(compressedData, 0, compressedSize);
        int uncompressedSizeResult = this.decompressor().decompress(uncompressedData, 0, uncompressedSize);
        Predef$.MODULE$.assert(this.decompressor().needsInput());
        Predef$.MODULE$.assert(uncompressedSizeResult == uncompressedSize);
        return new Tuple2((Object)uncompressedData, (Object)BoxesRunTime.boxToInteger((int)uncompressedSize));
    }

    private final Decompressor liftedTree1$1() {
        try {
            CompressionCodecFactory cf = new CompressionCodecFactory(this.configuration);
            CompressionCodec codec = cf.getCodecByName("lzo");
            return codec.createDecompressor();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create lzo decompressor--is lzo properly configured?", exception);
        }
    }

    public LzoInputStreamBuffer(Configuration configuration, InputStream inStream) {
        DataInputStream dataInputStream;
        this.configuration = configuration;
        InputStream inputStream = inStream;
        DataInputStream dataInputStream2 = inputStream instanceof DataInputStream ? (dataInputStream = (DataInputStream)inputStream) : new DataInputStream(inStream);
        this.in = dataInputStream2;
        this.decompressor = this.liftedTree1$1();
    }
}

