/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.DataOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.SnappyOutputStreamBuffer$;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0001\t5\u0011\u0001d\u00158baBLx*\u001e;qkR\u001cFO]3b[\n+hMZ3s\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005g&d7N\u0003\u0002\u0004\u000f)\u0011\u0001\"C\u0001\u0006]\u0016$8/\u0019\u0006\u0003\u0015-\tAaY3si*\tA\"A\u0002pe\u001e\u001c2\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\r\u0005V4g-\u001a:Xe&$XM\u001d\u0005\t3\u0001\u0011\t\u0011)A\u00057\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u001c\u0001\u0001\u0005\u0002\u001dG5\tQD\u0003\u0002\u001f?\u0005!1m\u001c8g\u0015\t\u0001\u0013%\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003E-\ta!\u00199bG\",\u0017B\u0001\u0013\u001e\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"Aa\u0005\u0001B\u0001B\u0003%q%A\u0005pkR\u001cFO]3b[B\u0011\u0001\u0006L\u0007\u0002S)\u00111A\u000b\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0013F\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u00030\u0001\u0011\u0005\u0001'\u0001\u0004=S:LGO\u0010\u000b\u0004cI\u001a\u0004CA\u000b\u0001\u0011\u0015Ib\u00061\u0001\u001c\u0011\u00151c\u00061\u0001(\u0011\u001d)\u0004A1A\u0005\nY\n1a\\;u+\u00059\u0004C\u0001\u00159\u0013\tI\u0014F\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\"11\b\u0001Q\u0001\n]\nAa\\;uA!9Q\b\u0001b\u0001\n\u0013q\u0014AC2p[B\u0014Xm]:peV\tq\b\u0005\u0002A\t6\t\u0011I\u0003\u0002C\u0007\u0006A1m\\7qe\u0016\u001c8O\u0003\u0002\u0004?%\u0011Q)\u0011\u0002\u000b\u0007>l\u0007O]3tg>\u0014\bBB$\u0001A\u0003%q(A\u0006d_6\u0004(/Z:t_J\u0004\u0003BB%\u0001A\u0013%!*A\u0007d_6\u0004(/Z:t\u0005>,h\u000e\u001a\u000b\u0003\u0017:\u0003\"a\u0004'\n\u00055\u0003\"aA%oi\")q\n\u0013a\u0001\u0017\u0006I1o\\;sG\u0016dUM\u001c\u0005\u0006#\u0002!\tAU\u0001\u0004K:$G#A*\u0011\u0005=!\u0016BA+\u0011\u0005\u0011)f.\u001b;\t\u000b]\u0003A\u0011\u0001-\u0002\u0013A,HOQ;gM\u0016\u0014HcA*ZC\")!L\u0016a\u00017\u0006\u0001RO\\2p[B\u0014Xm]:fI\u0012\u000bG/\u0019\t\u0004\u001fqs\u0016BA/\u0011\u0005\u0015\t%O]1z!\tyq,\u0003\u0002a!\t!!)\u001f;f\u0011\u0015\u0011g\u000b1\u0001L\u0003A)hnY8naJ,7o]3e'&TXm\u0002\u0004e\u0005!\u0005A!Z\u0001\u0019':\f\u0007\u000f]=PkR\u0004X\u000f^*ue\u0016\fWNQ;gM\u0016\u0014\bCA\u000bg\r\u0019\t!\u0001#\u0001\u0005ON\u0011aM\u0004\u0005\u0006_\u0019$\t!\u001b\u000b\u0002K\")1N\u001aC\u0001Y\u0006)\u0011\r\u001d9msR\u0019\u0011'\u001c8\t\u000byQ\u0007\u0019A\u000e\t\u000b\u0019R\u0007\u0019A\u0014")
public class SnappyOutputStreamBuffer
implements BufferWriter {
    private final DataOutputStream out;
    private final Compressor compressor;

    public static SnappyOutputStreamBuffer apply(Configuration configuration, OutputStream outputStream) {
        return SnappyOutputStreamBuffer$.MODULE$.apply(configuration, outputStream);
    }

    private DataOutputStream out() {
        return this.out;
    }

    private Compressor compressor() {
        return this.compressor;
    }

    private int compressBound(int sourceLen) {
        return 32 + sourceLen + sourceLen / 6;
    }

    @Override
    public void end() {
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().end();
        this.out().flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putBuffer(byte[] uncompressedData, int uncompressedSize) {
        if (0 == uncompressedSize) {
            return;
        }
        int maxCompressedSize = this.compressBound(uncompressedSize);
        byte[] compressedData = (byte[])Array$.MODULE$.ofDim(maxCompressedSize, ClassTag$.MODULE$.Byte());
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().setInput(uncompressedData, 0, uncompressedSize);
        this.compressor().finish();
        int compressedSize = this.compressor().compress(compressedData, 0, maxCompressedSize);
        this.out().writeInt(compressedSize);
        this.out().writeInt(uncompressedSize);
        this.out().write(compressedData, 0, compressedSize);
        while (true) {
            void var3_3;
            void var4_4;
            if (this.compressor().finished()) {
                Predef$.MODULE$.assert(this.compressor().needsInput());
                Predef$.MODULE$.assert(0 == this.compressor().compress(compressedData, 0, maxCompressedSize));
                this.compressor().reset();
                return;
            }
            int size = this.compressor().compress((byte[])var4_4, 0, (int)var3_3);
            this.out().write((byte[])var4_4, 0, size);
        }
    }

    public SnappyOutputStreamBuffer(Configuration configuration, OutputStream outStream) {
        DataOutputStream dataOutputStream;
        OutputStream outputStream = outStream;
        DataOutputStream dataOutputStream2 = outputStream instanceof DataOutputStream ? (dataOutputStream = (DataOutputStream)outputStream) : new DataOutputStream(outStream);
        this.out = dataOutputStream2;
        CompressionCodecFactory cf = new CompressionCodecFactory(configuration);
        CompressionCodec c = cf.getCodecByName("snappy");
        this.compressor = c.createCompressor();
    }
}

