/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.DataOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.LzoOutputStreamBuffer$;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0001\t5\u0011Q\u0003\u0014>p\u001fV$\b/\u001e;TiJ,\u0017-\u001c\"vM\u001a,'O\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\tAa]5mW*\u00111a\u0002\u0006\u0003\u0011%\tQA\\3ug\u0006T!AC\u0006\u0002\t\r,'\u000f\u001e\u0006\u0002\u0019\u0005\u0019qN]4\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011ABQ;gM\u0016\u0014xK]5uKJD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0004\u0001A\u0011AdI\u0007\u0002;)\u0011adH\u0001\u0005G>tgM\u0003\u0002!C\u00051\u0001.\u00193p_BT!AI\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!SDA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005Iq.\u001e;TiJ,\u0017-\u001c\t\u0003Q1j\u0011!\u000b\u0006\u0003\u0007)R\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.S\taq*\u001e;qkR\u001cFO]3b[\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"2!\r\u001a4!\t)\u0002\u0001C\u0003\u001a]\u0001\u00071\u0004C\u0003']\u0001\u0007q\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u0007=,H/F\u00018!\tA\u0003(\u0003\u0002:S\t\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0007w\u0001\u0001\u000b\u0011B\u001c\u0002\t=,H\u000f\t\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003)\u0019w.\u001c9sKN\u001cxN]\u000b\u0002\u007fA\u0011\u0001\tR\u0007\u0002\u0003*\u0011!iQ\u0001\tG>l\u0007O]3tg*\u00111aH\u0005\u0003\u000b\u0006\u0013!bQ8naJ,7o]8s\u0011\u00199\u0005\u0001)A\u0005\u007f\u0005Y1m\\7qe\u0016\u001c8o\u001c:!\u0011\u0019I\u0005\u0001)C\u0005\u0015\u0006i1m\\7qe\u0016\u001c8OQ8v]\u0012$\"a\u0013(\u0011\u0005=a\u0015BA'\u0011\u0005\rIe\u000e\u001e\u0005\u0006\u001f\"\u0003\raS\u0001\ng>,(oY3MK:DQ!\u0015\u0001\u0005\u0002I\u000b1!\u001a8e)\u0005\u0019\u0006CA\bU\u0013\t)\u0006C\u0001\u0003V]&$\b\"B,\u0001\t\u0003A\u0016!\u00039vi\n+hMZ3s)\r\u0019\u0016,\u0019\u0005\u00065Z\u0003\raW\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\r\u001a#bi\u0006\u00042a\u0004/_\u0013\ti\u0006CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010?&\u0011\u0001\r\u0005\u0002\u0005\u0005f$X\rC\u0003c-\u0002\u00071*\u0001\tv]\u000e|W\u000e\u001d:fgN,GmU5{K\u001e1AM\u0001E\u0001\t\u0015\fQ\u0003\u0014>p\u001fV$\b/\u001e;TiJ,\u0017-\u001c\"vM\u001a,'\u000f\u0005\u0002\u0016M\u001a1\u0011A\u0001E\u0001\t\u001d\u001c\"A\u001a\b\t\u000b=2G\u0011A5\u0015\u0003\u0015DQa\u001b4\u0005\u00021\fQ!\u00199qYf$2!M7o\u0011\u0015q\"\u000e1\u0001\u001c\u0011\u00151#\u000e1\u0001(\u0001")
public class LzoOutputStreamBuffer
implements BufferWriter {
    private final Configuration configuration;
    private final DataOutputStream out;
    private final Compressor compressor;

    public static LzoOutputStreamBuffer apply(Configuration configuration, OutputStream outputStream) {
        return LzoOutputStreamBuffer$.MODULE$.apply(configuration, outputStream);
    }

    private DataOutputStream out() {
        return this.out;
    }

    private Compressor compressor() {
        return this.compressor;
    }

    private int compressBound(int sourceLen) {
        return sourceLen + (sourceLen >>> 4) + 64 + 3;
    }

    @Override
    public void end() {
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().end();
        this.out().flush();
    }

    @Override
    public void putBuffer(byte[] uncompressedData, int uncompressedSize) {
        if (0 == uncompressedSize) {
            return;
        }
        int maxCompressedSize = this.compressBound(uncompressedSize);
        byte[] compressedData = (byte[])Array$.MODULE$.ofDim(maxCompressedSize, ClassTag$.MODULE$.Byte());
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().setInput(uncompressedData, 0, uncompressedSize);
        int compressedSize = this.compressor().compress(compressedData, 0, maxCompressedSize);
        this.out().writeInt(compressedSize);
        this.out().writeInt(uncompressedSize);
        this.out().write(compressedData, 0, compressedSize);
        Predef$.MODULE$.assert(this.compressor().needsInput());
        Predef$.MODULE$.assert(0 == this.compressor().compress(compressedData, 0, maxCompressedSize));
        this.compressor().reset();
    }

    private final Compressor liftedTree1$1() {
        try {
            CompressionCodecFactory cf = new CompressionCodecFactory(this.configuration);
            CompressionCodec c = cf.getCodecByName("lzo");
            return c.createCompressor();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create lzo compressor--is lzo properly configured?", exception);
        }
    }

    public LzoOutputStreamBuffer(Configuration configuration, OutputStream outStream) {
        DataOutputStream dataOutputStream;
        this.configuration = configuration;
        OutputStream outputStream = outStream;
        DataOutputStream dataOutputStream2 = outputStream instanceof DataOutputStream ? (dataOutputStream = (DataOutputStream)outputStream) : new DataOutputStream(outStream);
        this.out = dataOutputStream2;
        this.compressor = this.liftedTree1$1();
    }
}

