/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io.unpackers;

import java.time.Duration;
import java.time.Instant;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.Unpacker;

public final class FT_RWGENERIC_v3$
implements Unpacker {
    public static final FT_RWGENERIC_v3$ MODULE$;
    private final int recordLength;

    static {
        new FT_RWGENERIC_v3$();
    }

    @Override
    public int recordLength() {
        return this.recordLength;
    }

    @Override
    public RWRec unpack(byte[] buffer, int offset, boolean swap, Header header) {
        IPv4Address sIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset, swap);
        IPv4Address dIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 4, swap);
        short sPort = BufferUtil$.MODULE$.getPort(buffer, offset + 8, swap);
        short dPort = BufferUtil$.MODULE$.getPort(buffer, offset + 10, swap);
        IPv4Address nhIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 12, swap);
        int input = BufferUtil$.MODULE$.getSNMPInterface16(buffer, offset + 16, swap);
        int output = BufferUtil$.MODULE$.getSNMPInterface16(buffer, offset + 18, swap);
        long startTimeSecs = Integer.toUnsignedLong(BufferUtil$.MODULE$.getInt32(buffer, offset + 20, swap));
        long elapsedSecs = Integer.toUnsignedLong(BufferUtil$.MODULE$.getInt32(buffer, offset + 24, swap));
        long packets = BufferUtil$.MODULE$.getPackets32(buffer, offset + 28, swap);
        long bytes = BufferUtil$.MODULE$.getBytes32(buffer, offset + 32, swap);
        byte protocol = BufferUtil$.MODULE$.getProtocol(buffer, offset + 36, swap);
        byte flowType = BufferUtil$.MODULE$.getFlowType(buffer, offset + 37, swap);
        short sensor2 = BufferUtil$.MODULE$.getSensor16(buffer, offset + 38, swap);
        byte flags = BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 40, swap);
        byte initFlags = BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 41, swap);
        byte restFlags = BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 42, swap);
        byte tcpState = BufferUtil$.MODULE$.getTCPState(buffer, offset + 43, swap);
        int startTimeMsecs = Short.toUnsignedInt(BufferUtil$.MODULE$.getInt16(buffer, offset + 48, swap));
        int elapsedMsecs = Short.toUnsignedInt(BufferUtil$.MODULE$.getInt16(buffer, offset + 50, swap));
        Instant startTime = Instant.ofEpochMilli(startTimeSecs * 1000L + (long)startTimeMsecs);
        Duration elapsed = Duration.ofMillis(elapsedSecs * 1000L + (long)elapsedMsecs);
        short application = BufferUtil$.MODULE$.getPort(buffer, offset + 52, swap);
        short memo = 0;
        return BufferUtil$.MODULE$.TCPStateFixHelper(new RWRec(startTime, elapsed, sPort, dPort, protocol, flowType, sensor2, flags, initFlags, restFlags, tcpState, application, memo, input, output, packets, bytes, (IPAddress)sIP, (IPAddress)dIP, (IPAddress)nhIP)).maybeClearTCPStateExpanded();
    }

    private FT_RWGENERIC_v3$() {
        MODULE$ = this;
        this.recordLength = 56;
    }
}

