/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$FT_IPSET$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.IPSetReader;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ipset.IPSetV2Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV3IPv4Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV3IPv6Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV4IPv4Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV4IPv6Reader;
import org.cert.netsa.io.silk.io.ipset.IPSetV5Reader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class IPSetReader$ {
    public static IPSetReader$ MODULE$;

    static {
        new IPSetReader$();
    }

    private Tuple2<Header, Object> checkHeader(InputStream s) {
        HeaderEntry.IPSet iPSet;
        Option hentry_opt;
        Header header = Header$.MODULE$.readFrom(s);
        boolean isIPv6 = false;
        if (!((Object)((Object)FileFormat$FT_IPSET$.MODULE$)).equals((Object)header.fileFormat())) {
            throw new SilkDataFormatException("File is not an IPset file");
        }
        if (1 != header.recordSize()) {
            throw new SilkDataFormatException(new StringBuilder(39).append("IPset file has unexpected record size: ").append(header.recordSize()).toString());
        }
        short s2 = header.recordVersion();
        switch (s2) {
            case 2: {
                return new Tuple2((Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv6));
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new SilkDataFormatException(new StringBuilder(42).append("IPset file has unexpected record version: ").append(header.recordVersion()).toString());
            }
        }
        Option option = hentry_opt = header.headerEntries().collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends HeaderEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof HeaderEntry.IPSet) {
                    HeaderEntry.IPSet iPSet = (HeaderEntry.IPSet)A1;
                    object = iPSet;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(HeaderEntry x1) {
                HeaderEntry headerEntry = x1;
                boolean bl = headerEntry instanceof HeaderEntry.IPSet;
                return bl;
            }
        });
        if (None$.MODULE$.equals(option)) {
            throw new SilkDataFormatException("File is missing the IPset header entry");
        }
        HeaderEntry.IPSet hentry = iPSet = (HeaderEntry.IPSet)hentry_opt.get();
        if (3 == header.recordVersion()) {
            boolean bl;
            boolean bl2;
            if (16 != hentry.childNode()) {
                throw new SilkDataFormatException(new StringBuilder(48).append("IPset file has unexpected child-per-node count: ").append(hentry.childNode()).toString());
            }
            int n = hentry.nodeSize();
            switch (n) {
                case 96: {
                    bl2 = true;
                    break;
                }
                case 80: {
                    bl2 = false;
                    break;
                }
                default: {
                    throw new SilkDataFormatException(new StringBuilder(37).append("IPset file has unexpected node size: ").append(hentry.nodeSize()).toString());
                }
            }
            boolean nodeIsV6 = bl2;
            int n2 = hentry.leafSize();
            switch (n2) {
                case 24: {
                    bl = true;
                    break;
                }
                case 8: {
                    bl = false;
                    break;
                }
                default: {
                    throw new SilkDataFormatException(new StringBuilder(37).append("IPset file has unexpected leaf size: ").append(hentry.leafSize()).toString());
                }
            }
            boolean leafIsV6 = bl;
            if (nodeIsV6 != leafIsV6) {
                throw new SilkDataFormatException("IPset file has mismatched node and leaf sizes");
            }
            isIPv6 = nodeIsV6;
        } else {
            boolean bl;
            int n = hentry.leafSize();
            switch (n) {
                case 16: {
                    bl = true;
                    break;
                }
                case 4: {
                    bl = false;
                    break;
                }
                default: {
                    throw new SilkDataFormatException(new StringBuilder(37).append("IPset file has unexpected leaf size: ").append(hentry.leafSize()).toString());
                }
            }
            isIPv6 = bl;
            if (!isIPv6 && 5 == header.recordVersion()) {
                throw new SilkDataFormatException(new StringBuilder(37).append("IPset file has unexpected leaf size: ").append(hentry.leafSize()).toString());
            }
            if (0 != hentry.childNode()) {
                throw new SilkDataFormatException(new StringBuilder(48).append("IPset file has unexpected child-per-node count: ").append(hentry.childNode()).toString());
            }
            if (0 != hentry.nodeCount()) {
                throw new SilkDataFormatException(new StringBuilder(38).append("IPset file has unexpected node count: ").append(hentry.nodeCount()).toString());
            }
            if (0 != hentry.nodeSize()) {
                throw new SilkDataFormatException(new StringBuilder(37).append("IPset file has unexpected node size: ").append(hentry.nodeSize()).toString());
            }
            if (0 != hentry.leafCount()) {
                throw new SilkDataFormatException(new StringBuilder(38).append("IPset file has unexpected leaf count: ").append(hentry.leafCount()).toString());
            }
            if (0 != hentry.rootIndex()) {
                throw new SilkDataFormatException(new StringBuilder(38).append("IPset file has unexpected root index: ").append(hentry.rootIndex()).toString());
            }
        }
        return new Tuple2((Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv6));
    }

    private IPSetReader createReader(BufferReader bufferReader, Header header, boolean isIPv6) {
        short s = header.recordVersion();
        switch (s) {
            case 2: {
                return new IPSetV2Reader(bufferReader, header);
            }
            case 3: {
                if (isIPv6) {
                    return new IPSetV3IPv6Reader(bufferReader, header);
                }
                return new IPSetV3IPv4Reader(bufferReader, header);
            }
            case 4: {
                if (isIPv6) {
                    return new IPSetV4IPv6Reader(bufferReader, header);
                }
                return new IPSetV4IPv4Reader(bufferReader, header);
            }
            case 5: {
                return new IPSetV5Reader(bufferReader, header);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToShort((short)s));
    }

    public IPSetReader ofInputStream(InputStream s) {
        BufferReader bufferReader;
        Tuple2<Header, Object> tuple2 = this.checkHeader(s);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Header header = (Header)tuple2._1();
        boolean isIPv6 = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv6));
        Tuple2 tuple23 = tuple22;
        Header header2 = (Header)tuple23._1();
        boolean isIPv62 = tuple23._2$mcZ$sp();
        int bufferSize = 65536;
        CompressionMethod compressionMethod = header2.compressionMethod();
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(s);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(s);
        } else {
            throw new SilkDataFormatException("Unsupported compression method (without Hadoop)");
        }
        RawInputStreamBuffer bufferReader2 = bufferReader;
        return this.createReader(bufferReader2, header2, isIPv62);
    }

    public IPSetReader ofInputStream(Configuration conf, InputStream s) {
        BufferReader bufferReader;
        Tuple2<Header, Object> tuple2 = this.checkHeader(s);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Header header = (Header)tuple2._1();
        boolean isIPv6 = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)isIPv6));
        Tuple2 tuple23 = tuple22;
        Header header2 = (Header)tuple23._1();
        boolean isIPv62 = tuple23._2$mcZ$sp();
        int bufferSize = 65536;
        CompressionMethod compressionMethod = header2.compressionMethod();
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(conf, s);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = LzoInputStreamBuffer$.MODULE$.apply(conf, s);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(conf, s);
        } else {
            throw new SilkDataFormatException("Unrecognized compression method");
        }
        RawInputStreamBuffer bufferReader2 = bufferReader;
        return this.createReader(bufferReader2, header2, isIPv62);
    }

    private IPSetReader$() {
        MODULE$ = this;
    }
}

