/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPBlock;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$FT_IPSET$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.HeaderEntry$EndOfHeaders$;
import org.cert.netsa.io.silk.IPSetWriter$;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.LzoOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibOutputStreamBuffer$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005_!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b9\u0003A\u0011B(\t\rQ\u0003\u0001\u0015)\u0003V\u0011%A\u0006\u00011A\u0001B\u0003&\u0011\fC\u0005]\u0001\u0001\u0007\t\u0011)Q\u00053\"1Q\f\u0001Q\u0001\neCaA\u0018\u0001!\u0002\u0013y\u0006BB3\u0001A\u0003&\u0011\fC\u0005g\u0001\u0001\u0007\t\u0011)Q\u0005O\"1q\u000e\u0001Q\u0001\nADa!\u001e\u0001!\n\u00131\b\"\u0002?\u0001\t\u0003i\b\"\u0002@\u0001\t\u0003y\bbBA\u001b\u0001\u0011\u0005\u0011qG\u0004\b\u0003sY\u0002\u0012AA\u001e\r\u0019Q2\u0004#\u0001\u0002>!1a*\u0006C\u0001\u0003\u007fAq!!\u0011\u0016\t\u0003\t\u0019\u0005C\u0005\u0002TU\t\n\u0011\"\u0001\u0002V!I\u00111N\u000b\u0012\u0002\u0013\u0005\u0011Q\u000e\u0002\f\u0013B\u001bV\r^,sSR,'O\u0003\u0002\u001d;\u0005!1/\u001b7l\u0015\tqr$\u0001\u0002j_*\u0011\u0001%I\u0001\u0006]\u0016$8/\u0019\u0006\u0003E\r\nAaY3si*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001OA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\f1a\\;u+\u0005y\u0003C\u0001\u00195\u001b\u0005\t$B\u0001\u00103\u0015\u0005\u0019\u0014\u0001\u00026bm\u0006L!!N\u0019\u0003!\u0011\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0017\u0001B8vi\u0002\n\u0011cY8naJ,7o]5p]6+G\u000f[8e+\u0005I\u0004C\u0001\u001e<\u001b\u0005Y\u0012B\u0001\u001f\u001c\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8NKRDw\u000eZ\u0001\u0013G>l\u0007O]3tg&|g.T3uQ>$\u0007%\u0001\u0007iC\u0012|w\u000e]\"p]\u001aLw-F\u0001A!\rA\u0013iQ\u0005\u0003\u0005&\u0012aa\u00149uS>t\u0007C\u0001#L\u001b\u0005)%B\u0001$H\u0003\u0011\u0019wN\u001c4\u000b\u0005!K\u0015A\u00025bI>|\u0007O\u0003\u0002KG\u00051\u0011\r]1dQ\u0016L!\u0001T#\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00035A\u0017\rZ8pa\u000e{gNZ5hA\u00051A(\u001b8jiz\"B\u0001U)S'B\u0011!\b\u0001\u0005\u0006[\u001d\u0001\ra\f\u0005\u0006o\u001d\u0001\r!\u000f\u0005\u0006}\u001d\u0001\r\u0001Q\u0001\u000eQ\u0016\fG-\u001a:Xe&$H/\u001a8\u0011\u0005!2\u0016BA,*\u0005\u001d\u0011un\u001c7fC:\f\u0001\"\u001b9MK:<G\u000f\u001b\t\u0003QiK!aW\u0015\u0003\u0007%sG/\u0001\u0007sK\u000e|'\u000f\u001a'f]\u001e$\b.\u0001\u0006ck\u001a4WM]*ju\u0016\faAY;gM\u0016\u0014\bc\u0001\u0015aE&\u0011\u0011-\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003Q\rL!\u0001Z\u0015\u0003\t\tKH/Z\u0001\u0007_\u001a47/\u001a;\u0002\u0019A\u0014XM\u001e\"m_\u000e\\W*\u0019=\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017a\u00018fi*\u0011AnH\u0001\u0005I\u0006$\u0018-\u0003\u0002oS\nI\u0011\nU!eIJ,7o]\u0001\u0007oJLG/\u001a:\u0011\u0005E\u001cX\"\u0001:\u000b\u0005yY\u0012B\u0001;s\u00051\u0011UO\u001a4fe^\u0013\u0018\u000e^3s\u0003-9(/\u001b;f\u0011\u0016\fG-\u001a:\u0015\u0005]T\bC\u0001\u0015y\u0013\tI\u0018F\u0001\u0003V]&$\b\"B>\u0011\u0001\u0004)\u0016AB5t\u0013B3h'\u0001\txCNDU-\u00193fe^\u0013\u0018\u000e\u001e;f]V\tQ+\u0001\u0004baB,g\u000eZ\u000b\u0005\u0003\u0003\t\u0019\u0003F\u0002x\u0003\u0007Aq!!\u0002\u0013\u0001\u0004\t9!\u0001\u0003ji\u0016\u0014\bCBA\u0005\u00033\tyB\u0004\u0003\u0002\f\u0005Ua\u0002BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EQ%\u0001\u0004=e>|GOP\u0005\u0002U%\u0019\u0011qC\u0015\u0002\u000fA\f7m[1hK&!\u00111DA\u000f\u0005!IE/\u001a:bi>\u0014(bAA\fSA!\u0011\u0011EA\u0012\u0019\u0001!q!!\n\u0013\u0005\u0004\t9CA\u0001U#\u0011\tI#a\f\u0011\u0007!\nY#C\u0002\u0002.%\u0012qAT8uQ&tw\rE\u0002i\u0003cI1!a\rj\u0005\u001dI\u0005K\u00117pG.\fQa\u00197pg\u0016$\u0012a^\u0001\f\u0013B\u001bV\r^,sSR,'\u000f\u0005\u0002;+M\u0011Qc\n\u000b\u0003\u0003w\ta\u0002^8PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0004Q\u0003\u000b\ny%!\u0015\t\u000f\u0005\u001ds\u00031\u0001\u0002J\u0005\t1\u000fE\u00021\u0003\u0017J1!!\u00142\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d9t\u0003%AA\u0002eBqAP\f\u0011\u0002\u0003\u0007\u0001)\u0001\ru_>+H\u000f];u'R\u0014X-Y7%I\u00164\u0017-\u001e7uII*\"!a\u0016+\u0007e\nIf\u000b\u0002\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014!C;oG\",7m[3e\u0015\r\t)'K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA5\u0003?\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003a!xnT;uaV$8\u000b\u001e:fC6$C-\u001a4bk2$HeM\u000b\u0003\u0003_R3\u0001QA-\u0001")
public class IPSetWriter {
    private final DataOutputStream out;
    private final CompressionMethod compressionMethod;
    private final Option<Configuration> hadoopConfig;
    private boolean headerWritten;
    private int ipLength;
    private int recordLength;
    private final int bufferSize;
    private final byte[] buffer;
    private int offset;
    private IPAddress prevBlockMax;
    private final BufferWriter writer;

    public static Option<Configuration> toOutputStream$default$3() {
        return IPSetWriter$.MODULE$.toOutputStream$default$3();
    }

    public static CompressionMethod toOutputStream$default$2() {
        return IPSetWriter$.MODULE$.toOutputStream$default$2();
    }

    public static IPSetWriter toOutputStream(OutputStream outputStream, CompressionMethod compressionMethod, Option<Configuration> option) {
        return IPSetWriter$.MODULE$.toOutputStream(outputStream, compressionMethod, option);
    }

    public DataOutputStream out() {
        return this.out;
    }

    public CompressionMethod compressionMethod() {
        return this.compressionMethod;
    }

    public Option<Configuration> hadoopConfig() {
        return this.hadoopConfig;
    }

    private void writeHeader(boolean isIPv6) {
        Vector h_entries = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HeaderEntry[]{new HeaderEntry.IPSet(0, 0, isIPv6 ? 16 : 4, 0, 0, 0), HeaderEntry$EndOfHeaders$.MODULE$}));
        Header header = new Header(Header$.MODULE$.BigEndian(), FileFormat$FT_IPSET$.MODULE$, Header$.MODULE$.FileVersion(), this.compressionMethod(), 0, 1, 4, (IndexedSeq<HeaderEntry>)h_entries);
        header.writeTo(this.out());
        this.out().flush();
        this.headerWritten = true;
    }

    public boolean wasHeaderWritten() {
        return this.headerWritten;
    }

    public <T extends IPBlock> void append(Iterator<T> iter) {
        if (!this.headerWritten) {
            boolean bl;
            if (!iter.hasNext()) {
                return;
            }
            IPBlock block2 = (IPBlock)iter.next();
            this.ipLength = block2.min().toBytes().length;
            this.recordLength = this.ipLength + 1;
            int n = this.ipLength;
            switch (n) {
                case 4: {
                    bl = false;
                    break;
                }
                case 16: {
                    bl = true;
                    break;
                }
                default: {
                    throw new NoSuchElementException(new StringBuilder(28).append("Unexpected IP Address length").append(this.ipLength).toString());
                }
            }
            boolean isIPv6 = bl;
            this.writeHeader(isIPv6);
            Predef$.MODULE$.assert(0 == this.offset);
            Predef$.MODULE$.assert(this.bufferSize > this.recordLength);
            BufferUtil$.MODULE$.putBytes(this.buffer, 0, block2.min().toBytes(), this.ipLength);
            BufferUtil$.MODULE$.putInt8(this.buffer, this.ipLength, (byte)block2.prefixLength());
            this.offset = this.recordLength;
            this.prevBlockMax = block2.max();
        }
        iter.foreach((Function1 & Serializable & scala.Serializable)block -> {
            IPSetWriter.$anonfun$append$1(this, block);
            return BoxedUnit.UNIT;
        });
        if (this.offset > 0) {
            this.writer.putBuffer(this.buffer, this.offset);
            this.offset = 0;
        }
        this.out().flush();
    }

    public void close() {
        if (!this.headerWritten) {
            this.writeHeader(false);
        }
        if (this.offset > 0) {
            this.writer.putBuffer(this.buffer, this.offset);
            this.offset = 0;
        }
        this.writer.end();
        this.out().close();
    }

    public static final /* synthetic */ void $anonfun$append$1(IPSetWriter $this, IPBlock block) {
        if ($this.prevBlockMax.$greater$eq((Object)block.min())) {
            throw new NoSuchElementException("IPBlocks are unsorted or overlap");
        }
        $this.prevBlockMax = block.max();
        byte[] arr = block.min().toBytes();
        if (arr.length != $this.ipLength) {
            throw new NoSuchElementException("Cannot mix IPv4Blocks and IPv6Blocks in IPSetWriter");
        }
        if ($this.bufferSize - $this.offset < $this.recordLength) {
            $this.writer.putBuffer($this.buffer, $this.offset);
            $this.offset = 0;
        }
        BufferUtil$.MODULE$.putBytes($this.buffer, $this.offset, arr, $this.ipLength);
        BufferUtil$.MODULE$.putInt8($this.buffer, $this.offset + $this.ipLength, (byte)block.prefixLength());
        $this.offset += $this.recordLength;
    }

    public IPSetWriter(DataOutputStream out, CompressionMethod compressionMethod, Option<Configuration> hadoopConfig) {
        BufferWriter bufferWriter;
        this.out = out;
        this.compressionMethod = compressionMethod;
        this.hadoopConfig = hadoopConfig;
        this.headerWritten = false;
        this.bufferSize = 65536;
        this.buffer = (byte[])Array$.MODULE$.ofDim(this.bufferSize, ClassTag$.MODULE$.Byte());
        this.offset = 0;
        CompressionMethod compressionMethod2 = compressionMethod;
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = RawOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = ZlibOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = LzoOutputStreamBuffer$.MODULE$.apply((Configuration)hadoopConfig.get(), out);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = SnappyOutputStreamBuffer$.MODULE$.apply((Configuration)hadoopConfig.get(), out);
        } else {
            throw new SilkDataFormatException("Unrecognized compression method");
        }
        this.writer = bufferWriter;
    }
}

