/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.time.Duration;
import java.time.Instant;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.IPv6Address;
import org.cert.netsa.data.net.IPv6Address$;
import org.cert.netsa.data.net.Port;
import org.cert.netsa.data.net.Port$;
import org.cert.netsa.data.net.Protocol;
import org.cert.netsa.data.net.Protocol$;
import org.cert.netsa.data.net.SNMPInterface$;
import org.cert.netsa.data.net.TCPFlags;
import org.cert.netsa.data.net.TCPFlags$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.TCPState;
import org.cert.netsa.io.silk.TCPState$;
import org.cert.netsa.io.silk.io.BufferUtil;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class BufferUtil$ {
    public static BufferUtil$ MODULE$;
    private final byte[] ipv4InV6;

    static {
        new BufferUtil$();
    }

    public byte getInt8(byte[] buffer, int offset, boolean swap) {
        return buffer[offset + 0];
    }

    public short getInt16(byte[] buffer, int offset, boolean swap) {
        return swap ? (short)(buffer[offset + 0] & 0xFF | (buffer[offset + 1] & 0xFF) << 8) : (short)((buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF);
    }

    public int getInt24(byte[] buffer, int offset, boolean swap) {
        return swap ? buffer[offset + 0] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 : (buffer[offset + 0] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 2] & 0xFF;
    }

    public int getInt32(byte[] buffer, int offset, boolean swap) {
        return swap ? buffer[offset + 0] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24 : (buffer[offset + 0] & 0xFF) << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    public long getInt64(byte[] buffer, int offset, boolean swap) {
        return swap ? (long)buffer[offset + 0] & 0xFFL | ((long)buffer[offset + 1] & 0xFFL) << 8 | ((long)buffer[offset + 2] & 0xFFL) << 16 | ((long)buffer[offset + 3] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 32 | ((long)buffer[offset + 5] & 0xFFL) << 40 | ((long)buffer[offset + 6] & 0xFFL) << 48 | ((long)buffer[offset + 7] & 0xFFL) << 56 : ((long)buffer[offset + 0] & 0xFFL) << 56 | ((long)buffer[offset + 1] & 0xFFL) << 48 | ((long)buffer[offset + 2] & 0xFFL) << 40 | ((long)buffer[offset + 3] & 0xFFL) << 32 | ((long)buffer[offset + 4] & 0xFFL) << 24 | ((long)buffer[offset + 5] & 0xFFL) << 16 | ((long)buffer[offset + 6] & 0xFFL) << 8 | (long)buffer[offset + 7] & 0xFFL;
    }

    public byte[] getBytes(byte[] buffer, int offset, int length) {
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buffer)).slice(offset, offset + length);
    }

    public Instant getStartTime(byte[] buffer, int offset, boolean swap) {
        return Instant.ofEpochMilli(this.getInt64(buffer, offset, swap));
    }

    public Instant getStartTimeSecs(byte[] buffer, int offset, boolean swap) {
        return Instant.ofEpochSecond(Integer.toUnsignedLong(this.getInt32(buffer, offset, swap)));
    }

    public Duration getElapsed(byte[] buffer, int offset, boolean swap) {
        return Duration.ofMillis(this.getInt32(buffer, offset, swap));
    }

    public Duration getElapsedSecs16(byte[] buffer, int offset, boolean swap) {
        return Duration.ofSeconds(Short.toUnsignedLong(this.getInt16(buffer, offset, swap)));
    }

    public Duration getElapsedSecs32(byte[] buffer, int offset, boolean swap) {
        return Duration.ofSeconds(Integer.toUnsignedLong(this.getInt32(buffer, offset, swap)));
    }

    public short getPort(byte[] buffer, int offset, boolean swap) {
        return this.getInt16(buffer, offset, swap);
    }

    public byte getProtocol(byte[] buffer, int offset, boolean swap) {
        return this.getInt8(buffer, offset, swap);
    }

    public byte getFlowType(byte[] buffer, int offset, boolean swap) {
        return this.getInt8(buffer, offset, swap);
    }

    public short getSensor8(byte[] buffer, int offset, boolean swap) {
        return (short)Byte.toUnsignedInt(this.getInt8(buffer, offset, swap));
    }

    public short getSensor16(byte[] buffer, int offset, boolean swap) {
        return this.getInt16(buffer, offset, swap);
    }

    public byte getTCPFlags(byte[] buffer, int offset, boolean swap) {
        return this.getInt8(buffer, offset, swap);
    }

    public byte getTCPState(byte[] buffer, int offset, boolean swap) {
        return this.getInt8(buffer, offset, swap);
    }

    public short getApplication(byte[] buffer, int offset, boolean swap) {
        return this.getInt16(buffer, offset, swap);
    }

    public short getMemo(byte[] buffer, int offset, boolean swap) {
        return this.getInt16(buffer, offset, swap);
    }

    public int getSNMPInterface8(byte[] buffer, int offset, boolean swap) {
        return Byte.toUnsignedInt(this.getInt8(buffer, offset, swap));
    }

    public int getSNMPInterface16(byte[] buffer, int offset, boolean swap) {
        return Short.toUnsignedInt(this.getInt16(buffer, offset, swap));
    }

    public int getSNMPInterface32(byte[] buffer, int offset, boolean swap) {
        return this.getInt32(buffer, offset, swap);
    }

    public long getPackets24(byte[] buffer, int offset, boolean swap) {
        return this.getInt24(buffer, offset, swap);
    }

    public long getPackets32(byte[] buffer, int offset, boolean swap) {
        return Integer.toUnsignedLong(this.getInt32(buffer, offset, swap));
    }

    public long getPackets64(byte[] buffer, int offset, boolean swap) {
        return this.getInt64(buffer, offset, swap);
    }

    public long getBytes32(byte[] buffer, int offset, boolean swap) {
        return Integer.toUnsignedLong(this.getInt32(buffer, offset, swap));
    }

    public long getBytes64(byte[] buffer, int offset, boolean swap) {
        return this.getInt64(buffer, offset, swap);
    }

    public IPv6Address getIPv6Address(byte[] buffer, int offset) {
        return IPv6Address$.MODULE$.apply(this.getBytes(buffer, offset, 16));
    }

    public IPv4Address getIPv4Address(byte[] buffer, int offset, boolean swap) {
        return new IPv4Address(this.getInt32(buffer, offset, swap));
    }

    public boolean getIPv4Address$default$3() {
        return false;
    }

    public Tuple6<Instant, Protocol, TCPState, TCPFlags, TCPFlags, TCPFlags> unpackTimesFlagsProto(byte[] buffer, int offset, boolean swap, Header header) {
        Tuple6 tuple6;
        int rflagStartTime = this.getInt32(buffer, offset, swap);
        byte tcpState = this.getTCPState(buffer, offset + 5, swap);
        int startTimeOffset2 = rflagStartTime & 0x3FFFFF;
        boolean isTCP = (rflagStartTime & 0x800000) != 0;
        Instant startTime = Instant.ofEpochMilli(header.packedStartTime() + (long)startTimeOffset2);
        if (!isTCP) {
            tuple6 = new Tuple6((Object)startTime, (Object)new Protocol(this.getProtocol(buffer, offset + 4, false)), (Object)new TCPState(tcpState), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        } else if (TCPState$.MODULE$.expandedFlags$extension(tcpState)) {
            byte restFlags = (byte)(rflagStartTime >> 24);
            byte initFlags = this.getInt8(buffer, offset + 4, false);
            byte flags = (byte)(restFlags | initFlags);
            tuple6 = new Tuple6((Object)startTime, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPState(tcpState), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
        } else {
            tuple6 = new Tuple6((Object)startTime, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPState(tcpState), (Object)new TCPFlags(this.getTCPFlags(buffer, offset + 4, false)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }
        return tuple6;
    }

    public Tuple10<Instant, Duration, Object, Object, Protocol, TCPFlags, TCPFlags, TCPFlags, TCPState, Port> unpackFlagsTimesVolumes(byte[] buffer, int offset, int len, boolean inIsTCP, boolean swap, Header header) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        boolean isTCP;
        boolean pFlag;
        Tuple3 tuple3;
        Tuple3 tuple32 = tuple3 = len == 12 ? new Tuple3((Object)new TCPState(TCPState$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new Port(Port$.MODULE$.apply(0))) : new Tuple3((Object)new TCPState(this.getTCPState(buffer, offset + 12, swap)), (Object)new TCPFlags(this.getTCPFlags(buffer, offset + 13, swap)), (Object)new Port(this.getApplication(buffer, offset + 14, swap)));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        byte tcpState = ((TCPState)tuple3._1()).toByte();
        byte inRestFlags = ((TCPFlags)tuple3._2()).toByte();
        short application = ((Port)tuple3._3()).toShort();
        Tuple3 tuple33 = new Tuple3((Object)new TCPState(tcpState), (Object)new TCPFlags(inRestFlags), (Object)new Port(application));
        Tuple3 tuple34 = tuple33;
        byte tcpState2 = ((TCPState)tuple34._1()).toByte();
        byte inRestFlags2 = ((TCPFlags)tuple34._2()).toByte();
        short application2 = ((Port)tuple34._3()).toShort();
        int protoFlagPackets = this.getInt32(buffer, offset + 8, swap);
        int inPackets = protoFlagPackets & 0xFFFFF;
        boolean bl = pFlag = (protoFlagPackets & 0x800000) != 0;
        boolean bl2 = inIsTCP ? true : (isTCP = (protoFlagPackets & 0x400000) != 0);
        if (!isTCP) {
            tuple42 = new Tuple4((Object)new Protocol((byte)(protoFlagPackets >> 24)), (Object)new TCPFlags(inRestFlags2), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        } else {
            byte initFlags = (byte)(protoFlagPackets >> 24);
            byte flags = (byte)(initFlags | inRestFlags2);
            tuple42 = tuple4 = TCPState$.MODULE$.expandedFlags$extension(tcpState2) ? new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(inRestFlags2)) : new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(flags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        byte protocol = ((Protocol)tuple4._1()).toByte();
        byte flags = ((TCPFlags)tuple4._2()).toByte();
        byte initFlags = ((TCPFlags)tuple4._3()).toByte();
        byte restFlags = ((TCPFlags)tuple4._4()).toByte();
        Tuple4 tuple43 = new Tuple4((Object)new Protocol(protocol), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
        Tuple4 tuple44 = tuple43;
        byte protocol2 = ((Protocol)tuple44._1()).toByte();
        byte flags2 = ((TCPFlags)tuple44._2()).toByte();
        byte initFlags2 = ((TCPFlags)tuple44._3()).toByte();
        byte restFlags2 = ((TCPFlags)tuple44._4()).toByte();
        int bb2Elapsed = this.getInt32(buffer, offset + 4, swap);
        Duration elapsed = Duration.ofMillis(bb2Elapsed & 0x3FFFFF);
        int stimeBb1 = this.getInt32(buffer, offset, swap);
        int startTimeOffset2 = stimeBb1 >> 10 & 0x3FFFFF;
        Instant startTime = Instant.ofEpochMilli(header.packedStartTime() + (long)startTimeOffset2);
        int bpp = (stimeBb1 & 0x3FF) << 10 | bb2Elapsed >> 22 & 0x3FF;
        Tuple2<Object, Object> tuple2 = this.unpackBytesPackets(bpp, inPackets, pFlag);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytes = tuple2._1$mcI$sp();
        int packets = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(bytes, packets);
        Tuple2.mcII.sp sp3 = sp2;
        int bytes2 = sp3._1$mcI$sp();
        int packets2 = sp3._2$mcI$sp();
        return new Tuple10((Object)startTime, (Object)elapsed, (Object)BoxesRunTime.boxToInteger((int)packets2), (Object)BoxesRunTime.boxToInteger((int)bytes2), (Object)new Protocol(protocol2), (Object)new TCPFlags(flags2), (Object)new TCPFlags(initFlags2), (Object)new TCPFlags(restFlags2), (Object)new TCPState(tcpState2), (Object)new Port(application2));
    }

    public Tuple6<Instant, Object, Object, Duration, Protocol, TCPFlags> getTimeBytesPacketsFlags(byte[] buffer, int offset1, int offset2, int offset3, boolean forceTCP, boolean swap, Header header) {
        int pktsStime = this.getInt32(buffer, offset1, swap);
        int bbe = this.getInt32(buffer, offset2, swap);
        int msecFlags = this.getInt32(buffer, offset3, swap);
        int inPackets = pktsStime >> 12 & 0xFFFFF;
        int startTimeSecOffset = pktsStime & 0xFFF;
        int startTimeMilliOffset = msecFlags >> 22 & 0x3FF;
        Instant startTime = Instant.ofEpochMilli(header.packedStartTime() + (long)(startTimeSecOffset * 1000) + (long)startTimeMilliOffset);
        int bytesPerPacket = bbe >> 12 & 0xFFFFF;
        int elapsedSecs = bbe & 0xFFF;
        int elapsedMillis = msecFlags >> 12 & 0x3FF;
        Duration elapsed = Duration.ofMillis(elapsedSecs * 1000 + elapsedMillis);
        boolean pflag = (msecFlags & 0x800) != 0;
        boolean isTCP = (msecFlags & 0x400) != 0 || forceTCP;
        Tuple2<Object, Object> tuple2 = this.unpackBytesPackets(bytesPerPacket, inPackets, pflag);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytes = tuple2._1$mcI$sp();
        int packets = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(bytes, packets);
        Tuple2.mcII.sp sp3 = sp2;
        int bytes2 = sp3._1$mcI$sp();
        int packets2 = sp3._2$mcI$sp();
        byte protFlags = (byte)msecFlags;
        return isTCP ? new Tuple6((Object)startTime, (Object)BoxesRunTime.boxToInteger((int)packets2), (Object)BoxesRunTime.boxToInteger((int)bytes2), (Object)elapsed, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(protFlags)) : new Tuple6((Object)startTime, (Object)BoxesRunTime.boxToInteger((int)packets2), (Object)BoxesRunTime.boxToInteger((int)bytes2), (Object)elapsed, (Object)new Protocol(protFlags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
    }

    public Tuple2<Object, Object> unpackBytesPackets(int bpp, int inPackets, boolean pflag) {
        int packets = pflag ? inPackets * 64 : inPackets;
        int bytesPerPacket = bpp >> 6 & 0x3FFF;
        int bytesPerPacketFrac = bpp & 0x3F;
        int i_quot = bytesPerPacketFrac * packets >> 6;
        int i_rem = bytesPerPacketFrac * packets & 0x3F;
        int bytes = bytesPerPacket * packets + i_quot + (i_rem >= 32 ? 1 : 0);
        return new Tuple2.mcII.sp(bytes, packets);
    }

    public Tuple4<Protocol, TCPFlags, TCPFlags, TCPFlags> unpackProtoFlags(boolean isTCP, byte protFlags, byte tcpState, byte inRestFlags) {
        Tuple4 tuple4;
        if (isTCP) {
            if (TCPState$.MODULE$.expandedFlags$extension(tcpState)) {
                byte flags = (byte)(protFlags | inRestFlags);
                byte initFlags = protFlags;
                byte restFlags = inRestFlags;
                tuple4 = new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
            } else {
                tuple4 = new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(protFlags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
            }
        } else {
            tuple4 = new Tuple4((Object)new Protocol(protFlags), (Object)new TCPFlags(inRestFlags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }
        return tuple4;
    }

    public Tuple4<Instant, Duration, Object, Object> unpackSbbPef(byte[] buffer, int sbbOffset, int pefOffset, boolean swap, Header header) {
        int pef = this.getInt32(buffer, pefOffset, swap);
        int inPackets = pef >> 12 & 0xFFFFF;
        int elapsedSecs = pef >> 1 & 0x7FF;
        boolean pFlag = (pef & 1) != 0;
        int sbb = this.getInt32(buffer, sbbOffset, swap);
        int bpp = sbb & 0xFFFFF;
        int startTimeSecOffset = sbb >> 20 & 0xFFF;
        Instant startTime = Instant.ofEpochMilli(header.packedStartTime() + (long)(startTimeSecOffset * 1000));
        Duration elapsed = Duration.ofSeconds(elapsedSecs);
        Tuple2<Object, Object> tuple2 = this.unpackBytesPackets(bpp, inPackets, pFlag);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytes = tuple2._1$mcI$sp();
        int packets = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(bytes, packets);
        Tuple2.mcII.sp sp3 = sp2;
        int bytes2 = sp3._1$mcI$sp();
        int packets2 = sp3._2$mcI$sp();
        return new Tuple4((Object)startTime, (Object)elapsed, (Object)BoxesRunTime.boxToInteger((int)bytes2), (Object)BoxesRunTime.boxToInteger((int)packets2));
    }

    public short decodeWWWPort(int bits) {
        short s;
        int n = bits;
        switch (n) {
            case 0: {
                s = Port$.MODULE$.apply(80);
                break;
            }
            case 1: {
                s = Port$.MODULE$.apply(443);
                break;
            }
            case 2: {
                s = Port$.MODULE$.apply(8080);
                break;
            }
            default: {
                s = Port$.MODULE$.apply(0);
                break;
            }
        }
        return s;
    }

    public BufferUtil.TCPStateFixHelper TCPStateFixHelper(RWRec self) {
        return new BufferUtil.TCPStateFixHelper(self);
    }

    public void putInt8(byte[] buffer, int offset, byte value) {
        buffer[offset + 0] = value;
    }

    public void putInt16(byte[] buffer, int offset, short value) {
        buffer[offset + 0] = (byte)(value >>> 8);
        buffer[offset + 1] = (byte)value;
    }

    public void putInt32(byte[] buffer, int offset, int value) {
        buffer[offset + 0] = (byte)(value >>> 24);
        buffer[offset + 1] = (byte)(value >>> 16);
        buffer[offset + 2] = (byte)(value >>> 8);
        buffer[offset + 3] = (byte)value;
    }

    public void putInt64(byte[] buffer, int offset, long value) {
        buffer[offset + 0] = (byte)(value >>> 56);
        buffer[offset + 1] = (byte)(value >>> 48);
        buffer[offset + 2] = (byte)(value >>> 40);
        buffer[offset + 3] = (byte)(value >>> 32);
        buffer[offset + 4] = (byte)(value >>> 24);
        buffer[offset + 5] = (byte)(value >>> 16);
        buffer[offset + 6] = (byte)(value >>> 8);
        buffer[offset + 7] = (byte)value;
    }

    public void putBytes(byte[] buffer, int offset, byte[] value) {
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value)).copyToArray((Object)buffer, offset, value.length);
    }

    public void putBytes(byte[] buffer, int offset, byte[] value, int length) {
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value)).copyToArray((Object)buffer, offset, length);
    }

    public void putInstant(byte[] buffer, int offset, Instant value) {
        this.putInt64(buffer, offset, value.toEpochMilli());
    }

    public void putElapsed(byte[] buffer, int offset, Duration value) {
        this.putInt32(buffer, offset, (int)value.toMillis());
    }

    public void putPort(byte[] buffer, int offset, short value) {
        this.putInt16(buffer, offset, value);
    }

    public void putProtocol(byte[] buffer, int offset, byte value) {
        this.putInt8(buffer, offset, value);
    }

    public void putFlowType(byte[] buffer, int offset, byte value) {
        this.putInt8(buffer, offset, value);
    }

    public void putSensor(byte[] buffer, int offset, short value) {
        this.putInt16(buffer, offset, value);
    }

    public void putTCPFlags(byte[] buffer, int offset, byte value) {
        this.putInt8(buffer, offset, value);
    }

    public void putTCPState(byte[] buffer, int offset, byte value) {
        this.putInt8(buffer, offset, value);
    }

    public void putApplication(byte[] buffer, int offset, short value) {
        this.putInt16(buffer, offset, value);
    }

    public void putMemo(byte[] buffer, int offset, short value) {
        this.putInt16(buffer, offset, value);
    }

    public void putSNMPInterface16(byte[] buffer, int offset, int value) {
        this.putInt16(buffer, offset, SNMPInterface$.MODULE$.toShort$extension(value));
    }

    public void putSNMPInterface32(byte[] buffer, int offset, int value) {
        this.putInt32(buffer, offset, value);
    }

    public void putPackets32(byte[] buffer, int offset, long value) {
        this.putInt32(buffer, offset, (int)value);
    }

    public void putPackets64(byte[] buffer, int offset, long value) {
        this.putInt64(buffer, offset, value);
    }

    public void putBytes32(byte[] buffer, int offset, long value) {
        this.putInt32(buffer, offset, (int)value);
    }

    public void putBytes64(byte[] buffer, int offset, long value) {
        this.putInt64(buffer, offset, value);
    }

    public boolean putIPAddress(byte[] buffer, int offset, IPAddress value) {
        boolean bl;
        IPAddress iPAddress = value;
        if (iPAddress instanceof IPv6Address) {
            IPv6Address iPv6Address = (IPv6Address)iPAddress;
            this.putBytes(buffer, offset, iPv6Address.toBytes(), 16);
            bl = true;
        } else if (iPAddress instanceof IPv4Address) {
            IPv4Address iPv4Address = (IPv4Address)iPAddress;
            this.putBytes(buffer, offset, this.ipv4InV6, 12);
            this.putInt32(buffer, offset + 12, iPv4Address.toInt());
            bl = false;
        } else {
            throw new MatchError((Object)iPAddress);
        }
        return bl;
    }

    public void putIPv6Address(byte[] buffer, int offset, IPv6Address value) {
        this.putBytes(buffer, offset, value.toBytes(), 16);
    }

    public void putIPv4Address(byte[] buffer, int offset, IPv4Address value) {
        this.putInt32(buffer, offset, value.toInt());
    }

    private BufferUtil$() {
        MODULE$ = this;
        this.ipv4InV6 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}), ClassTag$.MODULE$.Byte());
    }
}

