/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.DataOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.LzoOutputStreamBuffer$;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Qa\u0004\t\u0001%mA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!)!\b\u0001C\u0001w!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u0002#\u0001A\u0003%\u0011\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r9\u0003\u0001\u0015!\u0003H\u0011\u0019y\u0005\u0001)C\u0005!\")a\u000b\u0001C\u0001/\")1\f\u0001C\u00019\u001e1q\r\u0005E\u0001%!4aa\u0004\t\t\u0002II\u0007\"\u0002\u001e\r\t\u0003Q\u0007\"B6\r\t\u0003a'!\u0006'{_>+H\u000f];u'R\u0014X-Y7Ck\u001a4WM\u001d\u0006\u0003#I\t!![8\u000b\u0005M!\u0012\u0001B:jY.T!!E\u000b\u000b\u0005Y9\u0012!\u00028fiN\f'B\u0001\r\u001a\u0003\u0011\u0019WM\u001d;\u000b\u0003i\t1a\u001c:h'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r\"S\"\u0001\t\n\u0005\u0015\u0002\"\u0001\u0004\"vM\u001a,'o\u0016:ji\u0016\u0014\u0018!D2p]\u001aLw-\u001e:bi&|gn\u0001\u0001\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013\u0001B2p]\u001aT!!\f\u0018\u0002\r!\fGm\\8q\u0015\ty\u0013$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003c)\u0012QbQ8oM&<WO]1uS>t\u0017!C8viN#(/Z1n!\t!\u0004(D\u00016\u0015\t\tbGC\u00018\u0003\u0011Q\u0017M^1\n\u0005e*$\u0001D(viB,Ho\u0015;sK\u0006l\u0017A\u0002\u001fj]&$h\bF\u0002={y\u0002\"a\t\u0001\t\u000b\u0019\u001a\u0001\u0019\u0001\u0015\t\u000bI\u001a\u0001\u0019A\u001a\u0002\u0007=,H/F\u0001B!\t!$)\u0003\u0002Dk\t\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0005_V$\b%\u0001\u0006d_6\u0004(/Z:t_J,\u0012a\u0012\t\u0003\u00112k\u0011!\u0013\u0006\u0003\u0015.\u000b\u0001bY8naJ,7o\u001d\u0006\u0003#1J!!T%\u0003\u0015\r{W\u000e\u001d:fgN|'/A\u0006d_6\u0004(/Z:t_J\u0004\u0013!D2p[B\u0014Xm]:C_VtG\r\u0006\u0002R)B\u0011QDU\u0005\u0003'z\u00111!\u00138u\u0011\u0015)\u0006\u00021\u0001R\u0003%\u0019x.\u001e:dK2+g.A\u0002f]\u0012$\u0012\u0001\u0017\t\u0003;eK!A\u0017\u0010\u0003\tUs\u0017\u000e^\u0001\naV$()\u001e4gKJ$2\u0001W/f\u0011\u0015q&\u00021\u0001`\u0003A)hnY8naJ,7o]3e\t\u0006$\u0018\rE\u0002\u001eA\nL!!\u0019\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005u\u0019\u0017B\u00013\u001f\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u0019T\u0001\u0019A)\u0002!Ut7m\\7qe\u0016\u001c8/\u001a3TSj,\u0017!\u0006'{_>+H\u000f];u'R\u0014X-Y7Ck\u001a4WM\u001d\t\u0003G1\u0019\"\u0001\u0004\u000f\u0015\u0003!\fQ!\u00199qYf$2\u0001P7o\u0011\u0015Yc\u00021\u0001)\u0011\u0015\u0011d\u00021\u00014\u0001")
public class LzoOutputStreamBuffer
implements BufferWriter {
    private final Configuration configuration;
    private final DataOutputStream out;
    private final Compressor compressor;

    public static LzoOutputStreamBuffer apply(Configuration configuration, OutputStream outputStream) {
        return LzoOutputStreamBuffer$.MODULE$.apply(configuration, outputStream);
    }

    private DataOutputStream out() {
        return this.out;
    }

    private Compressor compressor() {
        return this.compressor;
    }

    private int compressBound(int sourceLen) {
        return sourceLen + (sourceLen >>> 4) + 64 + 3;
    }

    @Override
    public void end() {
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().end();
        this.out().flush();
    }

    @Override
    public void putBuffer(byte[] uncompressedData, int uncompressedSize) {
        if (0 == uncompressedSize) {
            return;
        }
        int maxCompressedSize = this.compressBound(uncompressedSize);
        byte[] compressedData = (byte[])Array$.MODULE$.ofDim(maxCompressedSize, ClassTag$.MODULE$.Byte());
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().setInput(uncompressedData, 0, uncompressedSize);
        int compressedSize = this.compressor().compress(compressedData, 0, maxCompressedSize);
        this.out().writeInt(compressedSize);
        this.out().writeInt(uncompressedSize);
        this.out().write(compressedData, 0, compressedSize);
        Predef$.MODULE$.assert(this.compressor().needsInput());
        Predef$.MODULE$.assert(0 == this.compressor().compress(compressedData, 0, maxCompressedSize));
        this.compressor().reset();
    }

    private final /* synthetic */ Compressor liftedTree1$1() {
        Compressor compressor;
        try {
            CompressionCodecFactory cf = new CompressionCodecFactory(this.configuration);
            CompressionCodec c = cf.getCodecByName("lzo");
            compressor = c.createCompressor();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create lzo compressor--is lzo properly configured?", ex);
        }
        return compressor;
    }

    public LzoOutputStreamBuffer(Configuration configuration, OutputStream outStream) {
        DataOutputStream dataOutputStream;
        this.configuration = configuration;
        OutputStream outputStream = outStream;
        DataOutputStream dataOutputStream2 = outputStream instanceof DataOutputStream ? (dataOutputStream = (DataOutputStream)outputStream) : new DataOutputStream(outStream);
        this.out = dataOutputStream2;
        this.compressor = this.liftedTree1$1();
    }
}

