/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.DataOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.SnappyOutputStreamBuffer$;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Qa\u0004\t\u0001%mA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!)!\b\u0001C\u0001w!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u0002#\u0001A\u0003%\u0011\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r9\u0003\u0001\u0015!\u0003H\u0011\u0019y\u0005\u0001)C\u0005!\")a\u000b\u0001C\u0001/\")1\f\u0001C\u00019\u001e1q\r\u0005E\u0001%!4aa\u0004\t\t\u0002II\u0007\"\u0002\u001e\r\t\u0003Q\u0007\"B6\r\t\u0003a'\u0001G*oCB\u0004\u0018pT;uaV$8\u000b\u001e:fC6\u0014UO\u001a4fe*\u0011\u0011CE\u0001\u0003S>T!a\u0005\u000b\u0002\tMLGn\u001b\u0006\u0003#UQ!AF\f\u0002\u000b9,Go]1\u000b\u0005aI\u0012\u0001B2feRT\u0011AG\u0001\u0004_J<7c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003AI!!\n\t\u0003\u0019\t+hMZ3s/JLG/\u001a:\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0007\u0001\u0001\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\t\r|gN\u001a\u0006\u0003[9\na\u0001[1e_>\u0004(BA\u0018\u001a\u0003\u0019\t\u0007/Y2iK&\u0011\u0011G\u000b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0013=,Ho\u0015;sK\u0006l\u0007C\u0001\u001b9\u001b\u0005)$BA\t7\u0015\u00059\u0014\u0001\u00026bm\u0006L!!O\u001b\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\rqJg.\u001b;?)\raTH\u0010\t\u0003G\u0001AQAJ\u0002A\u0002!BQAM\u0002A\u0002M\n1a\\;u+\u0005\t\u0005C\u0001\u001bC\u0013\t\u0019UG\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\u0006!q.\u001e;!\u0003)\u0019w.\u001c9sKN\u001cxN]\u000b\u0002\u000fB\u0011\u0001\nT\u0007\u0002\u0013*\u0011!jS\u0001\tG>l\u0007O]3tg*\u0011\u0011\u0003L\u0005\u0003\u001b&\u0013!bQ8naJ,7o]8s\u0003-\u0019w.\u001c9sKN\u001cxN\u001d\u0011\u0002\u001b\r|W\u000e\u001d:fgN\u0014u.\u001e8e)\t\tF\u000b\u0005\u0002\u001e%&\u00111K\b\u0002\u0004\u0013:$\b\"B+\t\u0001\u0004\t\u0016!C:pkJ\u001cW\rT3o\u0003\r)g\u000e\u001a\u000b\u00021B\u0011Q$W\u0005\u00035z\u0011A!\u00168ji\u0006I\u0001/\u001e;Ck\u001a4WM\u001d\u000b\u00041v+\u0007\"\u00020\u000b\u0001\u0004y\u0016\u0001E;oG>l\u0007O]3tg\u0016$G)\u0019;b!\ri\u0002MY\u0005\u0003Cz\u0011Q!\u0011:sCf\u0004\"!H2\n\u0005\u0011t\"\u0001\u0002\"zi\u0016DQA\u001a\u0006A\u0002E\u000b\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u00021Ms\u0017\r\u001d9z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\"vM\u001a,'\u000f\u0005\u0002$\u0019M\u0011A\u0002\b\u000b\u0002Q\u0006)\u0011\r\u001d9msR\u0019A(\u001c8\t\u000b-r\u0001\u0019\u0001\u0015\t\u000bIr\u0001\u0019A\u001a")
public class SnappyOutputStreamBuffer
implements BufferWriter {
    private final DataOutputStream out;
    private final Compressor compressor;

    public static SnappyOutputStreamBuffer apply(Configuration configuration, OutputStream outputStream) {
        return SnappyOutputStreamBuffer$.MODULE$.apply(configuration, outputStream);
    }

    private DataOutputStream out() {
        return this.out;
    }

    private Compressor compressor() {
        return this.compressor;
    }

    private int compressBound(int sourceLen) {
        return 32 + sourceLen + sourceLen / 6;
    }

    @Override
    public void end() {
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().end();
        this.out().flush();
    }

    @Override
    public void putBuffer(byte[] uncompressedData, int uncompressedSize) {
        if (0 == uncompressedSize) {
            return;
        }
        int maxCompressedSize = this.compressBound(uncompressedSize);
        byte[] compressedData = (byte[])Array$.MODULE$.ofDim(maxCompressedSize, ClassTag$.MODULE$.Byte());
        Predef$.MODULE$.assert(this.compressor().needsInput());
        this.compressor().setInput(uncompressedData, 0, uncompressedSize);
        this.compressor().finish();
        int compressedSize = this.compressor().compress(compressedData, 0, maxCompressedSize);
        this.out().writeInt(compressedSize);
        this.out().writeInt(uncompressedSize);
        this.out().write(compressedData, 0, compressedSize);
        while (!this.compressor().finished()) {
            int size = this.compressor().compress(compressedData, 0, maxCompressedSize);
            this.out().write(compressedData, 0, size);
        }
        Predef$.MODULE$.assert(this.compressor().needsInput());
        Predef$.MODULE$.assert(0 == this.compressor().compress(compressedData, 0, maxCompressedSize));
        this.compressor().reset();
    }

    public SnappyOutputStreamBuffer(Configuration configuration, OutputStream outStream) {
        DataOutputStream dataOutputStream;
        OutputStream outputStream = outStream;
        DataOutputStream dataOutputStream2 = outputStream instanceof DataOutputStream ? (dataOutputStream = (DataOutputStream)outputStream) : new DataOutputStream(outStream);
        this.out = dataOutputStream2;
        CompressionCodecFactory cf = new CompressionCodecFactory(configuration);
        CompressionCodec c = cf.getCodecByName("snappy");
        this.compressor = c.createCompressor();
    }
}

