/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io.ipset;

import java.io.Serializable;
import org.cert.netsa.data.net.IPBlock;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.IPv4Block;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.IPSetReader;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.BufferUtil$;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc!\u0002\u0012$\u0001\u001d\u0002\u0004\"C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c<\u0011%a\u0004A!A!\u0002\u0013i\u0004\tC\u0003B\u0001\u0011\u0005!\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0015B(\u0007\r}\u0003\u0001\u0015!\u0003a\u0011!!gA!A!\u0002\u0013)\u0007\"B!\u0007\t\u0003A\u0007b\u00027\u0007\u0005\u0004%\t!\u001c\u0005\u0007]\u001a\u0001\u000b\u0011\u0002%\t\u000f=4!\u0019!C\u0001[\"1\u0001O\u0002Q\u0001\n!Cq!\u001d\u0004A\u0002\u0013\u0005Q\u000eC\u0004s\r\u0001\u0007I\u0011A:\t\re4\u0001\u0015)\u0003I\u0011\u001dQhA1A\u0005\u00025Daa\u001f\u0004!\u0002\u0013A\u0005b\u0002?\u0007\u0005\u0004%\t!\u001c\u0005\u0007{\u001a\u0001\u000b\u0011\u0002%\t\u000fy4!\u0019!C\u0001[\"1qP\u0002Q\u0001\n!C\u0001\"!\u0001\u0007\u0001\u0004%\t!\u001c\u0005\n\u0003\u00071\u0001\u0019!C\u0001\u0003\u000bAq!!\u0003\u0007A\u0003&\u0001\n\u0003\u0005\u0002\f\u0019\u0001K\u0011BA\u0007\u0011!\t\u0019B\u0002Q\u0005\n\u0005U\u0001bBA\r\r\u0011\u0005\u00111\u0004\u0005\b\u0003O1A\u0011AA\u0015\u0011\u001d\tYC\u0002C\u0001\u0003[A\u0001\"a\u0012\u0001A\u0013%\u0011\u0011\n\u0005\b\u0003\u0017\u0002A\u0011IA\u0015\u0011\u001d\ti\u0005\u0001C!\u0003SAq!a\u0014\u0001\t\u0003\n\tFA\u0007J!N+GO\u0016\u001aSK\u0006$WM\u001d\u0006\u0003I\u0015\nQ!\u001b9tKRT!AJ\u0014\u0002\u0005%|'B\u0001\u0015*\u0003\u0011\u0019\u0018\u000e\\6\u000b\u0005\u0019R#BA\u0016-\u0003\u0015qW\r^:b\u0015\tic&\u0001\u0003dKJ$(\"A\u0018\u0002\u0007=\u0014xm\u0005\u0002\u0001cA\u0011!gM\u0007\u0002O%\u0011Ag\n\u0002\f\u0013B\u001bV\r\u001e*fC\u0012,'/\u0001\u0004sK\u0006$WM]\u0002\u0001!\tA\u0014(D\u0001&\u0013\tQTE\u0001\u0007Ck\u001a4WM\u001d*fC\u0012,'/\u0003\u00026g\u00051\u0001.Z1eKJ\u0004\"A\r \n\u0005}:#A\u0002%fC\u0012,'/\u0003\u0002=g\u00051A(\u001b8jiz\"2aQ#G!\t!\u0005!D\u0001$\u0011\u0015)4\u00011\u00018\u0011\u0015a4\u00011\u0001>\u00031\u0011XmY8sI2+gn\u001a;i!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\rIe\u000e^\u0001\u0007E2|7m[:\u0011\u0007A+v+D\u0001R\u0015\t\u00116+A\u0005j[6,H/\u00192mK*\u0011AKS\u0001\u000bG>dG.Z2uS>t\u0017B\u0001,R\u0005\u0015\tV/Z;f!\tAV,D\u0001Z\u0015\tQ6,A\u0002oKRT!\u0001\u0018\u0016\u0002\t\u0011\fG/Y\u0005\u0003=f\u0013q!\u0013)CY>\u001c7NA\u0006DS\u0012\u0014()^5mI\u0016\u00148C\u0001\u0004b!\tI%-\u0003\u0002d\u0015\n1\u0011I\\=SK\u001a\f!!\u001b9\u0011\u0005a3\u0017BA4Z\u0005%I\u0005K\u001e\u001bCY>\u001c7\u000e\u0006\u0002jWB\u0011!NB\u0007\u0002\u0001!)A\r\u0003a\u0001K\u00061\u0001O]3gSb,\u0012\u0001S\u0001\baJ,g-\u001b=!\u0003\u0015i\u0017N\\%q\u0003\u0019i\u0017N\\%qA\u0005)Q.\u0019=Ja\u0006IQ.\u0019=Ja~#S-\u001d\u000b\u0003i^\u0004\"!S;\n\u0005YT%\u0001B+oSRDq\u0001\u001f\b\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\na!\\1y\u0013B\u0004\u0013\u0001\u0003;sC&d\u0017N\\4\u0002\u0013Q\u0014\u0018-\u001b7j]\u001e\u0004\u0013!D7bq\u000e{g\u000e^5hk>,8/\u0001\bnCb\u001cuN\u001c;jOV|Wo\u001d\u0011\u0002\u000f5\f\u0007pQ5ee\u0006AQ.\u0019=DS\u0012\u0014\b%\u0001\u0006d_:$\u0018nZ;pkN\fabY8oi&<Wo\\;t?\u0012*\u0017\u000fF\u0002u\u0003\u000fAq\u0001_\f\u0002\u0002\u0003\u0007\u0001*A\u0006d_:$\u0018nZ;pkN\u0004\u0013A\u00027pOR;x\u000eF\u0002I\u0003\u001fAa!!\u0005\u001a\u0001\u0004A\u0015A\u0001<w\u00031!(/Y5mS:<',\u001a:p)\rA\u0015q\u0003\u0005\u0007\u0003#Q\u0002\u0019\u0001%\u0002\u0011\u0005$GM\u00117pG.$B!!\b\u0002$A\u0019\u0011*a\b\n\u0007\u0005\u0005\"JA\u0004C_>dW-\u00198\t\r\u0005\u00152\u00041\u0001f\u0003\u0015qWm^%q\u0003%\tG/T1y'&TX-\u0006\u0002\u0002\u001e\u00051Ao\u001c'jgR,\"!a\f\u0011\u000b\u0005E\u0012\u0011I3\u000f\t\u0005M\u0012Q\b\b\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0015bAA \u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\"\u0003\u000b\u0012A\u0001T5ti*\u0019\u0011q\b&\u0002\u000f\u001d,G/T8sKR\tA/\u0001\u0007d_:$\u0018-\u001b8t\u0013B3h'A\u0004iCNtU\r\u001f;\u0002\t9,\u0007\u0010\u001e\u000b\u0002/\u0002")
public class IPSetV2Reader
extends IPSetReader {
    private final int recordLength;
    private Queue<IPBlock> blocks = Queue$.MODULE$.apply((Seq)Nil$.MODULE$);

    private void getMore() {
        if (this.blocks.isEmpty() && this.checkAvailable(this.recordLength)) {
            None$ builder = None$.MODULE$;
            boolean bl = true;
            do {
                int baseIp = BufferUtil$.MODULE$.getInt32(this.buffer(), this.bufOffset(), this.swap());
                List bitmapIps = (List)this.handleBitmap256(this.buffer(), this.bufOffset() + 4, this.swap()).map((Function1 & Serializable & scala.Serializable)pair -> new IPv4Block(new IPv4Address(baseIp | BoxesRunTime.unboxToInt((Object)pair.apply(0))), this.lenToCidrV4(BoxesRunTime.unboxToInt((Object)pair.apply(1)))), List$.MODULE$.canBuildFrom());
                this.bufOffset_$eq(this.bufOffset() + this.recordLength);
                IPv4Block fin = (IPv4Block)bitmapIps.last();
                None$ none$ = builder;
                None$ none$2 = None$.MODULE$;
                if (!(none$ != null ? !none$.equals(none$2) : none$2 != null)) {
                    if (fin.prefixLength() > 24 || 256 == (baseIp & 0x100) || !this.checkAvailable(this.recordLength)) {
                        this.blocks = (Queue)this.blocks.$plus$plus((GenTraversableOnce)bitmapIps, Queue$.MODULE$.canBuildFrom());
                        bl = false;
                        continue;
                    }
                    builder = Option$.MODULE$.apply((Object)new CidrBuilder(fin));
                    continue;
                }
                if (((CidrBuilder)builder.get()).addBlock(fin)) {
                    if (((CidrBuilder)builder.get()).atMaxSize()) {
                        this.blocks = (Queue)this.blocks.$plus$plus(((CidrBuilder)builder.get()).toList(), Queue$.MODULE$.canBuildFrom());
                        bl = false;
                        continue;
                    }
                    if (this.checkAvailable(this.recordLength)) continue;
                    this.blocks = (Queue)this.blocks.$plus$plus(((CidrBuilder)builder.get()).toList(), Queue$.MODULE$.canBuildFrom());
                    bl = false;
                    continue;
                }
                this.blocks = (Queue)this.blocks.$plus$plus(((CidrBuilder)builder.get()).toList(), Queue$.MODULE$.canBuildFrom());
                if (fin.prefixLength() > 24 || 256 == (baseIp & 0x100) || !this.checkAvailable(this.recordLength)) {
                    this.blocks = (Queue)this.blocks.$plus$plus((GenTraversableOnce)bitmapIps, Queue$.MODULE$.canBuildFrom());
                    bl = false;
                    continue;
                }
                builder = Option$.MODULE$.apply((Object)new CidrBuilder(fin));
            } while (bl);
        }
    }

    @Override
    public boolean containsIPv6() {
        return false;
    }

    @Override
    public boolean hasNext() {
        this.getMore();
        return !this.blocks.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPBlock next() {
        void var1_1;
        this.getMore();
        IPBlock ip = (IPBlock)this.blocks.head();
        this.blocks = this.blocks.tail();
        return var1_1;
    }

    public IPSetV2Reader(BufferReader reader, Header header) {
        super(reader, header);
        this.recordLength = 36;
    }

    private class CidrBuilder {
        private final int prefix;
        private final int minIp;
        private int maxIp;
        private final int trailing;
        private final int maxContiguous;
        private final int maxCidr;
        private int contiguous;

        public int prefix() {
            return this.prefix;
        }

        public int minIp() {
            return this.minIp;
        }

        public int maxIp() {
            return this.maxIp;
        }

        public void maxIp_$eq(int x$1) {
            this.maxIp = x$1;
        }

        public int trailing() {
            return this.trailing;
        }

        public int maxContiguous() {
            return this.maxContiguous;
        }

        public int maxCidr() {
            return this.maxCidr;
        }

        public int contiguous() {
            return this.contiguous;
        }

        public void contiguous_$eq(int x$1) {
            this.contiguous = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private int logTwo(int vv) {
            void var3_3;
            block4: {
                int v = vv;
                int r = 0;
                if ((v & 0xFFFF0000) != 0) {
                    v >>>= 16;
                    r |= 0x10;
                }
                if ((v & 0xFF00) != 0) {
                    v >>>= 8;
                    r |= 8;
                }
                if ((v & 0xF0) != 0) {
                    v >>>= 4;
                    r |= 4;
                }
                if ((v & 0xC) != 0) {
                    v >>>= 2;
                    r |= 2;
                }
                if ((v & 2) == 0) break block4;
                v >>>= 1;
                r |= 1;
            }
            return (int)var3_3;
        }

        private int trailingZero(int vv) {
            int v;
            int trailingZero;
            block4: {
                if (0 == vv) {
                    return 0;
                }
                trailingZero = 1;
                v = vv;
                if ((v & 0xFFFF) == 0) {
                    trailingZero += 16;
                    v >>>= 16;
                }
                if ((v & 0xFF) == 0) {
                    trailingZero += 8;
                    v >>>= 8;
                }
                if ((v & 0xF) == 0) {
                    trailingZero += 4;
                    v >>>= 4;
                }
                if ((v & 3) != 0) break block4;
                trailingZero += 2;
                v >>>= 2;
            }
            return trailingZero - (v & 1);
        }

        public boolean addBlock(IPv4Block newIp) {
            if (newIp.prefixLength() != 24 || newIp.min().toInt() - this.maxIp() != 1) {
                return false;
            }
            this.contiguous_$eq(this.contiguous() + 1);
            this.maxIp_$eq(newIp.max().toInt());
            return true;
        }

        public boolean atMaxSize() {
            return this.contiguous() == this.maxContiguous();
        }

        public List<IPv4Block> toList() {
            ListBuffer listBuffer;
            ListBuffer buf = new ListBuffer();
            if (this.maxContiguous() == this.contiguous()) {
                listBuffer = buf.$plus$eq((Object)new IPv4Block(new IPv4Address(this.minIp()), this.maxCidr()));
            } else if (1 == this.contiguous()) {
                listBuffer = buf.$plus$eq((Object)new IPv4Block(new IPv4Address(this.minIp()), this.prefix()));
            } else {
                int start = this.minIp();
                do {
                    int msb = this.logTwo(this.contiguous());
                    buf.$plus$eq((Object)new IPv4Block(new IPv4Address(start), 24 - msb));
                    start += 1 << 8 + msb;
                    this.contiguous_$eq(this.contiguous() - (1 << msb));
                } while (this.contiguous() > 0);
                listBuffer = BoxedUnit.UNIT;
            }
            return buf.toList();
        }

        public /* synthetic */ IPSetV2Reader org$cert$netsa$io$silk$io$ipset$IPSetV2Reader$CidrBuilder$$$outer() {
            return IPSetV2Reader.this;
        }

        public CidrBuilder(IPv4Block ip) {
            if (IPSetV2Reader.this == null) {
                throw null;
            }
            Predef$.MODULE$.require(ip.prefixLength() == 24);
            this.prefix = ip.prefixLength();
            this.minIp = ip.min().toInt();
            this.maxIp = ip.max().toInt();
            this.trailing = this.trailingZero(this.minIp());
            this.maxContiguous = 1 << this.trailing() - 8;
            this.maxCidr = 32 - this.trailing();
            this.contiguous = 1;
        }
    }
}

