/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io.unpackers;

import java.time.Duration;
import java.time.Instant;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.Port$;
import org.cert.netsa.data.net.TCPFlags$;
import org.cert.netsa.io.silk.FlowType$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.TCPState$;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.Unpacker;
import scala.MatchError;
import scala.Tuple2;

public final class FT_RWFILTER_v2$
implements Unpacker {
    public static FT_RWFILTER_v2$ MODULE$;
    private final int recordLength;

    static {
        new FT_RWFILTER_v2$();
    }

    @Override
    public int recordLength() {
        return this.recordLength;
    }

    @Override
    public RWRec unpack(byte[] buffer, int offset, boolean swap, Header header) {
        IPv4Address sIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset, swap);
        IPv4Address dIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 4, swap);
        short sPort = BufferUtil$.MODULE$.getPort(buffer, offset + 8, swap);
        short dPort = BufferUtil$.MODULE$.getPort(buffer, offset + 10, swap);
        byte protocol = BufferUtil$.MODULE$.getProtocol(buffer, offset + 12, swap);
        byte flags = BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 13, swap);
        int input = BufferUtil$.MODULE$.getSNMPInterface8(buffer, offset + 14, swap);
        int output = BufferUtil$.MODULE$.getSNMPInterface8(buffer, offset + 15, swap);
        IPv4Address nhIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 16, swap);
        Instant startTime = BufferUtil$.MODULE$.getStartTimeSecs(buffer, offset + 20, swap);
        int pef = BufferUtil$.MODULE$.getInt32(buffer, offset + 24, swap);
        int inPackets = pef >> 12 & 0xFFFFF;
        Duration elapsed = Duration.ofSeconds(pef >> 1 & 0x7FF);
        boolean pFlag = (pef & 1) != 0;
        int bbs = BufferUtil$.MODULE$.getInt32(buffer, offset + 28, swap);
        int bpp = bbs >> 12 & 0xFFFFF;
        short sensor = (short)(bbs & 0xFF);
        Tuple2<Object, Object> tuple2 = BufferUtil$.MODULE$.unpackBytesPackets(bpp, inPackets, pFlag);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytes = tuple2._1$mcI$sp();
        int packets = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(bytes, packets);
        Tuple2.mcII.sp sp3 = sp2;
        int bytes2 = sp3._1$mcI$sp();
        int packets2 = sp3._2$mcI$sp();
        byte flowType = FlowType$.MODULE$.apply(0);
        byte initFlags = TCPFlags$.MODULE$.apply(0);
        byte restFlags = TCPFlags$.MODULE$.apply(0);
        byte tcpState = TCPState$.MODULE$.apply(0);
        short application = Port$.MODULE$.apply(0);
        short memo = 0;
        return new RWRec(startTime, elapsed, sPort, dPort, protocol, flowType, sensor, flags, initFlags, restFlags, tcpState, application, memo, input, output, packets2, bytes2, (IPAddress)sIP, (IPAddress)dIP, (IPAddress)nhIP);
    }

    private FT_RWFILTER_v2$() {
        MODULE$ = this;
        this.recordLength = 32;
    }
}

