/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.PrefixMapResult;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibInputStreamBuffer$;
import org.cert.netsa.io.silk.io.prefixmap.PrefixMapReaderIPv4;
import org.cert.netsa.io.silk.io.prefixmap.PrefixMapReaderIPv6;
import org.cert.netsa.io.silk.io.prefixmap.PrefixMapReaderProtoPort;

public final class PrefixMapReader$ {
    public static PrefixMapReader$ MODULE$;

    static {
        new PrefixMapReader$();
    }

    private PrefixMapResult createReader(BufferReader bufferReader, Header header) {
        PrefixMapResult prefixMapResult;
        if (header.recordVersion() < 1 || header.recordVersion() > 5) {
            throw new SilkDataFormatException(new StringBuilder(46).append("PrefixMap file has unexpected record version: ").append(header.recordVersion()).toString());
        }
        if (1 != header.recordSize()) {
            throw new SilkDataFormatException(new StringBuilder(44).append("PrefixMap file has unexpected recordLength: ").append(header.recordSize()).toString());
        }
        short s = header.recordVersion();
        switch (s) {
            case 1: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv4(bufferReader, header));
                break;
            }
            case 2: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv4(bufferReader, header));
                break;
            }
            case 3: {
                prefixMapResult = new PrefixMapResult.ProtocolPortPrefixMap(new PrefixMapReaderProtoPort(bufferReader, header));
                break;
            }
            case 4: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv6(bufferReader, header));
                break;
            }
            case 5: {
                prefixMapResult = new PrefixMapResult.IPBlockPrefixMap(new PrefixMapReaderIPv6(bufferReader, header));
                break;
            }
            default: {
                throw new SilkDataFormatException(new StringBuilder(46).append("PrefixMap file has unexpected record version: ").append(header.recordVersion()).toString());
            }
        }
        return prefixMapResult;
    }

    public PrefixMapResult ofInputStream(InputStream s) {
        BufferReader bufferReader;
        Header header = Header$.MODULE$.readFrom(s);
        int bufferSize = 65536;
        CompressionMethod compressionMethod = header.compressionMethod();
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(s);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(s);
        } else {
            throw new SilkDataFormatException("Unsupported compression method (without Hadoop)");
        }
        RawInputStreamBuffer bufferReader2 = bufferReader;
        return this.createReader(bufferReader2, header);
    }

    public PrefixMapResult ofInputStream(Configuration conf, InputStream s) {
        BufferReader bufferReader;
        Header header = Header$.MODULE$.readFrom(s);
        int bufferSize = 65536;
        CompressionMethod compressionMethod = header.compressionMethod();
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(conf, s);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = LzoInputStreamBuffer$.MODULE$.apply(conf, s);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(conf, s);
        } else {
            throw new SilkDataFormatException("Unrecognized compression method");
        }
        RawInputStreamBuffer bufferReader2 = bufferReader;
        return this.createReader(bufferReader2, header);
    }

    private PrefixMapReader$() {
        MODULE$ = this;
    }
}

