/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$FT_RWIPV6ROUTING$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.HeaderEntry$EndOfHeaders$;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.RWRecWriter$;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.LzoOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibOutputStreamBuffer$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005]!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00039\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b5\u0003A\u0011\u0002(\t\rM\u0003\u0001\u0015)\u0003U\u0011\u00199\u0006\u0001)A\u00051\"11\f\u0001Q\u0001\nqCaa\u0018\u0001!\u0002\u0013\u0001\u0007B\u00024\u0001A\u0003&A\f\u0003\u0004h\u0001\u0001\u0006I\u0001\u001b\u0005\u0007[\u0002\u0001K\u0011\u00028\t\rI\u0004\u0001\u0015\"\u0003t\u0011\u0015I\b\u0001\"\u0001{\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0019\t9\u0002\u0001C\u0001]\u001e9\u0011\u0011\u0004\u000e\t\u0002\u0005maAB\r\u001b\u0011\u0003\ti\u0002\u0003\u0004N)\u0011\u0005\u0011q\u0004\u0005\b\u0003C!B\u0011AA\u0012\u0011%\t\u0019\u0004FI\u0001\n\u0003\t)\u0004C\u0005\u0002LQ\t\n\u0011\"\u0001\u0002N\tY!k\u0016*fG^\u0013\u0018\u000e^3s\u0015\tYB$\u0001\u0003tS2\\'BA\u000f\u001f\u0003\tIwN\u0003\u0002 A\u0005)a.\u001a;tC*\u0011\u0011EI\u0001\u0005G\u0016\u0014HOC\u0001$\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u0004_V$X#\u0001\u0018\u0011\u0005=\u001aT\"\u0001\u0019\u000b\u0005u\t$\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003iA\u0012\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\u0002\t=,H\u000fI\u0001\u0012G>l\u0007O]3tg&|g.T3uQ>$W#\u0001\u001d\u0011\u0005eRT\"\u0001\u000e\n\u0005mR\"!E\"p[B\u0014Xm]:j_:lU\r\u001e5pI\u0006\u00112m\\7qe\u0016\u001c8/[8o\u001b\u0016$\bn\u001c3!\u00031A\u0017\rZ8pa\u000e{gNZ5h+\u0005y\u0004cA\u0014A\u0005&\u0011\u0011\t\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015\u0001B2p]\u001aT!a\u0012%\u0002\r!\fGm\\8q\u0015\tI%%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0017\u0012\u0013QbQ8oM&<WO]1uS>t\u0017!\u00045bI>|\u0007oQ8oM&<\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001fB\u000b&\u000b\u0005\u0002:\u0001!)Af\u0002a\u0001]!)ag\u0002a\u0001q!)Qh\u0002a\u0001\u007f\u0005i\u0001.Z1eKJ<&/\u001b;uK:\u0004\"aJ+\n\u0005YC#a\u0002\"p_2,\u0017M\\\u0001\re\u0016\u001cwN\u001d3MK:<G\u000f\u001b\t\u0003OeK!A\u0017\u0015\u0003\u000bMCwN\u001d;\u0002\u0015\t,hMZ3s'&TX\r\u0005\u0002(;&\u0011a\f\u000b\u0002\u0004\u0013:$\u0018A\u00022vM\u001a,'\u000fE\u0002(C\u000eL!A\u0019\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001d\"\u0017BA3)\u0005\u0011\u0011\u0015\u0010^3\u0002\r=4gm]3u\u0003\u00199(/\u001b;feB\u0011\u0011n[\u0007\u0002U*\u0011QDG\u0005\u0003Y*\u0014ABQ;gM\u0016\u0014xK]5uKJ\f1b\u001e:ji\u0016DU-\u00193feR\tq\u000e\u0005\u0002(a&\u0011\u0011\u000f\u000b\u0002\u0005+:LG/\u0001\u0003qC\u000e\\GCA8u\u0011\u0015)x\u00021\u0001w\u0003\u0015\u0011xO]3d!\tIt/\u0003\u0002y5\t)!k\u0016*fG\u0006\u0001r/Y:IK\u0006$WM],sSR$XM\\\u000b\u0002)\u00061\u0011\r\u001d9f]\u0012$\"a\\?\t\u000by\f\u0002\u0019A@\u0002\t%$XM\u001d\t\u0006\u0003\u0003\t\tB\u001e\b\u0005\u0003\u0007\tiA\u0004\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001J\u0001\u0007yI|w\u000e\u001e \n\u0003%J1!a\u0004)\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0005\u0002\u0016\tA\u0011\n^3sCR|'OC\u0002\u0002\u0010!\nQa\u00197pg\u0016\f1BU,SK\u000e<&/\u001b;feB\u0011\u0011\bF\n\u0003)\u0019\"\"!a\u0007\u0002\u001dQ|w*\u001e;qkR\u001cFO]3b[R9q*!\n\u00020\u0005E\u0002bBA\u0014-\u0001\u0007\u0011\u0011F\u0001\u0002gB\u0019q&a\u000b\n\u0007\u00055\u0002G\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u00047-A\u0005\t\u0019\u0001\u001d\t\u000fu2\u0002\u0013!a\u0001\u007f\u0005ABo\\(viB,Ho\u0015;sK\u0006lG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]\"f\u0001\u001d\u0002:-\u0012\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003%)hn\u00195fG.,GMC\u0002\u0002F!\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI%a\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ru_>+H\u000f];u'R\u0014X-Y7%I\u00164\u0017-\u001e7uIM*\"!a\u0014+\u0007}\nI\u0004")
public class RWRecWriter {
    private final DataOutputStream out;
    private final CompressionMethod compressionMethod;
    private final Option<Configuration> hadoopConfig;
    private boolean headerWritten;
    private final short recordLength;
    private final int bufferSize;
    private final byte[] buffer;
    private int offset;
    private final BufferWriter writer;

    public static Option<Configuration> toOutputStream$default$3() {
        return RWRecWriter$.MODULE$.toOutputStream$default$3();
    }

    public static CompressionMethod toOutputStream$default$2() {
        return RWRecWriter$.MODULE$.toOutputStream$default$2();
    }

    public static RWRecWriter toOutputStream(OutputStream outputStream, CompressionMethod compressionMethod, Option<Configuration> option) {
        return RWRecWriter$.MODULE$.toOutputStream(outputStream, compressionMethod, option);
    }

    public DataOutputStream out() {
        return this.out;
    }

    public CompressionMethod compressionMethod() {
        return this.compressionMethod;
    }

    public Option<Configuration> hadoopConfig() {
        return this.hadoopConfig;
    }

    private void writeHeader() {
        Header header = new Header(Header$.MODULE$.BigEndian(), FileFormat$FT_RWIPV6ROUTING$.MODULE$, Header$.MODULE$.FileVersion(), this.compressionMethod(), 0, this.recordLength, 1, (IndexedSeq<HeaderEntry>)((IndexedSeq)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HeaderEntry$EndOfHeaders$[]{HeaderEntry$EndOfHeaders$.MODULE$}))));
        header.writeTo(this.out());
        this.out().flush();
        this.headerWritten = true;
    }

    private void pack(RWRec rwrec) {
        BufferUtil$.MODULE$.putInstant(this.buffer, this.offset, rwrec.startTime());
        BufferUtil$.MODULE$.putElapsed(this.buffer, this.offset + 8, rwrec.elapsed());
        BufferUtil$.MODULE$.putPort(this.buffer, this.offset + 12, rwrec.sPort());
        BufferUtil$.MODULE$.putPort(this.buffer, this.offset + 14, rwrec.dPort());
        BufferUtil$.MODULE$.putProtocol(this.buffer, this.offset + 16, rwrec.protocol());
        BufferUtil$.MODULE$.putFlowType(this.buffer, this.offset + 17, rwrec.flowType());
        BufferUtil$.MODULE$.putSensor(this.buffer, this.offset + 18, rwrec.sensor());
        BufferUtil$.MODULE$.putTCPFlags(this.buffer, this.offset + 20, rwrec.flags());
        BufferUtil$.MODULE$.putTCPFlags(this.buffer, this.offset + 21, rwrec.initFlags());
        BufferUtil$.MODULE$.putTCPFlags(this.buffer, this.offset + 22, rwrec.restFlags());
        BufferUtil$.MODULE$.putTCPState(this.buffer, this.offset + 23, rwrec.tcpState());
        BufferUtil$.MODULE$.putApplication(this.buffer, this.offset + 24, rwrec.application());
        BufferUtil$.MODULE$.putMemo(this.buffer, this.offset + 26, rwrec.memo());
        BufferUtil$.MODULE$.putSNMPInterface16(this.buffer, this.offset + 28, rwrec.input());
        BufferUtil$.MODULE$.putSNMPInterface16(this.buffer, this.offset + 30, rwrec.output());
        BufferUtil$.MODULE$.putPackets32(this.buffer, this.offset + 32, rwrec.packets());
        BufferUtil$.MODULE$.putBytes32(this.buffer, this.offset + 36, rwrec.bytes());
        BufferUtil$.MODULE$.putIPAddress(this.buffer, this.offset + 40, rwrec.sIP());
        BufferUtil$.MODULE$.putIPAddress(this.buffer, this.offset + 56, rwrec.dIP());
        BufferUtil$.MODULE$.putIPAddress(this.buffer, this.offset + 72, rwrec.nhIP());
    }

    public boolean wasHeaderWritten() {
        return this.headerWritten;
    }

    public void append(Iterator<RWRec> iter) {
        if (!this.headerWritten) {
            this.writeHeader();
        }
        iter.foreach((Function1 & Serializable & scala.Serializable)rwrec -> {
            RWRecWriter.$anonfun$append$1(this, rwrec);
            return BoxedUnit.UNIT;
        });
        if (this.offset > 0) {
            this.writer.putBuffer(this.buffer, this.offset);
            this.offset = 0;
        }
        this.out().flush();
    }

    public void close() {
        if (!this.headerWritten) {
            this.writeHeader();
        }
        if (this.offset > 0) {
            this.writer.putBuffer(this.buffer, this.offset);
            this.offset = 0;
        }
        this.writer.end();
        this.out().close();
    }

    public static final /* synthetic */ void $anonfun$append$1(RWRecWriter $this, RWRec rwrec) {
        if ($this.bufferSize - $this.offset < $this.recordLength) {
            $this.writer.putBuffer($this.buffer, $this.offset);
            $this.offset = 0;
        }
        $this.pack(rwrec);
        $this.offset += $this.recordLength;
    }

    public RWRecWriter(DataOutputStream out, CompressionMethod compressionMethod, Option<Configuration> hadoopConfig) {
        BufferWriter bufferWriter;
        this.out = out;
        this.compressionMethod = compressionMethod;
        this.hadoopConfig = hadoopConfig;
        this.headerWritten = false;
        this.recordLength = (short)88;
        this.bufferSize = 65536 / this.recordLength * this.recordLength;
        this.buffer = (byte[])Array$.MODULE$.ofDim(this.bufferSize, ClassTag$.MODULE$.Byte());
        this.offset = 0;
        CompressionMethod compressionMethod2 = compressionMethod;
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = RawOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = ZlibOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = LzoOutputStreamBuffer$.MODULE$.apply((Configuration)hadoopConfig.get(), out);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = SnappyOutputStreamBuffer$.MODULE$.apply((Configuration)hadoopConfig.get(), out);
        } else {
            throw new SilkDataFormatException("Unrecognized compression method");
        }
        this.writer = bufferWriter;
    }
}

