/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.DataInputStream;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4QAD\b\u0001#iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0013y\u0004BB\"\u0001A\u0003%\u0001\tC\u0004E\u0001\t\u0007I\u0011B#\t\r5\u0003\u0001\u0015!\u0003G\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u000f\u0019\tw\u0002#\u0001\u0012E\u001a1ab\u0004E\u0001#\rDQ!O\u0006\u0005\u0002\u0011DQ!Z\u0006\u0005\u0002\u0019\u0014A\u0003\u0014>p\u0013:\u0004X\u000f^*ue\u0016\fWNQ;gM\u0016\u0014(B\u0001\t\u0012\u0003\tIwN\u0003\u0002\u0013'\u0005!1/\u001b7l\u0015\t\u0001BC\u0003\u0002\u0016-\u0005)a.\u001a;tC*\u0011q\u0003G\u0001\u0005G\u0016\u0014HOC\u0001\u001a\u0003\ry'oZ\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\tq\"\u0003\u0002%\u001f\ta!)\u001e4gKJ\u0014V-\u00193fe\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u001c\u0001\u0001\u0005\u0002)_5\t\u0011F\u0003\u0002+W\u0005!1m\u001c8g\u0015\taS&\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003]a\ta!\u00199bG\",\u0017B\u0001\u0019*\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006A\u0011N\\*ue\u0016\fW\u000e\u0005\u00024o5\tAG\u0003\u0002\u0011k)\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d5\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\rqJg.\u001b;?)\rYD(\u0010\t\u0003E\u0001AQ!J\u0002A\u0002\u001dBQ!M\u0002A\u0002I\n!!\u001b8\u0016\u0003\u0001\u0003\"aM!\n\u0005\t#$a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7\u0002\u0007%t\u0007%\u0001\u0007eK\u000e|W\u000e\u001d:fgN|'/F\u0001G!\t95*D\u0001I\u0015\tI%*\u0001\u0005d_6\u0004(/Z:t\u0015\t\u00012&\u0003\u0002M\u0011\naA)Z2p[B\u0014Xm]:pe\u0006iA-Z2p[B\u0014Xm]:pe\u0002\nQa\u00197pg\u0016$\u0012\u0001\u0015\t\u00039EK!AU\u000f\u0003\tUs\u0017\u000e^\u0001\u000eO\u0016$h*\u001a=u\u0005V4g-\u001a:\u0015\u0003U\u0003B\u0001\b,Y=&\u0011q+\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007qI6,\u0003\u0002[;\t)\u0011I\u001d:bsB\u0011A\u0004X\u0005\u0003;v\u0011AAQ=uKB\u0011AdX\u0005\u0003Av\u00111!\u00138u\u0003Qa%p\\%oaV$8\u000b\u001e:fC6\u0014UO\u001a4feB\u0011!eC\n\u0003\u0017m!\u0012AY\u0001\u0006CB\u0004H.\u001f\u000b\u0004w\u001dD\u0007\"\u0002\u0016\u000e\u0001\u00049\u0003\"B\u0019\u000e\u0001\u0004\u0011\u0004")
public class LzoInputStreamBuffer
implements BufferReader {
    private final Configuration configuration;
    private final DataInputStream in;
    private final Decompressor decompressor;

    public static LzoInputStreamBuffer apply(Configuration configuration, InputStream inputStream) {
        return LzoInputStreamBuffer$.MODULE$.apply(configuration, inputStream);
    }

    private DataInputStream in() {
        return this.in;
    }

    private Decompressor decompressor() {
        return this.decompressor;
    }

    @Override
    public void close() {
        this.in().close();
    }

    @Override
    public Tuple2<byte[], Object> getNextBuffer() {
        int compressedSize = this.in().readInt();
        int uncompressedSize = this.in().readInt();
        byte[] compressedData = (byte[])Array$.MODULE$.ofDim(compressedSize, ClassTag$.MODULE$.Byte());
        byte[] uncompressedData = (byte[])Array$.MODULE$.ofDim(uncompressedSize, ClassTag$.MODULE$.Byte());
        this.in().readFully(compressedData);
        this.decompressor().setInput(compressedData, 0, compressedSize);
        int uncompressedSizeResult = this.decompressor().decompress(uncompressedData, 0, uncompressedSize);
        Predef$.MODULE$.assert(this.decompressor().needsInput());
        Predef$.MODULE$.assert(uncompressedSizeResult == uncompressedSize);
        return new Tuple2((Object)uncompressedData, (Object)BoxesRunTime.boxToInteger((int)uncompressedSize));
    }

    private final /* synthetic */ Decompressor liftedTree1$1() {
        Decompressor decompressor;
        try {
            CompressionCodecFactory cf = new CompressionCodecFactory(this.configuration);
            CompressionCodec codec = cf.getCodecByName("lzo");
            decompressor = codec.createDecompressor();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create lzo decompressor--is lzo properly configured?", ex);
        }
        return decompressor;
    }

    public LzoInputStreamBuffer(Configuration configuration, InputStream inStream) {
        DataInputStream dataInputStream;
        this.configuration = configuration;
        InputStream inputStream = inStream;
        DataInputStream dataInputStream2 = inputStream instanceof DataInputStream ? (dataInputStream = (DataInputStream)inputStream) : new DataInputStream(inStream);
        this.in = dataInputStream2;
        this.decompressor = this.liftedTree1$1();
    }
}

