/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io.unpackers;

import java.time.Duration;
import java.time.Instant;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.TCPFlags;
import org.cert.netsa.data.net.TCPFlags$;
import org.cert.netsa.io.silk.FlowType$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.Sensor$;
import org.cert.netsa.io.silk.TCPState$;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.Unpacker;
import scala.MatchError;
import scala.Tuple3;

public final class FT_FLOWCAP_v5$
implements Unpacker {
    public static FT_FLOWCAP_v5$ MODULE$;
    private final int recordLength;

    static {
        new FT_FLOWCAP_v5$();
    }

    @Override
    public int recordLength() {
        return this.recordLength;
    }

    @Override
    public RWRec unpack(byte[] buffer, int offset, boolean swap, Header header) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        IPv4Address sIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset, swap);
        IPv4Address dIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 4, swap);
        long bytes = BufferUtil$.MODULE$.getBytes32(buffer, offset + 8, swap);
        int timeFrac = BufferUtil$.MODULE$.getInt24(buffer, offset + 35, false);
        int startTimeSecs = BufferUtil$.MODULE$.getInt32(buffer, offset + 12, swap);
        short elapsedSecs = BufferUtil$.MODULE$.getInt16(buffer, offset + 16, swap);
        Instant startTime = Instant.ofEpochMilli(Integer.toUnsignedLong(startTimeSecs) * 1000L + (long)(timeFrac >> 14 & 0x3FF));
        Duration elapsed = Duration.ofMillis(Short.toUnsignedInt(elapsedSecs) * 1000 + (timeFrac >> 4 & 0x3FF));
        short sPort = BufferUtil$.MODULE$.getPort(buffer, offset + 18, swap);
        short dPort = BufferUtil$.MODULE$.getPort(buffer, offset + 20, swap);
        short application = BufferUtil$.MODULE$.getPort(buffer, offset + 22, swap);
        int input = BufferUtil$.MODULE$.getSNMPInterface16(buffer, offset + 24, swap);
        int output = BufferUtil$.MODULE$.getSNMPInterface16(buffer, offset + 26, swap);
        long packets = BufferUtil$.MODULE$.getPackets24(buffer, offset + 28, swap);
        byte protocol = BufferUtil$.MODULE$.getProtocol(buffer, offset + 31, swap);
        byte tcpState = BufferUtil$.MODULE$.getTCPState(buffer, offset + 34, swap);
        if (TCPState$.MODULE$.expandedFlags$extension(tcpState)) {
            byte restFlags = BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 32, swap);
            byte initFlags = BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 33, swap);
            byte flags = (byte)(restFlags | initFlags);
            tuple32 = new Tuple3((Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
        } else {
            tuple32 = tuple3 = new Tuple3((Object)new TCPFlags(BufferUtil$.MODULE$.getTCPFlags(buffer, offset + 32, swap)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        byte flags = ((TCPFlags)tuple3._1()).toByte();
        byte initFlags = ((TCPFlags)tuple3._2()).toByte();
        byte restFlags = ((TCPFlags)tuple3._3()).toByte();
        Tuple3 tuple33 = new Tuple3((Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
        Tuple3 tuple34 = tuple33;
        byte flags2 = ((TCPFlags)tuple34._1()).toByte();
        byte initFlags2 = ((TCPFlags)tuple34._2()).toByte();
        byte restFlags2 = ((TCPFlags)tuple34._3()).toByte();
        byte flowType = FlowType$.MODULE$.apply(0);
        short sensor = Sensor$.MODULE$.apply(0);
        short memo = 0;
        IPv4Address nhIP = new IPv4Address(0);
        return BufferUtil$.MODULE$.TCPStateFixHelper(new RWRec(startTime, elapsed, sPort, dPort, protocol, flowType, sensor, flags2, initFlags2, restFlags2, tcpState, application, memo, input, output, packets, bytes, (IPAddress)sIP, (IPAddress)dIP, (IPAddress)nhIP)).maybeClearTCPStateExpanded();
    }

    private FT_FLOWCAP_v5$() {
        MODULE$ = this;
        this.recordLength = 38;
    }
}

