/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io.unpackers;

import java.time.Duration;
import java.time.Instant;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.Protocol;
import org.cert.netsa.data.net.TCPFlags;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.Unpacker;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple4;

public final class FT_RWFILTER_v4$
implements Unpacker {
    public static FT_RWFILTER_v4$ MODULE$;
    private final int recordLength;

    static {
        new FT_RWFILTER_v4$();
    }

    @Override
    public int recordLength() {
        return this.recordLength;
    }

    @Override
    public RWRec unpack(byte[] buffer, int offset, boolean swap, Header header) {
        IPv4Address sIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset, swap);
        IPv4Address dIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 4, swap);
        short sPort = BufferUtil$.MODULE$.getPort(buffer, offset + 8, swap);
        short dPort = BufferUtil$.MODULE$.getPort(buffer, offset + 10, swap);
        IPv4Address nhIP = BufferUtil$.MODULE$.getIPv4Address(buffer, offset + 12, swap);
        int input = BufferUtil$.MODULE$.getSNMPInterface16(buffer, offset + 16, swap);
        int output = BufferUtil$.MODULE$.getSNMPInterface16(buffer, offset + 18, swap);
        int startTimeSecs = BufferUtil$.MODULE$.getInt32(buffer, offset + 20, swap);
        int elapsedSecs = BufferUtil$.MODULE$.getInt32(buffer, offset + 24, swap);
        int packetsStartTimeMs = BufferUtil$.MODULE$.getInt32(buffer, offset + 28, swap);
        int bbElapsedMs = BufferUtil$.MODULE$.getInt32(buffer, offset + 32, swap);
        Instant startTime = Instant.ofEpochMilli(Integer.toUnsignedLong(startTimeSecs) * 1000L + (long)(packetsStartTimeMs & 0x3FF));
        Duration elapsed = Duration.ofMillis(Integer.toUnsignedLong(elapsedSecs) * 1000L + (long)(bbElapsedMs & 0x3FF));
        int inPackets = packetsStartTimeMs >> 12 & 0xFFFFF;
        boolean pFlag = (packetsStartTimeMs & 0x800) != 0;
        boolean isTcp = (packetsStartTimeMs & 0x400) != 0;
        int bpp = bbElapsedMs >> 12 & 0xFFFFF;
        short sensor = BufferUtil$.MODULE$.getSensor16(buffer, offset + 36, swap);
        byte flowType = BufferUtil$.MODULE$.getFlowType(buffer, offset + 38, swap);
        byte protFlags = BufferUtil$.MODULE$.getInt8(buffer, offset + 39, swap);
        short application = BufferUtil$.MODULE$.getPort(buffer, offset + 40, swap);
        byte tcpState = BufferUtil$.MODULE$.getTCPState(buffer, offset + 42, swap);
        byte inRestFlags = BufferUtil$.MODULE$.getInt8(buffer, offset + 43, swap);
        Tuple2<Object, Object> tuple2 = BufferUtil$.MODULE$.unpackBytesPackets(bpp, inPackets, pFlag);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytes = tuple2._1$mcI$sp();
        int packets = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(bytes, packets);
        Tuple2.mcII.sp sp3 = sp2;
        int bytes2 = sp3._1$mcI$sp();
        int packets2 = sp3._2$mcI$sp();
        Tuple4<Protocol, TCPFlags, TCPFlags, TCPFlags> tuple4 = BufferUtil$.MODULE$.unpackProtoFlags(isTcp, protFlags, tcpState, inRestFlags);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        byte protocol = ((Protocol)tuple4._1()).toByte();
        byte flags = ((TCPFlags)tuple4._2()).toByte();
        byte initFlags = ((TCPFlags)tuple4._3()).toByte();
        byte restFlags = ((TCPFlags)tuple4._4()).toByte();
        Tuple4 tuple42 = new Tuple4((Object)new Protocol(protocol), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
        Tuple4 tuple43 = tuple42;
        byte protocol2 = ((Protocol)tuple43._1()).toByte();
        byte flags2 = ((TCPFlags)tuple43._2()).toByte();
        byte initFlags2 = ((TCPFlags)tuple43._3()).toByte();
        byte restFlags2 = ((TCPFlags)tuple43._4()).toByte();
        short memo = 0;
        return new RWRec(startTime, elapsed, sPort, dPort, protocol2, flowType, sensor, flags2, initFlags2, restFlags2, tcpState, application, memo, input, output, packets2, bytes2, (IPAddress)sIP, (IPAddress)dIP, (IPAddress)nhIP);
    }

    private FT_RWFILTER_v4$() {
        MODULE$ = this;
        this.recordLength = 44;
    }
}

