// Copyright 2025 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.silk

/** A SiLK version number, as represented by an [[scala.Int Int]] value encoding the major version,
  * minor version, and patch numbers.
  *
  * @param toInt The int value representing this SiLK version.
  */
final case class SilkVersion(val toInt: Int) extends AnyVal {
  override def toString: String = {
    val major = toInt / 1000000
    val minor = toInt / 1000 % 1000
    val patch = toInt % 1000
    s"$major.$minor.$patch"
  }
}

object SilkVersion {

  /** Returns a [[SilkVersion]] constructed from the provided major version, minor version, and
    * patch numbers.
    */
  def apply(major: Int, minor: Int, patch: Int): SilkVersion =
    new SilkVersion(major * 1000000 + (minor % 1000) * 1000 + (patch % 1000) * 1000)
}

// @LICENSE_FOOTER@
//
// Mothra 1.7
//
// Copyright 2025 Carnegie Mellon University.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING INSTITUTE MATERIAL IS
// FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND,
// EITHER EXPRESSED OR IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS
// FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF THE MATERIAL.
// CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM
// PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or contac
// permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public release and unlimited
// distribution.  Please see Copyright notice for non-US Government use and distribution.
//
// This Software includes and/or makes use of Third-Party Software each subject to its own license.
//
// DM24-1649
