// Copyright 2025 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io.silk
package io

import java.io.EOFException
import java.io.InputStream

/** A [[BufferReader]] which reads uncompressed data from SiLK file streams. */
private[silk] class RawInputStreamBuffer(private val in: InputStream, val bufferSize: Int)
    extends BufferReader {
  def close(): Unit = {
    in.close()
  }
  def getNextBuffer(): (Array[Byte], Int) = {
    var length = 0
    var lastRead = 0
    val buffer = Array.ofDim[Byte](bufferSize)
    while (lastRead >= 0 && length < bufferSize) {
      lastRead = in.read(buffer, length, bufferSize - length)
      if (lastRead >= 0) {
        length += lastRead
      }
    }
    if ((length == 0) && (lastRead == -1)) {
      throw new EOFException("End of file")
    } else {
      (buffer, length)
    }
  }
}

private[silk] object RawInputStreamBuffer {
  def apply(in: InputStream, bufferSize: Int): RawInputStreamBuffer =
    new RawInputStreamBuffer(in, bufferSize)
}

// @LICENSE_FOOTER@
//
// Mothra 1.7
//
// Copyright 2025 Carnegie Mellon University.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING INSTITUTE MATERIAL IS
// FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND,
// EITHER EXPRESSED OR IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS
// FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF THE MATERIAL.
// CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM
// PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or contac
// permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public release and unlimited
// distribution.  Please see Copyright notice for non-US Government use and distribution.
//
// This Software includes and/or makes use of Third-Party Software each subject to its own license.
//
// DM24-1649
