// Copyright 2025 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.io

/** SiLK file formats, data types, and methods to read them, including support for reading them from
  * Spark.
  *
  * [[org.cert.netsa.io.silk.RWRec RWRec]] is the type of SiLK flow records.
  *
  * You can use [[org.cert.netsa.io.silk.RWRecReader$ RWRecReader]] to read SiLK files from Scala,
  * including compressed files if Hadoop native libraries are available. For example:
  *
  * {{{
  * import org.cert.netsa.io.silk.RWRecReader
  * import java.io.FileInputStream
  *
  * val inputFile = new FileInputStream("path/to/silk/rw/file")
  *
  * for ( rec <- RWRecReader.ofInputStream(inputFile) ) {
  *   println(rec.sIP)
  * }
  * }}}
  *
  * @see [[org.cert.netsa.mothra.datasources.silk.flow]] for working with SiLK data in Spark using
  *   the Mothra SiLK datasource.
  */
package object silk

// @LICENSE_FOOTER@
//
// Mothra 1.7
//
// Copyright 2025 Carnegie Mellon University.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING INSTITUTE MATERIAL IS
// FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND,
// EITHER EXPRESSED OR IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS
// FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF THE MATERIAL.
// CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM
// PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or contac
// permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public release and unlimited
// distribution.  Please see Copyright notice for non-US Government use and distribution.
//
// This Software includes and/or makes use of Third-Party Software each subject to its own license.
//
// DM24-1649
