/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.InputStream;
import org.cert.netsa.io.silk.BagDataType;
import org.cert.netsa.io.silk.BagDataType$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_ANY_IPv4$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_ANY_IPv6$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_CUSTOM$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_DIPv4$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_DIPv6$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_NHIPv4$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_NHIPv6$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_SIPv4$;
import org.cert.netsa.io.silk.BagDataType$SKBAG_FIELD_SIPv6$;
import org.cert.netsa.io.silk.BagResult;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$FT_RWBAG$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibInputStreamBuffer$;
import org.cert.netsa.io.silk.io.bag.BagReaderIPv4Address;
import org.cert.netsa.io.silk.io.bag.BagReaderIPv6Address;
import org.cert.netsa.io.silk.io.bag.BagReaderInt;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;

public final class BagReader$ {
    public static BagReader$ MODULE$;

    static {
        new BagReader$();
    }

    private BagResult createReader(BufferReader bufferReader, Header header) {
        boolean containsIP;
        HeaderEntry.Bag hentry;
        short defaultLengthKey = 4;
        short defaultLengthCounter = 8;
        short bagTypeCustom = BagDataType$SKBAG_FIELD_CUSTOM$.MODULE$.value();
        if (!((Object)((Object)FileFormat$FT_RWBAG$.MODULE$)).equals((Object)header.fileFormat())) {
            throw new SilkDataFormatException("File is not a Bag file");
        }
        if (header.recordVersion() < 3 || header.recordVersion() > 4) {
            throw new SilkDataFormatException(new StringBuilder(40).append("Bag file has unexpected record version: ").append(header.recordVersion()).toString());
        }
        Option hentry_opt = header.headerEntries().collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends HeaderEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof HeaderEntry.Bag) {
                    HeaderEntry.Bag bag = (HeaderEntry.Bag)A1;
                    return (B1)bag;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(HeaderEntry x1) {
                HeaderEntry headerEntry = x1;
                return headerEntry instanceof HeaderEntry.Bag;
            }
        });
        Option option = hentry_opt;
        HeaderEntry.Bag bag = hentry = None$.MODULE$.equals(option) ? new HeaderEntry.Bag(bagTypeCustom, defaultLengthKey, bagTypeCustom, defaultLengthCounter) : (HeaderEntry.Bag)hentry_opt.get();
        if (hentry.keyLength() + hentry.counterLength() != header.recordSize()) {
            throw new SilkDataFormatException(new StringBuilder(38).append("Bag file has unexpected recordLength: ").append(header.recordSize()).toString());
        }
        if (16 == hentry.keyLength()) {
            return new BagResult.IPAddressBag(new BagReaderIPv6Address(bufferReader, header));
        }
        if (4 != hentry.keyLength()) {
            throw new SilkDataFormatException(new StringBuilder(35).append("Bag file has unexpected keyLength: ").append(hentry.keyLength()).toString());
        }
        BagDataType bagDataType = BagDataType$.MODULE$.apply(hentry.keyType());
        boolean bl = ((Object)((Object)BagDataType$SKBAG_FIELD_SIPv4$.MODULE$)).equals((Object)bagDataType) ? true : (((Object)((Object)BagDataType$SKBAG_FIELD_DIPv4$.MODULE$)).equals((Object)bagDataType) ? true : (((Object)((Object)BagDataType$SKBAG_FIELD_NHIPv4$.MODULE$)).equals((Object)bagDataType) ? true : (((Object)((Object)BagDataType$SKBAG_FIELD_ANY_IPv4$.MODULE$)).equals((Object)bagDataType) ? true : (((Object)((Object)BagDataType$SKBAG_FIELD_SIPv6$.MODULE$)).equals((Object)bagDataType) ? true : (((Object)((Object)BagDataType$SKBAG_FIELD_DIPv6$.MODULE$)).equals((Object)bagDataType) ? true : (((Object)((Object)BagDataType$SKBAG_FIELD_NHIPv6$.MODULE$)).equals((Object)bagDataType) ? true : (containsIP = ((Object)((Object)BagDataType$SKBAG_FIELD_ANY_IPv6$.MODULE$)).equals((Object)bagDataType))))))));
        if (containsIP) {
            return new BagResult.IPAddressBag(new BagReaderIPv4Address(bufferReader, header));
        }
        return new BagResult.IntBag(new BagReaderInt(bufferReader, header));
    }

    public BagResult ofInputStream(InputStream s) {
        BufferReader bufferReader;
        Header header = Header$.MODULE$.readFrom(s);
        int bufferSize = 65536 / header.recordSize() * header.recordSize();
        CompressionMethod compressionMethod = header.compressionMethod();
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(s);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = LzoInputStreamBuffer$.MODULE$.apply(s);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(s);
        } else {
            throw new SilkDataFormatException("Unsupported compression method (without Hadoop)");
        }
        RawInputStreamBuffer bufferReader2 = bufferReader;
        return this.createReader(bufferReader2, header);
    }

    private BagReader$() {
        MODULE$ = this;
    }
}

