/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPBlock;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$FT_IPSET$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.HeaderEntry;
import org.cert.netsa.io.silk.HeaderEntry$EndOfHeaders$;
import org.cert.netsa.io.silk.IPSetWriter$;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.BufferWriter;
import org.cert.netsa.io.silk.io.LzoOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyOutputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibOutputStreamBuffer$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u0013&\u0001AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005s!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015A\u0005\u0001\"\u0003J\u0011\u001di\u0005\u00011A\u0005\n9CqA\u0015\u0001A\u0002\u0013%1\u000b\u0003\u0004Z\u0001\u0001\u0006Ka\u0014\u0005\n5\u0002\u0001\r\u00111A\u0005\nmC\u0011b\u0018\u0001A\u0002\u0003\u0007I\u0011\u00021\t\u0013\t\u0004\u0001\u0019!A!B\u0013a\u0006\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003\\\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005h\u0001\u0001\u0007\t\u0011)Q\u00059\"9\u0001\u000e\u0001b\u0001\n\u0013Y\u0006BB5\u0001A\u0003%A\fC\u0004k\u0001\t\u0007I\u0011B6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\b\u00011A\u0005\nmCq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004x\u0001\u0001\u0006K\u0001\u0018\u0005\nq\u0002\u0001\r\u00111A\u0005\neD1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b!Q\u00111\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002>\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0005\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !1\u0011Q\u0005\u0001\u0005\u00029Cq!a\n\u0001\t\u0003\tI\u0003C\u0004\u0002`\u0001!\t!!\u0019\b\u000f\u0005\rT\u0005#\u0001\u0002f\u00191A%\nE\u0001\u0003OBa\u0001\u0013\u0011\u0005\u0002\u0005%\u0004bBA6A\u0011\u0005\u0011Q\u000e\u0005\n\u0003w\u0002\u0013\u0013!C\u0001\u0003{\u00121\"\u0013)TKR<&/\u001b;fe*\u0011aeJ\u0001\u0005g&d7N\u0003\u0002)S\u0005\u0011\u0011n\u001c\u0006\u0003U-\nQA\\3ug\u0006T!\u0001L\u0017\u0002\t\r,'\u000f\u001e\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\u0007=,H/F\u0001:!\tQd(D\u0001<\u0015\tACHC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}Z$\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0003\u0011yW\u000f\u001e\u0011\u0002#\r|W\u000e\u001d:fgNLwN\\'fi\"|G-F\u0001D!\t!U)D\u0001&\u0013\t1UEA\tD_6\u0004(/Z:tS>tW*\u001a;i_\u0012\f!cY8naJ,7o]5p]6+G\u000f[8eA\u00051A(\u001b8jiz\"2AS&M!\t!\u0005\u0001C\u00038\u000b\u0001\u0007\u0011\bC\u0003B\u000b\u0001\u00071)A\u0007iK\u0006$WM],sSR$XM\\\u000b\u0002\u001fB\u0011!\u0007U\u0005\u0003#N\u0012qAQ8pY\u0016\fg.A\tiK\u0006$WM],sSR$XM\\0%KF$\"\u0001V,\u0011\u0005I*\u0016B\u0001,4\u0005\u0011)f.\u001b;\t\u000fa;\u0011\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\u0002\u001d!,\u0017\rZ3s/JLG\u000f^3oA\u0005A\u0011\u000e\u001d'f]\u001e$\b.F\u0001]!\t\u0011T,\u0003\u0002_g\t\u0019\u0011J\u001c;\u0002\u0019%\u0004H*\u001a8hi\"|F%Z9\u0015\u0005Q\u000b\u0007b\u0002-\u000b\u0003\u0003\u0005\r\u0001X\u0001\nSBdUM\\4uQ\u0002\nAB]3d_J$G*\u001a8hi\"\f\u0001C]3d_J$G*\u001a8hi\"|F%Z9\u0015\u0005Q3\u0007b\u0002-\u000e\u0003\u0003\u0005\r\u0001X\u0001\u000ee\u0016\u001cwN\u001d3MK:<G\u000f\u001b\u0011\u0002\u0015\t,hMZ3s'&TX-A\u0006ck\u001a4WM]*ju\u0016\u0004\u0013A\u00022vM\u001a,'/F\u0001m!\ti\u0007/D\u0001o\u0015\tyG(A\u0002oS>L!!\u001d8\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0004ck\u001a4WM\u001d\u0011\u0002\r=4gm]3u\u0003)ygMZ:fi~#S-\u001d\u000b\u0003)ZDq\u0001\u0017\u000b\u0002\u0002\u0003\u0007A,A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\u0019A\u0014XM\u001e\"m_\u000e\\W*\u0019=\u0016\u0003i\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003\rqW\r\u001e\u0006\u0003\u007f&\nA\u0001Z1uC&\u0019\u00111\u0001?\u0003\u0013%\u0003\u0016\t\u001a3sKN\u001c\u0018\u0001\u00059sKZ\u0014En\\2l\u001b\u0006Dx\fJ3r)\r!\u0016\u0011\u0002\u0005\b1^\t\t\u00111\u0001{\u00035\u0001(/\u001a<CY>\u001c7.T1yA\u00051qO]5uKJ,\"!!\u0005\u0011\t\u0005M\u0011qC\u0007\u0003\u0003+Q!\u0001K\u0013\n\t\u0005e\u0011Q\u0003\u0002\r\u0005V4g-\u001a:Xe&$XM]\u0001\boJLG/\u001a:!\u0003-9(/\u001b;f\u0011\u0016\fG-\u001a:\u0015\u0007Q\u000b\t\u0003\u0003\u0004\u0002$m\u0001\raT\u0001\u0007SNL\u0005K\u001e\u001c\u0002!]\f7\u000fS3bI\u0016\u0014xK]5ui\u0016t\u0017AB1qa\u0016tG-\u0006\u0003\u0002,\u00055Cc\u0001+\u0002.!9\u0011qF\u000fA\u0002\u0005E\u0012\u0001B5uKJ\u0004b!a\r\u0002D\u0005%c\u0002BA\u001b\u0003\u007fqA!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wy\u0013A\u0002\u001fs_>$h(C\u00015\u0013\r\t\teM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)%a\u0012\u0003\u0011%#XM]1u_JT1!!\u00114!\u0011\tY%!\u0014\r\u0001\u00119\u0011qJ\u000fC\u0002\u0005E#!\u0001+\u0012\t\u0005M\u0013\u0011\f\t\u0004e\u0005U\u0013bAA,g\t9aj\u001c;iS:<\u0007cA>\u0002\\%\u0019\u0011Q\f?\u0003\u000f%\u0003&\t\\8dW\u0006)1\r\\8tKR\tA+A\u0006J!N+Go\u0016:ji\u0016\u0014\bC\u0001#!'\t\u0001\u0013\u0007\u0006\u0002\u0002f\u0005qAo\\(viB,Ho\u0015;sK\u0006lG#\u0002&\u0002p\u0005e\u0004bBA9E\u0001\u0007\u00111O\u0001\u0002gB\u0019!(!\u001e\n\u0007\u0005]4H\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004BEA\u0005\t\u0019A\"\u00021Q|w*\u001e;qkR\u001cFO]3b[\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0000)\u001a1)!!,\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!$4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\u000b9IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class IPSetWriter {
    private final DataOutputStream out;
    private final CompressionMethod compressionMethod;
    private boolean headerWritten;
    private int ipLength;
    private int recordLength;
    private final int bufferSize;
    private final ByteBuffer buffer;
    private int offset;
    private IPAddress prevBlockMax;
    private final BufferWriter writer;
    private volatile byte bitmap$init$0;

    public static CompressionMethod toOutputStream$default$2() {
        return IPSetWriter$.MODULE$.toOutputStream$default$2();
    }

    public static IPSetWriter toOutputStream(OutputStream outputStream, CompressionMethod compressionMethod) {
        return IPSetWriter$.MODULE$.toOutputStream(outputStream, compressionMethod);
    }

    public DataOutputStream out() {
        return this.out;
    }

    public CompressionMethod compressionMethod() {
        return this.compressionMethod;
    }

    private boolean headerWritten() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/IPSetWriter.scala: 35");
        }
        return this.headerWritten;
    }

    private void headerWritten_$eq(boolean x$1) {
        this.headerWritten = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private int ipLength() {
        return this.ipLength;
    }

    private void ipLength_$eq(int x$1) {
        this.ipLength = x$1;
    }

    private int recordLength() {
        return this.recordLength;
    }

    private void recordLength_$eq(int x$1) {
        this.recordLength = x$1;
    }

    private int bufferSize() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/IPSetWriter.scala: 46");
        }
        return this.bufferSize;
    }

    private ByteBuffer buffer() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/IPSetWriter.scala: 49");
        }
        return this.buffer;
    }

    private int offset() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/IPSetWriter.scala: 52");
        }
        return this.offset;
    }

    private void offset_$eq(int x$1) {
        this.offset = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private IPAddress prevBlockMax() {
        return this.prevBlockMax;
    }

    private void prevBlockMax_$eq(IPAddress x$1) {
        this.prevBlockMax = x$1;
    }

    private BufferWriter writer() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/IPSetWriter.scala: 60");
        }
        return this.writer;
    }

    private void writeHeader(boolean isIPv6) {
        Vector h_entries = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HeaderEntry[]{new HeaderEntry.IPSet(0, 0, isIPv6 ? 16 : 4, 0, 0, 0), HeaderEntry$EndOfHeaders$.MODULE$}));
        Header header = new Header(Header$.MODULE$.BigEndian(), FileFormat$FT_IPSET$.MODULE$, Header$.MODULE$.FileVersion(), this.compressionMethod(), 0, 1, 4, (IndexedSeq<HeaderEntry>)h_entries);
        header.writeTo(this.out());
        this.out().flush();
        this.headerWritten_$eq(true);
    }

    public boolean wasHeaderWritten() {
        return this.headerWritten();
    }

    public <T extends IPBlock> void append(Iterator<T> iter) {
        if (!this.headerWritten()) {
            boolean bl;
            if (!iter.hasNext()) {
                return;
            }
            IPBlock block2 = (IPBlock)iter.next();
            this.ipLength_$eq(block2.min().toBytes().length);
            this.recordLength_$eq(this.ipLength() + 1);
            int n = this.ipLength();
            switch (n) {
                case 4: {
                    bl = false;
                    break;
                }
                case 16: {
                    bl = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(29).append("Unexpected IP Address length ").append(this.ipLength()).toString());
                }
            }
            boolean isIPv6 = bl;
            this.writeHeader(isIPv6);
            Predef$.MODULE$.assert(0 == this.offset());
            Predef$.MODULE$.assert(this.bufferSize() > this.recordLength());
            BufferUtil$.MODULE$.BufferOps(this.buffer()).putBytes(0, block2.min().toBytes(), this.ipLength());
            this.buffer().put(this.ipLength(), (byte)block2.prefixLength());
            this.offset_$eq(this.recordLength());
            this.prevBlockMax_$eq(block2.max());
        }
        iter.foreach((Function1 & Serializable & scala.Serializable)block -> {
            IPSetWriter.$anonfun$append$1(this, block);
            return BoxedUnit.UNIT;
        });
        if (this.offset() > 0) {
            this.writer().putBuffer(this.buffer().array(), this.offset());
            this.offset_$eq(0);
        }
        this.out().flush();
    }

    public void close() {
        if (!this.headerWritten()) {
            this.writeHeader(false);
        }
        if (this.offset() > 0) {
            this.writer().putBuffer(this.buffer().array(), this.offset());
            this.offset_$eq(0);
        }
        this.writer().end();
        this.out().close();
    }

    public static final /* synthetic */ void $anonfun$append$1(IPSetWriter $this, IPBlock block) {
        Predef$.MODULE$.require($this.prevBlockMax().$less((Object)block.min()), (Function0 & Serializable & scala.Serializable)() -> "IPBlocks are unsorted or overlap");
        $this.prevBlockMax_$eq(block.max());
        byte[] arr = block.min().toBytes();
        Predef$.MODULE$.require(arr.length == $this.ipLength(), (Function0 & Serializable & scala.Serializable)() -> "Cannot mix IPv4Blocks and IPv6Blocks in IPSetWriter");
        if ($this.bufferSize() - $this.offset() < $this.recordLength()) {
            $this.writer().putBuffer($this.buffer().array(), $this.offset());
            $this.offset_$eq(0);
        }
        BufferUtil$.MODULE$.BufferOps($this.buffer()).putBytes($this.offset(), arr, $this.ipLength());
        $this.buffer().put($this.offset() + $this.ipLength(), (byte)block.prefixLength());
        $this.offset_$eq($this.offset() + $this.recordLength());
    }

    public IPSetWriter(DataOutputStream out, CompressionMethod compressionMethod) {
        BufferWriter bufferWriter;
        this.out = out;
        this.compressionMethod = compressionMethod;
        this.headerWritten = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.bufferSize = 65536;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.buffer = ByteBuffer.allocate(this.bufferSize());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.offset = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        CompressionMethod compressionMethod2 = compressionMethod;
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = RawOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = ZlibOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = LzoOutputStreamBuffer$.MODULE$.apply(out);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod2)) {
            bufferWriter = SnappyOutputStreamBuffer$.MODULE$.apply(out);
        } else {
            throw new SilkDataFormatException("Unrecognized compression method");
        }
        this.writer = bufferWriter;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

