/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk;

import java.io.InputStream;
import org.cert.netsa.io.silk.CompressionMethod;
import org.cert.netsa.io.silk.CompressionMethod$LZO1X$;
import org.cert.netsa.io.silk.CompressionMethod$NONE$;
import org.cert.netsa.io.silk.CompressionMethod$SNAPPY$;
import org.cert.netsa.io.silk.CompressionMethod$ZLIB$;
import org.cert.netsa.io.silk.FileFormat$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.Header$;
import org.cert.netsa.io.silk.RWRecReader;
import org.cert.netsa.io.silk.SilkDataFormatException;
import org.cert.netsa.io.silk.io.BufferReader;
import org.cert.netsa.io.silk.io.FlowDecoder;
import org.cert.netsa.io.silk.io.LzoInputStreamBuffer$;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer;
import org.cert.netsa.io.silk.io.RawInputStreamBuffer$;
import org.cert.netsa.io.silk.io.SnappyInputStreamBuffer$;
import org.cert.netsa.io.silk.io.ZlibInputStreamBuffer$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class RWRecReader$ {
    public static RWRecReader$ MODULE$;

    static {
        new RWRecReader$();
    }

    public RWRecReader ofInputStream(InputStream s) {
        BufferReader bufferReader;
        Header header = Header$.MODULE$.readFrom(s);
        Option<FlowDecoder> option = FileFormat$.MODULE$.decoder(header.fileFormat(), header.recordVersion());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new SilkDataFormatException("Unrecognized file format and version");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        FlowDecoder decoder = (FlowDecoder)some.value();
        FlowDecoder decoder2 = decoder;
        int bufferSize = 65536 / decoder2.recordLength() * decoder2.recordLength();
        CompressionMethod compressionMethod = header.compressionMethod();
        if (((Object)((Object)CompressionMethod$NONE$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = RawInputStreamBuffer$.MODULE$.apply(s, bufferSize);
        } else if (((Object)((Object)CompressionMethod$ZLIB$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = ZlibInputStreamBuffer$.MODULE$.apply(s);
        } else if (((Object)((Object)CompressionMethod$LZO1X$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = LzoInputStreamBuffer$.MODULE$.apply(s);
        } else if (((Object)((Object)CompressionMethod$SNAPPY$.MODULE$)).equals((Object)compressionMethod)) {
            bufferReader = SnappyInputStreamBuffer$.MODULE$.apply(s);
        } else {
            throw new SilkDataFormatException("Unsupported compression method (without Hadoop)");
        }
        RawInputStreamBuffer bufferReader2 = bufferReader;
        return new RWRecReader(bufferReader2, decoder2, header);
    }

    private RWRecReader$() {
        MODULE$ = this;
    }
}

