/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.IPv4Address$;
import org.cert.netsa.data.net.IPv6Address;
import org.cert.netsa.data.net.IPv6Address$;
import org.cert.netsa.data.net.Port;
import org.cert.netsa.data.net.Port$;
import org.cert.netsa.data.net.Protocol;
import org.cert.netsa.data.net.Protocol$;
import org.cert.netsa.data.net.SNMPInterface$;
import org.cert.netsa.data.net.TCPFlags;
import org.cert.netsa.data.net.TCPFlags$;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.RWRec$;
import org.cert.netsa.io.silk.TCPState;
import org.cert.netsa.io.silk.TCPState$;
import org.cert.netsa.io.silk.io.BufferUtil$;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.Tuple7;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r]uAB&M\u0011\u0003quK\u0002\u0004Z\u0019\"\u0005aJ\u0017\u0005\u0006C\u0006!\ta\u0019\u0004\u0005I\u0006\tQ\r\u0003\u0005g\u0007\t\u0015\r\u0011\"\u0001h\u0011!\u00018A!A!\u0002\u0013A\u0007\"B1\u0004\t\u0003\t\b\"B;\u0004\t\u00031\b\"\u0002?\u0004\t\u0003i\bBB@\u0004\t\u0003\t\t\u0001C\u0004\u0002\u0016\r!\t!a\u0006\t\u000f\u0005\u001d2\u0001\"\u0001\u0002*!9\u0011QF\u0002\u0005\u0002\u0005=\u0002bBA\u001a\u0007\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u007f\u0019A\u0011AA!\u0011\u001d\t)e\u0001C\u0001\u0003\u000fBq!a\u0013\u0004\t\u0003\ti\u0005C\u0004\u0002b\r!\t!a\u0019\t\u000f\u000554\u0001\"\u0001\u0002p!9\u00111P\u0002\u0005\u0002\u0005u\u0004bBAD\u0007\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u001b\u001bA\u0011AAH\u0011\u001d\tIj\u0001C\u0001\u00037Cq!!*\u0004\t\u0003\t9\u000bC\u0004\u0002,\u000e!\t!!,\t\u000f\u0005]6\u0001\"\u0001\u0002:\"9\u00111Y\u0002\u0005\u0002\u0005\u0015\u0007bBAe\u0007\u0011\u0005\u00111\u001a\u0005\b\u0003\u001f\u001cA\u0011AAi\u0011\u001d\tYn\u0001C\u0001\u0003;Dq!!9\u0004\t\u0003\t\u0019\u000fC\u0004\u0002h\u000e!\t!!;\t\u000f\u000558\u0001\"\u0001\u0002p\"9\u00111_\u0002\u0005\u0002\u0005U\bb\u0002B\u0005\u0007\u0011\u0005!1\u0002\u0005\b\u0005+\u0019A\u0011\u0001B\f\u0011\u001d\u0011\tc\u0001C\u0001\u0005GAqAa\u000e\u0004\t\u0003\u0011I\u0004C\u0004\u0003F\r!\tAa\u0012\t\u000f\tm3\u0001\"\u0001\u0003^!9!1O\u0002\u0005\u0002\tU\u0004b\u0002BE\u0007\u0011\u0005!1\u0012\u0005\b\u0005G\u001bA\u0011\u0001BS\u0011\u001d\u0011\u0019l\u0001C\u0001\u0005kCqAa/\u0004\t\u0003\u0011i\fC\u0004\u0003<\u000e!\tA!2\t\u000f\t57\u0001\"\u0001\u0003P\"9!Q[\u0002\u0005\u0002\t]\u0007b\u0002Bo\u0007\u0011\u0005!q\u001c\u0005\b\u0005K\u001cA\u0011\u0001Bt\u0011\u001d\u0011io\u0001C\u0001\u0005_DqA!>\u0004\t\u0003\u00119\u0010C\u0004\u0003~\u000e!\tAa@\t\u000f\r\u00151\u0001\"\u0001\u0004\b!91QB\u0002\u0005\u0002\r=\u0001bBB\u000b\u0007\u0011\u00051q\u0003\u0005\b\u0007;\u0019A\u0011AB\u0010\u0011\u001d\u0019)c\u0001C\u0001\u0007OAqa!\f\u0004\t\u0003\u0019y\u0003C\u0004\u00046\r!\taa\u000e\t\u000f\ru2\u0001\"\u0001\u0004@!91QI\u0002\u0005\u0002\r\u001d\u0003bBB'\u0007\u0011\u00051q\n\u0005\n\u0007+\u001a!\u0019!C\u0005\u0007/B\u0001b!\u0017\u0004A\u0003%\u00111\u0001\u0005\b\u00077\u001aA\u0011AB/\u0011\u001d\u0019\u0019g\u0001C\u0001\u0007KBqaa\u001b\u0004\t\u0003\u0019i\u0007C\u0005\u0004t\u0005\t\t\u0011b\u0001\u0004v\u001911\u0011P\u0001\u0002\u0007wB!b! F\u0005\u000b\u0007I\u0011AB@\u0011)\u00199)\u0012B\u0001B\u0003%1\u0011\u0011\u0005\u0007C\u0016#\ta!#\t\u000f\r=U\t\"\u0001\u0004\u0000!I1\u0011S\u0001\u0002\u0002\u0013\r11S\u0001\u000b\u0005V4g-\u001a:Vi&d'BA'O\u0003\tIwN\u0003\u0002P!\u0006!1/\u001b7l\u0015\ti\u0015K\u0003\u0002S'\u0006)a.\u001a;tC*\u0011A+V\u0001\u0005G\u0016\u0014HOC\u0001W\u0003\ry'o\u001a\t\u00031\u0006i\u0011\u0001\u0014\u0002\u000b\u0005V4g-\u001a:Vi&d7CA\u0001\\!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001X\u0005%\u0011UO\u001a4fe>\u00038o\u0005\u0002\u00047\u00061!-\u001e4gKJ,\u0012\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\f1A\\5p\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0004ck\u001a4WM\u001d\u0011\u0015\u0005I$\bCA:\u0004\u001b\u0005\t\u0001\"\u00024\u0007\u0001\u0004A\u0017AC4fi&sGO\r\u001bC\u000bR\u0011qO\u001f\t\u00039bL!!_/\u0003\u0007%sG\u000fC\u0003|\u000f\u0001\u0007q/\u0001\u0004pM\u001a\u001cX\r^\u0001\tO\u0016$\u0018J\u001c;3iQ\u0011qO \u0005\u0006w\"\u0001\ra^\u0001\tO\u0016$()\u001f;fgR1\u00111AA\b\u0003#\u0001R\u0001XA\u0003\u0003\u0013I1!a\u0002^\u0005\u0015\t%O]1z!\ra\u00161B\u0005\u0004\u0003\u001bi&\u0001\u0002\"zi\u0016DQa_\u0005A\u0002]Da!a\u0005\n\u0001\u00049\u0018A\u00027f]\u001e$\b.A\u0007hKR$\u0016.\\3NS2d\u0017n\u001d\u000b\u0005\u00033\t)\u0003\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002\\\u0001\u0005i&lW-\u0003\u0003\u0002$\u0005u!aB%ogR\fg\u000e\u001e\u0005\u0006w*\u0001\ra^\u0001\rO\u0016$H+[7f\u001d\u0006twn\u001d\u000b\u0005\u00033\tY\u0003C\u0003|\u0017\u0001\u0007q/A\u0006hKR$\u0016.\\3TK\u000e\u001cH\u0003BA\r\u0003cAQa\u001f\u0007A\u0002]\f\u0001cZ3u\u000b2\f\u0007o]3e\u001b&dG.[:\u0015\t\u0005]\u0012Q\b\t\u0005\u00037\tI$\u0003\u0003\u0002<\u0005u!\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000bml\u0001\u0019A<\u0002!\u001d,G/\u00127baN,GmU3dgF2D\u0003BA\u001c\u0003\u0007BQa\u001f\bA\u0002]\f\u0001cZ3u\u000b2\f\u0007o]3e'\u0016\u001c7o\r\u001a\u0015\t\u0005]\u0012\u0011\n\u0005\u0006w>\u0001\ra^\u0001\bO\u0016$\bk\u001c:u)\u0011\ty%a\u0018\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005\u0019a.\u001a;\u000b\u0007\u0005e\u0013+\u0001\u0003eCR\f\u0017\u0002BA/\u0003'\u0012A\u0001U8si\")1\u0010\u0005a\u0001o\u0006Yq-\u001a;Qe>$xnY8m)\u0011\t)'a\u001b\u0011\t\u0005E\u0013qM\u0005\u0005\u0003S\n\u0019F\u0001\u0005Qe>$xnY8m\u0011\u0015Y\u0018\u00031\u0001x\u0003-9W\r\u001e$m_^$\u0016\u0010]3\u0015\t\u0005E\u0014\u0011\u0010\t\u0005\u0003g\n)(D\u0001O\u0013\r\t9H\u0014\u0002\t\r2|w\u000fV=qK\")1P\u0005a\u0001o\u0006Qq-\u001a;TK:\u001cxN\u001d\u001d\u0015\t\u0005}\u0014Q\u0011\t\u0005\u0003g\n\t)C\u0002\u0002\u0004:\u0013aaU3og>\u0014\b\"B>\u0014\u0001\u00049\u0018aC4fiN+gn]8scY\"B!a \u0002\f\")1\u0010\u0006a\u0001o\u0006Yq-\u001a;U\u0007B3E.Y4t)\u0011\t\t*a&\u0011\t\u0005E\u00131S\u0005\u0005\u0003+\u000b\u0019F\u0001\u0005U\u0007B3E.Y4t\u0011\u0015YX\u00031\u0001x\u0003-9W\r\u001e+D!N#\u0018\r^3\u0015\t\u0005u\u00151\u0015\t\u0005\u0003g\ny*C\u0002\u0002\":\u0013\u0001\u0002V\"Q'R\fG/\u001a\u0005\u0006wZ\u0001\ra^\u0001\u000fO\u0016$\u0018\t\u001d9mS\u000e\fG/[8o)\u0011\ty%!+\t\u000bm<\u0002\u0019A<\u0002\u000f\u001d,G/T3n_R!\u0011qVA[!\ra\u0016\u0011W\u0005\u0004\u0003gk&!B*i_J$\b\"B>\u0019\u0001\u00049\u0018!E4fiNsU\nU%oi\u0016\u0014h-Y2fqQ!\u00111XAa!\u0011\t\t&!0\n\t\u0005}\u00161\u000b\u0002\u000e':k\u0005+\u00138uKJ4\u0017mY3\t\u000bmL\u0002\u0019A<\u0002%\u001d,Go\u0015(N!&sG/\u001a:gC\u000e,\u0017G\u000e\u000b\u0005\u0003w\u000b9\rC\u0003|5\u0001\u0007q/\u0001\nhKR\u001cf*\u0014)J]R,'OZ1dKN\u0012D\u0003BA^\u0003\u001bDQa_\u000eA\u0002]\f\u0001cZ3u!\u0006\u001c7.\u001a;D_VtGO\r\u001b\u0015\t\u0005M\u0017\u0011\u001c\t\u00049\u0006U\u0017bAAl;\n!Aj\u001c8h\u0011\u0015YH\u00041\u0001x\u0003A9W\r\u001e)bG.,GoQ8v]R\u001c$\u0007\u0006\u0003\u0002T\u0006}\u0007\"B>\u001e\u0001\u00049\u0018\u0001E4fiB\u000b7m[3u\u0007>,h\u000e\u001e\u001c5)\u0011\t\u0019.!:\t\u000bmt\u0002\u0019A<\u0002\u001d\u001d,GOQ=uK\u000e{WO\u001c;4eQ!\u00111[Av\u0011\u0015Yx\u00041\u0001x\u000399W\r\u001e\"zi\u0016\u001cu.\u001e8umQ\"B!a5\u0002r\")1\u0010\ta\u0001o\u0006aq-\u001a;J!\u0006#GM]3tgR1\u0011q_A\u007f\u0003\u007f\u0004B!!\u0015\u0002z&!\u00111`A*\u0005%I\u0005+\u00113ee\u0016\u001c8\u000fC\u0003|C\u0001\u0007q\u000fC\u0004\u0003\u0002\u0005\u0002\rAa\u0001\u0002\r%\u001c\u0018\n\u0015<7!\ra&QA\u0005\u0004\u0005\u000fi&a\u0002\"p_2,\u0017M\\\u0001\u000fO\u0016$\u0018\n\u0015<7\u0003\u0012$'/Z:t)\u0011\u0011iAa\u0005\u0011\t\u0005E#qB\u0005\u0005\u0005#\t\u0019FA\u0006J!Z4\u0014\t\u001a3sKN\u001c\b\"B>#\u0001\u00049\u0018AD4fi&\u0003f\u000fN!eIJ,7o\u001d\u000b\u0005\u00053\u0011y\u0002\u0005\u0003\u0002R\tm\u0011\u0002\u0002B\u000f\u0003'\u00121\"\u0013)wi\u0005#GM]3tg\")1p\ta\u0001o\u0006IB-Z2pI\u0016t\u0015M\\8US6,7O\u00127bON\u0004&o\u001c;p)\u0019\u0011)Ca\u000b\u0003.A\tBLa\n\u0002\u001a\u0005e\u0011QMAO\u0003#\u000b\t*!%\n\u0007\t%RL\u0001\u0004UkBdWm\u000e\u0005\u0006w\u0012\u0002\ra\u001e\u0005\b\u0005_!\u0003\u0019\u0001B\u0019\u0003\u0019AW-\u00193feB!\u00111\u000fB\u001a\u0013\r\u0011)D\u0014\u0002\u0007\u0011\u0016\fG-\u001a:\u0002+\u0011,7m\u001c3f)&lWm\u001d$mC\u001e\u001c\bK]8u_R1!1\bB!\u0005\u0007\u0002r\u0002\u0018B\u001f\u00033\t)'!(\u0002\u0012\u0006E\u0015\u0011S\u0005\u0004\u0005\u007fi&A\u0002+va2,g\u0007C\u0003|K\u0001\u0007q\u000fC\u0004\u00030\u0015\u0002\rA!\r\u0002/\u0011,7m\u001c3f\r2\fwm\u001d+j[\u0016\u001chk\u001c7v[\u0016\u001cHC\u0003B%\u0005\u001f\u0012\tF!\u0016\u0003ZA9BLa\u0013\u0002\u001a\u0005]\u00121[Aj\u0003K\n\t*!%\u0002\u0012\u0006u\u0015qJ\u0005\u0004\u0005\u001bj&a\u0002+va2,\u0017\u0007\r\u0005\u0006w\u001a\u0002\ra\u001e\u0005\u0007\u0005'2\u0003\u0019A<\u0002\u00071,g\u000eC\u0004\u0003X\u0019\u0002\rAa\u0001\u0002\u000f%t\u0017j\u001d+D!\"9!q\u0006\u0014A\u0002\tE\u0012\u0001G4fiRKW.\u001a\"zi\u0016\u001c\b+Y2lKR\u001ch\t\\1hgRa!q\fB1\u0005K\u0012IG!\u001c\u0003rAyAL!\u0010\u0002\u001a\u0005M\u00171[A\u001c\u0003K\n\t\n\u0003\u0004\u0003d\u001d\u0002\ra^\u0001\b_\u001a47/\u001a;2\u0011\u0019\u00119g\na\u0001o\u00069qN\u001a4tKR\u0014\u0004B\u0002B6O\u0001\u0007q/A\u0004pM\u001a\u001cX\r^\u001a\t\u000f\t=t\u00051\u0001\u0003\u0004\u0005Aam\u001c:dKR\u001b\u0005\u000bC\u0004\u00030\u001d\u0002\rA!\r\u0002%\u0011,7m\u001c3f\u0005f$Xm\u001d)bG.,Go\u001d\u000b\t\u0005o\u0012iH!!\u0003\u0006B9AL!\u001f\u0002T\u0006M\u0017b\u0001B>;\n1A+\u001e9mKJBaAa )\u0001\u00049\u0018a\u00012qa\"1!1\u0011\u0015A\u0002]\f\u0011\"\u001b8QC\u000e\\W\r^:\t\u000f\t\u001d\u0005\u00061\u0001\u0003\u0004\u0005)\u0001O\u001a7bO\u0006\u0001B-Z2pI\u0016\u0004&o\u001c;p\r2\fwm\u001d\u000b\u000b\u0005\u001b\u0013\u0019Ja&\u0003\u001c\n}\u0005c\u0003/\u0003\u0010\u0006\u0015\u0014\u0011SAI\u0003#K1A!%^\u0005\u0019!V\u000f\u001d7fi!9!QS\u0015A\u0002\t\r\u0011!B5t)\u000e\u0003\u0006b\u0002BMS\u0001\u0007\u0011\u0011B\u0001\naJ|GO\u00127bONDqA!(*\u0001\u0004\ti*\u0001\u0005uGB\u001cF/\u0019;f\u0011\u001d\u0011\t+\u000ba\u0001\u0003\u0013\t1\"\u001b8SKN$h\t\\1hg\u0006aA-Z2pI\u0016\u001c&M\u0019)fMRA!q\u0015BU\u0005[\u0013\t\fE\u0006]\u0005\u001f\u000bI\"a\u000e\u0002T\u0006M\u0007B\u0002BVU\u0001\u0007q/A\u0005tE\n|eMZ:fi\"1!q\u0016\u0016A\u0002]\f\u0011\u0002]3g\u001f\u001a47/\u001a;\t\u000f\t=\"\u00061\u0001\u00032\u0005iA-Z2pI\u0016<vk\u0016)peR$B!a\u0014\u00038\"1!\u0011X\u0016A\u0002]\fAAY5ug\u0006A\u0001/\u001e;CsR,7\u000fF\u0003i\u0005\u007f\u0013\t\rC\u0003|Y\u0001\u0007q\u000fC\u0004\u0003D2\u0002\r!a\u0001\u0002\u000bY\fG.^3\u0015\u000f!\u00149M!3\u0003L\")10\fa\u0001o\"9!1Y\u0017A\u0002\u0005\r\u0001BBA\n[\u0001\u0007q/A\u0007qkR$\u0016.\\3NS2d\u0017n\u001d\u000b\u0006Q\nE'1\u001b\u0005\u0006w:\u0002\ra\u001e\u0005\b\u0005\u0007t\u0003\u0019AA\r\u00031\u0001X\u000f\u001e+j[\u0016t\u0015M\\8t)\u0015A'\u0011\u001cBn\u0011\u0015Yx\u00061\u0001x\u0011\u001d\u0011\u0019m\fa\u0001\u00033\t\u0001\u0003];u\u000b2\f\u0007o]3e\u001b&dG.[:\u0015\u000b!\u0014\tOa9\t\u000bm\u0004\u0004\u0019A<\t\u000f\t\r\u0007\u00071\u0001\u00028\u00059\u0001/\u001e;Q_J$H#\u00025\u0003j\n-\b\"B>2\u0001\u00049\bb\u0002Bbc\u0001\u0007\u0011qJ\u0001\faV$\bK]8u_\u000e|G\u000eF\u0003i\u0005c\u0014\u0019\u0010C\u0003|e\u0001\u0007q\u000fC\u0004\u0003DJ\u0002\r!!\u001a\u0002\u0017A,HO\u00127poRK\b/\u001a\u000b\u0006Q\ne(1 \u0005\u0006wN\u0002\ra\u001e\u0005\b\u0005\u0007\u001c\u0004\u0019AA9\u0003-\u0001X\u000f^*f]N|'/\r\u001c\u0015\u000b!\u001c\taa\u0001\t\u000bm$\u0004\u0019A<\t\u000f\t\rG\u00071\u0001\u0002\u0000\u0005Y\u0001/\u001e;U\u0007B3E.Y4t)\u0015A7\u0011BB\u0006\u0011\u0015YX\u00071\u0001x\u0011\u001d\u0011\u0019-\u000ea\u0001\u0003#\u000b1\u0002];u)\u000e\u00036\u000b^1uKR)\u0001n!\u0005\u0004\u0014!)1P\u000ea\u0001o\"9!1\u0019\u001cA\u0002\u0005u\u0015A\u00049vi\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0006Q\u000ee11\u0004\u0005\u0006w^\u0002\ra\u001e\u0005\b\u0005\u0007<\u0004\u0019AA(\u0003\u001d\u0001X\u000f^'f[>$R\u0001[B\u0011\u0007GAQa\u001f\u001dA\u0002]DqAa19\u0001\u0004\ty+\u0001\nqkR\u001cf*\u0014)J]R,'OZ1dKF2D#\u00025\u0004*\r-\u0002\"B>:\u0001\u00049\bb\u0002Bbs\u0001\u0007\u00111X\u0001\u0013aV$8KT'Q\u0013:$XM\u001d4bG\u0016\u001c$\u0007F\u0003i\u0007c\u0019\u0019\u0004C\u0003|u\u0001\u0007q\u000fC\u0004\u0003Dj\u0002\r!a/\u0002!A,H\u000fU1dW\u0016$8i\\;oiN\u0012D#\u00025\u0004:\rm\u0002\"B><\u0001\u00049\bb\u0002Bbw\u0001\u0007\u00111[\u0001\u0011aV$\b+Y2lKR\u001cu.\u001e8umQ\"R\u0001[B!\u0007\u0007BQa\u001f\u001fA\u0002]DqAa1=\u0001\u0004\t\u0019.\u0001\bqkR\u0014\u0015\u0010^3D_VtGo\r\u001a\u0015\u000b!\u001cIea\u0013\t\u000bml\u0004\u0019A<\t\u000f\t\rW\b1\u0001\u0002T\u0006q\u0001/\u001e;CsR,7i\\;oiZ\"D#\u00025\u0004R\rM\u0003\"B>?\u0001\u00049\bb\u0002Bb}\u0001\u0007\u00111[\u0001\u000fSB4H'\u00138WmA\u0013XMZ5y+\t\t\u0019!A\bjaZ$\u0014J\u001c,7!J,g-\u001b=!\u00031\u0001X\u000f^%Q\u0003\u0012$'/Z:t)\u0015A7qLB1\u0011\u0015Y\u0018\t1\u0001x\u0011\u001d\u0011\u0019-\u0011a\u0001\u0003o\fa\u0002];u\u0013B3h'\u00113ee\u0016\u001c8\u000fF\u0003i\u0007O\u001aI\u0007C\u0003|\u0005\u0002\u0007q\u000fC\u0004\u0003D\n\u0003\rA!\u0004\u0002\u001dA,H/\u0013)wi\u0005#GM]3tgR)\u0001na\u001c\u0004r!)1p\u0011a\u0001o\"9!1Y\"A\u0002\te\u0011!\u0003\"vM\u001a,'o\u00149t)\r\u00118q\u000f\u0005\u0006M\u0012\u0003\r\u0001\u001b\u0002\u0012)\u000e\u00036\u000b^1uK\u001aK\u0007\u0010S3ma\u0016\u00148CA#\\\u0003\u0011\u0019X\r\u001c4\u0016\u0005\r\u0005\u0005\u0003BA:\u0007\u0007K1a!\"O\u0005\u0015\u0011vKU3d\u0003\u0015\u0019X\r\u001c4!)\u0011\u0019Yi!$\u0011\u0005M,\u0005bBB?\u0011\u0002\u00071\u0011Q\u0001\u001b[\u0006L(-Z\"mK\u0006\u0014Hk\u0011)Ti\u0006$X-\u0012=qC:$W\rZ\u0001\u0012)\u000e\u00036\u000b^1uK\u001aK\u0007\u0010S3ma\u0016\u0014H\u0003BBF\u0007+Cqa! K\u0001\u0004\u0019\t\t")
public final class BufferUtil {
    public static TCPStateFixHelper TCPStateFixHelper(RWRec rWRec) {
        return BufferUtil$.MODULE$.TCPStateFixHelper(rWRec);
    }

    public static BufferOps BufferOps(ByteBuffer byteBuffer) {
        return BufferUtil$.MODULE$.BufferOps(byteBuffer);
    }

    public static class BufferOps {
        private final ByteBuffer buffer;
        private final byte[] ipv4InV6Prefix;
        private volatile boolean bitmap$init$0;

        public ByteBuffer buffer() {
            return this.buffer;
        }

        public int getInt24BE(int offset) {
            return (this.buffer().get(offset + 0) & 0xFF) << 16 | (this.buffer().get(offset + 1) & 0xFF) << 8 | this.buffer().get(offset + 2) & 0xFF;
        }

        public int getInt24(int offset) {
            ByteOrder byteOrder = this.buffer().order();
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            if (!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null)) {
                return this.buffer().get(offset + 0) & 0xFF | (this.buffer().get(offset + 1) & 0xFF) << 8 | (this.buffer().get(offset + 2) & 0xFF) << 16;
            }
            return (this.buffer().get(offset + 0) & 0xFF) << 16 | (this.buffer().get(offset + 1) & 0xFF) << 8 | this.buffer().get(offset + 2) & 0xFF;
        }

        public byte[] getBytes(int offset, int length) {
            byte[] result = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
            this.buffer().position(offset);
            this.buffer().get(result);
            return result;
        }

        public Instant getTimeMillis(int offset) {
            return Instant.ofEpochMilli(this.buffer().getLong(offset));
        }

        public Instant getTimeNanos(int offset) {
            return Instant.ofEpochSecond(0L, this.buffer().getLong(offset));
        }

        public Instant getTimeSecs(int offset) {
            return Instant.ofEpochSecond(Integer.toUnsignedLong(this.buffer().getInt(offset)));
        }

        public Duration getElapsedMillis(int offset) {
            return Duration.ofMillis(Integer.toUnsignedLong(this.buffer().getInt(offset)));
        }

        public Duration getElapsedSecs16(int offset) {
            return Duration.ofSeconds(Short.toUnsignedLong(this.buffer().getShort(offset)));
        }

        public Duration getElapsedSecs32(int offset) {
            return Duration.ofSeconds(Integer.toUnsignedLong(this.buffer().getInt(offset)));
        }

        public short getPort(int offset) {
            return this.buffer().getShort(offset);
        }

        public byte getProtocol(int offset) {
            return this.buffer().get(offset);
        }

        public byte getFlowType(int offset) {
            return this.buffer().get(offset);
        }

        public short getSensor8(int offset) {
            return (short)Byte.toUnsignedInt(this.buffer().get(offset));
        }

        public short getSensor16(int offset) {
            return this.buffer().getShort(offset);
        }

        public byte getTCPFlags(int offset) {
            return this.buffer().get(offset);
        }

        public byte getTCPState(int offset) {
            return this.buffer().get(offset);
        }

        public short getApplication(int offset) {
            return this.buffer().getShort(offset);
        }

        public short getMemo(int offset) {
            return this.buffer().getShort(offset);
        }

        public int getSNMPInterface8(int offset) {
            return Byte.toUnsignedInt(this.buffer().get(offset));
        }

        public int getSNMPInterface16(int offset) {
            return Short.toUnsignedInt(this.buffer().getShort(offset));
        }

        public int getSNMPInterface32(int offset) {
            return this.buffer().getInt(offset);
        }

        public long getPacketCount24(int offset) {
            return BufferUtil$.MODULE$.BufferOps(this.buffer()).getInt24(offset);
        }

        public long getPacketCount32(int offset) {
            return Integer.toUnsignedLong(this.buffer().getInt(offset));
        }

        public long getPacketCount64(int offset) {
            return this.buffer().getLong(offset);
        }

        public long getByteCount32(int offset) {
            return Integer.toUnsignedLong(this.buffer().getInt(offset));
        }

        public long getByteCount64(int offset) {
            return this.buffer().getLong(offset);
        }

        public IPAddress getIPAddress(int offset, boolean isIPv6) {
            if (isIPv6) {
                return IPv6Address$.MODULE$.apply(BufferUtil$.MODULE$.BufferOps(this.buffer()).getBytes(offset, 16));
            }
            return IPv4Address$.MODULE$.apply(BufferUtil$.MODULE$.BufferOps(this.buffer()).getBytes(offset + 12, 4));
        }

        public IPv6Address getIPv6Address(int offset) {
            return IPv6Address$.MODULE$.apply(BufferUtil$.MODULE$.BufferOps(this.buffer()).getBytes(offset, 16));
        }

        public IPv4Address getIPv4Address(int offset) {
            return new IPv4Address(this.buffer().getInt(offset));
        }

        public Tuple7<Instant, Instant, Protocol, TCPState, TCPFlags, TCPFlags, TCPFlags> decodeNanoTimesFlagsProto(int offset, Header header) {
            long stateFlagStartTime = this.buffer().getLong(offset);
            long rflagEndTime = this.buffer().getLong(offset + 8);
            boolean isTcp = (stateFlagStartTime & 0x40000000000L) != 0L;
            long startTimeOffsetNanos = stateFlagStartTime & 0x3FFFFFFFFFFL;
            long endTimeOffsetNanos = rflagEndTime & 0xFFFFFFFFFFFFFFL;
            byte tcpState = (byte)(stateFlagStartTime >>> 56);
            Instant startTime = header.packedStartTime().plusNanos(startTimeOffsetNanos);
            Instant endTime = header.packedStartTime().plusNanos(endTimeOffsetNanos);
            if (!isTcp) {
                byte protocol = (byte)(stateFlagStartTime >>> 48);
                return new Tuple7((Object)startTime, (Object)endTime, (Object)new Protocol(protocol), (Object)new TCPState(tcpState), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
            }
            if (TCPState$.MODULE$.expandedFlags$extension(tcpState)) {
                byte initFlags = (byte)(stateFlagStartTime >>> 48);
                byte restFlags = (byte)(rflagEndTime >>> 56);
                byte flags = TCPFlags$.MODULE$.$bar$extension(initFlags, restFlags);
                return new Tuple7((Object)startTime, (Object)endTime, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPState(tcpState), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
            }
            byte flags = (byte)(stateFlagStartTime >>> 48);
            return new Tuple7((Object)startTime, (Object)endTime, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPState(tcpState), (Object)new TCPFlags(flags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }

        public Tuple6<Instant, Protocol, TCPState, TCPFlags, TCPFlags, TCPFlags> decodeTimesFlagsProto(int offset, Header header) {
            int rflagStartTime = this.buffer().getInt(offset);
            byte tcpState = BufferUtil$.MODULE$.BufferOps(this.buffer()).getTCPState(offset + 5);
            int startTimeOffset2 = rflagStartTime & 0x3FFFFF;
            boolean isTCP = (rflagStartTime & 0x800000) != 0;
            Instant startTime = header.packedStartTime().plusMillis(startTimeOffset2);
            if (!isTCP) {
                return new Tuple6((Object)startTime, (Object)new Protocol(BufferUtil$.MODULE$.BufferOps(this.buffer()).getProtocol(offset + 4)), (Object)new TCPState(tcpState), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
            }
            if (TCPState$.MODULE$.expandedFlags$extension(tcpState)) {
                byte restFlags = (byte)(rflagStartTime >> 24);
                byte initFlags = this.buffer().get(offset + 4);
                byte flags = (byte)(restFlags | initFlags);
                return new Tuple6((Object)startTime, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPState(tcpState), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
            }
            return new Tuple6((Object)startTime, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPState(tcpState), (Object)new TCPFlags(BufferUtil$.MODULE$.BufferOps(this.buffer()).getTCPFlags(offset + 4)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }

        public Tuple10<Instant, Duration, Object, Object, Protocol, TCPFlags, TCPFlags, TCPFlags, TCPState, Port> decodeFlagsTimesVolumes(int offset, int len, boolean inIsTCP, Header header) {
            Tuple4 tuple4;
            Tuple4 tuple42;
            boolean isTCP;
            boolean pFlag;
            Tuple3 tuple3;
            Tuple3 tuple32 = tuple3 = len == 12 ? new Tuple3((Object)new TCPState(TCPState$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new Port(Port$.MODULE$.apply(0))) : new Tuple3((Object)new TCPState(BufferUtil$.MODULE$.BufferOps(this.buffer()).getTCPState(offset + 12)), (Object)new TCPFlags(BufferUtil$.MODULE$.BufferOps(this.buffer()).getTCPFlags(offset + 13)), (Object)new Port(BufferUtil$.MODULE$.BufferOps(this.buffer()).getApplication(offset + 14)));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            byte tcpState = ((TCPState)tuple3._1()).toByte();
            byte inRestFlags = ((TCPFlags)tuple3._2()).toByte();
            short application = ((Port)tuple3._3()).toShort();
            Tuple3 tuple33 = new Tuple3((Object)new TCPState(tcpState), (Object)new TCPFlags(inRestFlags), (Object)new Port(application));
            byte tcpState2 = ((TCPState)tuple33._1()).toByte();
            byte inRestFlags2 = ((TCPFlags)tuple33._2()).toByte();
            short application2 = ((Port)tuple33._3()).toShort();
            int protoFlagPackets = this.buffer().getInt(offset + 8);
            int inPackets = protoFlagPackets & 0xFFFFF;
            boolean bl = pFlag = (protoFlagPackets & 0x800000) != 0;
            boolean bl2 = inIsTCP ? true : (isTCP = (protoFlagPackets & 0x400000) != 0);
            if (!isTCP) {
                tuple42 = new Tuple4((Object)new Protocol((byte)(protoFlagPackets >> 24)), (Object)new TCPFlags(inRestFlags2), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
            } else {
                byte initFlags = (byte)(protoFlagPackets >> 24);
                byte flags = (byte)(initFlags | inRestFlags2);
                tuple42 = tuple4 = TCPState$.MODULE$.expandedFlags$extension(tcpState2) ? new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(inRestFlags2)) : new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(flags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
            }
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            byte protocol = ((Protocol)tuple4._1()).toByte();
            byte flags = ((TCPFlags)tuple4._2()).toByte();
            byte initFlags = ((TCPFlags)tuple4._3()).toByte();
            byte restFlags = ((TCPFlags)tuple4._4()).toByte();
            Tuple4 tuple43 = new Tuple4((Object)new Protocol(protocol), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
            byte protocol2 = ((Protocol)tuple43._1()).toByte();
            byte flags2 = ((TCPFlags)tuple43._2()).toByte();
            byte initFlags2 = ((TCPFlags)tuple43._3()).toByte();
            byte restFlags2 = ((TCPFlags)tuple43._4()).toByte();
            int bb2Elapsed = this.buffer().getInt(offset + 4);
            Duration elapsed = Duration.ofMillis(bb2Elapsed & 0x3FFFFF);
            int stimeBb1 = this.buffer().getInt(offset);
            int startTimeOffset2 = stimeBb1 >> 10 & 0x3FFFFF;
            Instant startTime = header.packedStartTime().plusMillis(startTimeOffset2);
            int bpp = (stimeBb1 & 0x3FF) << 10 | bb2Elapsed >> 22 & 0x3FF;
            Tuple2<Object, Object> tuple2 = this.decodeBytesPackets(bpp, inPackets, pFlag);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long bytes = tuple2._1$mcJ$sp();
            long packets = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bytes, packets);
            long bytes2 = sp2._1$mcJ$sp();
            long packets2 = sp2._2$mcJ$sp();
            return new Tuple10((Object)startTime, (Object)elapsed, (Object)BoxesRunTime.boxToLong((long)packets2), (Object)BoxesRunTime.boxToLong((long)bytes2), (Object)new Protocol(protocol2), (Object)new TCPFlags(flags2), (Object)new TCPFlags(initFlags2), (Object)new TCPFlags(restFlags2), (Object)new TCPState(tcpState2), (Object)new Port(application2));
        }

        public Tuple6<Instant, Object, Object, Duration, Protocol, TCPFlags> getTimeBytesPacketsFlags(int offset1, int offset2, int offset3, boolean forceTCP, Header header) {
            int pktsStime = this.buffer().getInt(offset1);
            int bbe = this.buffer().getInt(offset2);
            int msecFlags = this.buffer().getInt(offset3);
            int inPackets = pktsStime >> 12 & 0xFFFFF;
            int startTimeSecOffset = pktsStime & 0xFFF;
            int startTimeMilliOffset = msecFlags >> 22 & 0x3FF;
            Instant startTime = header.packedStartTime().plusSeconds(startTimeSecOffset).plusMillis(startTimeMilliOffset);
            int bytesPerPacket = bbe >> 12 & 0xFFFFF;
            int elapsedSecs = bbe & 0xFFF;
            int elapsedMillis = msecFlags >> 12 & 0x3FF;
            Duration elapsed = Duration.ofMillis(elapsedSecs * 1000 + elapsedMillis);
            boolean pflag = (msecFlags & 0x800) != 0;
            boolean isTCP = (msecFlags & 0x400) != 0 || forceTCP;
            Tuple2<Object, Object> tuple2 = this.decodeBytesPackets(bytesPerPacket, inPackets, pflag);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long bytes = tuple2._1$mcJ$sp();
            long packets = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bytes, packets);
            long bytes2 = sp2._1$mcJ$sp();
            long packets2 = sp2._2$mcJ$sp();
            byte protFlags = (byte)msecFlags;
            if (isTCP) {
                return new Tuple6((Object)startTime, (Object)BoxesRunTime.boxToLong((long)packets2), (Object)BoxesRunTime.boxToLong((long)bytes2), (Object)elapsed, (Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(protFlags));
            }
            return new Tuple6((Object)startTime, (Object)BoxesRunTime.boxToLong((long)packets2), (Object)BoxesRunTime.boxToLong((long)bytes2), (Object)elapsed, (Object)new Protocol(protFlags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }

        public Tuple2<Object, Object> decodeBytesPackets(int bpp, int inPackets, boolean pflag) {
            int packets = pflag ? inPackets * 64 : inPackets;
            int bytesPerPacket = bpp >> 6 & 0x3FFF;
            int bytesPerPacketFrac = bpp & 0x3F;
            int i_quot = bytesPerPacketFrac * packets >> 6;
            int i_rem = bytesPerPacketFrac * packets & 0x3F;
            int bytes = bytesPerPacket * packets + i_quot + (i_rem >= 32 ? 1 : 0);
            return new Tuple2.mcJJ.sp((long)bytes, (long)packets);
        }

        public Tuple4<Protocol, TCPFlags, TCPFlags, TCPFlags> decodeProtoFlags(boolean isTCP, byte protFlags, byte tcpState, byte inRestFlags) {
            if (isTCP) {
                if (TCPState$.MODULE$.expandedFlags$extension(tcpState)) {
                    byte flags = (byte)(protFlags | inRestFlags);
                    byte initFlags = protFlags;
                    byte restFlags = inRestFlags;
                    return new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
                }
                return new Tuple4((Object)new Protocol(Protocol$.MODULE$.TCP()), (Object)new TCPFlags(protFlags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
            }
            return new Tuple4((Object)new Protocol(protFlags), (Object)new TCPFlags(inRestFlags), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)), (Object)new TCPFlags(TCPFlags$.MODULE$.apply(0)));
        }

        public Tuple4<Instant, Duration, Object, Object> decodeSbbPef(int sbbOffset, int pefOffset, Header header) {
            int pef = this.buffer().getInt(pefOffset);
            int inPackets = pef >> 12 & 0xFFFFF;
            int elapsedSecs = pef >> 1 & 0x7FF;
            boolean pFlag = (pef & 1) != 0;
            int sbb = this.buffer().getInt(sbbOffset);
            int bpp = sbb & 0xFFFFF;
            int startTimeSecOffset = sbb >> 20 & 0xFFF;
            Instant startTime = header.packedStartTime().plusSeconds(startTimeSecOffset);
            Duration elapsed = Duration.ofSeconds(elapsedSecs);
            Tuple2<Object, Object> tuple2 = this.decodeBytesPackets(bpp, inPackets, pFlag);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long bytes = tuple2._1$mcJ$sp();
            long packets = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bytes, packets);
            long bytes2 = sp2._1$mcJ$sp();
            long packets2 = sp2._2$mcJ$sp();
            return new Tuple4((Object)startTime, (Object)elapsed, (Object)BoxesRunTime.boxToLong((long)bytes2), (Object)BoxesRunTime.boxToLong((long)packets2));
        }

        public short decodeWWWPort(int bits) {
            int n = bits;
            switch (n) {
                case 0: {
                    return Port$.MODULE$.apply(80);
                }
                case 1: {
                    return Port$.MODULE$.apply(443);
                }
                case 2: {
                    return Port$.MODULE$.apply(8080);
                }
            }
            return Port$.MODULE$.apply(0);
        }

        public ByteBuffer putBytes(int offset, byte[] value) {
            this.buffer().position(offset);
            return this.buffer().put(value);
        }

        public ByteBuffer putBytes(int offset, byte[] value, int length) {
            this.buffer().position(offset);
            return this.buffer().put(value, 0, length);
        }

        public ByteBuffer putTimeMillis(int offset, Instant value) {
            return this.buffer().putLong(offset, value.toEpochMilli());
        }

        public ByteBuffer putTimeNanos(int offset, Instant value) {
            Predef$.MODULE$.assert(value.getEpochSecond() < 9223372036L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Time ").append(value).append(" is too large to be represented as a 64-bit signed number of nanoseconds").toString());
            return this.buffer().putLong(offset, value.getEpochSecond() * 1000000000L + (long)value.getNano());
        }

        public ByteBuffer putElapsedMillis(int offset, Duration value) {
            return this.buffer().putInt(offset, (int)value.toMillis());
        }

        public ByteBuffer putPort(int offset, short value) {
            return this.buffer().putShort(offset, value);
        }

        public ByteBuffer putProtocol(int offset, byte value) {
            return this.buffer().put(offset, value);
        }

        public ByteBuffer putFlowType(int offset, byte value) {
            return this.buffer().put(offset, value);
        }

        public ByteBuffer putSensor16(int offset, short value) {
            return this.buffer().putShort(offset, value);
        }

        public ByteBuffer putTCPFlags(int offset, byte value) {
            return this.buffer().put(offset, value);
        }

        public ByteBuffer putTCPState(int offset, byte value) {
            return this.buffer().put(offset, value);
        }

        public ByteBuffer putApplication(int offset, short value) {
            return this.buffer().putShort(offset, value);
        }

        public ByteBuffer putMemo(int offset, short value) {
            return this.buffer().putShort(offset, value);
        }

        public ByteBuffer putSNMPInterface16(int offset, int value) {
            return this.buffer().putShort(offset, SNMPInterface$.MODULE$.toShort$extension(value));
        }

        public ByteBuffer putSNMPInterface32(int offset, int value) {
            return this.buffer().putInt(offset, value);
        }

        public ByteBuffer putPacketCount32(int offset, long value) {
            return this.buffer().putInt(offset, (int)value);
        }

        public ByteBuffer putPacketCount64(int offset, long value) {
            return this.buffer().putLong(offset, value);
        }

        public ByteBuffer putByteCount32(int offset, long value) {
            return this.buffer().putInt(offset, (int)value);
        }

        public ByteBuffer putByteCount64(int offset, long value) {
            return this.buffer().putLong(offset, value);
        }

        private byte[] ipv4InV6Prefix() {
            if (!this.bitmap$init$0) {
                throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/io/BufferUtil.scala: 600");
            }
            return this.ipv4InV6Prefix;
        }

        public ByteBuffer putIPAddress(int offset, IPAddress value) {
            IPAddress iPAddress = value;
            if (iPAddress instanceof IPv6Address) {
                IPv6Address iPv6Address = (IPv6Address)iPAddress;
                return BufferUtil$.MODULE$.BufferOps(this.buffer()).putBytes(offset, iPv6Address.toBytes(), 16);
            }
            if (iPAddress instanceof IPv4Address) {
                IPv4Address iPv4Address = (IPv4Address)iPAddress;
                return BufferUtil$.MODULE$.BufferOps(BufferUtil$.MODULE$.BufferOps(this.buffer()).putBytes(offset, this.ipv4InV6Prefix())).putBytes(offset + 12, iPv4Address.toBytes());
            }
            throw new MatchError((Object)iPAddress);
        }

        public ByteBuffer putIPv6Address(int offset, IPv6Address value) {
            return BufferUtil$.MODULE$.BufferOps(this.buffer()).putBytes(offset, value.toBytes(), 16);
        }

        public ByteBuffer putIPv4Address(int offset, IPv4Address value) {
            return this.buffer().putInt(offset, value.toInt());
        }

        public BufferOps(ByteBuffer buffer) {
            this.buffer = buffer;
            this.ipv4InV6Prefix = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}), ClassTag$.MODULE$.Byte());
            this.bitmap$init$0 = true;
        }
    }

    public static class TCPStateFixHelper {
        private final RWRec self;

        public RWRec self() {
            return this.self;
        }

        public RWRec maybeClearTCPStateExpanded() {
            if (TCPState$.MODULE$.expandedFlags$extension(this.self().tcpState()) && (this.self().protocol() != Protocol$.MODULE$.TCP() || this.self().initFlags() == 0 && this.self().restFlags() == 0)) {
                return RWRec$.MODULE$.apply(this.self().startTime(), this.self().elapsed(), this.self().sPort(), this.self().dPort(), this.self().protocol(), this.self().flowType(), this.self().sensor(), this.self().flags(), TCPFlags$.MODULE$.apply(0), TCPFlags$.MODULE$.apply(0), (byte)(this.self().tcpState() & ~1), this.self().application(), this.self().memo(), this.self().input(), this.self().output(), this.self().packets(), this.self().bytes(), this.self().sIP(), this.self().dIP(), this.self().nhIP());
            }
            return this.self();
        }

        public TCPStateFixHelper(RWRec self) {
            this.self = self;
        }
    }
}

