/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.io.silk.io.flow_formats;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.cert.netsa.data.net.IPAddress;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.Protocol;
import org.cert.netsa.data.net.TCPFlags;
import org.cert.netsa.io.silk.Header;
import org.cert.netsa.io.silk.RWRec;
import org.cert.netsa.io.silk.RWRec$;
import org.cert.netsa.io.silk.io.BufferUtil$;
import org.cert.netsa.io.silk.io.FlowDecoder;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple4;
import scala.UninitializedFieldError;

public final class FT_RWFILTER_v4$
implements FlowDecoder {
    public static FT_RWFILTER_v4$ MODULE$;
    private final short recordLength;
    private final ChronoUnit timePrecision;
    private volatile byte bitmap$init$0;

    static {
        new FT_RWFILTER_v4$();
    }

    @Override
    public short recordLength() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/io/flow_formats/FT_RWFILTER_v4.scala: 66");
        }
        return this.recordLength;
    }

    @Override
    public ChronoUnit timePrecision() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/mothra/netsa_io_silk/src/io/flow_formats/FT_RWFILTER_v4.scala: 67");
        }
        return this.timePrecision;
    }

    @Override
    public RWRec decode(ByteBuffer buffer, int offset, Header header) {
        IPv4Address sIP = BufferUtil$.MODULE$.BufferOps(buffer).getIPv4Address(offset);
        IPv4Address dIP = BufferUtil$.MODULE$.BufferOps(buffer).getIPv4Address(offset + 4);
        short sPort = BufferUtil$.MODULE$.BufferOps(buffer).getPort(offset + 8);
        short dPort = BufferUtil$.MODULE$.BufferOps(buffer).getPort(offset + 10);
        IPv4Address nhIP = BufferUtil$.MODULE$.BufferOps(buffer).getIPv4Address(offset + 12);
        int input = BufferUtil$.MODULE$.BufferOps(buffer).getSNMPInterface16(offset + 16);
        int output = BufferUtil$.MODULE$.BufferOps(buffer).getSNMPInterface16(offset + 18);
        int startTimeSecs = buffer.getInt(offset + 20);
        int elapsedSecs = buffer.getInt(offset + 24);
        int packetsStartTimeMs = buffer.getInt(offset + 28);
        int bbElapsedMs = buffer.getInt(offset + 32);
        Instant startTime = Instant.ofEpochMilli(Integer.toUnsignedLong(startTimeSecs) * 1000L + (long)(packetsStartTimeMs & 0x3FF));
        Duration elapsed = Duration.ofMillis(Integer.toUnsignedLong(elapsedSecs) * 1000L + (long)(bbElapsedMs & 0x3FF));
        int inPackets = packetsStartTimeMs >> 12 & 0xFFFFF;
        boolean pFlag = (packetsStartTimeMs & 0x800) != 0;
        boolean isTcp = (packetsStartTimeMs & 0x400) != 0;
        int bpp = bbElapsedMs >> 12 & 0xFFFFF;
        short sensor = BufferUtil$.MODULE$.BufferOps(buffer).getSensor16(offset + 36);
        byte flowType = BufferUtil$.MODULE$.BufferOps(buffer).getFlowType(offset + 38);
        byte protFlags = buffer.get(offset + 39);
        short application = BufferUtil$.MODULE$.BufferOps(buffer).getPort(offset + 40);
        byte tcpState = BufferUtil$.MODULE$.BufferOps(buffer).getTCPState(offset + 42);
        byte inRestFlags = buffer.get(offset + 43);
        Tuple2<Object, Object> tuple2 = BufferUtil$.MODULE$.BufferOps(buffer).decodeBytesPackets(bpp, inPackets, pFlag);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bytes = tuple2._1$mcJ$sp();
        long packets = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bytes, packets);
        long bytes2 = sp2._1$mcJ$sp();
        long packets2 = sp2._2$mcJ$sp();
        Tuple4<Protocol, TCPFlags, TCPFlags, TCPFlags> tuple4 = BufferUtil$.MODULE$.BufferOps(buffer).decodeProtoFlags(isTcp, protFlags, tcpState, inRestFlags);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        byte protocol = ((Protocol)tuple4._1()).toByte();
        byte flags = ((TCPFlags)tuple4._2()).toByte();
        byte initFlags = ((TCPFlags)tuple4._3()).toByte();
        byte restFlags = ((TCPFlags)tuple4._4()).toByte();
        Tuple4 tuple42 = new Tuple4((Object)new Protocol(protocol), (Object)new TCPFlags(flags), (Object)new TCPFlags(initFlags), (Object)new TCPFlags(restFlags));
        byte protocol2 = ((Protocol)tuple42._1()).toByte();
        byte flags2 = ((TCPFlags)tuple42._2()).toByte();
        byte initFlags2 = ((TCPFlags)tuple42._3()).toByte();
        byte restFlags2 = ((TCPFlags)tuple42._4()).toByte();
        short memo = 0;
        return RWRec$.MODULE$.apply(startTime, elapsed, sPort, dPort, protocol2, flowType, sensor, flags2, initFlags2, restFlags2, tcpState, application, memo, input, output, packets2, bytes2, (IPAddress)sIP, (IPAddress)dIP, (IPAddress)nhIP);
    }

    private FT_RWFILTER_v4$() {
        MODULE$ = this;
        this.recordLength = (short)44;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.timePrecision = ChronoUnit.MILLIS;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

