/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csexport.data;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.csexport.data.jaxb.CSExport;
import org.certificateservices.messages.csexport.data.jaxb.ObjectFactory;
import org.certificateservices.messages.csexport.data.jaxb.Organisation;
import org.certificateservices.messages.csexport.data.jaxb.TokenType;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.SystemTime;
import org.certificateservices.messages.utils.XMLSigner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class CSExportDataParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/csexport_data_1_0";
    public static String DEFAULT_VERSION = "1.4";
    public static String VERSION_1_0 = "1.0";
    public static String VERSION_1_1 = "1.1";
    public static String VERSION_1_2 = "1.2";
    public static String VERSION_1_3 = "1.3";
    public static String VERSION_1_4 = "1.4";
    private static final String CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_0 = "/cs-export-data_1_0.xsd";
    private static final String CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_1 = "/cs-export-data_1_1.xsd";
    private static final String CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_2 = "/cs-export-data_1_2.xsd";
    private static final String CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_3 = "/cs-export-data_1_3.xsd";
    private static final String CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_4 = "/cs-export-data_1_4.xsd";
    private static final Map<String, String> versionToSchemaMap = new HashMap<String, String>();
    private ObjectFactory of = new ObjectFactory();
    private XMLSigner xmlSigner;
    private SystemTime systemTime = new DefaultSystemTime();
    private CSExportDataSignatureLocationFinder csExportDataSignatureLocationFinder = new CSExportDataSignatureLocationFinder();
    private boolean requireSignature = false;
    private JAXBContext jaxbContext = null;
    private Map<String, Schema> schemas = new HashMap<String, Schema>();

    public CSExportDataParser(MessageSecurityProvider securityProvider, boolean requireSignature) throws MessageProcessingException {
        this.requireSignature = requireSignature;
        try {
            this.xmlSigner = new XMLSigner(securityProvider, true, new CSExportDataSignatureLocationFinder(), null);
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initializing HardTokenDataParser: " + e.getMessage(), e);
        }
    }

    public CSExport parse(byte[] data) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(data));
            String version = doc.getDocumentElement().getAttribute("version");
            if (version == null || versionToSchemaMap.get(version) == null) {
                throw new MessageContentException("Invalid CSExport XML, bad version attribute found");
            }
            Object retval = this.getUnmarshaller(version).unmarshal((Node)doc);
            this.validateCSExportData(retval, doc);
            return (CSExport)retval;
        }
        catch (SAXException e) {
            throw new MessageContentException("Message content error when parsing cs export data: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Message content error when parsing cs export data: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when parsing cs export data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when parsing cs export data: " + e.getMessage(), e);
        }
    }

    private void validateCSExportData(Object object, Document doc) throws MessageContentException, MessageProcessingException {
        if (!(object instanceof CSExport)) {
            throw new MessageContentException("Error: parsed object not a CS Export data.");
        }
        this.validateSignature(doc);
    }

    private void validateSignature(Document doc) throws MessageContentException, MessageProcessingException {
        if (this.requireSignature) {
            this.xmlSigner.verifyEnvelopedSignature(doc, false);
        }
    }

    public CSExport genCSExport_1_xAsObject(String version, List<Organisation> organisations, List<TokenType> tokenTypes) throws MessageProcessingException, MessageContentException {
        return this.parse(this.genCSExport_1_x(version, organisations, tokenTypes));
    }

    public byte[] genCSExport_1_x(String version, List<Organisation> organisations, List<TokenType> tokenTypes) throws MessageProcessingException, MessageContentException {
        CSExport csexp = this.of.createCSExport();
        csexp.setVersion(version);
        csexp.setID(MessageGenerateUtils.generateRandomUUID());
        csexp.setTimeStamp(MessageGenerateUtils.dateToXMLGregorianCalendar(this.systemTime.getSystemTime()));
        if (organisations != null && organisations.size() > 0) {
            CSExport.Organisations orgs = this.of.createCSExportOrganisations();
            orgs.getOrganisation().addAll(organisations);
            csexp.setOrganisations(orgs);
        }
        if (tokenTypes != null && tokenTypes.size() > 0) {
            CSExport.TokenTypes tts = this.of.createCSExportTokenTypes();
            tts.getTokenType().addAll(tokenTypes);
            csexp.setTokenTypes(tts);
        }
        return this.marshallAndSign(csexp);
    }

    public byte[] marshallCSExportData(CSExport csExport) throws MessageContentException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMarshaller().marshal((Object)csExport, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error marshalling CSExport Data to byte array: " + e.getMessage(), e);
        }
    }

    private byte[] marshallAndSign(CSExport csExport) throws MessageProcessingException, MessageContentException {
        if (csExport == null) {
            throw new MessageProcessingException("Error marshalling cs export data, message cannot be null.");
        }
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal((Object)csExport, (Node)doc);
            return this.xmlSigner.marshallAndSign(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, this.csExportDataSignatureLocationFinder);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling message " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error generating document builder " + e.getMessage(), e);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    Unmarshaller getUnmarshaller(String version) throws JAXBException, SAXException {
        Unmarshaller retval = this.getJAXBContext().createUnmarshaller();
        retval.setSchema(this.getSchema(version));
        return retval;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            String jaxbClassPath = "org.certificateservices.messages.csexport.data.jaxb:org.certificateservices.messages.xmldsig.jaxb";
            this.jaxbContext = JAXBContext.newInstance((String)jaxbClassPath);
        }
        return this.jaxbContext;
    }

    private Schema getSchema(String version) throws SAXException {
        Schema retval = this.schemas.get(version);
        if (retval == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new CSExportLSResourceResolver(version));
            Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(versionToSchemaMap.get(version)))};
            retval = schemaFactory.newSchema(sources);
            this.schemas.put(version, retval);
        }
        return retval;
    }

    static {
        versionToSchemaMap.put(VERSION_1_0, CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_0);
        versionToSchemaMap.put(VERSION_1_1, CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_1);
        versionToSchemaMap.put(VERSION_1_2, CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_2);
        versionToSchemaMap.put(VERSION_1_3, CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_3);
        versionToSchemaMap.put(VERSION_1_4, CSEXPORT_XSD_SCHEMA_RESOURCE_LOCATION_1_4);
    }

    public class CSExportDataSignatureLocationFinder
    implements XMLSigner.SignatureLocationFinder {
        @Override
        public Element[] getSignatureLocations(Document doc) throws MessageContentException {
            try {
                if (doc.getDocumentElement().getLocalName().equals("CSExport") && doc.getDocumentElement().getNamespaceURI().equals(NAMESPACE)) {
                    return new Element[]{doc.getDocumentElement()};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageContentException("Invalid SAMLP message type sent for signature.");
        }

        @Override
        public String getIDAttribute() {
            return "ID";
        }

        @Override
        public String getIDValue(Element signedElement) throws MessageContentException {
            return signedElement.getAttribute(this.getIDAttribute());
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            return null;
        }
    }

    public class CSExportLSResourceResolver
    implements LSResourceResolver {
        private String version;

        public CSExportLSResourceResolver(String version) {
            this.version = version;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xmldsig-core-schema.xsd"));
                    }
                    if (namespaceURI.equals(NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream((String)versionToSchemaMap.get(this.version)));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

