/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.saml2.assertion;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.saml2.BaseSAMLMessageParser;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeStatementType;
import org.certificateservices.messages.saml2.assertion.jaxb.ConditionsType;
import org.certificateservices.messages.saml2.assertion.jaxb.EncryptedElementType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.saml2.assertion.jaxb.SubjectType;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.utils.XMLSigner;
import org.certificateservices.messages.xenc.jaxb.EncryptedDataType;
import org.certificateservices.messages.xenc.jaxb.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLAssertionMessageParser
extends BaseSAMLMessageParser {
    private static final String BASE_JAXB_CONTEXT = "org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.saml2.protocol.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb";
    EncryptedAssertionXMLConverter encryptedAssertionXMLConverter = new EncryptedAssertionXMLConverter();

    @Override
    public String getNameSpace() {
        return ASSERTION_NAMESPACE;
    }

    @Override
    public String getJAXBPackages() {
        return BASE_JAXB_CONTEXT;
    }

    @Override
    public String[] getDefaultSchemaLocations() throws SAXException {
        return new String[]{"/xmldsig-core-schema.xsd", "/xenc-schema.xsd", "/cs-message-saml-schema-assertion-2.0.xsd", "/cs-message-saml-schema-protocol-2.0.xsd"};
    }

    @Override
    public XMLSigner.SignatureLocationFinder getSignatureLocationFinder() {
        return this.assertionSignatureLocationFinder;
    }

    @Override
    public XMLSigner.OrganisationLookup getOrganisationLookup() {
        return null;
    }

    @Override
    protected String lookupSchemaForElement(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (namespaceURI != null) {
            if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                return "/xmldsig-core-schema.xsd";
            }
            if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                return "/xenc-schema.xsd";
            }
            if (namespaceURI.equals(PROTOCOL_NAMESPACE)) {
                return "/cs-message-saml-schema-protocol-2.0.xsd";
            }
            if (namespaceURI.equals(ASSERTION_NAMESPACE)) {
                return "/cs-message-saml-schema-assertion-2.0.xsd";
            }
        }
        return null;
    }

    public JAXBElement<AssertionType> generateSimpleAssertion(String issuer, Date notBefore, Date notOnOrAfter, String subjectId, List<Object> attributes) throws MessageProcessingException {
        AttributeStatementType attributeStatementType = null;
        if (attributes != null) {
            attributeStatementType = this.of.createAttributeStatementType();
            for (Object attribute : attributes) {
                attributeStatementType.getAttributeOrEncryptedAttribute().add(attribute);
            }
        }
        NameIDType issuerNameType = this.of.createNameIDType();
        issuerNameType.setValue(issuer);
        NameIDType subjectNameType = this.of.createNameIDType();
        subjectNameType.setValue(subjectId);
        SubjectType subjectType = this.of.createSubjectType();
        subjectType.getContent().add(this.of.createNameID(subjectNameType));
        ConditionsType conditionsType = this.of.createConditionsType();
        conditionsType.setNotBefore(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(notBefore));
        conditionsType.setNotOnOrAfter(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(notOnOrAfter));
        AssertionType assertionType = this.of.createAssertionType();
        assertionType.setID("_" + MessageGenerateUtils.generateRandomUUID());
        assertionType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
        assertionType.setVersion(DEFAULT_SAML_VERSION);
        assertionType.setIssuer(issuerNameType);
        assertionType.setSubject(subjectType);
        assertionType.setConditions(conditionsType);
        if (attributeStatementType != null) {
            assertionType.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attributeStatementType);
        }
        return this.of.createAssertion(assertionType);
    }

    public JAXBElement<EncryptedElementType> genEncryptedAssertion(ContextMessageSecurityProvider.Context context, byte[] assertion, List<X509Certificate> reciepients, boolean useKeyId) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(assertion));
            Document encDoc = this.xmlEncrypter.encryptElement(context, doc, reciepients, useKeyId);
            JAXBElement encryptedData = (JAXBElement)this.getUnmarshaller().unmarshal((Node)encDoc);
            EncryptedElementType encryptedElement = this.of.createEncryptedElementType();
            encryptedElement.setEncryptedData((EncryptedDataType)encryptedData.getValue());
            return this.of.createEncryptedAssertion(encryptedElement);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new MessageProcessingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException(e.getMessage(), e);
        }
    }

    public JAXBElement<AssertionType> decryptEncryptedAssertion(ContextMessageSecurityProvider.Context context, EncryptedElementType encryptedAssertion, boolean verify) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        Document decryptedDoc = this.decryptEncryptedAssertionToDoc(context, encryptedAssertion);
        return this.marshallAndVerifyAssertionDoc(context, decryptedDoc, verify);
    }

    public Document decryptEncryptedAssertionToDoc(ContextMessageSecurityProvider.Context context, EncryptedElementType encryptedAssertion) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        try {
            ObjectFactory xmlEncOf = new ObjectFactory();
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal(xmlEncOf.createEncryptedData(encryptedAssertion.getEncryptedData()), (Node)doc);
            return this.xmlEncrypter.decryptDoc(context, doc, null);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error parsing assertion : " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
    }

    public JAXBElement<AssertionType> marshallAndVerifyAssertionDoc(ContextMessageSecurityProvider.Context context, Document assertionDoc, boolean verify) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        try {
            if (verify) {
                this.xmlSigner.verifyEnvelopedSignature(context, assertionDoc, this.getSignatureLocationFinder(), this.getOrganisationLookup());
            }
            JAXBElement assertion = (JAXBElement)this.getUnmarshaller().unmarshal((Node)assertionDoc);
            this.schemaValidate(assertion);
            return assertion;
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error parsing assertion : " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new MessageContentException("Error parsing assertion : " + e.getMessage(), e);
        }
    }

    public void verifyAssertionSignature(ContextMessageSecurityProvider.Context context, AssertionType assertion) throws MessageContentException, MessageProcessingException {
        Document doc = this.getDocumentBuilder().newDocument();
        try {
            this.getMarshaller().marshal(this.of.createAssertion(assertion), (Node)doc);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error marshalling assertion: " + e.getMessage(), e);
        }
        this.xmlSigner.verifyEnvelopedSignature(context, doc, this.getSignatureLocationFinder(), this.getOrganisationLookup());
    }

    public static class EncryptedAssertionXMLConverter
    implements XMLEncrypter.DecryptedXMLConverter {
        @Override
        public Document convert(Document doc) throws MessageContentException {
            NodeList nodeList = doc.getElementsByTagNameNS(BaseSAMLMessageParser.ASSERTION_NAMESPACE, "Assertion");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element attribute = (Element)nodeList.item(i);
                Element parent = (Element)attribute.getParentNode();
                if (!parent.getLocalName().equals("EncryptedAssertion") || !parent.getNamespaceURI().equals(BaseSAMLMessageParser.ASSERTION_NAMESPACE)) continue;
                parent.getParentNode().replaceChild(attribute, parent);
            }
            return doc;
        }
    }
}

